/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql;

import com.intellij.database.util.Version;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.mssql.MsDialect;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MsTypeSystem
extends SqlTypeSystemBase {
    public static final MsTypeSystem INSTANCE = new MsTypeSystem();
    @NotNull
    private static final Map<String, SqlTypeSystemBase.DeprecatedTypeInfo> DEPRECATED_TYPES = new ContainerUtil.ImmutableMapBuilder().put((Object)"text", (Object)new SqlTypeSystemBase.DeprecatedTypeInfo("inspection.message.deprecated.type.mssql.text.description", Collections.singletonList("varchar(max)"))).put((Object)"ntext", (Object)new SqlTypeSystemBase.DeprecatedTypeInfo("inspection.message.deprecated.type.mssql.ntext.description", Collections.singletonList("nvarchar(max)"))).put((Object)"image", (Object)new SqlTypeSystemBase.DeprecatedTypeInfo("inspection.message.deprecated.type.mssql.image.description", Collections.singletonList("varbinary(max)"))).build();

    private MsTypeSystem() {
        super((SqlLanguageDialectEx)MsDialect.INSTANCE);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            MsTypeSystem.$$$reportNull$$$0(0);
        }
        if ((name2 = super.getNormalizedTypeName(name2)).equals("integer")) {
            return "int";
        }
        if (name2.equals("dec")) {
            return "decimal";
        }
        if (name2.equals("binary varying")) {
            return "varbinary";
        }
        if (name2.equals("double precision")) {
            return "float";
        }
        if (name2.equals("character")) {
            return "char";
        }
        if (name2.equals("char varying")) {
            return "varchar";
        }
        if (name2.equals("character varying")) {
            return "varchar";
        }
        if (name2.equals("national char")) {
            return "nchar";
        }
        if (name2.equals("national character")) {
            return "nchar";
        }
        if (name2.equals("national char varying")) {
            return "nvarchar";
        }
        if (name2.equals("national character varying")) {
            return "nvarchar";
        }
        if (name2.equals("national text")) {
            return "ntext";
        }
        if (name2.equals("rowversion")) {
            return "timestamp";
        }
        String string = name2;
        if (string == null) {
            MsTypeSystem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            MsTypeSystem.$$$reportNull$$$0(2);
        }
        switch (cat) {
            case INTEGER: {
                return "int";
            }
            case REAL: {
                return "numeric";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "int";
            }
            case DATE_TIME: {
                return "datetime";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "datetimeoffset";
            }
            case BYTES: {
                return "binary";
            }
            case TABLE: {
                return "table";
            }
        }
        return null;
    }

    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            MsTypeSystem.$$$reportNull$$$0(3);
        }
        if ("money".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                MsTypeSystem.$$$reportNull$$$0(4);
            }
            return category;
        }
        if ("smallmoney".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                MsTypeSystem.$$$reportNull$$$0(5);
            }
            return category;
        }
        if ("datetimeoffset".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTERVAL;
            if (category == null) {
                MsTypeSystem.$$$reportNull$$$0(6);
            }
            return category;
        }
        if ("sysname".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                MsTypeSystem.$$$reportNull$$$0(7);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            MsTypeSystem.$$$reportNull$$$0(8);
        }
        return category;
    }

    @NotNull
    public Map<String, SqlTypeSystemBase.DeprecatedTypeInfo> getDeprecatedTypes(@NotNull PsiFile contextFile) {
        Version version;
        if (contextFile == null) {
            MsTypeSystem.$$$reportNull$$$0(9);
        }
        if ((version = SqlImplUtil.getMinDbmsVersion((PsiElement)contextFile)) != null && version.compareTo(new int[]{13}) < 0) {
            Map<String, SqlTypeSystemBase.DeprecatedTypeInfo> map2 = Collections.emptyMap();
            if (map2 == null) {
                MsTypeSystem.$$$reportNull$$$0(10);
            }
            return map2;
        }
        Map<String, SqlTypeSystemBase.DeprecatedTypeInfo> map3 = DEPRECATED_TYPES;
        if (map3 == null) {
            MsTypeSystem.$$$reportNull$$$0(11);
        }
        return map3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mssql/MsTypeSystem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mssql/MsTypeSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeprecatedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecatedTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

