/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.database.DatabaseBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.mysql.psi.MysqlLoadDmlInstructionImpl;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlLoadDataPathInspection
extends SqlInspectionBase {
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, final @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, final boolean onTheFly) {
        if (dialect == null) {
            MysqlLoadDataPathInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            MysqlLoadDataPathInspection.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            MysqlLoadDataPathInspection.$$$reportNull$$$0(2);
        }
        if (!dialect.getDbms().isMysql()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, (SqlLanguageDialect)dialect, result2){

            public void visitSqlDmlInstruction(SqlDmlInstruction o2) {
                String path;
                if (!(o2 instanceof MysqlLoadDmlInstructionImpl)) {
                    return;
                }
                SqlStringLiteralExpression pathLiteral = ((MysqlLoadDmlInstructionImpl)o2).getPath();
                String string = path = pathLiteral == null ? null : pathLiteral.getValue();
                if (path == null) {
                    return;
                }
                if (!MysqlLoadDataPathInspection.startsWithTilde(path)) {
                    return;
                }
                this.addDescriptor(manager.createProblemDescriptor((PsiElement)pathLiteral, DatabaseBundle.message((String)"inspection.message.tilde.allowed.here", (Object[])new Object[0]), (LocalQuickFix)new PathExpander(), ProblemHighlightType.WEAK_WARNING, onTheFly));
            }
        };
    }

    private static boolean startsWithTilde(@NotNull String path) {
        if (path == null) {
            MysqlLoadDataPathInspection.$$$reportNull$$$0(3);
        }
        return path.startsWith("~/") || path.startsWith("~\\");
    }

    @NotNull
    private static String expandTilde(@NotNull String path) {
        if (path == null) {
            MysqlLoadDataPathInspection.$$$reportNull$$$0(4);
        }
        Object object = MysqlLoadDataPathInspection.startsWithTilde(path) ? StringUtil.escapeChar((String)SystemProperties.getUserHome(), (char)'\\') + path.substring(1) : path;
        if (object == null) {
            MysqlLoadDataPathInspection.$$$reportNull$$$0(5);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mysql/inspections/MysqlLoadDataPathInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mysql/inspections/MysqlLoadDataPathInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "expandTilde";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startsWithTilde";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "expandTilde";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PathExpander
    implements LocalQuickFix {
        private PathExpander() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = DatabaseBundle.message((String)"intention.family.name.expand.tilde", (Object[])new Object[0]);
            if (string == null) {
                PathExpander.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            SqlStringLiteralExpression literal;
            Document document;
            if (project == null) {
                PathExpander.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PathExpander.$$$reportNull$$$0(2);
            }
            Document document2 = document = (literal = (SqlStringLiteralExpression)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), SqlStringLiteralExpression.class)) == null ? null : PsiDocumentManager.getInstance((Project)project).getDocument(literal.getContainingFile());
            if (document == null) {
                return;
            }
            String value = literal.getValue();
            if (value == null) {
                return;
            }
            String result2 = MysqlLoadDataPathInspection.expandTilde(value);
            TextRange range = literal.getTextRange();
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)("'" + result2 + "'"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/mysql/inspections/MysqlLoadDataPathInspection$PathExpander";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/mysql/inspections/MysqlLoadDataPathInspection$PathExpander";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

