/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.base.psi.SqlFunctionBodyInjector;
import com.intellij.sql.dialects.postgres.PgDialect;
import com.intellij.sql.dialects.postgres.PgOptionalKeywords;
import com.intellij.sql.dialects.postgres.PgReservedKeywords;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionBodyInjector
extends SqlFunctionBodyInjector {
    @Override
    protected boolean canApply(PsiElement context) {
        return context instanceof SqlStringLiteralExpression && SqlImplUtil.getSqlDialectSafe((PsiElement)context) == this.getDialect();
    }

    @Override
    @Nullable
    protected Pair<Language, String> calcBodyLanguage(@NotNull PsiElement context) {
        if (context == null) {
            FunctionBodyInjector.$$$reportNull$$$0(0);
        }
        return this.getBodyLanguage(context);
    }

    @Override
    @Nullable
    protected Pair<String, String> getPrefixSuffix(Language language) {
        return null;
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<SqlStringLiteralExpressionImpl>> list = Collections.singletonList(SqlStringLiteralExpressionImpl.class);
        if (list == null) {
            FunctionBodyInjector.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    private Pair<Language, String> getBodyLanguage(@NotNull PsiElement context) {
        PsiElement lang;
        if (context == null) {
            FunctionBodyInjector.$$$reportNull$$$0(2);
        }
        ASTNode nodeParent = Objects.requireNonNull(context.getNode().getTreeParent());
        SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)context, SqlStatement.class, (boolean)false);
        if (!(statement instanceof SqlCreateProcedureStatement || statement != null && statement.getFirstChild().getNode().getElementType() == PgTypes.PG_DO)) {
            return null;
        }
        ASTNode asNode = TreeUtil.findSiblingBackward((ASTNode)nodeParent, (IElementType)PgReservedKeywords.PG_AS);
        if (statement instanceof SqlCreateProcedureStatement && asNode == null) {
            return null;
        }
        ASTNode gp = nodeParent.getTreeParent();
        ASTNode langNode = gp == null ? null : gp.findChildByType((IElementType)SqlCompositeElementTypes.SQL_LANGUAGE_CLAUSE);
        langNode = langNode == null ? null : langNode.findChildByType(PgOptionalKeywords.PG_LANGUAGE);
        PsiElement psiElement = lang = langNode == null ? null : SqlImplUtil.getSiblingToTheRightOfType((PsiElement)langNode.getPsi(), (boolean)true, (Class[])new Class[]{PsiElement.class});
        if (lang == context) {
            return null;
        }
        String text = lang == null ? null : lang.getText();
        return this.getLangBySpec(text, context);
    }

    @Override
    protected Pair<Language, String> getLangBySpec(@Nullable String text, @NotNull PsiElement host) {
        if (host == null) {
            FunctionBodyInjector.$$$reportNull$$$0(3);
        }
        return FunctionBodyInjector.getBlockByLangSpec(text, host, this.getDialect());
    }

    @NotNull
    protected Language getDialect() {
        PgDialect pgDialect = PgDialect.INSTANCE;
        if (pgDialect == null) {
            FunctionBodyInjector.$$$reportNull$$$0(4);
        }
        return pgDialect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/psi/FunctionBodyInjector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/psi/FunctionBodyInjector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcBodyLanguage";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBodyLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLangBySpec";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

