/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.run.ShConfigurationType;
import com.intellij.sh.run.ShRunConfiguration;
import org.jetbrains.annotations.NotNull;

final class ShRunConfigurationProducer
extends LazyRunConfigurationProducer<ShRunConfiguration> {
    ShRunConfigurationProducer() {
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ShConfigurationType shConfigurationType = ShConfigurationType.getInstance();
        if (shConfigurationType == null) {
            ShRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return shConfigurationType;
    }

    protected boolean setupConfigurationFromContext(@NotNull ShRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiFile psiFile;
        if (configuration == null) {
            ShRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ShRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            ShRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (!((psiFile = ((PsiElement)sourceElement.get()).getContainingFile()) instanceof ShFile)) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        String defaultShell = ShConfigurationType.getDefaultShell();
        if (defaultShell != null) {
            configuration.setInterpreterPath(defaultShell);
        }
        configuration.setScriptWorkingDirectory(virtualFile.getParent().getPath());
        configuration.setName(virtualFile.getPresentableName());
        configuration.setScriptPath(virtualFile.getPath());
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull ShRunConfiguration configuration, @NotNull ConfigurationContext context) {
        PsiElement psiLocation;
        if (configuration == null) {
            ShRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            ShRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((psiLocation = context.getPsiLocation()) == null) {
            return false;
        }
        PsiFile psiFile = psiLocation.getContainingFile();
        if (!(psiFile instanceof ShFile)) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        String scriptPath = configuration.getScriptPath();
        String workingDirectory = configuration.getScriptWorkingDirectory();
        return scriptPath != null && scriptPath.equals(virtualFile.getPath()) && workingDirectory != null && workingDirectory.equals(virtualFile.getParent().getPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/run/ShRunConfigurationProducer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/run/ShRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

