/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.indexing.IndexableSetContributor;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.stdlib.SassScssStdlibInclusionContext;
import org.jetbrains.plugins.sass.stdlib.SassScssStubMarker;

public class SassScssIndexedRootProvider
extends IndexableSetContributor {
    private static final Logger LOG = Logger.getInstance(SassScssIndexedRootProvider.class);
    private Set<VirtualFile> myAdditionalRoots;
    private VirtualFile myGlobalFunctionsFile;
    private Map<String, VirtualFile> myBuiltInModuleNameToFile;

    @NotNull
    public Set<VirtualFile> getAdditionalRootsToIndex() {
        if (this.myAdditionalRoots == null) {
            this.initGlobalAndBuiltInModuleFiles();
        }
        Set<VirtualFile> set = this.myAdditionalRoots;
        if (set == null) {
            SassScssIndexedRootProvider.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public VirtualFile getGlobalFunctionsFile() {
        if (this.myGlobalFunctionsFile == null) {
            this.initGlobalAndBuiltInModuleFiles();
        }
        VirtualFile virtualFile = this.myGlobalFunctionsFile;
        if (virtualFile == null) {
            SassScssIndexedRootProvider.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getBuiltInModuleFile(@NotNull String moduleName) {
        if (moduleName == null) {
            SassScssIndexedRootProvider.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(ArrayUtil.contains((String)moduleName, (String[])SassScssStdlibInclusionContext.SASS_BUILTIN_MODULES), (Object)("unexpected module name: " + moduleName));
        if (this.myBuiltInModuleNameToFile == null) {
            this.initGlobalAndBuiltInModuleFiles();
        }
        VirtualFile virtualFile = this.myBuiltInModuleNameToFile.get(moduleName);
        if (virtualFile == null) {
            SassScssIndexedRootProvider.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    public static SassScssIndexedRootProvider getInstance() {
        return (SassScssIndexedRootProvider)((Object)IndexableSetContributor.EP_NAME.findExtension(SassScssIndexedRootProvider.class));
    }

    private void initGlobalAndBuiltInModuleFiles() {
        if (this.myAdditionalRoots != null) {
            return;
        }
        URL globalFunctionsUrl = SassScssStubMarker.class.getResource("sass_functions.scss");
        assert (globalFunctionsUrl != null);
        VirtualFile globalFunctionsFile = VfsUtil.findFileByURL((URL)globalFunctionsUrl);
        if (globalFunctionsFile == null) {
            LOG.error("Cannot find sass stdlib file in ", new String[]{globalFunctionsUrl.getFile()});
            return;
        }
        HashSet<VirtualFile> additionalRoots = new HashSet<VirtualFile>(SassScssStdlibInclusionContext.SASS_BUILTIN_MODULES.length + 1);
        additionalRoots.add(globalFunctionsFile);
        HashMap<String, VirtualFile> builtInModuleNameToFile = new HashMap<String, VirtualFile>();
        for (String moduleName : SassScssStdlibInclusionContext.SASS_BUILTIN_MODULES) {
            String moduleFileName = moduleName.replace(':', '_') + ".scss";
            VirtualFile moduleFile = globalFunctionsFile.getParent().findChild(moduleFileName);
            if (moduleFile != null) {
                builtInModuleNameToFile.put(moduleName, moduleFile);
                additionalRoots.add(moduleFile);
                continue;
            }
            LOG.error("Cannot find sass built-in module file ", new String[]{moduleFileName});
        }
        this.myGlobalFunctionsFile = globalFunctionsFile;
        this.myBuiltInModuleNameToFile = builtInModuleNameToFile;
        this.myAdditionalRoots = additionalRoots;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/scss/index/SassScssIndexedRootProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalRootsToIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalFunctionsFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/scss/index/SassScssIndexedRootProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltInModuleFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltInModuleFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

