/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.lexer.YAMLGrammarCharUtil;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.impl.YAMLScalarImpl;
import org.jetbrains.yaml.psi.impl.YamlScalarTextEvaluator;

public class YAMLPlainTextImpl
extends YAMLScalarImpl
implements YAMLScalar {
    public YAMLPlainTextImpl(@NotNull ASTNode node) {
        if (node == null) {
            YAMLPlainTextImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        int myStart = this.getTextRange().getStartOffset();
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        TextRange textRange = null;
        for (ASTNode child = this.getFirstContentNode(); child != null; child = child.getTreeNext()) {
            TextRange childRange = child.getTextRange().shiftRight(-myStart);
            if (child.getElementType() == YAMLTokenTypes.TEXT) {
                if (textRange != null) {
                    result.add(textRange);
                }
                textRange = childRange;
                continue;
            }
            if (child.getElementType() != YAMLTokenTypes.EOL) continue;
            if (textRange == null) {
                result.add(childRange);
                continue;
            }
            result.add(textRange.union(childRange));
            textRange = null;
        }
        if (textRange != null) {
            result.add(textRange);
        }
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            YAMLPlainTextImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public YamlScalarTextEvaluator getTextEvaluator() {
        return new YamlScalarTextEvaluator<YAMLPlainTextImpl>(this){

            @Override
            @NotNull
            public List<TextRange> getContentRanges() {
                int myStart = YAMLPlainTextImpl.this.getTextRange().getStartOffset();
                ArrayList<TextRange> result = new ArrayList<TextRange>();
                boolean seenText = false;
                for (ASTNode child = YAMLPlainTextImpl.this.getFirstContentNode(); child != null; child = child.getTreeNext()) {
                    if (child.getElementType() == YAMLTokenTypes.TEXT) {
                        seenText = true;
                        result.add(child.getTextRange().shiftRight(-myStart));
                        continue;
                    }
                    if (child.getElementType() != YAMLTokenTypes.EOL) continue;
                    if (!seenText) {
                        result.add(child.getTextRange().shiftRight(-myStart));
                    }
                    seenText = false;
                }
                ArrayList<TextRange> arrayList = result;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            @Override
            @NotNull
            protected String getRangesJoiner(@NotNull CharSequence text, @NotNull List<TextRange> contentRanges, int indexBefore) {
                if (text == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (contentRanges == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (this.isNewline(text, contentRanges.get(indexBefore)) || this.isNewline(text, contentRanges.get(indexBefore + 1))) {
                    return "";
                }
                return " ";
            }

            private boolean isNewline(@NotNull CharSequence text, @NotNull TextRange range) {
                if (text == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (range == null) {
                    1.$$$reportNull$$$0(4);
                }
                return range.getLength() == 1 && text.charAt(range.getStartOffset()) == '\n';
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl$1";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "contentRanges";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "range";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContentRanges";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getRangesJoiner";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "isNewline";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    protected List<Pair<TextRange, String>> getEncodeReplacements(@NotNull CharSequence input) throws IllegalArgumentException {
        if (input == null) {
            YAMLPlainTextImpl.$$$reportNull$$$0(2);
        }
        YAMLPlainTextImpl.checkForConsistency(input);
        return super.getDecodeReplacements(input);
    }

    private static void checkForConsistency(@NotNull CharSequence input) throws IllegalArgumentException {
        if (input == null) {
            YAMLPlainTextImpl.$$$reportNull$$$0(3);
        }
        if (input.length() == 0) {
            throw new IllegalArgumentException("Cannot be empty");
        }
        if (!YAMLGrammarCharUtil.isNonSpaceChar(input.charAt(0)) || !YAMLGrammarCharUtil.isNonSpaceChar(input.charAt(input.length() - 1))) {
            throw new IllegalArgumentException("Cannot have leading or trailing whitespaces");
        }
        char firstChar = input.charAt(0);
        if ((firstChar != '?' && firstChar != ':' && firstChar != '-' || input.length() <= 1 || !YAMLGrammarCharUtil.isPlainSafe(input.charAt(1))) && YAMLGrammarCharUtil.isIndicatorChar(firstChar)) {
            throw new IllegalArgumentException("Could not start with indicator chars");
        }
        for (int i = 1; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\n' && !YAMLPlainTextImpl.isSurroundedByNoSpace(input, i)) {
                throw new IllegalArgumentException("Could not form line with leading/trailing whitespace");
            }
            if (YAMLGrammarCharUtil.isSpaceLike(c) || YAMLGrammarCharUtil.isPlainSafe(c) && c != ':' && c != '#' || c == '#' && YAMLGrammarCharUtil.isNonSpaceChar(input.charAt(i - 1)) || c == ':' && i + 1 < input.length() && YAMLGrammarCharUtil.isPlainSafe(input.charAt(i + 1))) continue;
            throw new IllegalArgumentException("Restricted characters appeared");
        }
    }

    @Override
    public String toString() {
        return "YAML plain scalar text";
    }

    @Override
    public boolean isMultiline() {
        return this.getNode().findChildByType((IElementType)YAMLTokenTypes.EOL) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEncodeReplacements";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkForConsistency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

