/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.auth;

import java.util.Date;
import org.gradle.internal.impldep.com.amazonaws.ClientConfiguration;
import org.gradle.internal.impldep.com.amazonaws.auth.AWSSessionCredentials;
import org.gradle.internal.impldep.com.amazonaws.auth.AWSSessionCredentialsProvider;
import org.gradle.internal.impldep.com.amazonaws.auth.AnonymousAWSCredentials;
import org.gradle.internal.impldep.com.amazonaws.auth.BasicSessionCredentials;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityResult;
import org.gradle.internal.impldep.com.amazonaws.services.securitytoken.model.Credentials;

public class WebIdentityFederationSessionCredentialsProvider
implements AWSSessionCredentialsProvider {
    public static final int DEFAULT_DURATION_SECONDS = 3600;
    public static final int DEFAULT_THRESHOLD_SECONDS = 500;
    private final AWSSecurityTokenService securityTokenService;
    private AWSSessionCredentials sessionCredentials;
    private Date sessionCredentialsExpiration;
    private final String wifToken;
    private final String wifProvider;
    private final String roleArn;
    private int sessionDuration;
    private int refreshThreshold;
    private String subjectFromWIF;

    public WebIdentityFederationSessionCredentialsProvider(String wifToken, String wifProvider, String roleArn) {
        this(wifToken, wifProvider, roleArn, new ClientConfiguration());
    }

    public WebIdentityFederationSessionCredentialsProvider(String wifToken, String wifProvider, String roleArn, ClientConfiguration clientConfiguration) {
        this(wifToken, wifProvider, roleArn, new AWSSecurityTokenServiceClient(new AnonymousAWSCredentials(), clientConfiguration));
    }

    public WebIdentityFederationSessionCredentialsProvider(String wifToken, String wifProvider, String roleArn, AWSSecurityTokenService stsClient) {
        this.securityTokenService = stsClient;
        this.wifProvider = wifProvider;
        this.wifToken = wifToken;
        this.roleArn = roleArn;
        this.sessionDuration = 3600;
        this.refreshThreshold = 500;
    }

    @Override
    public AWSSessionCredentials getCredentials() {
        if (this.needsNewSession()) {
            this.startSession();
        }
        return this.sessionCredentials;
    }

    @Override
    public void refresh() {
        this.startSession();
    }

    public void setSessionDuration(int sessionDuration) {
        this.sessionDuration = sessionDuration;
    }

    public WebIdentityFederationSessionCredentialsProvider withSessionDuration(int sessionDuration) {
        this.setSessionDuration(sessionDuration);
        return this;
    }

    public int getSessionDuration() {
        return this.sessionDuration;
    }

    public void setRefreshThreshold(int refreshThreshold) {
        this.refreshThreshold = refreshThreshold;
    }

    public WebIdentityFederationSessionCredentialsProvider withRefreshThreshold(int refreshThreshold) {
        this.setRefreshThreshold(refreshThreshold);
        return this;
    }

    public int getRefreshThreshold() {
        return this.refreshThreshold;
    }

    public String getSubjectFromWIF() {
        return this.subjectFromWIF;
    }

    private void startSession() {
        AssumeRoleWithWebIdentityResult sessionTokenResult = this.securityTokenService.assumeRoleWithWebIdentity(new AssumeRoleWithWebIdentityRequest().withWebIdentityToken(this.wifToken).withProviderId(this.wifProvider).withRoleArn(this.roleArn).withRoleSessionName("ProviderSession").withDurationSeconds(this.sessionDuration));
        Credentials stsCredentials = sessionTokenResult.getCredentials();
        this.subjectFromWIF = sessionTokenResult.getSubjectFromWebIdentityToken();
        this.sessionCredentials = new BasicSessionCredentials(stsCredentials.getAccessKeyId(), stsCredentials.getSecretAccessKey(), stsCredentials.getSessionToken());
        this.sessionCredentialsExpiration = stsCredentials.getExpiration();
    }

    private boolean needsNewSession() {
        if (this.sessionCredentials == null) {
            return true;
        }
        long timeRemaining = this.sessionCredentialsExpiration.getTime() - System.currentTimeMillis();
        return timeRemaining < (long)(this.refreshThreshold * 1000);
    }
}

