/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.services.s3.transfer.internal;

import java.util.concurrent.Future;
import org.apache.commons.logging.LogFactory;
import org.gradle.internal.impldep.com.amazonaws.event.DeliveryMode;
import org.gradle.internal.impldep.com.amazonaws.event.ProgressListener;
import org.gradle.internal.impldep.com.amazonaws.event.SDKProgressPublisher;
import org.gradle.internal.impldep.com.amazonaws.services.s3.transfer.PersistableTransfer;
import org.gradle.internal.impldep.com.amazonaws.services.s3.transfer.internal.S3ProgressListener;

public class S3ProgressPublisher
extends SDKProgressPublisher {
    public static Future<?> publishTransferPersistable(ProgressListener listener, PersistableTransfer persistableTransfer) {
        if (persistableTransfer == null || !(listener instanceof S3ProgressListener)) {
            return null;
        }
        S3ProgressListener s3listener = (S3ProgressListener)listener;
        return S3ProgressPublisher.deliverEvent(s3listener, persistableTransfer);
    }

    private static Future<?> deliverEvent(final S3ProgressListener listener, final PersistableTransfer persistableTransfer) {
        DeliveryMode mode;
        if (listener instanceof DeliveryMode && (mode = (DeliveryMode)((Object)listener)).isSyncCallSafe()) {
            return S3ProgressPublisher.quietlyCallListener(listener, persistableTransfer);
        }
        return S3ProgressPublisher.setLatestFutureTask(S3ProgressPublisher.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                listener.onPersistableTransfer(persistableTransfer);
            }
        }));
    }

    private static Future<?> quietlyCallListener(S3ProgressListener listener, PersistableTransfer persistableTransfer) {
        try {
            listener.onPersistableTransfer(persistableTransfer);
        }
        catch (Throwable t) {
            LogFactory.getLog(S3ProgressPublisher.class).debug((Object)"Failure from the event listener", t);
        }
        return null;
    }
}

