/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.BCPGInputStream;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.LiteralDataPacket;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.Packet;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.Util;

public class PGPLiteralData {
    public static final char BINARY = 'b';
    public static final char TEXT = 't';
    public static final char UTF8 = 'u';
    public static final String CONSOLE = "_CONSOLE";
    public static final Date NOW = new Date(0L);
    LiteralDataPacket data;

    public PGPLiteralData(byte[] byArray) throws IOException {
        this(Util.createBCPGInputStream(new ByteArrayInputStream(byArray), 11));
    }

    public PGPLiteralData(InputStream inputStream) throws IOException {
        this(Util.createBCPGInputStream(inputStream, 11));
    }

    public PGPLiteralData(BCPGInputStream bCPGInputStream) throws IOException {
        Packet packet = bCPGInputStream.readPacket();
        if (!(packet instanceof LiteralDataPacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        this.data = (LiteralDataPacket)packet;
    }

    public int getFormat() {
        return this.data.getFormat();
    }

    public String getFileName() {
        return this.data.getFileName();
    }

    public byte[] getRawFileName() {
        return this.data.getRawFileName();
    }

    public Date getModificationTime() {
        return new Date(this.data.getModificationTime());
    }

    public InputStream getInputStream() {
        return this.data.getInputStream();
    }

    public InputStream getDataStream() {
        return this.getInputStream();
    }
}

