/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.api;

import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;

public abstract class GitCommand<T>
implements Callable<T> {
    protected final Repository repo;
    private AtomicBoolean callable = new AtomicBoolean(true);

    protected GitCommand(Repository repo) {
        this.repo = repo;
    }

    public Repository getRepository() {
        return this.repo;
    }

    protected void setCallable(boolean callable) {
        this.callable.set(callable);
    }

    protected void checkCallable() {
        if (!this.callable.get()) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().commandWasCalledInTheWrongState, this.getClass().getName()));
        }
    }

    @Override
    public abstract T call() throws GitAPIException;
}

