/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import org.gradle.internal.impldep.org.eclipse.jgit.api.GitCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.JGitInternalException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.NoHeadException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.StashApplyFailureException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCache;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCacheBuilder;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCacheCheckout;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCacheEntry;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCacheIterator;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.CheckoutConflictException;
import org.gradle.internal.impldep.org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.CoreConfig;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectReader;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.RepositoryState;
import org.gradle.internal.impldep.org.eclipse.jgit.merge.MergeStrategy;
import org.gradle.internal.impldep.org.eclipse.jgit.merge.ResolveMerger;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevCommit;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevTree;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.FileTreeIterator;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.TreeWalk;

public class StashApplyCommand
extends GitCommand<ObjectId> {
    private static final String DEFAULT_REF = "stash@{0}";
    private String stashRef;
    private boolean restoreIndex = true;
    private boolean restoreUntracked = true;
    private boolean ignoreRepositoryState;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;

    public StashApplyCommand(Repository repo) {
        super(repo);
    }

    public StashApplyCommand setStashRef(String stashRef) {
        this.stashRef = stashRef;
        return this;
    }

    public StashApplyCommand ignoreRepositoryState(boolean willIgnoreRepositoryState) {
        this.ignoreRepositoryState = willIgnoreRepositoryState;
        return this;
    }

    private ObjectId getStashId() throws GitAPIException {
        ObjectId stashId;
        String revision = this.stashRef != null ? this.stashRef : DEFAULT_REF;
        try {
            stashId = this.repo.resolve(revision);
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().stashResolveFailed, revision), e);
        }
        if (stashId == null) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().stashResolveFailed, revision));
        }
        return stashId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ObjectId call() throws GitAPIException, WrongRepositoryStateException, NoHeadException, StashApplyFailureException {
        this.checkCallable();
        if (!this.ignoreRepositoryState && this.repo.getRepositoryState() != RepositoryState.SAFE) {
            throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().stashApplyOnUnsafeRepository, new Object[]{this.repo.getRepositoryState()}));
        }
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try {
                ObjectReader reader = this.repo.newObjectReader();
                RevWalk revWalk = new RevWalk(reader);
                try {
                    boolean ok;
                    ObjectId headCommit = this.repo.resolve("HEAD");
                    if (headCommit == null) {
                        throw new NoHeadException(JGitText.get().stashApplyWithoutHead);
                    }
                    ObjectId stashId = this.getStashId();
                    RevCommit stashCommit = revWalk.parseCommit(stashId);
                    if (stashCommit.getParentCount() < 2 || stashCommit.getParentCount() > 3) {
                        throw new JGitInternalException(MessageFormat.format(JGitText.get().stashCommitIncorrectNumberOfParents, stashId.name(), stashCommit.getParentCount()));
                    }
                    ObjectId headTree = this.repo.resolve("HEAD^{tree}");
                    RevCommit stashIndexCommit = revWalk.parseCommit(stashCommit.getParent(1));
                    RevCommit stashHeadCommit = stashCommit.getParent(0);
                    RevCommit untrackedCommit = null;
                    if (this.restoreUntracked && stashCommit.getParentCount() == 3) {
                        untrackedCommit = revWalk.parseCommit(stashCommit.getParent(2));
                    }
                    ResolveMerger merger = (ResolveMerger)this.strategy.newMerger(this.repo);
                    merger.setCommitNames(new String[]{"stashed HEAD", "HEAD", "stash"});
                    merger.setBase(stashHeadCommit);
                    merger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                    boolean mergeSucceeded = merger.merge(headCommit, stashCommit);
                    List<String> modifiedByMerge = merger.getModifiedFiles();
                    if (!modifiedByMerge.isEmpty()) {
                        this.repo.fireEvent(new WorkingTreeModifiedEvent(modifiedByMerge, null));
                    }
                    if (!mergeSucceeded) throw new StashApplyFailureException(JGitText.get().stashApplyConflict);
                    DirCache dc = this.repo.lockDirCache();
                    DirCacheCheckout dco = new DirCacheCheckout(this.repo, headTree, dc, merger.getResultTreeId());
                    dco.setFailOnConflict(true);
                    dco.checkout();
                    if (this.restoreIndex) {
                        ResolveMerger ixMerger = (ResolveMerger)this.strategy.newMerger(this.repo, true);
                        ixMerger.setCommitNames(new String[]{"stashed HEAD", "HEAD", "stashed index"});
                        ixMerger.setBase(stashHeadCommit);
                        ok = ixMerger.merge(headCommit, stashIndexCommit);
                        if (!ok) throw new StashApplyFailureException(JGitText.get().stashApplyConflict);
                        this.resetIndex(revWalk.parseTree(ixMerger.getResultTreeId()));
                    }
                    if (untrackedCommit != null) {
                        ResolveMerger untrackedMerger = (ResolveMerger)this.strategy.newMerger(this.repo, true);
                        untrackedMerger.setCommitNames(new String[]{"null", "HEAD", "untracked files"});
                        untrackedMerger.setBase(null);
                        ok = untrackedMerger.merge(headCommit, untrackedCommit);
                        if (!ok) throw new StashApplyFailureException(JGitText.get().stashApplyConflict);
                        try {
                            RevTree untrackedTree = revWalk.parseTree(untrackedCommit);
                            this.resetUntracked(untrackedTree);
                        }
                        catch (CheckoutConflictException e) {
                            throw new StashApplyFailureException(JGitText.get().stashApplyConflict, e);
                        }
                    }
                    if (revWalk != null) {
                        revWalk.close();
                    }
                    if (reader == null) return stashId;
                    reader.close();
                    return stashId;
                }
                catch (Throwable throwable2) {
                    try {
                        if (revWalk == null) throw throwable2;
                        revWalk.close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (reader == null) throw throwable;
                        reader.close();
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                } else {
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (JGitInternalException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().stashApplyFailed, e);
        }
    }

    @Deprecated
    public void setApplyIndex(boolean applyIndex) {
        this.restoreIndex = applyIndex;
    }

    public StashApplyCommand setRestoreIndex(boolean restoreIndex) {
        this.restoreIndex = restoreIndex;
        return this;
    }

    public StashApplyCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    @Deprecated
    public void setApplyUntracked(boolean applyUntracked) {
        this.restoreUntracked = applyUntracked;
    }

    public StashApplyCommand setRestoreUntracked(boolean restoreUntracked) {
        this.restoreUntracked = restoreUntracked;
        return this;
    }

    private void resetIndex(RevTree tree) throws IOException {
        DirCache dc = this.repo.lockDirCache();
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (TreeWalk walk = new TreeWalk(this.repo);){
                DirCacheBuilder builder = dc.builder();
                walk.addTree(tree);
                walk.addTree(new DirCacheIterator(dc));
                walk.setRecursive(true);
                while (walk.next()) {
                    AbstractTreeIterator cIter = walk.getTree(0, AbstractTreeIterator.class);
                    if (cIter == null) continue;
                    DirCacheEntry entry = new DirCacheEntry(walk.getRawPath());
                    entry.setFileMode(cIter.getEntryFileMode());
                    entry.setObjectIdFromRaw(cIter.idBuffer(), cIter.idOffset());
                    DirCacheIterator dcIter = walk.getTree(1, DirCacheIterator.class);
                    if (dcIter != null && dcIter.idEqual(cIter)) {
                        DirCacheEntry indexEntry = dcIter.getDirCacheEntry();
                        entry.setLastModified(indexEntry.getLastModifiedInstant());
                        entry.setLength(indexEntry.getLength());
                    }
                    builder.add(entry);
                }
                builder.commit();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            dc.unlock();
        }
    }

    private void resetUntracked(RevTree tree) throws CheckoutConflictException, IOException {
        HashSet<String> actuallyModifiedPaths = new HashSet<String>();
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (TreeWalk walk = new TreeWalk(this.repo);){
                walk.addTree(tree);
                walk.addTree(new FileTreeIterator(this.repo));
                walk.setRecursive(true);
                ObjectReader reader = walk.getObjectReader();
                while (walk.next()) {
                    AbstractTreeIterator cIter = walk.getTree(0, AbstractTreeIterator.class);
                    if (cIter == null) continue;
                    CoreConfig.EolStreamType eolStreamType = walk.getEolStreamType(TreeWalk.OperationType.CHECKOUT_OP);
                    DirCacheEntry entry = new DirCacheEntry(walk.getRawPath());
                    entry.setFileMode(cIter.getEntryFileMode());
                    entry.setObjectIdFromRaw(cIter.idBuffer(), cIter.idOffset());
                    FileTreeIterator fIter = walk.getTree(1, FileTreeIterator.class);
                    if (fIter != null && fIter.isModified(entry, true, reader)) {
                        throw new CheckoutConflictException(entry.getPathString());
                    }
                    this.checkoutPath(entry, reader, new DirCacheCheckout.CheckoutMetadata(eolStreamType, null));
                    actuallyModifiedPaths.add(entry.getPathString());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (!actuallyModifiedPaths.isEmpty()) {
                this.repo.fireEvent(new WorkingTreeModifiedEvent(actuallyModifiedPaths, null));
            }
        }
    }

    private void checkoutPath(DirCacheEntry entry, ObjectReader reader, DirCacheCheckout.CheckoutMetadata checkoutMetadata) {
        try {
            DirCacheCheckout.checkoutEntry(this.repo, entry, reader, true, checkoutMetadata);
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutConflictWithFile, entry.getPathString()), e);
        }
    }
}

