/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.launcher.core;

import java.util.Collection;
import java.util.Collections;
import org.gradle.internal.impldep.org.junit.platform.commons.util.Preconditions;
import org.gradle.internal.impldep.org.junit.platform.engine.TestEngine;
import org.gradle.internal.impldep.org.junit.platform.launcher.Launcher;
import org.gradle.internal.impldep.org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.gradle.internal.impldep.org.junit.platform.launcher.PostDiscoveryFilter;
import org.gradle.internal.impldep.org.junit.platform.launcher.TestExecutionListener;
import org.gradle.internal.impldep.org.junit.platform.launcher.TestPlan;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.EngineDiscoveryOrchestrator;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.EngineExecutionOrchestrator;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.EngineIdValidator;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.InternalTestPlan;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.LauncherDiscoveryResult;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.TestExecutionListenerRegistry;

class DefaultLauncher
implements Launcher {
    private final TestExecutionListenerRegistry listenerRegistry = new TestExecutionListenerRegistry();
    private final EngineExecutionOrchestrator executionOrchestrator = new EngineExecutionOrchestrator(this.listenerRegistry);
    private final EngineDiscoveryOrchestrator discoveryOrchestrator;

    DefaultLauncher(Iterable<TestEngine> testEngines, Collection<PostDiscoveryFilter> filters) {
        Preconditions.condition(testEngines != null && testEngines.iterator().hasNext(), () -> "Cannot create Launcher without at least one TestEngine; consider adding an engine implementation JAR to the classpath");
        Preconditions.notNull(filters, "PostDiscoveryFilter array must not be null");
        Preconditions.containsNoNullElements(filters, "PostDiscoveryFilter array must not contain null elements");
        this.discoveryOrchestrator = new EngineDiscoveryOrchestrator(EngineIdValidator.validate(testEngines), Collections.unmodifiableCollection(filters));
    }

    @Override
    public void registerTestExecutionListeners(TestExecutionListener ... listeners) {
        Preconditions.notEmpty(listeners, "listeners array must not be null or empty");
        Preconditions.containsNoNullElements(listeners, "individual listeners must not be null");
        this.listenerRegistry.registerListeners(listeners);
    }

    @Override
    public TestPlan discover(LauncherDiscoveryRequest discoveryRequest) {
        Preconditions.notNull(discoveryRequest, "LauncherDiscoveryRequest must not be null");
        return InternalTestPlan.from(this.discover(discoveryRequest, "discovery"));
    }

    @Override
    public void execute(LauncherDiscoveryRequest discoveryRequest, TestExecutionListener ... listeners) {
        Preconditions.notNull(discoveryRequest, "LauncherDiscoveryRequest must not be null");
        Preconditions.notNull(listeners, "TestExecutionListener array must not be null");
        Preconditions.containsNoNullElements(listeners, "individual listeners must not be null");
        this.execute(InternalTestPlan.from(this.discover(discoveryRequest, "execution")), listeners);
    }

    @Override
    public void execute(TestPlan testPlan, TestExecutionListener ... listeners) {
        Preconditions.notNull(testPlan, "TestPlan must not be null");
        Preconditions.condition(testPlan instanceof InternalTestPlan, "TestPlan was not returned by this Launcher");
        Preconditions.notNull(listeners, "TestExecutionListener array must not be null");
        Preconditions.containsNoNullElements(listeners, "individual listeners must not be null");
        this.execute((InternalTestPlan)testPlan, listeners);
    }

    TestExecutionListenerRegistry getTestExecutionListenerRegistry() {
        return this.listenerRegistry;
    }

    private LauncherDiscoveryResult discover(LauncherDiscoveryRequest discoveryRequest, String phase) {
        return this.discoveryOrchestrator.discover(discoveryRequest, phase);
    }

    private void execute(InternalTestPlan internalTestPlan, TestExecutionListener[] listeners) {
        this.executionOrchestrator.execute(internalTestPlan, listeners);
    }
}

