/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.neuralnetwork;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.languagetool.rules.neuralnetwork.ResourceReader;

public class Matrix {
    private float[][] m;

    public Matrix(InputStream stream) {
        List<String> rows = ResourceReader.readAllLines(stream);
        this.fromLines(rows);
    }

    Matrix(float[] row) {
        this.m = new float[][]{row};
    }

    Matrix(List<String> rows) {
        this.fromLines(rows);
    }

    Matrix(float[][] matrix) {
        this.m = matrix;
    }

    private void fromLines(List<String> rows) {
        int nRows = rows.size();
        int nCols = rows.get(0).split(" ").length;
        this.m = new float[nRows][nCols];
        for (int i = 0; i < nRows; ++i) {
            String[] row = rows.get(i).split(" ");
            for (int j = 0; j < nCols; ++j) {
                this.m[i][j] = Float.parseFloat(row[j]);
            }
        }
    }

    float[] row(int n) {
        return Arrays.copyOf(this.m[n], this.m[n].length);
    }

    int rows() {
        return this.m.length;
    }

    int columns() {
        return this.m[0].length;
    }

    void printDimension() {
        System.out.println(this.m.length + "/" + this.m[0].length);
    }

    Matrix mul(Matrix that) {
        float[][] a = this.m;
        float[][] b = that.m;
        int rowsA = a.length;
        int colsA = a[0].length;
        int rowsB = b.length;
        int colsB = b[0].length;
        if (colsA != rowsB) {
            throw new ArithmeticException("Matrix with " + colsA + " columns cannot be multiplied with matrix with " + colsB + " rows");
        }
        float[][] c = new float[rowsA][colsB];
        for (int i = 0; i < rowsA; ++i) {
            for (int j = 0; j < colsB; ++j) {
                for (int k = 0; k < colsA; ++k) {
                    float[] fArray = c[i];
                    int n = j;
                    fArray[n] = fArray[n] + a[i][k] * b[k][j];
                }
            }
        }
        return new Matrix(c);
    }

    Matrix add(Matrix that) {
        float[][] a = this.m;
        float[][] b = that.m;
        int rowsA = a.length;
        int colsA = a[0].length;
        int rowsB = b.length;
        int colsB = b[0].length;
        if (rowsA != rowsB) {
            throw new ArithmeticException("Matrix with " + rowsA + " rows cannot be added to a matrix with " + rowsB + " rows");
        }
        if (colsA != colsB) {
            throw new ArithmeticException("Matrix with " + colsA + " columns cannot be added to a matrix with " + colsB + " columns");
        }
        float[][] c = new float[rowsA][colsA];
        for (int i = 0; i < rowsA; ++i) {
            for (int j = 0; j < colsB; ++j) {
                c[i][j] = a[i][j] + b[i][j];
            }
        }
        return new Matrix(c);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Matrix) {
            return Arrays.deepEquals((Object[])this.m, (Object[])((Matrix)obj).m);
        }
        return false;
    }

    public Matrix transpose() {
        int rows = this.m.length;
        int cols = this.m[0].length;
        float[][] b = new float[cols][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                b[j][i] = this.m[i][j];
            }
        }
        return new Matrix(b);
    }

    public Matrix relu() {
        int rows = this.m.length;
        int cols = this.m[0].length;
        float[][] b = new float[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                b[i][j] = this.m[i][j] < 0.0f ? 0.0f : this.m[i][j];
            }
        }
        return new Matrix(b);
    }
}

