/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.remote.CredentialsType;
import com.jetbrains.plugins.remotesdk.RemoteSdkUsagesProvider;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RemoteSdkTypeUsagesCollector {
    private static final ExtensionPointName<RemoteSdkUsagesProvider> EP_NAME = new ExtensionPointName("com.jetbrains.plugins.remotesdk.usagesProvider");

    RemoteSdkTypeUsagesCollector() {
    }

    @NotNull
    private static Set<MetricEvent> collectUsages(@Nullable Project project) {
        HashSet<MetricEvent> usages = new HashSet<MetricEvent>();
        for (RemoteSdkUsagesProvider provider : EP_NAME.getExtensionList()) {
            Map<CredentialsType, Long> collected = provider.getRemoteSdks(project).stream().map(sdk -> sdk.getRemoteConnectionType()).collect(Collectors.groupingBy(type -> type, Collectors.counting()));
            FeatureUsageData data = new FeatureUsageData().addLanguage(provider.getLanguage()).addData("level", project == null ? "ide" : "project");
            for (Map.Entry<CredentialsType, Long> entry : collected.entrySet()) {
                CredentialsType key = entry.getKey();
                String typeName = PluginInfoDetectorKt.getPluginInfo(key.getClass()).isDevelopedByJetBrains() ? key.getName() : "third.party";
                data.addData("sdk_type", typeName);
                int count = entry.getValue() > Integer.MAX_VALUE ? Integer.MAX_VALUE : entry.getValue().intValue();
                usages.add(MetricEventFactoryKt.newCounterMetric((String)"configured.sdk", (int)count, (FeatureUsageData)data));
            }
        }
        HashSet<MetricEvent> hashSet = usages;
        if (hashSet == null) {
            RemoteSdkTypeUsagesCollector.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkTypeUsagesCollector", "collectUsages"));
    }

    static final class ProjectCollector
    extends ProjectUsagesCollector {
        ProjectCollector() {
        }

        @NotNull
        public String getGroupId() {
            return "remote.sdk.type";
        }

        public int getVersion() {
            return 2;
        }

        @NotNull
        public Set<MetricEvent> getMetrics(@NotNull Project project) {
            if (project == null) {
                ProjectCollector.$$$reportNull$$$0(0);
            }
            Set<MetricEvent> set = RemoteSdkTypeUsagesCollector.collectUsages(project);
            if (set == null) {
                ProjectCollector.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/remotesdk/RemoteSdkTypeUsagesCollector$ProjectCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteSdkTypeUsagesCollector$ProjectCollector";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetrics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMetrics";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class AppCollector
    extends ApplicationUsagesCollector {
        AppCollector() {
        }

        @NotNull
        public String getGroupId() {
            return "remote.sdk.type";
        }

        public int getVersion() {
            return 2;
        }

        @NotNull
        public Set<MetricEvent> getMetrics() {
            Set<MetricEvent> set = RemoteSdkTypeUsagesCollector.collectUsages(null);
            if (set == null) {
                AppCollector.$$$reportNull$$$0(0);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkTypeUsagesCollector$AppCollector", "getMetrics"));
        }
    }
}

