/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.CoverageClassfileTransformer;
import com.intellij.rt.coverage.instrumentation.SaveHook;
import com.intellij.rt.coverage.instrumentation.testTracking.NoTestTrackingMode;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingArrayMode;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingClassDataMode;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingMode;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.ProjectDataLoader;
import com.intellij.rt.coverage.util.ReportFormat;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Instrumentator {
    public static void premain(String argsString, Instrumentation instrumentation) throws Exception {
        new Instrumentator().performPremain(argsString, instrumentation);
    }

    public void performPremain(String argsString, Instrumentation instrumentation) throws Exception {
        File sourceMapFile;
        boolean sampling;
        String[] args;
        if (argsString != null) {
            File argsFile = new File(argsString);
            if (argsFile.isFile()) {
                try {
                    args = this.readArgsFromFile(argsString);
                }
                catch (IOException e) {
                    ErrorReporter.reportError("Arguments were not passed correctly", e);
                    return;
                }
            } else {
                args = Instrumentator.tokenize(argsString);
            }
        } else {
            ErrorReporter.reportError("Argument string should be passed");
            return;
        }
        if (0 < args.length && args.length < 5) {
            System.err.println("At least 5 arguments expected but " + args.length + " found.\nExpected arguments are:\n1) data file to save coverage result\n2) a flag to enable tracking per test coverage\n3) a flag to calculate coverage for unloaded classes\n4) a flag to use data file as initial coverage\n5) a flag to run coverage in sampling mode or in tracing mode otherwise\n");
            System.exit(1);
        }
        File dataFile = args.length > 0 ? new File(args[0]) : null;
        boolean traceLines = args.length > 0 && Boolean.parseBoolean(args[1]);
        boolean calcUnloaded = args.length > 0 && Boolean.parseBoolean(args[2]);
        ProjectData initialData = args.length > 0 && Boolean.parseBoolean(args[3]) && dataFile.isFile() ? ProjectDataLoader.load(dataFile) : null;
        boolean bl = sampling = args.length == 0 || Boolean.parseBoolean(args[4]);
        if (dataFile != null) {
            ErrorReporter.setBasePath(dataFile.getParent());
        }
        int i = 5;
        if (args.length > 5 && Boolean.parseBoolean(args[5])) {
            sourceMapFile = new File(args[6]);
            i = 7;
        } else {
            sourceMapFile = null;
        }
        ReportFormat reportFormat = ReportFormat.BINARY;
        if (i < args.length && args[i].equals("-xml")) {
            this.checkXMLReportCompatibility();
            ++i;
            reportFormat = ReportFormat.XML;
        }
        ArrayList<Pattern> includePatterns = new ArrayList<Pattern>();
        System.out.println("---- IntelliJ IDEA coverage runner ---- ");
        System.out.println(sampling ? "sampling ..." : "tracing " + (traceLines ? "and tracking per test coverage ..." : "..."));
        String excludes = "-exclude";
        System.out.println("include patterns:");
        while (i < args.length && !"-exclude".equals(args[i])) {
            try {
                includePatterns.add(Pattern.compile(args[i]));
                System.out.println(args[i]);
            }
            catch (PatternSyntaxException ex) {
                System.err.println("Problem occurred with include pattern " + args[i]);
                System.err.println(ex.getDescription());
                System.err.println("This may cause no tests run and no coverage collected");
                System.exit(1);
            }
            ++i;
        }
        System.out.println("exclude patterns:");
        ++i;
        ArrayList<Pattern> excludePatterns = new ArrayList<Pattern>();
        while (i < args.length) {
            try {
                Pattern pattern = Pattern.compile(args[i]);
                excludePatterns.add(pattern);
                System.out.println(pattern.pattern());
            }
            catch (PatternSyntaxException ex) {
                System.err.println("Problem occurred with exclude pattern " + args[i]);
                System.err.println(ex.getDescription());
                System.err.println("This may cause no tests run and no coverage collected");
                System.exit(1);
            }
            ++i;
        }
        TestTrackingMode testTrackingMode = this.createTestTrackingMode(traceLines);
        ProjectData data = ProjectData.createProjectData(dataFile, initialData, traceLines, sampling, includePatterns, excludePatterns, testTrackingMode.createTestTrackingCallback());
        ClassFinder cf = new ClassFinder(includePatterns, excludePatterns);
        if (dataFile != null) {
            SaveHook hook = new SaveHook(dataFile, calcUnloaded, cf, reportFormat);
            hook.setSourceMapFile(sourceMapFile);
            Runtime.getRuntime().addShutdownHook(new Thread(hook));
        }
        boolean shouldCalculateSource = sourceMapFile != null || reportFormat == ReportFormat.XML;
        instrumentation.addTransformer(new CoverageClassfileTransformer(data, shouldCalculateSource, excludePatterns, includePatterns, cf, testTrackingMode));
    }

    private void checkXMLReportCompatibility() {
        try {
            Class.forName("javax.xml.stream.XMLStreamWriter");
        }
        catch (ClassNotFoundException e) {
            System.err.println("XML report is available if JDK version is higher than 6. javax.xml.stream.* classes were not found.");
            System.exit(1);
        }
    }

    private TestTrackingMode createTestTrackingMode(boolean traceLines) {
        if (!traceLines) {
            return new NoTestTrackingMode();
        }
        if (System.getProperty("idea.new.tracing.coverage") != null && "true".equals(System.getProperty("idea.new.test.tracking.coverage", "true"))) {
            return new TestTrackingArrayMode();
        }
        return new TestTrackingClassDataMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] readArgsFromFile(String arg) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        File file = new File(arg);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            while (reader.ready()) {
                result.add(reader.readLine());
            }
        }
        finally {
            reader.close();
        }
        return result.toArray(new String[0]);
    }

    private static String[] tokenize(String argumentString) {
        ArrayList<String> tokenizedArgs = new ArrayList<String>();
        StringBuffer currentArg = new StringBuffer();
        block4: for (int i = 0; i < argumentString.length(); ++i) {
            char c = argumentString.charAt(i);
            switch (c) {
                default: {
                    currentArg.append(c);
                    continue block4;
                }
                case ' ': {
                    String arg = currentArg.toString();
                    if (arg.length() > 0) {
                        tokenizedArgs.add(arg);
                    }
                    currentArg = new StringBuffer();
                    continue block4;
                }
                case '\"': {
                    char d;
                    ++i;
                    while (i < argumentString.length() && (d = argumentString.charAt(i)) != '\"') {
                        currentArg.append(d);
                        ++i;
                    }
                    break block0;
                }
            }
        }
        String arg = currentArg.toString();
        if (arg.length() > 0) {
            tokenizedArgs.add(arg);
        }
        return tokenizedArgs.toArray(new String[0]);
    }
}

