/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.AbstractTracingInstrumenter;
import com.intellij.rt.coverage.instrumentation.ExtraFieldInstrumenter;
import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.LineEnumerator;
import com.intellij.rt.coverage.instrumentation.LocalVariableInserter;
import com.intellij.rt.coverage.instrumentation.data.BranchDataContainer;
import com.intellij.rt.coverage.instrumentation.data.Jump;
import com.intellij.rt.coverage.instrumentation.data.Switch;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class NewTracingInstrumenter
extends AbstractTracingInstrumenter {
    private static final String BRANCH_HITS_FIELD_NAME = "__$branchHits$__";
    private static final String BRANCH_HITS_FIELD_TYPE = "[I";
    private static final String BRANCH_HITS_FIELD_INIT_NAME = "__$branchHitsInit$__";
    private static final String BRANCH_HITS_LOCAL_VARIABLE_NAME = "__$localBranchHits$__";
    private static final String CLASS_INIT = "<clinit>";
    private final ExtraFieldInstrumenter myExtraFieldInstrumenter;

    public NewTracingInstrumenter(ProjectData projectData, ClassVisitor classVisitor, ClassReader cr, String className, boolean shouldCalculateSource) {
        super(projectData, classVisitor, className, shouldCalculateSource);
        this.myExtraFieldInstrumenter = new ExtraFieldTracingInstrumenter(cr, className);
    }

    public MethodVisitor createTouchCounter(MethodVisitor mv, BranchDataContainer branchData, LineEnumerator enumerator, int access, String name, String desc, String className) {
        if (!enumerator.hasExecutableLines()) {
            if (this.myExtraFieldInstrumenter.isInterface() && CLASS_INIT.equals(name)) {
                return this.myExtraFieldInstrumenter.createMethodVisitor(this, mv, mv, name);
            }
            return mv;
        }
        LocalVariableInserter visitor = new LocalVariableInserter(mv, access, desc, BRANCH_HITS_LOCAL_VARIABLE_NAME, BRANCH_HITS_FIELD_TYPE){

            public void visitLineNumber(int line, Label start) {
                LineData lineData = NewTracingInstrumenter.this.getLineData(line);
                if (lineData != null) {
                    this.incrementHitById(lineData.getId());
                }
                super.visitLineNumber(line, start);
            }

            public void visitLabel(Label label) {
                Switch aSwitch;
                super.visitLabel(label);
                Jump jump = NewTracingInstrumenter.this.myBranchData.getJump(label);
                if (jump != null) {
                    this.incrementHitById(jump.getId());
                }
                if ((aSwitch = NewTracingInstrumenter.this.myBranchData.getSwitch(label)) != null) {
                    this.incrementHitById(aSwitch.getId());
                }
            }

            private void incrementHitById(int id) {
                if (id == -1) {
                    return;
                }
                this.mv.visitVarInsn(25, this.getOrCreateLocalVariableIndex());
                InstrumentationUtils.pushInt(this.mv, id);
                InstrumentationUtils.incrementIntArrayByIndex(this.mv);
            }

            public void visitCode() {
                this.mv.visitFieldInsn(178, NewTracingInstrumenter.this.myExtraFieldInstrumenter.getInternalClassName(), NewTracingInstrumenter.BRANCH_HITS_FIELD_NAME, NewTracingInstrumenter.BRANCH_HITS_FIELD_TYPE);
                this.mv.visitVarInsn(58, this.getOrCreateLocalVariableIndex());
                super.visitCode();
            }
        };
        return this.myExtraFieldInstrumenter.createMethodVisitor(this, mv, visitor, name);
    }

    public void visitEnd() {
        this.myExtraFieldInstrumenter.generateMembers(this);
        super.visitEnd();
    }

    protected void initLineData() {
        this.myClassData.createHitsMask(this.myBranchData.getSize());
        super.initLineData();
    }

    private class ExtraFieldTracingInstrumenter
    extends ExtraFieldInstrumenter {
        public ExtraFieldTracingInstrumenter(ClassReader cr, String className) {
            super(cr, null, className, NewTracingInstrumenter.BRANCH_HITS_FIELD_NAME, NewTracingInstrumenter.BRANCH_HITS_FIELD_TYPE, NewTracingInstrumenter.BRANCH_HITS_FIELD_INIT_NAME, true);
        }

        public void initField(MethodVisitor mv) {
            mv.visitLdcInsn(NewTracingInstrumenter.this.getClassName());
            mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "getHitsMask", "(Ljava/lang/String;)[I", false);
            mv.visitFieldInsn(179, NewTracingInstrumenter.this.myExtraFieldInstrumenter.getInternalClassName(), NewTracingInstrumenter.BRANCH_HITS_FIELD_NAME, NewTracingInstrumenter.BRANCH_HITS_FIELD_TYPE);
        }
    }
}

