/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.BranchData;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLCoverageReport {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final Map<String, List<LineData>> myFiles = new HashMap<String, List<LineData>>();
    private XMLStreamWriter myOut;

    public void write(FileOutputStream fOut, ProjectData project) throws IOException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            this.myOut = factory.createXMLStreamWriter(new BufferedOutputStream(fOut));
            this.myFiles.clear();
            this.writeProject(project);
        }
        catch (XMLStreamException e) {
            throw this.wrapIOException(e);
        }
        finally {
            try {
                if (this.myOut != null) {
                    this.myOut.flush();
                    this.myOut.close();
                    this.myOut = null;
                } else {
                    fOut.close();
                }
            }
            catch (XMLStreamException e) {
                ErrorReporter.reportError("Error closing file.", e);
            }
        }
    }

    private void newLine() throws XMLStreamException {
        this.myOut.writeCharacters(NEW_LINE);
    }

    private void writeProject(ProjectData project) throws XMLStreamException {
        this.myOut.writeStartDocument();
        this.newLine();
        this.myOut.writeStartElement("report");
        this.myOut.writeAttribute("name", "Intellij Coverage Report");
        this.newLine();
        HashMap<String, List<ClassData>> packages = XMLCoverageReport.mapClassesToPackages(project);
        for (Map.Entry<String, List<ClassData>> packageEntry : packages.entrySet()) {
            String packageName = packageEntry.getKey();
            List<ClassData> classes = packageEntry.getValue();
            this.writePackage(packageName, classes);
        }
        this.myOut.writeEndElement();
        this.newLine();
        this.myOut.writeEndDocument();
        this.newLine();
    }

    private void writePackage(String packageName, List<ClassData> classes) throws XMLStreamException {
        this.myOut.writeStartElement("package");
        this.myOut.writeAttribute("name", packageName);
        this.newLine();
        this.myFiles.clear();
        for (ClassData classData : classes) {
            this.writeClass(classData);
        }
        for (Map.Entry entry : this.myFiles.entrySet()) {
            String fileName = (String)entry.getKey();
            List lines = (List)entry.getValue();
            this.writeFile(fileName, lines);
        }
        this.myOut.writeEndElement();
        this.newLine();
    }

    private void writeFile(String fileName, List<LineData> lines) throws XMLStreamException {
        this.myOut.writeStartElement("sourcefile");
        this.myOut.writeAttribute("name", fileName);
        this.newLine();
        for (LineData lineData : lines) {
            if (lineData == null) continue;
            this.writeLine(lineData);
        }
        this.myOut.writeEndElement();
        this.newLine();
    }

    private void writeClass(ClassData classData) throws XMLStreamException {
        this.myOut.writeStartElement("class");
        this.myOut.writeAttribute("name", classData.getName());
        String sourceName = classData.getSource();
        if (sourceName != null && sourceName.length() > 0) {
            this.myOut.writeAttribute("sourcefilename", classData.getSource());
            this.newLine();
            List<LineData> lines = this.myFiles.get(sourceName);
            ArrayList<LineData> newLines = new ArrayList<LineData>();
            LineData[] linesArray = (LineData[])classData.getLines();
            if (linesArray != null) {
                newLines.addAll(Arrays.asList(linesArray));
            }
            if (lines == null) {
                this.myFiles.put(sourceName, newLines);
            } else {
                lines.addAll(newLines);
            }
        } else {
            this.newLine();
        }
        Map<String, List<LineData>> methods = classData.mapLinesToMethods();
        for (Map.Entry<String, List<LineData>> methodEntry : methods.entrySet()) {
            this.writeMethod(methodEntry.getKey(), methodEntry.getValue());
        }
        this.myOut.writeEndElement();
        this.newLine();
    }

    private void writeMethod(String signature, List<LineData> lines) throws XMLStreamException {
        this.myOut.writeStartElement("method");
        int nameIndex = signature.indexOf(40);
        String name = signature.substring(0, nameIndex);
        String descriptor = signature.substring(nameIndex);
        this.myOut.writeAttribute("name", name);
        this.myOut.writeAttribute("desc", descriptor);
        this.newLine();
        int totalLines = 0;
        int coveredLines = 0;
        int totalBranches = 0;
        int coveredBranches = 0;
        for (LineData lineData : lines) {
            if (lineData == null) continue;
            ++totalLines;
            coveredLines += lineData.getHits() > 0 ? 1 : 0;
            BranchData branchData = lineData.getBranchData();
            if (branchData == null) continue;
            totalBranches += branchData.getTotalBranches();
            coveredBranches += branchData.getCoveredBranches();
        }
        this.writeCounter("LINE", totalLines, coveredLines);
        this.writeCounter("BRANCH", totalBranches, coveredBranches);
        this.myOut.writeEndElement();
        this.newLine();
    }

    private void writeLine(LineData lineData) throws XMLStreamException {
        this.myOut.writeEmptyElement("line");
        this.myOut.writeAttribute("nr", Integer.toString(lineData.getLineNumber()));
        BranchData branchData = lineData.getBranchData();
        int totalBranches = branchData == null ? 0 : branchData.getTotalBranches();
        int coveredBranches = branchData == null ? 0 : branchData.getCoveredBranches();
        this.myOut.writeAttribute("cb", Integer.toString(coveredBranches));
        this.myOut.writeAttribute("mb", Integer.toString(totalBranches - coveredBranches));
        int lineCovered = lineData.getHits() > 0 ? 1 : 0;
        this.myOut.writeAttribute("ci", Integer.toString(lineCovered));
        this.myOut.writeAttribute("mi", Integer.toString(1 - lineCovered));
        this.newLine();
    }

    private void writeCounter(String type, int total, int covered) throws XMLStreamException {
        this.myOut.writeEmptyElement("counter");
        this.myOut.writeAttribute("type", type);
        this.myOut.writeAttribute("covered", Integer.toString(covered));
        this.myOut.writeAttribute("missed", Integer.toString(total - covered));
        this.newLine();
    }

    private static HashMap<String, List<ClassData>> mapClassesToPackages(ProjectData project) {
        HashMap<String, List<ClassData>> packages = new HashMap<String, List<ClassData>>();
        for (ClassData classData : project.getClasses().values()) {
            String className = classData.getName();
            int indexOfName = className.lastIndexOf(46);
            String packageName = indexOfName < 0 ? className : className.substring(0, indexOfName);
            List<ClassData> packageClasses = packages.get(packageName);
            if (!packages.containsKey(packageName)) {
                packageClasses = new ArrayList<ClassData>();
                packages.put(packageName, packageClasses);
            }
            packageClasses.add(classData);
        }
        return packages;
    }

    private IOException wrapIOException(Throwable t) {
        IOException e = new IOException(t.getClass().getSimpleName() + ": " + t.getMessage());
        e.setStackTrace(t.getStackTrace());
        return e;
    }
}

