/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.CommonBundle;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.vcs.log.Hash;
import git4idea.DialogManager;
import git4idea.GitUtil;
import git4idea.actions.GitOperationActionBase;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.util.GitFreezingProcess;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001:\u0003\u001b\u001c\u001dB\"\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0013\u0010\u0010\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lgit4idea/actions/GitAbortOperationAction;", "Lgit4idea/actions/GitOperationActionBase;", "repositoryState", "Lcom/intellij/dvcs/repo/Repository$State;", "operationName", "", "Lorg/jetbrains/annotations/Nls;", "gitCommand", "Lgit4idea/commands/GitCommand;", "(Lcom/intellij/dvcs/repo/Repository$State;Ljava/lang/String;Lgit4idea/commands/GitCommand;)V", "notificationErrorDisplayId", "getNotificationErrorDisplayId", "()Ljava/lang/String;", "notificationSuccessDisplayId", "getNotificationSuccessDisplayId", "getOperationName", "operationNameCapitalised", "Lorg/jetbrains/annotations/NotNull;", "confirmAbort", "", "repository", "Lgit4idea/repo/GitRepository;", "doAbort", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "performInBackground", "CherryPick", "Merge", "Revert", "intellij.vcs.git"})
public abstract class GitAbortOperationAction
extends GitOperationActionBase {
    private final String operationNameCapitalised;
    @NotNull
    private final String operationName;
    private final GitCommand gitCommand;

    @NotNull
    protected abstract String getNotificationSuccessDisplayId();

    @NotNull
    protected abstract String getNotificationErrorDisplayId();

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean performInBackground(@NotNull GitRepository repository) {
        void title$iv;
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        if (!this.confirmAbort(repository)) {
            return false;
        }
        String string = GitBundle.message("abort.operation.progress.title", this.operationNameCapitalised);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"abort\u2026operationNameCapitalised)");
        String string2 = string;
        Project project$iv = repository.getProject();
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, (String)title$iv, cancellable$iv, project$iv, (String)title$iv, cancellable$iv, this, repository){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ GitAbortOperationAction this$0;
            final /* synthetic */ GitRepository $repository$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.this$0 = gitAbortOperationAction;
                this.$repository$inlined = gitRepository;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator indicator2 = indicator;
                boolean bl = false;
                GitAbortOperationAction.access$doAbort(this.this$0, this.$repository$inlined, indicator2);
            }
        });
        return true;
    }

    private final boolean confirmAbort(GitRepository repository) {
        String string = GitBundle.message("abort.operation.dialog.title", this.operationNameCapitalised);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"abort\u2026operationNameCapitalised)");
        String title = string;
        String string2 = GitBundle.message("abort.operation.dialog.msg", this.operationName, GitUtil.mention(repository));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitBundle.message(\"abort\u2026Util.mention(repository))");
        String message = string2;
        if (Messages.canShowMacSheetPanel()) {
            title = message;
            message = "";
        }
        return DialogManager.showOkCancelDialog(repository.getProject(), message, title, GitBundle.message("abort", new Object[0]), CommonBundle.getCancelButtonText(), Messages.getQuestionIcon()) == 0;
    }

    private final void doAbort(GitRepository repository, ProgressIndicator indicator) {
        Project project = repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"repository.project");
        Project project2 = project;
        new GitFreezingProcess(project2, GitBundle.message("abort", new Object[0]), new Runnable(this, project2, indicator, repository){
            final /* synthetic */ GitAbortOperationAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ GitRepository $repository;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                AutoCloseable autoCloseable = (AutoCloseable)DvcsUtil.workingTreeChangeStarted((Project)this.$project, (String)GitBundle.message("abort", new Object[0]));
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    AccessToken it = (AccessToken)autoCloseable;
                    boolean bl3 = false;
                    this.$indicator.setText2(GitBundle.message("abort.operation.indicator.text", GitAbortOperationAction.access$getGitCommand$p(this.this$0).name(), GitUtil.mention(this.$repository)));
                    Hash startHash = GitUtil.getHead(this.$repository);
                    Collection<GitChangeUtils.GitDiffChange> collection = GitChangeUtils.getStagedChanges(this.$project, this.$repository.getRoot());
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"GitChangeUtils.getStaged\u2026project, repository.root)");
                    Collection<GitChangeUtils.GitDiffChange> stagedChanges2 = collection;
                    GitLineHandler handler = new GitLineHandler(this.$project, this.$repository.getRoot(), GitAbortOperationAction.access$getGitCommand$p(this.this$0));
                    handler.addParameters("--abort");
                    GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
                    Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"Git.getInstance().runCommand(handler)");
                    GitCommandResult result2 = gitCommandResult;
                    if (!result2.success()) {
                        VcsNotifier.getInstance((Project)this.$project).notifyError(this.this$0.getNotificationErrorDisplayId(), GitBundle.message("abort.operation.failed", GitAbortOperationAction.access$getOperationNameCapitalised$p(this.this$0)), result2.getErrorOutputAsHtmlString(), true);
                    } else {
                        VcsNotifier.getInstance((Project)this.$project).notifySuccess(this.this$0.getNotificationSuccessDisplayId(), "", GitBundle.message("abort.operation.succeeded", GitAbortOperationAction.access$getOperationNameCapitalised$p(this.this$0)));
                        GitUtil.updateAndRefreshChangedVfs(this.$repository, startHash);
                        RefreshVFsSynchronously.INSTANCE.refresh(stagedChanges2, true);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            {
                this.this$0 = gitAbortOperationAction;
                this.$project = project;
                this.$indicator = progressIndicator;
                this.$repository = gitRepository;
            }
        }).execute();
    }

    @Override
    @NotNull
    protected final String getOperationName() {
        return this.operationName;
    }

    public GitAbortOperationAction(@NotNull Repository.State repositoryState, @NotNull String operationName, @NotNull GitCommand gitCommand) {
        Intrinsics.checkNotNullParameter((Object)repositoryState, (String)"repositoryState");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter((Object)gitCommand, (String)"gitCommand");
        super(repositoryState);
        this.operationName = operationName;
        this.gitCommand = gitCommand;
        String string = StringUtil.capitalizeWords((String)this.operationName, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.capitalizeWords(operationName, true)");
        this.operationNameCapitalised = string;
    }

    public static final /* synthetic */ void access$doAbort(GitAbortOperationAction $this, GitRepository repository, ProgressIndicator indicator) {
        $this.doAbort(repository, indicator);
    }

    public static final /* synthetic */ GitCommand access$getGitCommand$p(GitAbortOperationAction $this) {
        return $this.gitCommand;
    }

    public static final /* synthetic */ String access$getOperationNameCapitalised$p(GitAbortOperationAction $this) {
        return $this.operationNameCapitalised;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lgit4idea/actions/GitAbortOperationAction$Merge;", "Lgit4idea/actions/GitAbortOperationAction;", "()V", "notificationErrorDisplayId", "", "getNotificationErrorDisplayId", "()Ljava/lang/String;", "notificationSuccessDisplayId", "getNotificationSuccessDisplayId", "intellij.vcs.git"})
    public static final class Merge
    extends GitAbortOperationAction {
        @NotNull
        private final String notificationSuccessDisplayId;
        @NotNull
        private final String notificationErrorDisplayId;

        @Override
        @NotNull
        protected String getNotificationSuccessDisplayId() {
            return this.notificationSuccessDisplayId;
        }

        @Override
        @NotNull
        protected String getNotificationErrorDisplayId() {
            return this.notificationErrorDisplayId;
        }

        public Merge() {
            String string = GitBundle.message("abort.operation.merge.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"abort.operation.merge.name\")");
            GitCommand gitCommand = GitCommand.MERGE;
            Intrinsics.checkNotNullExpressionValue((Object)gitCommand, (String)"GitCommand.MERGE");
            super(Repository.State.MERGING, string, gitCommand);
            this.notificationSuccessDisplayId = "git.merge.abort.success";
            this.notificationErrorDisplayId = "git.merge.abort.failed";
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lgit4idea/actions/GitAbortOperationAction$CherryPick;", "Lgit4idea/actions/GitAbortOperationAction;", "()V", "notificationErrorDisplayId", "", "getNotificationErrorDisplayId", "()Ljava/lang/String;", "notificationSuccessDisplayId", "getNotificationSuccessDisplayId", "intellij.vcs.git"})
    public static final class CherryPick
    extends GitAbortOperationAction {
        @NotNull
        private final String notificationSuccessDisplayId;
        @NotNull
        private final String notificationErrorDisplayId;

        @Override
        @NotNull
        protected String getNotificationSuccessDisplayId() {
            return this.notificationSuccessDisplayId;
        }

        @Override
        @NotNull
        protected String getNotificationErrorDisplayId() {
            return this.notificationErrorDisplayId;
        }

        public CherryPick() {
            String string = GitBundle.message("abort.operation.cherry.pick.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"abort\u2026ration.cherry.pick.name\")");
            GitCommand gitCommand = GitCommand.CHERRY_PICK;
            Intrinsics.checkNotNullExpressionValue((Object)gitCommand, (String)"GitCommand.CHERRY_PICK");
            super(Repository.State.GRAFTING, string, gitCommand);
            this.notificationSuccessDisplayId = "git.cherry.pick.abort.success";
            this.notificationErrorDisplayId = "git.cherry.pick.abort.failed";
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lgit4idea/actions/GitAbortOperationAction$Revert;", "Lgit4idea/actions/GitAbortOperationAction;", "()V", "notificationErrorDisplayId", "", "getNotificationErrorDisplayId", "()Ljava/lang/String;", "notificationSuccessDisplayId", "getNotificationSuccessDisplayId", "intellij.vcs.git"})
    public static final class Revert
    extends GitAbortOperationAction {
        @NotNull
        private final String notificationSuccessDisplayId;
        @NotNull
        private final String notificationErrorDisplayId;

        @Override
        @NotNull
        protected String getNotificationSuccessDisplayId() {
            return this.notificationSuccessDisplayId;
        }

        @Override
        @NotNull
        protected String getNotificationErrorDisplayId() {
            return this.notificationErrorDisplayId;
        }

        public Revert() {
            String string = GitBundle.message("abort.operation.revert.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"abort.operation.revert.name\")");
            GitCommand gitCommand = GitCommand.REVERT;
            Intrinsics.checkNotNullExpressionValue((Object)gitCommand, (String)"GitCommand.REVERT");
            super(Repository.State.REVERTING, string, gitCommand);
            this.notificationSuccessDisplayId = "git.revert.abort.success";
            this.notificationErrorDisplayId = "git.revert.abort.failed";
        }
    }
}

