/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive.dialog;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.JBUI;
import git4idea.rebase.interactive.GitRebaseTodoModel;
import git4idea.rebase.interactive.dialog.GitRebaseCommitIconTableCellRenderer;
import git4idea.rebase.interactive.dialog.GitRebaseCommitsTableModel;
import git4idea.rebase.interactive.dialog.GitRebaseCommitsTableView;
import git4idea.rebase.interactive.dialog.NodeType;
import git4idea.rebase.interactive.dialog.SubjectRenderer;
import git4idea.rebase.interactive.dialog.view.CommitMessageCellEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0010\u0018\u0000 *2\u00020\u0001:\u0004*+,-B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u000eH\u0002J\b\u0010\u001d\u001a\u00020\u000eH\u0002J\b\u0010\u001e\u001a\u00020\u000eH\u0014J\b\u0010\u001f\u001a\u00020\u000eH\u0014J\b\u0010 \u001a\u00020\u000eH\u0002J\"\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0015H\u0016J\b\u0010&\u001a\u00020\u000eH\u0002J\b\u0010'\u001a\u00020\u000eH\u0016J\u000e\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006."}, d2={"Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;", "Lcom/intellij/ui/table/JBTable;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableModel;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableModel;Lcom/intellij/openapi/Disposable;)V", "getModel", "()Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableModel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "adjustCommitIconColumnWidth", "", "columnMarginChanged", "e", "Ljavax/swing/event/ChangeEvent;", "getDrawNodeType", "Lgit4idea/rebase/interactive/dialog/NodeType;", "row", "", "getDrawNodeType$intellij_vcs_git", "installAnActionWithShortcut", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "shortcutActionId", "", "installSpeedSearch", "installUndoRedoActions", "onEditorCreate", "onEditorRemove", "prepareCommitIconColumn", "prepareEditor", "Ljava/awt/Component;", "editor", "Ljavax/swing/table/TableCellEditor;", "column", "prepareSubjectColumn", "removeEditor", "setSelectionMode", "selectionMode", "Companion", "DisabledDuringRewordAction", "RedoAction", "UndoAction", "intellij.vcs.git"})
public class GitRebaseCommitsTableView
extends JBTable {
    @NotNull
    private final Project project;
    @NotNull
    private final GitRebaseCommitsTableModel<?> model;
    private final Disposable disposable;
    @NotNull
    private static final JBColor GRAPH_COLOR;
    @NotNull
    public static final Companion Companion;

    private final void installUndoRedoActions() {
        this.installAnActionWithShortcut((AnAction)new UndoAction(this), "$Undo");
        this.installAnActionWithShortcut((AnAction)new RedoAction(this), "$Redo");
    }

    private final void installAnActionWithShortcut(AnAction action, String shortcutActionId) {
        action.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)shortcutActionId), (JComponent)((Object)this));
    }

    public final void setSelectionMode(int selectionMode) {
        super.setSelectionMode(selectionMode);
    }

    private final void installSpeedSearch() {
        new TableSpeedSearch((JTable)((Object)this), (PairFunction)installSpeedSearch.1.INSTANCE);
    }

    private final void prepareCommitIconColumn() {
        TableColumn commitIconColumn;
        TableColumn tableColumn = commitIconColumn = this.columnModel.getColumn(0);
        Intrinsics.checkNotNullExpressionValue((Object)tableColumn, (String)"commitIconColumn");
        tableColumn.setCellRenderer((TableCellRenderer)((Object)new GitRebaseCommitIconTableCellRenderer()));
        this.adjustCommitIconColumnWidth();
    }

    private final void adjustCommitIconColumnWidth() {
        TableColumn column;
        int contentWidth = 2 * Companion.getGRAPH_NODE_WIDTH() + 10;
        TableColumn tableColumn = column = this.columnModel.getColumn(0);
        Intrinsics.checkNotNullExpressionValue((Object)tableColumn, (String)"column");
        tableColumn.setMaxWidth(contentWidth);
        column.setPreferredWidth(contentWidth);
    }

    @NotNull
    public Component prepareEditor(@Nullable TableCellEditor editor, int row, int column) {
        this.onEditorCreate();
        Component component = super.prepareEditor(editor, row, column);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"super.prepareEditor(editor, row, column)");
        return component;
    }

    protected void onEditorCreate() {
    }

    public void removeEditor() {
        this.onEditorRemove();
        int n = this.editingRow;
        if (0 <= n && this.getRowCount() > n) {
            this.setRowHeight(this.editingRow, Companion.getDEFAULT_CELL_HEIGHT());
        }
        super.removeEditor();
    }

    public void columnMarginChanged(@NotNull ChangeEvent e) {
        TableColumn resizingColumn;
        JTableHeader tableHeader;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JTableHeader jTableHeader = tableHeader = this.getTableHeader();
        TableColumn tableColumn = resizingColumn = jTableHeader != null ? jTableHeader.getResizingColumn() : null;
        if (resizingColumn != null && this.autoResizeMode == 0) {
            resizingColumn.setPreferredWidth(resizingColumn.getWidth());
        }
        this.resizeAndRepaint();
    }

    protected void onEditorRemove() {
    }

    private final void prepareSubjectColumn() {
        TableColumn subjectColumn;
        TableColumn tableColumn = subjectColumn = this.columnModel.getColumn(1);
        Intrinsics.checkNotNullExpressionValue((Object)tableColumn, (String)"subjectColumn");
        tableColumn.setCellRenderer((TableCellRenderer)((Object)new SubjectRenderer()));
        subjectColumn.setCellEditor(new CommitMessageCellEditor(this.project, this, this.disposable));
    }

    @NotNull
    public final NodeType getDrawNodeType$intellij_vcs_git(int row) {
        return Intrinsics.areEqual((Object)this.model.getElement(row).getType(), (Object)GitRebaseTodoModel.Type.NonUnite.KeepCommit.Edit.INSTANCE) ? NodeType.EDIT : (!(this.model.getElement(row).getType() instanceof GitRebaseTodoModel.Type.NonUnite.KeepCommit) ? NodeType.NO_NODE : (this.model.getElement(row) instanceof GitRebaseTodoModel.Element.UniteRoot ? NodeType.DOUBLE_NODE : NodeType.SIMPLE_NODE));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final GitRebaseCommitsTableModel<?> getModel() {
        return this.model;
    }

    public GitRebaseCommitsTableView(@NotNull Project project, @NotNull GitRebaseCommitsTableModel<?> model, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super((TableModel)model);
        this.project = project;
        this.model = model;
        this.disposable = disposable;
        this.setSelectionMode(2);
        TableColumnModel tableColumnModel = this.columnModel;
        Intrinsics.checkNotNullExpressionValue((Object)tableColumnModel, (String)"columnModel");
        tableColumnModel.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                int indexToForce = this.convertColumnIndexToView(1);
                super.setSelectionInterval(indexToForce, indexToForce);
            }
        });
        this.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.tableHeader = null;
        this.installSpeedSearch();
        this.prepareCommitIconColumn();
        this.prepareSubjectColumn();
        this.installUndoRedoActions();
    }

    static {
        Companion = new Companion(null);
        JBColor jBColor = JBColor.namedColor((String)"VersionControl.GitCommits.graphColor", (Color)((Color)new JBColor(new Color(174, 185, 192), new Color(135, 146, 154))));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.namedColor(\"Vers\u2026), Color(135, 146, 154)))");
        GRAPH_COLOR = jBColor;
    }

    public static final /* synthetic */ void access$setEditingRow$p(GitRebaseCommitsTableView $this, int n) {
        $this.editingRow = n;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView$DisabledDuringRewordAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "table", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;", "(Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;)V", "getTable", "()Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    private static abstract class DisabledDuringRewordAction
    extends DumbAwareAction {
        @NotNull
        private final GitRebaseCommitsTableView table;

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            Presentation presentation2 = presentation;
            presentation2.setEnabledAndVisible(true);
            if (this.table.editingRow != -1) {
                presentation2.setEnabledAndVisible(false);
            }
        }

        @NotNull
        protected final GitRebaseCommitsTableView getTable() {
            return this.table;
        }

        public DisabledDuringRewordAction(@NotNull GitRebaseCommitsTableView table) {
            Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
            this.table = table;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView$UndoAction;", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView$DisabledDuringRewordAction;", "table", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;", "(Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    private static final class UndoAction
    extends DisabledDuringRewordAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.getTable().getModel().undo();
        }

        public UndoAction(@NotNull GitRebaseCommitsTableView table) {
            Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
            super(table);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView$RedoAction;", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView$DisabledDuringRewordAction;", "table", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;", "(Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
    private static final class RedoAction
    extends DisabledDuringRewordAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.getTable().getModel().redo();
        }

        public RedoAction(@NotNull GitRebaseCommitsTableView table) {
            Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
            super(table);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView$Companion;", "", "()V", "DEFAULT_CELL_HEIGHT", "", "getDEFAULT_CELL_HEIGHT", "()I", "GRAPH_COLOR", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "getGRAPH_COLOR", "()Lcom/intellij/ui/JBColor;", "GRAPH_LINE_WIDTH", "", "getGRAPH_LINE_WIDTH", "()F", "GRAPH_NODE_WIDTH", "getGRAPH_NODE_WIDTH", "intellij.vcs.git"})
    public static final class Companion {
        public final float getGRAPH_LINE_WIDTH() {
            return JBUIScale.scale((float)1.5f);
        }

        public final int getGRAPH_NODE_WIDTH() {
            return JBUI.scale((int)8);
        }

        public final int getDEFAULT_CELL_HEIGHT() {
            return JBUI.scale((int)22);
        }

        @NotNull
        public final JBColor getGRAPH_COLOR() {
            return GRAPH_COLOR;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

