/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions.environment;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpClientDataKeys;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironmentInputFilter;
import com.intellij.httpClient.http.request.run.HttpRequestHistoryManager;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.internal.statistic.collectors.fus.ui.GotItUsageCollector;
import com.intellij.internal.statistic.collectors.fus.ui.GotItUsageCollectorGroup;
import com.intellij.json.JsonFileType;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.GotItTooltip;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public abstract class HttpRequestNewEnvironmentFileAction
extends AnAction
implements DumbAware {
    protected HttpRequestNewEnvironmentFileAction(@NotNull @NlsActions.ActionText Supplier<String> actionName, @NotNull @NlsActions.ActionDescription Supplier<String> description) {
        if (actionName == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(0);
        }
        if (description == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(1);
        }
        super(actionName, description, JsonFileType.INSTANCE.getIcon());
    }

    public boolean isDumbAware() {
        return true;
    }

    protected boolean isFileExistsInCurrentDirectory(@NotNull AnActionEvent e, @NotNull String filename) {
        Project project;
        if (e == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(2);
        }
        if (filename == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(3);
        }
        if ((project = e.getProject()) != null) {
            VirtualFile virtualDir;
            PsiDirectory psiDir = HttpRequestNewEnvironmentFileAction.getPsiDirectory(e);
            VirtualFile virtualFile = virtualDir = psiDir != null ? psiDir.getVirtualFile() : null;
            if (virtualDir != null) {
                return virtualDir.isDirectory() && virtualDir.findChild(filename) != null;
            }
        }
        return false;
    }

    protected void createHttpClientEnvFile(@NotNull AnActionEvent e, @Nullable String filename, @NotNull String templateName) {
        if (e == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(4);
        }
        if (templateName == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(5);
        }
        PsiDirectory psiDirectory = HttpRequestNewEnvironmentFileAction.getPsiDirectory(e);
        String defaultVariableName = (String)e.getData(HttpClientDataKeys.ENV_VARIABLE_DEFAULT_NAME);
        WriteCommandAction.writeCommandAction((Project)e.getProject()).withName(RestClientBundle.message("http.request.create.new.environment.file.command.name", new Object[0])).run(() -> {
            if (psiDirectory != null) {
                VirtualFile virtualFile;
                FileTemplate template = FileTemplateManager.getInstance((Project)psiDirectory.getProject()).getInternalTemplate(templateName);
                Map variables = defaultVariableName != null ? Map.of("name", defaultVariableName) : Collections.emptyMap();
                HttpRequestNewEnvironmentFileAction.scheduleTooltipShow(psiDirectory.getProject());
                PsiFile file2 = CreateFileFromTemplateAction.createFileFromTemplate((String)filename, (FileTemplate)template, (PsiDirectory)psiDirectory, null, (boolean)true, variables);
                if (file2 != null && (virtualFile = file2.getVirtualFile()) != null) {
                    FileEditorManager.getInstance((Project)file2.getProject()).openFile(virtualFile, true);
                }
            }
        });
    }

    private static void scheduleTooltipShow(final @NotNull Project project) {
        if (project == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(6);
        }
        Disposable disposable = Disposer.newDisposable();
        project.getMessageBus().connect(disposable).subscribe(TemplateManager.TEMPLATE_STARTED_TOPIC, s -> {
            s.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(){

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    if (template == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (brokenOff) {
                        return;
                    }
                    HttpRequestNewEnvironmentFileAction.showTooltip(s.getEditor(), project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/httpClient/actions/environment/HttpRequestNewEnvironmentFileAction$1", "templateFinished"));
                }
            });
            Disposer.dispose((Disposable)disposable);
        });
    }

    private static void showTooltip(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(7);
        }
        if (project == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(8);
        }
        int offset = editor.getCaretModel().getOffset();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (!(file2 instanceof JsonFile)) {
            return;
        }
        Pair<@NlsSafe String, @NlsSafe String> names = HttpRequestNewEnvironmentFileAction.getEnvAndVarNames((JsonFile)file2);
        if (names == null) {
            return;
        }
        GotItTooltip tooltip = new GotItTooltip("http.request.new.env.file.action", RestClientBundle.message("http.request.create.new.environment.tooltip.text", names.second, names.first), (Disposable)HttpRequestHistoryManager.getInstance(project));
        tooltip.withHeader(RestClientBundle.message("group.HTTPClientNewEnvironmentFile.text", new Object[0]));
        tooltip.withShowCount(1);
        tooltip.withMaxWidth(250);
        tooltip.withPosition(Balloon.Position.above);
        if (!HttpRequestNewEnvironmentFileAction.isOffsetVisible(editor, offset)) {
            return;
        }
        tooltip.setOnBalloonCreated(balloon -> {
            editor.getScrollingModel().addVisibleAreaListener(area -> {
                if (HttpRequestNewEnvironmentFileAction.isOffsetVisible(editor, offset)) {
                    balloon.revalidate();
                } else {
                    balloon.hide(true);
                    GotItUsageCollector.getInstance().logClose(tooltip.getId(), GotItUsageCollectorGroup.CloseType.AncestorRemoved);
                }
            }, (Disposable)balloon);
            return Unit.INSTANCE;
        });
        tooltip.show(editor.getContentComponent(), (c, b) -> editor.offsetToXY(offset));
    }

    private static boolean isOffsetVisible(@NotNull Editor editor, int offset) {
        if (editor == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(9);
        }
        return editor.getScrollingModel().getVisibleArea().contains(editor.offsetToXY(offset));
    }

    private static @Nullable Pair<@NlsSafe String, @NlsSafe String> getEnvAndVarNames(@NotNull JsonFile file2) {
        JsonValue object;
        if (file2 == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(10);
        }
        if (!((object = file2.getTopLevelValue()) instanceof JsonObject)) {
            return null;
        }
        List properties = ((JsonObject)object).getPropertyList();
        if (properties.isEmpty()) {
            return null;
        }
        JsonProperty envProperty = (JsonProperty)properties.get(0);
        String envName = envProperty.getName();
        if (!(envProperty.getValue() instanceof JsonObject)) {
            return null;
        }
        List envProperties = ((JsonObject)envProperty.getValue()).getPropertyList();
        if (envProperties.isEmpty()) {
            return null;
        }
        String variableName = ((JsonProperty)envProperties.get(0)).getName();
        return Pair.create((Object)envName, (Object)variableName);
    }

    @Nullable
    private static PsiDirectory getPsiDirectory(AnActionEvent e) {
        PsiFile currentPsiFile;
        PsiDirectory[] directories;
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view != null && (directories = view.getDirectories()).length == 1) {
            return directories[0];
        }
        VirtualFile currentFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (currentFile != null && e.getProject() != null && (currentPsiFile = PsiManager.getInstance((Project)e.getProject()).findFile(currentFile)) != null) {
            if (HttpRequestNewEnvironmentFileAction.isInsideProjectIdeaDir(currentPsiFile)) {
                VirtualFile directory = (VirtualFile)PlatformDataKeys.PROJECT_FILE_DIRECTORY.getData(dataContext);
                return directory != null ? PsiManager.getInstance((Project)e.getProject()).findDirectory(directory) : null;
            }
            if (currentPsiFile.getContainingDirectory() != null) {
                return currentPsiFile.getContainingDirectory();
            }
        }
        return null;
    }

    private static boolean isInsideProjectIdeaDir(@NotNull PsiFile file2) {
        if (file2 == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(11);
        }
        if (!ProjectKt.isDirectoryBased((Project)file2.getProject()) || file2.getProject().isDefault()) {
            return false;
        }
        String path = file2.getProject().getBasePath() + "/.idea";
        VirtualFile ideaDir = LocalFileFinder.findFile((String)path);
        if (ideaDir == null) {
            return false;
        }
        return VfsUtilCore.isAncestor((VirtualFile)ideaDir, (VirtualFile)file2.getVirtualFile(), (boolean)false);
    }

    @Nullable
    public static String getEnvFilename(@NotNull EnvironmentType environmentType) {
        if (environmentType == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(12);
        }
        switch (environmentType) {
            case PRIVATE: {
                return HttpRequestEnvironmentInputFilter.ENV_PRIVATE_FILE_NAMES[0];
            }
            case PUBLIC: {
                return HttpRequestEnvironmentInputFilter.ENV_FILE_NAMES[0];
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/actions/environment/HttpRequestNewEnvironmentFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileExistsInCurrentDirectory";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createHttpClientEnvFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleTooltipShow";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "showTooltip";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isOffsetVisible";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnvAndVarNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideProjectIdeaDir";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnvFilename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum EnvironmentType {
        PUBLIC,
        PRIVATE;

    }
}

