/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request;

import com.intellij.httpClient.http.request.HttpRequestPsiFactory;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariable;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.psi.HttpRequestTokenTypeSets;
import com.intellij.httpClient.http.request.run.HttpClientDynamicVariables;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestVariableDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        PsiElement identifier;
        if (element instanceof HttpDynamicVariable && (identifier = ((HttpDynamicVariable)element).getIdentifyingElement()) != null) {
            String description = HttpClientDynamicVariables.getDescription(identifier.getText());
            return description != null ? HttpRequestVariableDocumentationProvider.getDocumentation(identifier.getText(), description) : null;
        }
        return null;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file2, @Nullable PsiElement contextElement, int targetOffset) {
        if (editor == null) {
            HttpRequestVariableDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            HttpRequestVariableDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (file2 instanceof HttpRequestPsiFile) {
            if (contextElement != null && HttpRequestPsiUtils.isOfType(contextElement, HttpRequestElementTypes.MESSAGE_TEXT)) {
                String bodyText = contextElement.getText();
                int bodyStartOffset = contextElement.getTextOffset();
                TextRange variableRange = HttpRequestPsiUtils.collectVariablesRangesInMessageBody(bodyText).stream().filter(range -> range.containsOffset(targetOffset - bodyStartOffset)).findFirst().orElse(null);
                if (variableRange != null) {
                    TextRange dynamicVariable = HttpRequestPsiUtils.getDynamicVariableNameRange(bodyText, variableRange);
                    return dynamicVariable != null ? HttpRequestVariableDocumentationProvider.makeDummyPsiDynamicVariable(editor.getProject(), dynamicVariable.substring(bodyText)) : null;
                }
            }
            if (contextElement == null || contextElement instanceof PsiWhiteSpace) {
                int newOffset = StringUtil.skipWhitespaceBackward((CharSequence)file2.getText(), (int)targetOffset);
                contextElement = file2.findElementAt(newOffset > 0 ? newOffset - 1 : 0);
            }
            if (contextElement != null && HttpRequestPsiUtils.isOfTypes(contextElement, HttpRequestTokenTypeSets.DYNAMIC_VARIABLE_PARTS)) {
                return contextElement.getParent();
            }
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof String) {
            String text = (String)object;
            if (element instanceof HttpDynamicVariable && StringUtil.equals((CharSequence)text, (CharSequence)element.getText())) {
                return element;
            }
            Project project = psiManager != null ? psiManager.getProject() : null;
            return HttpRequestVariableDocumentationProvider.makeDummyPsiDynamicVariable(project, text);
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    private static PsiElement makeDummyPsiDynamicVariable(@Nullable Project project, @NotNull String name) {
        HttpRequestPsiFile file2;
        PsiElement leafElement;
        if (name == null) {
            HttpRequestVariableDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (project != null && StringUtil.isNotEmpty((String)name) && (leafElement = (file2 = HttpRequestPsiFactory.createDummyFile(project, HttpRequestVariableDocumentationProvider.makeDummyDynamicVariableText(name))).findElementAt(0)) != null && HttpRequestPsiUtils.isOfType(leafElement, HttpRequestElementTypes.LBRACES)) {
            return leafElement.getParent();
        }
        return null;
    }

    @NotNull
    private static String makeDummyDynamicVariableText(@NotNull String text) {
        if (text == null) {
            HttpRequestVariableDocumentationProvider.$$$reportNull$$$0(3);
        }
        String string = (text.startsWith(HttpRequestElementTypes.DYNAMIC_SIGN.toString()) ? "{{" : "{{$") + text + "}}";
        if (string == null) {
            HttpRequestVariableDocumentationProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String getDocumentation(@NotNull String identifier, @NotNull String description) {
        if (identifier == null) {
            HttpRequestVariableDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (description == null) {
            HttpRequestVariableDocumentationProvider.$$$reportNull$$$0(6);
        }
        String string = "<div class='definition'><pre>" + HttpRequestElementTypes.DYNAMIC_SIGN.toString() + identifier + "</pre></div><div class='content'>" + description + "</div>";
        if (string == null) {
            HttpRequestVariableDocumentationProvider.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/HttpRequestVariableDocumentationProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/HttpRequestVariableDocumentationProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "makeDummyDynamicVariableText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "makeDummyPsiDynamicVariable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "makeDummyDynamicVariableText";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

