/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.httpClient.http.request.completion.HttpSuffixInsertHandler;
import com.intellij.httpClient.http.request.environment.HttpRequestIndex;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.run.HttpClientDynamicVariables;
import com.intellij.httpClient.http.request.run.HttpRequestGlobalContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class HttpVariableCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final HttpSuffixInsertHandler CLOSING_BRACES = new HttpSuffixInsertHandler("}}");
    private static final String DYNAMIC_SIGN = HttpRequestElementTypes.DYNAMIC_SIGN.toString();

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiElement element;
        if (parameters == null) {
            HttpVariableCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            HttpVariableCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            HttpVariableCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((element = parameters.getOriginalPosition()) != null) {
            this.addCompletions(parameters, result, element, 0);
        }
    }

    protected abstract void fillVariables(@NotNull CompletionParameters var1, @NotNull CompletionResultSet var2, @NotNull PsiElement var3);

    void addCompletions(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull PsiElement element, int variableNameOffset) {
        TextRange range;
        if (parameters == null) {
            HttpVariableCompletionProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            HttpVariableCompletionProvider.$$$reportNull$$$0(4);
        }
        if (element == null) {
            HttpVariableCompletionProvider.$$$reportNull$$$0(5);
        }
        if ((range = element.getTextRange()).contains(parameters.getOffset()) || range.getEndOffset() == parameters.getOffset()) {
            int endOffset = parameters.getOffset() - range.getStartOffset();
            result = result.withPrefixMatcher(endOffset != 0 ? element.getText().substring(variableNameOffset, endOffset) : "");
        }
        this.fillVariables(parameters, result, element);
    }

    @NotNull
    @Contract(value="_ -> new")
    static HttpVariableCompletionProvider getProvider(@NotNull ProviderType providerType) {
        if (providerType == null) {
            HttpVariableCompletionProvider.$$$reportNull$$$0(6);
        }
        switch (providerType) {
            case ENVIRONMENT_VARIABLE: {
                return new HttpEnvironmentVariableCompletionProvider();
            }
            case DYNAMIC_VARIABLE: {
                return new HttpDynamicVariableCompletionProvider();
            }
        }
        throw new IllegalStateException("Unknown ProviderType");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/completion/HttpVariableCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HttpDynamicVariableCompletionProvider
    extends HttpVariableCompletionProvider {
        private HttpDynamicVariableCompletionProvider() {
        }

        @Override
        protected void fillVariables(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull PsiElement element) {
            if (parameters == null) {
                HttpDynamicVariableCompletionProvider.$$$reportNull$$$0(0);
            }
            if (result == null) {
                HttpDynamicVariableCompletionProvider.$$$reportNull$$$0(1);
            }
            if (element == null) {
                HttpDynamicVariableCompletionProvider.$$$reportNull$$$0(2);
            }
            HttpDynamicVariableCompletionProvider.fillDynamicVariables(result, HttpClientDynamicVariables.getAllNames());
        }

        private static void fillDynamicVariables(@NotNull CompletionResultSet resultSet, @NotNull Collection<String> variables) {
            if (resultSet == null) {
                HttpDynamicVariableCompletionProvider.$$$reportNull$$$0(3);
            }
            if (variables == null) {
                HttpDynamicVariableCompletionProvider.$$$reportNull$$$0(4);
            }
            for (String var : variables) {
                resultSet.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)var).withIcon(PlatformIcons.FUNCTION_ICON).withPresentableText(HttpDynamicVariableCompletionProvider.addDynamicSign(var)).withInsertHandler((InsertHandler)CLOSING_BRACES), (double)20.0));
            }
        }

        @NotNull
        private static String addDynamicSign(@NotNull String name) {
            if (name == null) {
                HttpDynamicVariableCompletionProvider.$$$reportNull$$$0(5);
            }
            Object object = name.startsWith(DYNAMIC_SIGN) ? name : DYNAMIC_SIGN + name;
            if (object == null) {
                HttpDynamicVariableCompletionProvider.$$$reportNull$$$0(6);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultSet";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variables";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/completion/HttpVariableCompletionProvider$HttpDynamicVariableCompletionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/completion/HttpVariableCompletionProvider$HttpDynamicVariableCompletionProvider";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addDynamicSign";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fillVariables";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "fillDynamicVariables";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addDynamicSign";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class HttpEnvironmentVariableCompletionProvider
    extends HttpVariableCompletionProvider {
        private HttpEnvironmentVariableCompletionProvider() {
        }

        @Override
        protected void fillVariables(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull PsiElement element) {
            if (parameters == null) {
                HttpEnvironmentVariableCompletionProvider.$$$reportNull$$$0(0);
            }
            if (result == null) {
                HttpEnvironmentVariableCompletionProvider.$$$reportNull$$$0(1);
            }
            if (element == null) {
                HttpEnvironmentVariableCompletionProvider.$$$reportNull$$$0(2);
            }
            Project project = element.getProject();
            HttpEnvironmentVariableCompletionProvider.fillEnvironmentVariables(result, HttpRequestIndex.getAllVariables(project, element.getContainingFile()));
            HttpEnvironmentVariableCompletionProvider.fillEnvironmentVariables(result, HttpRequestGlobalContext.getInstance(project).getAllVariables());
            HttpDynamicVariableCompletionProvider.fillDynamicVariables(result, ContainerUtil.map(HttpClientDynamicVariables.getAllNames(), x$0 -> HttpDynamicVariableCompletionProvider.addDynamicSign(x$0)));
        }

        private static void fillEnvironmentVariables(@NotNull CompletionResultSet result, @NotNull Collection<String> variables) {
            if (result == null) {
                HttpEnvironmentVariableCompletionProvider.$$$reportNull$$$0(3);
            }
            if (variables == null) {
                HttpEnvironmentVariableCompletionProvider.$$$reportNull$$$0(4);
            }
            for (String var : variables) {
                result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)var).withIcon(PlatformIcons.VARIABLE_ICON).withInsertHandler((InsertHandler)CLOSING_BRACES), (double)20.0));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variables";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/completion/HttpVariableCompletionProvider$HttpEnvironmentVariableCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillVariables";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillEnvironmentVariables";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum ProviderType {
        ENVIRONMENT_VARIABLE,
        DYNAMIC_VARIABLE;

    }
}

