/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.documentation.comments.HttpDocComment;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocNoLogResponseTag;
import com.intellij.httpClient.http.request.psi.HttpDifferenceFile;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.HttpRequestFilePostProcessor;
import com.intellij.httpClient.http.request.run.HttpRequestHistoryManager;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpScratchRequestPostProcessor
extends HttpRequestFilePostProcessor {
    public HttpScratchRequestPostProcessor(@NotNull SmartPsiElementPointer<HttpRequest> request) {
        if (request == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(0);
        }
        super(request);
    }

    @Override
    protected void updateRequest(@NotNull Document document, @NotNull HttpRequest request, @Nullable String responseFileName) {
        HttpDocComment docComment;
        if (document == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(1);
        }
        if (request == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(2);
        }
        if ((docComment = HttpRequestPsiUtils.findDocComment(request)) != null) {
            if (docComment.getTags().stream().anyMatch(HttpDocNoLogResponseTag.class::isInstance)) {
                return;
            }
        }
        List<Editor> editors = HttpScratchRequestPostProcessor.getEditors(request.getProject(), document);
        if (StringUtil.isNotEmpty((String)responseFileName)) {
            int offset;
            String text = "<> " + responseFileName;
            List<HttpDifferenceFile> diffFiles = request.getDifferenceFileList();
            if (!diffFiles.isEmpty()) {
                offset = diffFiles.get(0).getTextRange().getStartOffset();
                document.insertString(offset, (CharSequence)(text + "\n"));
            } else {
                offset = request.getTextRange().getEndOffset();
                document.insertString(offset, (CharSequence)("\n\n" + text));
            }
            HttpScratchRequestPostProcessor.moveCaretsToRespectFoldings(editors, diffFiles);
            HttpScratchRequestPostProcessor.foldWhenFoldRegionIsReady(editors, offset);
        }
    }

    @NotNull
    public static GlobalSearchScope getResponseReferencesSearchScope(@NotNull Project project) {
        if (project == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(3);
        }
        GlobalSearchScope globalSearchScope = ScratchesSearchScope.getScratchesScope((Project)project);
        if (globalSearchScope == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @NotNull
    private static List<Editor> getEditors(@NotNull Project project, @NotNull Document document) {
        VirtualFile file2;
        if (project == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(5);
        }
        if (document == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(6);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(document)) == null) {
            List<Editor> list = Collections.emptyList();
            if (list == null) {
                HttpScratchRequestPostProcessor.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = StreamEx.of((Object[])FileEditorManager.getInstance((Project)project).getEditors(file2)).map(editor -> {
            if (editor instanceof TextEditor) {
                return ((TextEditor)editor).getEditor();
            }
            return null;
        }).nonNull().toList();
        if (list == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static void moveCaretsToRespectFoldings(@NotNull List<Editor> editors, @NotNull List<HttpDifferenceFile> diffFiles) {
        if (editors == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(9);
        }
        if (diffFiles == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(10);
        }
        for (Editor editor : editors) {
            CaretModel caretModel = editor.getCaretModel();
            int caretOffset = caretModel.getOffset();
            if (!diffFiles.stream().anyMatch(diff -> diff.getTextRange().contains(caretOffset))) continue;
            LogicalPosition currentPosition = editor.offsetToLogicalPosition(caretOffset);
            LogicalPosition newLogicalPosition = new LogicalPosition(currentPosition.line - 1, currentPosition.column);
            caretModel.moveToLogicalPosition(newLogicalPosition);
        }
    }

    private static void foldWhenFoldRegionIsReady(@NotNull List<Editor> editors, final int offset) {
        if (editors == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(11);
        }
        for (final Editor editor : editors) {
            if (editor.getProject() == null) continue;
            final FoldingModelEx foldingModel = (FoldingModelEx)editor.getFoldingModel();
            final Disposable disposable = Disposer.newDisposable((Disposable)HttpRequestHistoryManager.getInstance(editor.getProject()), (String)"disposable for folding listener");
            foldingModel.addListener(new FoldingListener(){

                public void onFoldProcessingEnd() {
                    Disposer.dispose((Disposable)disposable);
                    LogicalPosition logicalPosition = editor.offsetToLogicalPosition(offset);
                    FoldRegion foldRegion = FoldingUtil.findFoldRegionStartingAtLine((Editor)editor, (int)(logicalPosition.line + 3));
                    if (foldRegion != null && foldRegion.isExpanded() && HttpScratchRequestPostProcessor.isRecentlyCreated(foldRegion)) {
                        foldingModel.runBatchFoldingOperation(() -> foldRegion.setExpanded(false));
                    }
                }
            }, disposable);
        }
    }

    private static boolean isRecentlyCreated(@NotNull FoldRegion foldRegion) {
        if (foldRegion == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(12);
        }
        Editor editor = foldRegion.getEditor();
        LogicalPosition start = editor.offsetToLogicalPosition(foldRegion.getStartOffset());
        LogicalPosition end = editor.offsetToLogicalPosition(foldRegion.getEndOffset());
        return end.line - start.line == 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpScratchRequestPostProcessor";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffFiles";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldRegion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpScratchRequestPostProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseReferencesSearchScope";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateRequest";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResponseReferencesSearchScope";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretsToRespectFoldings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "foldWhenFoldRegionIsReady";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isRecentlyCreated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

