/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ClasspathEntryModel;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.internal.BuildScriptClasspathModelImpl;
import org.jetbrains.plugins.gradle.tooling.internal.ClasspathEntryModelImpl;
import org.jetbrains.plugins.gradle.tooling.util.DependencyTraverser;
import org.jetbrains.plugins.gradle.tooling.util.SourceSetCachedFinder;
import org.jetbrains.plugins.gradle.tooling.util.resolve.DependencyResolverImpl;

public class ModelBuildScriptClasspathBuilderImpl
extends AbstractModelBuilderService {
    private static final String CLASSPATH_CONFIGURATION_NAME = "classpath";
    private final Map<String, BuildScriptClasspathModelImpl> cache = new ConcurrentHashMap<String, BuildScriptClasspathModelImpl>();
    private SourceSetCachedFinder mySourceSetFinder = null;

    public boolean canBuild(String modelName) {
        return BuildScriptClasspathModel.class.getName().equals(modelName);
    }

    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        Configuration classpathConfiguration;
        BuildScriptClasspathModelImpl parentBuildScriptClasspath;
        Project parent;
        BuildScriptClasspathModelImpl buildScriptClasspath;
        if (modelName == null) {
            ModelBuildScriptClasspathBuilderImpl.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ModelBuildScriptClasspathBuilderImpl.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ModelBuildScriptClasspathBuilderImpl.$$$reportNull$$$0(2);
        }
        if ((buildScriptClasspath = this.cache.get(project.getPath())) != null) {
            return buildScriptClasspath;
        }
        if (this.mySourceSetFinder == null) {
            this.mySourceSetFinder = new SourceSetCachedFinder(context);
        }
        buildScriptClasspath = new BuildScriptClasspathModelImpl();
        File gradleHomeDir = project.getGradle().getGradleHomeDir();
        buildScriptClasspath.setGradleHomeDir(gradleHomeDir);
        buildScriptClasspath.setGradleVersion(GradleVersion.current().getVersion());
        boolean downloadJavadoc = false;
        boolean downloadSources = true;
        IdeaPlugin ideaPlugin = (IdeaPlugin)project.getPlugins().findPlugin(IdeaPlugin.class);
        if (ideaPlugin != null) {
            IdeaModule ideaModule = ideaPlugin.getModel().getModule();
            downloadJavadoc = ideaModule.isDownloadJavadoc();
            downloadSources = ideaModule.isDownloadSources();
        }
        if ((parent = project.getParent()) != null && (parentBuildScriptClasspath = (BuildScriptClasspathModelImpl)this.buildAll(modelName, parent, context)) != null) {
            for (ClasspathEntryModel classpathEntryModel : parentBuildScriptClasspath.getClasspath()) {
                buildScriptClasspath.add(classpathEntryModel);
            }
        }
        if ((classpathConfiguration = (Configuration)project.getBuildscript().getConfigurations().findByName(CLASSPATH_CONFIGURATION_NAME)) == null) {
            return null;
        }
        Collection<ExternalDependency> dependencies = new DependencyResolverImpl(project, downloadJavadoc, downloadSources, this.mySourceSetFinder).resolveDependencies(classpathConfiguration);
        for (ExternalDependency dependency : new DependencyTraverser(dependencies)) {
            if (dependency instanceof ExternalProjectDependency) {
                ExternalProjectDependency projectDependency = (ExternalProjectDependency)dependency;
                Collection projectDependencyArtifacts = projectDependency.getProjectDependencyArtifacts();
                Collection projectDependencyArtifactsSources = projectDependency.getProjectDependencyArtifactsSources();
                buildScriptClasspath.add(new ClasspathEntryModelImpl(projectDependencyArtifacts, projectDependencyArtifactsSources, Collections.<File>emptySet()));
                continue;
            }
            if (dependency instanceof ExternalLibraryDependency) {
                ExternalLibraryDependency libraryDep = (ExternalLibraryDependency)dependency;
                buildScriptClasspath.add(new ClasspathEntryModelImpl(ModelBuildScriptClasspathBuilderImpl.singletonListOrEmpty(libraryDep.getFile()), ModelBuildScriptClasspathBuilderImpl.singletonListOrEmpty(libraryDep.getSource()), ModelBuildScriptClasspathBuilderImpl.singletonListOrEmpty(libraryDep.getJavadoc())));
                continue;
            }
            if (dependency instanceof ExternalMultiLibraryDependency) {
                ExternalMultiLibraryDependency multiLibraryDependency = (ExternalMultiLibraryDependency)dependency;
                buildScriptClasspath.add(new ClasspathEntryModelImpl(multiLibraryDependency.getFiles(), multiLibraryDependency.getSources(), multiLibraryDependency.getJavadoc()));
                continue;
            }
            if (!(dependency instanceof FileCollectionDependency)) continue;
            FileCollectionDependency fileCollectionDependency = (FileCollectionDependency)dependency;
            buildScriptClasspath.add(new ClasspathEntryModelImpl(fileCollectionDependency.getFiles(), Collections.<File>emptySet(), Collections.<File>emptySet()));
        }
        this.cache.put(project.getPath(), buildScriptClasspath);
        return buildScriptClasspath;
    }

    @NotNull
    public ErrorMessageBuilder getErrorMessageBuilder(@NotNull Project project, @NotNull Exception e) {
        if (project == null) {
            ModelBuildScriptClasspathBuilderImpl.$$$reportNull$$$0(3);
        }
        if (e == null) {
            ModelBuildScriptClasspathBuilderImpl.$$$reportNull$$$0(4);
        }
        ErrorMessageBuilder errorMessageBuilder = ErrorMessageBuilder.create((Project)project, (Exception)e, (String)"Project build classpath resolve errors").withDescription("Unable to resolve additional buildscript classpath dependencies");
        if (errorMessageBuilder == null) {
            ModelBuildScriptClasspathBuilderImpl.$$$reportNull$$$0(5);
        }
        return errorMessageBuilder;
    }

    @NotNull
    private static List<File> singletonListOrEmpty(@Nullable File file) {
        List<Object> list = file == null ? Collections.emptyList() : Collections.singletonList(file);
        if (list == null) {
            ModelBuildScriptClasspathBuilderImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/tooling/builder/ModelBuildScriptClasspathBuilderImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/builder/ModelBuildScriptClasspathBuilderImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessageBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "singletonListOrEmpty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildAll";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessageBuilder";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

