/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.DefaultTaskContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.MessageBuilder;
import org.jetbrains.plugins.gradle.tooling.MessageReporter;

public class TasksFactory {
    private static final boolean TASKS_REFRESH_REQUIRED = GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"5.0")) < 0;
    private final Map<Project, Set<Task>> allTasks;
    private final Set<Project> processedRootProjects;
    @NotNull
    private final MessageReporter myMessageReporter;

    public TasksFactory(@NotNull MessageReporter messageReporter) {
        if (messageReporter == null) {
            TasksFactory.$$$reportNull$$$0(0);
        }
        this.allTasks = new HashMap<Project, Set<Task>>();
        this.processedRootProjects = new HashSet<Project>();
        this.myMessageReporter = messageReporter;
    }

    private void collectTasks(Project root) {
        this.allTasks.putAll(this.getAllTasks(root));
    }

    @NotNull
    private Map<Project, Set<Task>> getAllTasks(@NotNull Project root) {
        if (root == null) {
            TasksFactory.$$$reportNull$$$0(1);
        }
        final TreeMap<Project, Set<Task>> foundTargets = new TreeMap<Project, Set<Task>>();
        Action<Project> action = new Action<Project>(){

            public void execute(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    TasksFactory.maybeRefreshTasks(project);
                    TaskContainer projectTasks = project.getTasks();
                    foundTargets.put(project, new TreeSet(projectTasks));
                }
                catch (Exception e) {
                    String title = "Can not load tasks for " + project;
                    TasksFactory.this.myMessageReporter.report(project, MessageBuilder.create((String)title, (String)title).warning().withException(e).build());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/tooling/builder/TasksFactory$1", "execute"));
            }
        };
        root.allprojects((Action)action);
        TreeMap<Project, Set<Task>> treeMap = foundTargets;
        if (treeMap == null) {
            TasksFactory.$$$reportNull$$$0(2);
        }
        return treeMap;
    }

    public Set<Task> getTasks(Project project) {
        Project rootProject = project.getRootProject();
        if (this.processedRootProjects.add(rootProject)) {
            this.collectTasks(rootProject);
        }
        LinkedHashSet<Task> tasks = new LinkedHashSet<Task>(this.getTasksNullsafe(project));
        for (Project subProject : project.getSubprojects()) {
            tasks.addAll(this.getTasksNullsafe(subProject));
        }
        return tasks;
    }

    private Set<Task> getTasksNullsafe(Project project) {
        Set<Task> tasks = this.allTasks.get(project);
        if (tasks != null) {
            return tasks;
        }
        return Collections.emptySet();
    }

    private static void maybeRefreshTasks(Project project) {
        TaskContainer tasks;
        if (TASKS_REFRESH_REQUIRED && (tasks = project.getTasks()) instanceof DefaultTaskContainer) {
            ((DefaultTaskContainer)tasks).discoverTasks();
            SortedSet taskNames = tasks.getNames();
            for (String taskName : taskNames) {
                tasks.findByName(taskName);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageReporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/tooling/builder/TasksFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/builder/TasksFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllTasks";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

