/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLBreakpoint
extends LLCodepoint {
    @NotNull
    private final String myOrigFile;
    private final int myOrigLine;
    @Nullable
    private final String myCondition;
    @NotNull
    private final List<LLBreakpointLocation> myLocations;

    public LLBreakpoint(int id, @NotNull String file, int line, @NotNull List<LLBreakpointLocation> locations, @Nullable String condition) {
        if (file == null) {
            LLBreakpoint.$$$reportNull$$$0(0);
        }
        if (locations == null) {
            LLBreakpoint.$$$reportNull$$$0(1);
        }
        super(id);
        this.myOrigFile = file;
        this.myOrigLine = line;
        this.myCondition = condition;
        this.myLocations = locations;
    }

    @NotNull
    public String getOrigFile() {
        String string = this.myOrigFile;
        if (string == null) {
            LLBreakpoint.$$$reportNull$$$0(2);
        }
        return string;
    }

    public int getOrigLine() {
        return this.myOrigLine;
    }

    @Nullable
    public String getCondition() {
        return this.myCondition;
    }

    @NotNull
    public final List<LLBreakpointLocation> getLocations() {
        List<LLBreakpointLocation> list = this.myLocations;
        if (list == null) {
            LLBreakpoint.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean isPending() {
        return this.myLocations.isEmpty();
    }

    public String toString() {
        String result2 = "Breakpoint-" + this.getId() + "@" + this.getOrigFile() + ":" + this.getOrigLine();
        if (this.myCondition != null) {
            result2 = result2 + ":condition:" + this.myCondition;
        }
        if (!this.myLocations.isEmpty()) {
            result2 = result2 + ":locations:[";
            result2 = result2 + String.join((CharSequence)",", ContainerUtil.map(this.myLocations, loc -> loc.toString()));
            result2 = result2 + "]";
        }
        return result2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LLBreakpoint that = (LLBreakpoint)o;
        if (this.myOrigLine != that.myOrigLine) {
            return false;
        }
        if (!this.myOrigFile.equals(that.myOrigFile)) {
            return false;
        }
        if (!Objects.equals(this.myCondition, that.myCondition)) {
            return false;
        }
        if (!this.myLocations.isEmpty() && !that.myLocations.isEmpty()) {
            if (this.myLocations.size() != that.myLocations.size()) {
                return false;
            }
            for (int i = 0; i < this.myLocations.size(); ++i) {
                if (Objects.equals(this.myLocations.get(i), that.myLocations.get(i))) continue;
                return false;
            }
        } else if (this.myLocations != that.myLocations) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myOrigFile.hashCode();
        result2 = 31 * result2 + this.myOrigLine;
        result2 = 31 * result2 + (this.myCondition != null ? this.myCondition.hashCode() : 0);
        result2 = 31 * result2;
        if (!this.myLocations.isEmpty()) {
            for (LLBreakpointLocation loc : this.myLocations) {
                result2 += 31 * result2 + loc.hashCode();
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/LLBreakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/LLBreakpoint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrigFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

