/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLFrame {
    private final int myIndex;
    @Nullable
    private final String myFunction;
    @Nullable
    private final String myFile;
    @Nullable
    private final DebuggerSourceFileHash myHash;
    private final int myLine;
    @NotNull
    private final Address myProgramCounter;
    @Nullable
    private final DebuggerDriver.DebuggerLanguage myLanguage;
    private final boolean myOptimized;

    public LLFrame(int index, @Nullable String function, @Nullable String file, @Nullable DebuggerSourceFileHash hash, int line, long pc, @Nullable DebuggerDriver.DebuggerLanguage language, boolean optimized) {
        this(index, function, file, hash, line, Address.fromUnsignedLong(pc), language, optimized);
    }

    public LLFrame(int index, @Nullable String function, @Nullable String file, @Nullable DebuggerSourceFileHash hash, int line, @NotNull Address pc, @Nullable DebuggerDriver.DebuggerLanguage language, boolean optimized) {
        if (pc == null) {
            LLFrame.$$$reportNull$$$0(0);
        }
        this.myIndex = index;
        this.myFunction = StringUtil.nullize((String)function, (boolean)true);
        this.myFile = file == null ? null : FileUtil.toSystemIndependentName((String)file);
        this.myHash = hash;
        this.myLine = line;
        this.myProgramCounter = pc;
        this.myLanguage = language;
        this.myOptimized = optimized;
    }

    public int getIndex() {
        return this.myIndex;
    }

    @NotNull
    @NlsSafe
    public String getFunction() {
        String string = StringUtil.notNullize((String)this.myFunction, (String)"<unknown>");
        if (string == null) {
            LLFrame.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getFile() {
        return this.myFile;
    }

    @Nullable
    public DebuggerSourceFileHash getHash() {
        return this.myHash;
    }

    public int getLine() {
        return this.myLine;
    }

    @NotNull
    public Address getProgramCounter() {
        Address address = this.myProgramCounter;
        if (address == null) {
            LLFrame.$$$reportNull$$$0(2);
        }
        return address;
    }

    @Nullable
    public DebuggerDriver.DebuggerLanguage getLanguage() {
        return this.myLanguage;
    }

    public boolean getOptimized() {
        return this.myOptimized;
    }

    public boolean hasDebugInfo() {
        return this.myFile != null;
    }

    public boolean hasSymbolInfo() {
        return this.myFunction != null;
    }

    public String toString() {
        return String.format("%d: %s %s@%s(%s):%d (%s)%s", this.myIndex, this.myProgramCounter, this.myFunction, this.myFile, this.myHash, this.myLine, this.myLanguage, this.myOptimized ? " [opt]" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LLFrame gdbFrame = (LLFrame)o;
        if (this.myLine != gdbFrame.myLine) {
            return false;
        }
        if (this.myIndex != gdbFrame.myIndex) {
            return false;
        }
        if (this.myFunction != null ? !this.myFunction.equals(gdbFrame.myFunction) : gdbFrame.myFunction != null) {
            return false;
        }
        if (this.myFile != null ? !this.myFile.equals(gdbFrame.myFile) : gdbFrame.myFile != null) {
            return false;
        }
        if (this.myHash != null ? !this.myHash.equals(gdbFrame.myHash) : gdbFrame.myHash != null) {
            return false;
        }
        if (!this.myProgramCounter.equals(gdbFrame.myProgramCounter)) {
            return false;
        }
        if (this.myLanguage != null ? !this.myLanguage.equals(gdbFrame.myLanguage) : gdbFrame.myLanguage != null) {
            return false;
        }
        return this.myOptimized == gdbFrame.myOptimized;
    }

    public int hashCode() {
        int result2 = this.myIndex;
        result2 = 31 * result2 + (this.myFunction != null ? this.myFunction.hashCode() : 0);
        result2 = 31 * result2 + (this.myFile != null ? this.myFile.hashCode() : 0);
        result2 = 31 * result2 + (this.myHash != null ? this.myHash.hashCode() : 0);
        result2 = 31 * result2 + this.myLine;
        result2 = 31 * result2 + this.myProgramCounter.hashCode();
        result2 = 31 * result2 + (this.myLanguage != null ? this.myLanguage.hashCode() : 0);
        result2 = 31 * result2 + (this.myOptimized ? 1 : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pc";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/LLFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/LLFrame";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgramCounter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

