/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.util.ExecUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NotNullProducer;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.VersionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.ProcessOutputReaders;
import com.jetbrains.cidr.execution.WinPipe;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerEvaluationTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerIllegalStateException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.cidr.execution.debugger.backend.LLSection;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolOffset;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBBundle;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBResponse;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import com.jetbrains.cidr.execution.debugger.backend.gdb.MacOSDebugSymbols;
import com.jetbrains.cidr.execution.debugger.backend.gdb.MacOSSierraDuringStartupProgramTerminatedException;
import com.jetbrains.cidr.execution.debugger.backend.gdb.lang.GDBLanguage;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.OSType;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import com.pty4j.unix.Pty;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Scanner;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.PrintFormat;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GDBDriver
extends DebuggerDriver {
    public static final Pattern VERSION_PATTERN = Pattern.compile("^GNU gdb (?:\\([^()]*(?:(?:\\([^()]+\\))[^()]*)*\\))+[^\\d]*(\\d+\\.\\d+(?:\\.\\d+)?).*");
    public static final Key<String> PRETTY_PRINTERS_PATH = Key.create((String)"GDBDriver.PRETTY_PRINTERS_PATH");
    public static final Key<Boolean> ENABLE_STL_PRETTY_PRINTERS = Key.create((String)"GDBDriver.ENABLE_STL_PRETTY_PRINTERS");
    private static final Key<LLValueLoader> LLVALUE_DATA_LOADER = Key.create((String)"GDBDriver.LLVALUE_DATA_LOADER");
    private static final Key<LLValueLoadedData> LLVALUE_DATA = Key.create((String)"GDBDriver.LLVALUE_DATA");
    private static final Key<GDBTuple> LLVALUE_CLASS_CHILDREN_CACHE = Key.create((String)"GDBDriver.LLVALUE_CLASS_CHILDREN");
    private static final Key<Integer> LLVALUE_CLASS_CHILDREN_COUNT_CACHE = Key.create((String)"GDBDriver.LLVALUE_CLASS_CHILDREN_COUNT_CACHE");
    private static final Key<MapElement> LLVALUE_MAP_ELEMENT = Key.create((String)"GDBDriver.LLVALUE_MAP_ELEMENT");
    @NonNls
    private static final String INFERIOR_NOT_EXECUTING = "mi_cmd_exec_interrupt: Inferior not executing.";
    @NonNls
    private static final String MAX_COMPLETIONS_REACHED = "*** List may be truncated, max-completions reached. ***";
    @NonNls
    private static final String CANNOT_SET_WATCHPOINT_FOR_EXPRESSION = "Cannot set a watchpoint for this expression";
    private static final Pattern CANNOT_ACCESS_MEMORY_AT_ADDRESS = Pattern.compile("Cannot access memory at address 0x([0-9a-f]+)(?: .*)?");
    private static final Pattern INSTRUCTION_LINE = Pattern.compile("^.{0,4}0x([0-9a-f]+)(?: (<.*>))?:\t((?:[0-9a-f]{2}(?: |(?=\t)))+)\t(.*)$");
    private static final Pattern INSTRUCTION_COMMENT = Pattern.compile("^([^#]*?)\\s*#\\s*(.*)$");
    private static final Pattern BAD_INSTRUCTION_WITH_PREFIX_SUFFIX = Pattern.compile("^[^#]*(\\(bad\\)).*$");
    private static final Pattern INSTRUCTION_ENDING_WITH_ADDRESS_AND_SYMBOL_NAME = Pattern.compile("^([^#]*(?:0|0x[0-9a-f]+))\\s*(<.*>)\\s*$", 2);
    private static final Pattern WHATIS_TYPE_OUTPUT = Pattern.compile("^(?:\\+.*?\\n)*type = (?:(?:/\\* real type = (.*) \\*/\\n.*)|(.*))\\n");
    private static final Pattern NON_ID_PATTERN = Pattern.compile("\\W+");
    private static final Pattern PROMPT = Pattern.compile("[ ]*>");
    private static final Pattern SECTIONS_INFO = Pattern.compile("^(?: \\[\\d+])?\\s*(0x[0-9a-f]+)->(0x[0-9a-f]+)(?: at 0x[0-9a-f]+): (\\S+)(.*)$");
    private static final Pattern LINE_INFO_RESULT = Pattern.compile("^Line ([0-9]+) of .* starts at address 0x([0-9a-f]+)(?: (<.*>))? and ends at 0x([0-9a-f]+)(?: (<.*>))?.*");
    private static final Pattern LINE_INFO_NO_CODE_RESULT = Pattern.compile("^Line ([0-9]+) of .* is at address 0x([0-9a-f]+)(?: (<.*>))? but contains no code.*");
    @NonNls
    private static final String OBJECT_FILE_PREFIX = "  Object file: ";
    private static final int IGNORE_RESPONSE_COMMAND_TOKEN = 0;
    private static final Pattern VALUE_DESCRIPTION_PATTERN = Pattern.compile("^(0x\\p{XDigit}+)(?: <.+?>)?(?: (\\w?\".*\"(?:\\.\\.\\.)?))?$");
    private static final LLValueLoadedData EMPTY_LOADED_VALUE = new LLValueLoadedData("", null, 0, false, false, "", "");
    @Nullable
    private static Boolean ourShellAvailable;
    @TestOnly
    @Nullable
    private volatile MIResponseFilter myMIResponseFilter;
    @NotNull
    private final DebuggerDriverConfiguration myStarter;
    @NlsSafe
    @NotNull
    private final String myInterruptSignalName;
    @Nullable
    private Version myGdbVersion;
    @Nullable
    private String myWinBreakPath;
    private boolean myWindowsIoRedirectionEnabled;
    private boolean myUseExternalConsoleRequested;
    @NotNull
    private final GeneralCommandLine myGdbCommandLine;
    @NotNull
    private final BaseProcessHandler myProcessHandler;
    private final boolean myEmulateStepMode;
    private volatile boolean myMIAsyncMode;
    private volatile boolean myStepMode;
    private final Deque<Integer> myPromptLevelStack;
    @NotNull
    private final Writer mySink;
    @Nullable
    private volatile OutputStream myProcessInput;
    private final Collection<String> allocatedVariables;
    private final OutputStream myProcessInputProxy;
    private final Semaphore myCommandSemaphore;
    private final ExecutorService myCommandExecutor;
    private final BlockingQueue<Response> myResultQueue;
    private final Semaphore myStopSemaphore;
    private boolean myIsInterruptedStop;
    private final Semaphore myPendingForAttachNotification;
    @Nullable
    private volatile Integer myTargetPID;
    @Nullable
    private volatile LongSet myIndirectSymbols;
    @Nullable
    private Map<String, List<LLSection>> mySectionsMap;
    @Nullable
    private volatile DebuggerDriver.StopPlace myStopPlace;
    @NotNull
    private volatile Communication myCommunication;
    @Nullable
    private volatile String myLastCommand;
    private boolean myIsConsoleCommand;
    private ThreadFrameInfoDriverDelegate myThreadFrameInfoDriverDelegate;
    private final Bridge myBridge;

    @TestOnly
    public void setMIOutputFilterInTests(@NotNull @RegExp String regexp, @NotNull String replacement) {
        if (regexp == null) {
            GDBDriver.$$$reportNull$$$0(0);
        }
        if (replacement == null) {
            GDBDriver.$$$reportNull$$$0(1);
        }
        this.setMIOutputFilterInTests((NotNullFunction<? super String, String>)((NotNullFunction)s -> s.replaceAll(regexp, replacement)));
    }

    @TestOnly
    public void setMIOutputFilterInTests(@Nullable NotNullFunction<? super String, String> miOutputFilter) {
        this.setMIResponseFilterInTests(miOutputFilter == null ? null : (request, s) -> (String)miOutputFilter.fun((Object)s));
    }

    @TestOnly
    public void setMIResponseFilterInTests(@Nullable MIResponseFilter miResponseFilter) {
        this.myMIResponseFilter = miResponseFilter;
    }

    @Deprecated
    public GDBDriver(@NotNull DebuggerDriver.Handler handler, @NotNull DebuggerDriverConfiguration starter) throws ExecutionException {
        if (handler == null) {
            GDBDriver.$$$reportNull$$$0(2);
        }
        if (starter == null) {
            GDBDriver.$$$reportNull$$$0(3);
        }
        this(handler, starter, ArchitectureType.UNKNOWN);
    }

    public GDBDriver(@NotNull DebuggerDriver.Handler handler, @NotNull DebuggerDriverConfiguration starter, @NotNull ArchitectureType architectureType) throws ExecutionException {
        if (handler == null) {
            GDBDriver.$$$reportNull$$$0(4);
        }
        if (starter == null) {
            GDBDriver.$$$reportNull$$$0(5);
        }
        if (architectureType == null) {
            GDBDriver.$$$reportNull$$$0(6);
        }
        super(handler);
        this.myMIAsyncMode = false;
        this.myStepMode = false;
        this.myPromptLevelStack = new ArrayDeque<Integer>();
        this.allocatedVariables = new ArrayList<String>();
        this.myProcessInputProxy = new OutputStream(){

            @Override
            public void write(int i) throws IOException {
                OutputStream input = GDBDriver.this.myProcessInput;
                if (input != null) {
                    input.write(i);
                }
            }

            @Override
            public void write(byte[] bytes, int i, int i1) throws IOException {
                OutputStream input = GDBDriver.this.myProcessInput;
                if (input != null) {
                    input.write(bytes, i, i1);
                }
            }

            @Override
            public void close() throws IOException {
                OutputStream input = GDBDriver.this.myProcessInput;
                if (input != null) {
                    input.close();
                }
            }

            @Override
            public void flush() throws IOException {
                OutputStream input = GDBDriver.this.myProcessInput;
                if (input != null) {
                    input.flush();
                }
            }
        };
        this.myCommandSemaphore = new Semaphore();
        this.myResultQueue = new LinkedBlockingQueue<Response>();
        this.myStopSemaphore = new Semaphore();
        this.myPendingForAttachNotification = new Semaphore();
        this.myTargetPID = null;
        this.myStopPlace = null;
        this.myCommunication = new Communication(this, "");
        this.myLastCommand = null;
        this.myThreadFrameInfoDriverDelegate = new ThreadFrameInfoDriverDelegate(){

            @Override
            @NotNull
            public CompletableFuture<DebuggerDriver.StopPlace> doReadStopPlaceAsync(@NotNull Bridge bridge, @NotNull GDBTuple stopTuple) {
                if (bridge == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (stopTuple == null) {
                    2.$$$reportNull$$$0(1);
                }
                CompletionStage completionStage = GDBDriver.this.executeAsyncCommand(() -> GDBDriver.this.doReadStopPlace(stopTuple)).handle((result2, throwable) -> {
                    if (throwable != null) {
                        CidrDebuggerLog.LOG.error(throwable);
                    }
                    return result2;
                });
                if (completionStage == null) {
                    2.$$$reportNull$$$0(2);
                }
                return completionStage;
            }

            @Override
            @NotNull
            public List<LLThread> getThreads(@NotNull Bridge bridge) throws ExecutionException, DebuggerCommandException {
                if (bridge == null) {
                    2.$$$reportNull$$$0(3);
                }
                List list = (List)GDBDriver.this.executeCommand(() -> GDBDriver.this.doGetThreads());
                if (list == null) {
                    2.$$$reportNull$$$0(4);
                }
                return list;
            }

            @Override
            @NotNull
            public DebuggerDriver.ResultList<LLFrame> getFrames(@NotNull Bridge bridge, @NotNull LLThread thread, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
                if (bridge == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (thread == null) {
                    2.$$$reportNull$$$0(6);
                }
                DebuggerDriver.ResultList resultList = GDBDriver.this.executeCommand(() -> GDBDriver.this.doGetFrames(thread.getId(), from, count, untilFirstLineWithCode));
                if (resultList == null) {
                    2.$$$reportNull$$$0(7);
                }
                return resultList;
            }

            @Override
            @NotNull
            public List<LLValue> getVariables(@NotNull Bridge bridge, @NotNull LLThread thread, @NotNull LLFrame frame) throws ExecutionException, DebuggerCommandException {
                if (bridge == null) {
                    2.$$$reportNull$$$0(8);
                }
                if (thread == null) {
                    2.$$$reportNull$$$0(9);
                }
                if (frame == null) {
                    2.$$$reportNull$$$0(10);
                }
                List list = (List)GDBDriver.this.executeCommand(() -> GDBDriver.this.doGetFrameVariables(thread.getId(), frame.getIndex()));
                if (list == null) {
                    2.$$$reportNull$$$0(11);
                }
                return list;
            }

            @Override
            @NotNull
            public DebuggerDriver.ResultList<LLValue> getVariableChildren(@NotNull Bridge bridge, @NotNull LLValue value, int from, int count) throws ExecutionException, DebuggerCommandException {
                if (bridge == null) {
                    2.$$$reportNull$$$0(12);
                }
                if (value == null) {
                    2.$$$reportNull$$$0(13);
                }
                DebuggerDriver.ResultList resultList = (DebuggerDriver.ResultList)GDBDriver.this.executeCommand(() -> GDBDriver.this.doGetVariableChildren(value, from, count));
                if (resultList == null) {
                    2.$$$reportNull$$$0(14);
                }
                return resultList;
            }

            @Override
            @NotNull
            public LLValueData getData(@NotNull Bridge bridge, @NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
                if (bridge == null) {
                    2.$$$reportNull$$$0(15);
                }
                if (var == null) {
                    2.$$$reportNull$$$0(16);
                }
                LLValueData lLValueData = (LLValueData)GDBDriver.this.executeCommand(() -> GDBDriver.doLoadVariable((LLValue)var).data);
                if (lLValueData == null) {
                    2.$$$reportNull$$$0(17);
                }
                return lLValueData;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 14: 
                    case 17: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 14: 
                    case 17: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "bridge";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "stopTuple";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 14: 
                    case 17: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$2";
                        break;
                    }
                    case 6: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "thread";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "frame";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 16: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "var";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doReadStopPlaceAsync";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getThreads";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFrames";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariables";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariableChildren";
                        break;
                    }
                    case 17: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getData";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doReadStopPlaceAsync";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 14: 
                    case 17: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getThreads";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getFrames";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "getVariables";
                        break;
                    }
                    case 12: 
                    case 13: {
                        objectArray = objectArray;
                        objectArray[2] = "getVariableChildren";
                        break;
                    }
                    case 15: 
                    case 16: {
                        objectArray = objectArray;
                        objectArray[2] = "getData";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 14: 
                    case 17: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myBridge = new Bridge(){

            @Override
            @NotNull
            public <T> CompletableFuture<T> executeAsyncCommand(@NotNull Command<T> c) {
                if (c == null) {
                    16.$$$reportNull$$$0(0);
                }
                CompletableFuture<T> completableFuture = GDBDriver.this.executeAsyncCommand(c);
                if (completableFuture == null) {
                    16.$$$reportNull$$$0(1);
                }
                return completableFuture;
            }

            @Override
            @NotNull
            public <T> T executeCommand(@NotNull Command<T> c) throws ExecutionException, DebuggerCommandException {
                if (c == null) {
                    16.$$$reportNull$$$0(2);
                }
                T t = GDBDriver.this.executeCommand(c);
                if (t == null) {
                    16.$$$reportNull$$$0(3);
                }
                return t;
            }

            @Override
            @NotNull
            public String sendSilentRequestAndGetOutput(@NonNls @NotNull String command, Object ... args) throws ExecutionException, GDBCommandException {
                if (command == null) {
                    16.$$$reportNull$$$0(4);
                }
                if (args == null) {
                    16.$$$reportNull$$$0(5);
                }
                String string = GDBDriver.this.sendSilentRequestAndWaitForDone(command, args).getOutput();
                if (string == null) {
                    16.$$$reportNull$$$0(6);
                }
                return string;
            }

            @Override
            @NotNull
            public LLFrame doReadFrame(int level, @NotNull GDBTuple frameTuple) {
                if (frameTuple == null) {
                    16.$$$reportNull$$$0(7);
                }
                LLFrame lLFrame = GDBDriver.this.doReadFrame(level, frameTuple);
                if (lLFrame == null) {
                    16.$$$reportNull$$$0(8);
                }
                return lLFrame;
            }

            @Override
            @NotNull
            public DebuggerDriver.ResultList<LLFrame> doGetFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
                DebuggerDriver.ResultList<LLFrame> resultList = GDBDriver.this.doGetFrames(threadId, from, count, untilFirstLineWithCode);
                if (resultList == null) {
                    16.$$$reportNull$$$0(9);
                }
                return resultList;
            }

            @Override
            @NotNull
            public List<LLValue> doGetFrameVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
                List<LLValue> list = GDBDriver.this.doGetFrameVariables(threadId, frameIndex);
                if (list == null) {
                    16.$$$reportNull$$$0(10);
                }
                return list;
            }

            @Override
            @NotNull
            public LLValueData doEvaluateAndLoad(long threadId, int frameIndex, String expression, @Nullable String language) throws ExecutionException, DebuggerCommandException {
                LLValue threadIdValue = GDBDriver.this.doEvaluate(threadId, frameIndex, expression, language);
                LLValueData lLValueData = GDBDriver.doLoadVariable((LLValue)threadIdValue).data;
                if (lLValueData == null) {
                    16.$$$reportNull$$$0(11);
                }
                return lLValueData;
            }

            @Override
            @Nullable
            public DebuggerDriver.StopPlace getStopPlace() {
                return GDBDriver.this.myStopPlace;
            }

            @Override
            @NotNull
            public LLValueData doLoadVariableData(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
                if (value == null) {
                    16.$$$reportNull$$$0(12);
                }
                LLValueData lLValueData = GDBDriver.doLoadVariable((LLValue)value).data;
                if (lLValueData == null) {
                    16.$$$reportNull$$$0(13);
                }
                return lLValueData;
            }

            @Override
            @NotNull
            public DebuggerDriver.ResultList<LLValue> doGetVariableChildren(@NotNull LLValue var, int offset, int count) throws ExecutionException, DebuggerCommandException {
                if (var == null) {
                    16.$$$reportNull$$$0(14);
                }
                DebuggerDriver.ResultList<LLValue> resultList = GDBDriver.this.doGetVariableChildren(var, offset, count);
                if (resultList == null) {
                    16.$$$reportNull$$$0(15);
                }
                return resultList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 13: 
                    case 15: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 13: 
                    case 15: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "c";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 13: 
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$16";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "command";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "args";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "frameTuple";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "var";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$16";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "executeAsyncCommand";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "executeCommand";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "sendSilentRequestAndGetOutput";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doReadFrame";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doGetFrames";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doGetFrameVariables";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doEvaluateAndLoad";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doLoadVariableData";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doGetVariableChildren";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "executeAsyncCommand";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 13: 
                    case 15: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "executeCommand";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "sendSilentRequestAndGetOutput";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "doReadFrame";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "doLoadVariableData";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray;
                        objectArray[2] = "doGetVariableChildren";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 13: 
                    case 15: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myStarter = starter;
        this.myInterruptSignalName = this.getInterruptSignalName();
        this.myEmulateStepMode = this.isMac();
        this.myCommandExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)this.getClass().getSimpleName(), (int)1);
        this.myGdbCommandLine = this.myStarter.createDriverCommandLine(this, architectureType);
        this.myProcessHandler = this.createDebugProcessHandler(this.myGdbCommandLine, this.myStarter);
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            @NotNull
            private StringBuilder myBuffer = new StringBuilder();
            private Boolean myGotAnyStdout = false;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    3.$$$reportNull$$$0(1);
                }
                @NotNull String text = event.getText();
                if (outputType == ProcessOutputTypes.STDERR && !this.myGotAnyStdout.booleanValue()) {
                    GDBDriver.this.handleTargetOutput(text, outputType);
                }
                if (outputType == ProcessOutputTypes.STDOUT) {
                    int end;
                    this.myGotAnyStdout = true;
                    this.myBuffer.append(text);
                    String content = this.myBuffer.toString();
                    boolean changed = false;
                    while ((end = content.indexOf("\n")) != -1) {
                        String response = content.substring(0, end).trim();
                        content = content.substring(end + 1);
                        changed = true;
                        MIResponseFilter filter = GDBDriver.this.myMIResponseFilter;
                        if (filter != null) {
                            for (String line : StringUtil.splitByLines((String)filter.apply(GDBDriver.this.myCommunication.command, response))) {
                                GDBDriver.this.processResponse(line);
                            }
                            continue;
                        }
                        GDBDriver.this.processResponse(response);
                    }
                    if (changed) {
                        this.myBuffer = new StringBuilder(content);
                    }
                } else {
                    if (CidrDebuggerLog.LOG.isDebugEnabled()) {
                        CidrDebuggerLog.LOG.debug("<" + text);
                    }
                    if (ProcessOutputType.isStderr((Key)outputType)) {
                        GDBDriver.this.handleDebuggerOutput(text, outputType);
                    }
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(2);
                }
                CidrDebuggerLog.LOG.info("Debugger exited with code " + event.getExitCode());
                CidrDebuggerLog.LOG.debug("<[terminated]");
                GDBDriver.this.cleanupOnTermination();
                GDBDriver.this.handleExited(event.getExitCode());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        OutputStream input = this.myProcessHandler.getProcessInput();
        Charset charset = this.myProcessHandler.getCharset();
        assert (charset != null);
        this.mySink = new OutputStreamWriter(input, charset);
        this.myCommandSemaphore.down();
        this.executeCommandNoUserException(() -> {
            this.handlePrompt();
            CidrDebuggerLog.LOG.info("Debugger started");
        });
    }

    @Override
    public boolean supportsWatchpointLifetime() {
        return true;
    }

    @Override
    public boolean supportsJumpToLine() {
        return true;
    }

    @Override
    @NotNull
    public Language getConsoleLanguage() {
        GDBLanguage gDBLanguage = GDBLanguage.INSTANCE;
        if (gDBLanguage == null) {
            GDBDriver.$$$reportNull$$$0(7);
        }
        return gDBLanguage;
    }

    @Override
    @NotNull
    public BaseProcessHandler getProcessHandler() {
        BaseProcessHandler baseProcessHandler = this.myProcessHandler;
        if (baseProcessHandler == null) {
            GDBDriver.$$$reportNull$$$0(8);
        }
        return baseProcessHandler;
    }

    @Override
    @Nullable
    public OutputStream getProcessInput() {
        return this.myProcessInputProxy;
    }

    @Override
    public void removeWatchpoint(@NotNull List<Integer> ids) throws ExecutionException, DebuggerCommandException {
        if (ids == null) {
            GDBDriver.$$$reportNull$$$0(9);
        }
        this.removeCodepoints(ids);
    }

    @Override
    public void addSymbolsFile(@NotNull File file, @NotNull File module) {
        if (file == null) {
            GDBDriver.$$$reportNull$$$0(10);
        }
        if (module == null) {
            GDBDriver.$$$reportNull$$$0(11);
        }
    }

    @Override
    public boolean isInPromptMode() {
        return this.getPromptLevel() > 0;
    }

    @Override
    public String getPromptText() {
        return "gdb";
    }

    @Override
    protected void setState(@NotNull DebuggerDriver.TargetState state) {
        if (state == null) {
            GDBDriver.$$$reportNull$$$0(12);
        }
        super.setState(state);
        if (this.getState() == DebuggerDriver.TargetState.SUSPENDED) {
            this.executeAsyncCommand(new VoidCommand(){

                @Override
                public void run() {
                    GDBDriver.this.allocatedVariables.forEach(x$0 -> GDBDriver.this.doDeleteVar((String)x$0));
                    GDBDriver.this.allocatedVariables.clear();
                }
            });
        }
    }

    private void doDeleteVar(String varId) {
        try {
            this.sendRequestAndWaitForDone("-var-delete %s", varId);
        }
        catch (ExecutionException | DebuggerCommandException e) {
            CidrDebuggerLog.LOG.debug(e);
        }
    }

    @NotNull
    private String getInterruptSignalName() {
        String signalName;
        try {
            String signalNameFromRegistry = Registry.stringValue((String)"cidr.debugger.gdb.interrupt.signal");
            signalName = StringUtil.trimStart((String)StringUtil.toUpperCase((String)signalNameFromRegistry.trim()), (String)"SIG");
            if (!StringUtil.isLatinAlphanumeric((CharSequence)signalName)) {
                this.warnUser("Invalid interrupt signal name '" + signalNameFromRegistry + "'; falling back to SIGSTOP");
                signalName = "STOP";
            }
        }
        catch (MissingResourceException e) {
            signalName = "STOP";
        }
        if (!this.getHostMachine().isRemote() && UnixProcessManager.getSignalNumber((String)signalName) == -1) {
            this.warnUser("Unknown interrupt signal SIG" + signalName);
        }
        String string = signalName;
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    protected String shellQuote(@NotNull String s) {
        if (s == null) {
            GDBDriver.$$$reportNull$$$0(14);
        }
        if (this.isWindows()) {
            String string = CommandLineUtil.escapeParameterOnWindows((String)s, (boolean)false);
            if (string == null) {
                GDBDriver.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = GDBDriver.format("'%s'", s.replace("'", "'\\''"));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(16);
        }
        return string;
    }

    private void warnUser(@NlsSafe @NotNull String message) {
        if (message == null) {
            GDBDriver.$$$reportNull$$$0(17);
        }
        this.warnUser(message, null);
    }

    private void warnUser(@NlsSafe @NotNull String message, @Nullable Throwable e) {
        if (message == null) {
            GDBDriver.$$$reportNull$$$0(18);
        }
        message = message.trim();
        this.handleTargetOutput(message + "\n\n", ProcessOutputTypes.SYSTEM);
        CidrDebuggerLog.LOG.warn(message, e);
    }

    @Override
    public void setValuesFilteringEnabled(boolean enabled) {
    }

    private void doSetUpGDB(boolean isRemoteTarget) throws ExecutionException {
        boolean isElevated = this.myStarter.isElevated();
        try {
            this.doSetMaxDescription(true);
            this.gdbSet("print repeats", 0);
            this.gdbSet("print object", true);
            this.gdbSet("print asm-demangle", true);
            this.gdbSet("python print-stack", "full");
            if (this.myEmulateStepMode) {
                this.gdbSet("step-mode", true);
            }
            this.gdbSet("backtrace past-main", true);
            if (this.isMac()) {
                this.gdbSet("backtrace past-entry", true);
            }
            this.doSetMIAsync(isRemoteTarget || isElevated || Registry.is((String)"cidr.debugger.gdb.forceMIAsync", (boolean)false));
            if (!isRemoteTarget && !"INT".equals(this.myInterruptSignalName)) {
                try {
                    this.sendSilentRequestAndWaitForDone("handle SIG%s stop nopass", this.myInterruptSignalName);
                }
                catch (GDBCommandException e) {
                    this.warnUser("Unable to setup interrupt signal '" + this.myInterruptSignalName + "': " + e.getMessage());
                }
            }
        }
        catch (DebuggerCommandException e) {
            this.warnUser("Cannot configure GDB defaults: " + e.getMessage(), e);
        }
        try {
            @NonNls Object script = "import sys; sys.dont_write_bytecode = True; ";
            String printersPath = (String)this.myGdbCommandLine.getUserData(PRETTY_PRINTERS_PATH);
            if (printersPath != null) {
                script = (String)script + "sys.path.insert(0, " + GDBDriver.stringify(this.toEnvPath(printersPath)) + "); ";
                script = (String)script + "from default.printers import register_default_printers; register_default_printers(None); ";
                if (this.myGdbCommandLine.getUserData(ENABLE_STL_PRETTY_PRINTERS) == Boolean.TRUE) {
                    Response response = this.sendSilentRequestAndWaitForDone("info pretty-printer", new Object[0]);
                    boolean hasSTLprinters = response.getOutput().contains("libstdc++-v6");
                    if (!hasSTLprinters) {
                        script = (String)script + "from libstdcxx.v6.printers import register_libstdcxx_printers; register_libstdcxx_printers(None); ";
                    }
                    script = (String)script + "from default.libstdcxx_printers import patch_libstdcxx_printers_module; patch_libstdcxx_printers_module(); ";
                }
                this.sendSilentRequestAndWaitForDone("python %s", script);
                this.sendRequestAndWaitForDone("-enable-pretty-printing", new Object[0]);
            }
        }
        catch (GDBCommandException e) {
            this.warnUser("Error during pretty printers setup: " + e.getMessage() + "\n\nSome features and performance optimizations will not be available.\n\n" + e.getResponse().getOutput(), e);
        }
    }

    private void doSetStepMode(boolean enabled) throws ExecutionException, DebuggerCommandException {
        if (this.myStepMode == enabled) {
            return;
        }
        if (!this.myEmulateStepMode) {
            this.gdbSet("step-mode", enabled);
        }
        this.myStepMode = enabled;
    }

    public boolean isMIAsyncMode() {
        return this.myMIAsyncMode;
    }

    private void doSetMIAsync(boolean enabled) throws ExecutionException, DebuggerCommandException {
        try {
            boolean actualAsync = this.gdbShow("mi-async").getBoolean("value");
            if (enabled == actualAsync) {
                this.myMIAsyncMode = actualAsync;
                return;
            }
            this.gdbSet("mi-async", enabled);
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.warn("Can't enable 'mi-async' mode (too old GDB?); falling back to 'target-async'");
            this.gdbSet("target-async", enabled);
        }
        this.myMIAsyncMode = enabled;
    }

    private void doSetMaxDescription(boolean enabled) throws ExecutionException, DebuggerCommandException {
        this.gdbSet("print elements", enabled ? 250 : 0);
    }

    protected void gdbSet(@NonNls @NotNull String setting, boolean enabled) throws ExecutionException, DebuggerCommandException {
        if (setting == null) {
            GDBDriver.$$$reportNull$$$0(19);
        }
        this.gdbSet(setting, enabled ? "on" : "off");
    }

    protected void gdbSet(@NonNls @NotNull String setting, int value) throws ExecutionException, DebuggerCommandException {
        if (setting == null) {
            GDBDriver.$$$reportNull$$$0(20);
        }
        this.gdbSet(setting, String.valueOf(value));
    }

    protected void gdbSet(@NonNls @NotNull String setting, @NonNls @Nullable String value) throws ExecutionException, DebuggerCommandException {
        String command;
        if (setting == null) {
            GDBDriver.$$$reportNull$$$0(21);
        }
        String string = command = value != null ? GDBDriver.format("-gdb-set %s %s", setting, value) : GDBDriver.format("unset %s", setting);
        if (StringUtil.containsLineBreak((CharSequence)command)) {
            command = GDBDriver.createMI2Command(command, -1L, -1);
        }
        this.sendRequestAndWaitForDone("%s", command);
    }

    @NotNull
    protected GDBTuple gdbShow(@NonNls @NotNull String setting) throws ExecutionException, DebuggerCommandException {
        if (setting == null) {
            GDBDriver.$$$reportNull$$$0(22);
        }
        GDBTuple gDBTuple = this.sendRequestAndWaitForDone("-gdb-show %s", setting).getResultList();
        if (gDBTuple == null) {
            GDBDriver.$$$reportNull$$$0(23);
        }
        return gDBTuple;
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForLaunch(@NotNull Installer installer, @Nullable String architecture) throws ExecutionException {
        GeneralCommandLine targetCommandLine;
        if (installer == null) {
            GDBDriver.$$$reportNull$$$0(24);
        }
        boolean bl = this.myUseExternalConsoleRequested = (targetCommandLine = installer.install()).getUserData(USE_EXTERNAL_CONSOLE_KEY) == Boolean.TRUE;
        if (this.isMac()) {
            this.tryLoadIndirectSymbols(targetCommandLine);
        }
        this.executeCommandNoUserException(() -> {
            this.doSetUpGDB(false);
            this.doLoadExecutable(installer.getExecutableFile());
        });
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                return GDBDriver.this.launch(targetCommandLine);
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                GDBDriver.this.detach(false);
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return GDBDriver.this.abort();
            }
        };
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForAttach(@NotNull String name, boolean wait) throws ExecutionException {
        if (name == null) {
            GDBDriver.$$$reportNull$$$0(25);
        }
        throw new ExecutionException(GDBBundle.message("error.attaching.by.name.not.implemented", new Object[0]));
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadCoreDump(@NotNull File coreFile, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> sourcePathMappings) throws ExecutionException {
        if (coreFile == null) {
            GDBDriver.$$$reportNull$$$0(26);
        }
        if (sourcePathMappings == null) {
            GDBDriver.$$$reportNull$$$0(27);
        }
        DebuggerDriver.Inferior inferior = this.loadCoreDump(coreFile, symbolFile, sysroot, sourcePathMappings, Collections.emptyList());
        if (inferior == null) {
            GDBDriver.$$$reportNull$$$0(28);
        }
        return inferior;
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadCoreDump(final @NotNull File coreFile, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> sourcePathMappings, @NotNull List<String> execSearchPaths) throws ExecutionException {
        if (coreFile == null) {
            GDBDriver.$$$reportNull$$$0(29);
        }
        if (sourcePathMappings == null) {
            GDBDriver.$$$reportNull$$$0(30);
        }
        if (execSearchPaths == null) {
            GDBDriver.$$$reportNull$$$0(31);
        }
        this.executeCommandNoUserException(() -> {
            this.doSetUpGDB(false);
            if (symbolFile != null) {
                this.doLoadExecutable(symbolFile);
            }
            if (sysroot != null) {
                this.gdbSet("sysroot", sysroot.getPath());
            }
            this.doAddPathMapping(sourcePathMappings);
        });
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                GDBDriver.this.targetSelectCore(coreFile);
                return 0L;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                GDBDriver.this.detach(false);
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return GDBDriver.this.abort();
            }
        };
    }

    private void targetSelectCore(@NotNull File coreFile) throws ExecutionException {
        if (coreFile == null) {
            GDBDriver.$$$reportNull$$$0(32);
        }
        this.executeCommandNoUserException(() -> {
            this.doSelectWinbreakBinary();
            Response response = this.sendRequest("-target-select core %s", this.toEnvPath(coreFile.getPath())).waitFor(GDBResponse.ResultRecord.Type.connected);
            GDBTuple frameTuple = response.getResultList().getRequiredTuple("frame");
            LLFrame frame = this.doReadFrame(frameTuple.getInt("level", 0), frameTuple);
            int threadId = 1;
            try {
                LLValue threadIdValue = this.doEvaluate(-1L, -1, "$_gthread", null);
                threadId = (int)GDBDriver.doLoadVariable((LLValue)threadIdValue).data.intValue();
            }
            catch (DebuggerCommandException e) {
                CidrDebuggerLog.LOG.warn("Unable to retrieve thread id using $_gthread: " + e.getMessage());
            }
            LLThread thread = new LLThread(threadId);
            DebuggerDriver.StopPlace stopPlace = new DebuggerDriver.StopPlace(thread, frame);
            this.handleInterrupted(stopPlace);
            return -1;
        });
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForAttach(final int pid) throws ExecutionException {
        if (this.isMac()) {
            throw new ExecutionException(GDBBundle.message("error.attaching.unsupported.for.gdb.on.os.x", new Object[0]));
        }
        this.executeCommandNoUserException(() -> this.doSetUpGDB(false));
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                GDBDriver.this.attachTo(pid);
                return pid;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                GDBDriver.this.detach(false);
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return GDBDriver.this.abort();
            }
        };
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForRemote(@NotNull String connectionString, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> pathMappings) throws ExecutionException {
        if (connectionString == null) {
            GDBDriver.$$$reportNull$$$0(33);
        }
        if (pathMappings == null) {
            GDBDriver.$$$reportNull$$$0(34);
        }
        DebuggerDriver.Inferior inferior = this.loadForRemote(connectionString, symbolFile, sysroot, pathMappings, Collections.emptyList());
        if (inferior == null) {
            GDBDriver.$$$reportNull$$$0(35);
        }
        return inferior;
    }

    @NotNull
    public DebuggerDriver.Inferior loadForRemote(final @NotNull String connectionString, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> pathMappings, final @NotNull List<String> additionalCommands) throws ExecutionException {
        if (connectionString == null) {
            GDBDriver.$$$reportNull$$$0(36);
        }
        if (pathMappings == null) {
            GDBDriver.$$$reportNull$$$0(37);
        }
        if (additionalCommands == null) {
            GDBDriver.$$$reportNull$$$0(38);
        }
        this.executeCommandNoUserException(() -> {
            this.doSetUpGDB(true);
            if (symbolFile != null) {
                try {
                    this.doLoadExecutable(symbolFile);
                }
                catch (DebuggerCommandException e) {
                    throw new DebuggerCommandException("Cannot load symbol file: " + e.getMessage(), e);
                }
            }
            if (sysroot != null) {
                try {
                    this.gdbSet("sysroot", sysroot.getPath());
                }
                catch (DebuggerCommandException e) {
                    throw new DebuggerCommandException("Cannot set sysroot: " + e.getMessage(), e);
                }
            }
            this.doAddPathMapping(pathMappings);
        });
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws ExecutionException {
                GDBDriver.this.connectTo(connectionString, additionalCommands);
                return 0L;
            }

            @Override
            protected void detachImpl() throws ExecutionException {
                GDBDriver.this.detach(true);
            }

            @Override
            protected boolean destroyImpl() throws ExecutionException {
                return GDBDriver.this.abort();
            }
        };
    }

    private void doAddPathMapping(@NotNull List<DebuggerDriver.PathMapping> pathMappings) throws ExecutionException, DebuggerCommandException {
        if (pathMappings == null) {
            GDBDriver.$$$reportNull$$$0(39);
        }
        for (DebuggerDriver.PathMapping each : pathMappings) {
            String from = FileUtil.toSystemIndependentName((String)each.from);
            String to = FileUtil.toSystemIndependentName((String)each.to);
            try {
                this.sendRequestAndWaitForDone("-gdb-set substitute-path %s %s", GDBDriver.stringify(from), GDBDriver.stringify(to));
                String envFrom = this.toEnvPath(from);
                if (from.equals(envFrom)) continue;
                this.sendRequestAndWaitForDone("-gdb-set substitute-path %s %s", GDBDriver.stringify(envFrom), GDBDriver.stringify(to));
            }
            catch (DebuggerCommandException e) {
                throw new DebuggerCommandException("Cannot set path mapping: " + e.getMessage(), e);
            }
        }
    }

    private void tryLoadIndirectSymbols(@NotNull GeneralCommandLine line) {
        if (line == null) {
            GDBDriver.$$$reportNull$$$0(40);
        }
        try {
            this.myIndirectSymbols = MacOSDebugSymbols.load(line);
        }
        catch (IOException e) {
            this.warnUser("Cannot create and read debug symbols: " + ExceptionUtil.getMessage((Throwable)e), e);
        }
    }

    private void doLoadExecutable(@NotNull File file) throws ExecutionException, DebuggerCommandException {
        if (file == null) {
            GDBDriver.$$$reportNull$$$0(41);
        }
        String path = this.toEnvPath(file.getPath());
        this.sendRequestAndWaitForDone("-file-exec-and-symbols %s", GDBDriver.stringify(FileUtil.toSystemIndependentName((String)path)));
        this.handleModulesLoaded(Collections.singletonList(new LLModule(path)));
    }

    private int launch(@NotNull GeneralCommandLine targetCommandLine) throws ExecutionException {
        if (targetCommandLine == null) {
            GDBDriver.$$$reportNull$$$0(42);
        }
        return this.executeCommandNoUserException(() -> {
            File workDirectory;
            this.printTargetCommandLine(targetCommandLine);
            Charset charset = targetCommandLine.getCharset();
            ArrayList<String> charsetNames = new ArrayList<String>();
            charsetNames.add(charset.name());
            charsetNames.addAll(ContainerUtil.sorted(charset.aliases()));
            for (String charsetName : charsetNames) {
                try {
                    this.gdbSet("charset", charsetName);
                    break;
                }
                catch (DebuggerCommandException e) {
                    CidrDebuggerLog.LOG.warn(e.getMessage());
                }
            }
            if ((workDirectory = targetCommandLine.getWorkDirectory()) != null) {
                this.sendRequestAndWaitForDone("-environment-cd %s", GDBDriver.stringify(this.toEnvPath(workDirectory.getPath())));
            }
            Map gdbEnv = this.myGdbCommandLine.getEffectiveEnvironment();
            this.doPrepareInferiorEnv(targetCommandLine, gdbEnv);
            boolean useStartupWithShellWorkaroundOnSierra = this.isMacOSSierra() && Registry.is((String)"cidr.debugger.gdb.workaround.macOS.startupWithShell", (boolean)true);
            Request execRunRequest = this.buildRequest("-exec-run", new Object[0]);
            Object params = this.getInferiorArgs(targetCommandLine.getParametersList(), !useStartupWithShellWorkaroundOnSierra, this.isWindowsIoRedirectionEnabled());
            try {
                NamedPipe pipe;
                File inputFile = targetCommandLine.getInputFile();
                if (inputFile != null) {
                    Path inputPath = this.getHostMachine().getPath(inputFile.getPath(), new String[0]);
                    if (!Files.exists(inputPath, new LinkOption[0]) || !Files.isReadable(inputPath)) {
                        throw new FileNotFoundException(CidrDebuggerBundle.message("debug.driver.cannotReadInputFile", inputFile.getPath()));
                    }
                    params = (String)params + GDBDriver.format(" < %s ", this.shellQuote(this.toEnvPath(inputFile.getPath())));
                } else if (!this.isWindows() && !this.getHostMachine().isRemote()) {
                    Pty pty = new Pty(true);
                    this.sendRequestAndWaitForDone("-inferior-tty-set %s", GDBDriver.stringify(pty.getSlaveName()));
                    this.myProcessInput = pty.getOutputStream();
                } else if (this.getHostMachine().isRemote()) {
                    pipe = this.getHostMachine().openNamedPipe();
                    params = (String)params + GDBDriver.format(" < %s ", this.shellQuote(pipe.getName()));
                    this.myProcessInput = pipe.getOutputStream();
                } else if (this.isWindowsIoRedirectionEnabled()) {
                    pipe = WinPipe.createOutboundPipe((String)"stdin");
                    params = GDBDriver.format(" < %s ", this.shellQuote(pipe.getName())) + (String)params;
                    this.myProcessInput = pipe.getOutputStream();
                }
            }
            catch (IOException e) {
                CidrDebuggerLog.LOG.error((Throwable)e);
                throw new ExecutionException(CidrDebuggerBundle.message("debug.driver.cannotCreatePipe", e.getMessage()));
            }
            if (this.myToRedirect) {
                if (this.isWindows() && !this.isWindowsIoRedirectionEnabled()) {
                    this.gdbSet("new-console", true);
                } else {
                    boolean isCsh;
                    ProcessOutputReaders readers = this.initReaders(this.getHostMachine(), targetCommandLine, !this.isWindows());
                    String redirectParams = GDBDriver.format(" 1> %s 2> %s ", this.shellQuote(this.toEnvPath(readers.getOutFileAbsolutePath())), this.shellQuote(this.toEnvPath(readers.getErrFileAbsolutePath())));
                    String gdbShell = gdbEnv.getOrDefault("SHELL", "/bin/sh");
                    boolean bl = isCsh = this.isUnix() && gdbShell.endsWith("csh");
                    if (useStartupWithShellWorkaroundOnSierra) {
                        this.gdbSet("startup-with-shell", false);
                        String[] symbolNames = new String[]{"main", "__cxx_global_var_init", "__libc_csu_init", "__static_initialization_and_destruction_0"};
                        ArrayList<Integer> startBreakpointNumbers = new ArrayList<Integer>(symbolNames.length);
                        for (String symbolName : symbolNames) {
                            startBreakpointNumbers.add(this.doInsertSymbolicBreakpoint(symbolName, null, true).getId());
                        }
                        ThreadPlan.BreakpointHit startThreadPlan = (stopPlace, breakpointNumber) -> {
                            this.executeAsyncCommand(() -> {
                                this.sendSilentRequestAndWaitForDone("-break-delete %s", StringUtil.join((Iterable)startBreakpointNumbers, (String)" "));
                                try {
                                    this.sendSilentRequestAndWaitForDone("-data-evaluate-expression %s %s", GDBDriver.onThreadAndFrame(stopPlace), GDBDriver.stringify(GDBDriver.createDupFdCall(this.toEnvPath(readers.getOutFileAbsolutePath()), 1)));
                                    this.sendSilentRequestAndWaitForDone("-data-evaluate-expression %s %s", GDBDriver.onThreadAndFrame(stopPlace), GDBDriver.stringify(GDBDriver.createDupFdCall(this.toEnvPath(readers.getErrFileAbsolutePath()), 2)));
                                }
                                catch (GDBCommandException e) {
                                    this.warnUser("Unable to setup IO redirection: " + e.getMessage(), e);
                                }
                                if (!startBreakpointNumbers.contains(breakpointNumber) || !this.doResumeInternal(false)) {
                                    this.handleBreakpoint(stopPlace, breakpointNumber);
                                }
                            });
                            return false;
                        };
                        execRunRequest = execRunRequest.withThreadPlan(startThreadPlan).suppressRunningEvent();
                        if (ContainerUtil.find((Iterable)targetCommandLine.getParametersList().getList(), StringUtil::containsWhitespaces) != null) {
                            this.warnUser("'startup-with-shell' is turned off in order to make GDB run on macOS Sierra and higher.\nThe program arguments might be passed incorrectly");
                        }
                    } else if (this.isWindows()) {
                        params = redirectParams + (String)params;
                    } else if (!isCsh) {
                        boolean isZsh = gdbShell.endsWith("zsh");
                        String ARGV0 = "ARGV0";
                        if (isZsh && gdbEnv.containsKey("ARGV0") && !targetCommandLine.getEnvironment().containsKey("ARGV0")) {
                            this.gdbSet("env ARGV0", null);
                        }
                        params = (String)params + redirectParams;
                    } else if (GDBDriver.isBourneShellAvailable()) {
                        this.doWrapExec(this.getShellCommandLineString("exec \"$@\" " + redirectParams));
                    } else {
                        params = (String)params + GDBDriver.format(" >&! %s", this.shellQuote(this.toEnvPath(readers.getOutFileAbsolutePath())));
                        this.warnUser(gdbShell + " doesn't support separate IO redirection.\nThe output will appear without stderr coloring");
                    }
                }
            }
            this.doSelectWinbreakBinary();
            this.gdbSet("args", (String)params);
            try {
                execRunRequest.send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
            }
            catch (GDBCommandException e) {
                if (this.isMacOSSierra() && e.getMessage().startsWith("During startup program terminated with")) {
                    throw new MacOSSierraDuringStartupProgramTerminatedException(e);
                }
                throw e;
            }
            Integer pid = this.myTargetPID;
            CidrDebuggerLog.LOG.assertTrue(pid != null);
            return pid;
        });
    }

    protected boolean isWindowsIoRedirectionEnabled() {
        return this.myWindowsIoRedirectionEnabled;
    }

    @NotNull
    protected static String createDupFdCall(@NotNull String path, int fd) {
        if (path == null) {
            GDBDriver.$$$reportNull$$$0(43);
        }
        String open = "((int (*)(const char *, int))open)";
        String dup2 = "((int (*)(int, int))dup2)";
        String openCall = GDBDriver.format("%s(%s, %o)", "((int (*)(const char *, int))open)", GDBDriver.stringify(path), 1);
        String string = GDBDriver.format("%s(%s, %d)", "((int (*)(int, int))dup2)", openCall, fd);
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(44);
        }
        return string;
    }

    protected void doWrapExec(@NotNull String wrapper) throws ExecutionException, DebuggerCommandException {
        String oldWrapper;
        if (wrapper == null) {
            GDBDriver.$$$reportNull$$$0(45);
        }
        if ((oldWrapper = this.gdbShow("exec-wrapper").getString("value")) != null) {
            wrapper = (String)wrapper + " " + oldWrapper;
        }
        this.gdbSet("exec-wrapper", (String)wrapper);
    }

    protected static boolean isBourneShellAvailable() throws ExecutionException {
        if (ourShellAvailable == null) {
            ourShellAvailable = ExecUtil.execAndGetOutput((GeneralCommandLine)GDBDriver.getShellWrapper("exit \"$@\" 1> /dev/null 2> /dev/null", "0")).checkSuccess(CidrDebuggerLog.LOG);
        }
        return ourShellAvailable;
    }

    @NotNull
    protected static GeneralCommandLine getShellWrapper(@NotNull String command, String ... parameters) {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(46);
        }
        if (parameters == null) {
            GDBDriver.$$$reportNull$$$0(47);
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{"/bin/sh", "-c", command, "--"}).withParameters(parameters);
        if (generalCommandLine == null) {
            GDBDriver.$$$reportNull$$$0(48);
        }
        return generalCommandLine;
    }

    @NotNull
    protected String getShellCommandLineString(@NotNull String command) {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(49);
        }
        String string = this.getShellCommandLineString(GDBDriver.getShellWrapper(command, new String[0]));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(50);
        }
        return string;
    }

    @NotNull
    protected String getShellCommandLineString(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            GDBDriver.$$$reportNull$$$0(51);
        }
        String string = commandLine.getCommandLineList(null).stream().map(s -> this.shellQuote((String)s)).collect(Collectors.joining(" "));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NotNull
    protected String getInferiorArgs(@NotNull ParametersList parametersList, boolean escapeParameters, boolean escapeForIORedirectionOnWindows) {
        if (parametersList == null) {
            GDBDriver.$$$reportNull$$$0(53);
        }
        Function<String, String> quoteFunction = parameter -> parameter;
        List<String> params = parametersList.getList();
        if (escapeParameters) {
            if (!this.isWindows()) {
                quoteFunction = parameter -> this.shellQuote((String)parameter);
            } else if (!escapeForIORedirectionOnWindows) {
                quoteFunction = parameter -> CommandLineUtil.escapeParameterOnWindows((String)parameter, (boolean)false);
            } else {
                params = GDBDriver.quoteParametersForIORedirectionOnWindows(params);
            }
        }
        String string = params.stream().map(quoteFunction).collect(Collectors.joining(" "));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(54);
        }
        return string;
    }

    @NotNull
    private static List<String> quoteParametersForIORedirectionOnWindows(@NotNull List<String> params) {
        if (params == null) {
            GDBDriver.$$$reportNull$$$0(55);
        }
        ArrayList<String> quotedParams = new ArrayList<String>(params.size());
        boolean quote = false;
        for (String parameter : params) {
            String escapedParameter = CommandLineUtil.escapeParameterOnWindows((String)parameter, (boolean)false);
            StringBuilder sb = new StringBuilder();
            boolean wildRedirection = false;
            char prev = '\u0000';
            for (int i = 0; i < escapedParameter.length(); ++i) {
                char ch = escapedParameter.charAt(i);
                if (ch == '\"') {
                    if (prev == '\\') {
                        sb.append(prev);
                    } else {
                        boolean bl = quote = !quote;
                    }
                }
                if (!(ch != '<' && ch != '>' || quote)) {
                    wildRedirection = true;
                }
                sb.append(ch);
                prev = ch;
            }
            if (wildRedirection) {
                if (sb.charAt(0) == '\"') {
                    sb.insert(0, '\\');
                } else {
                    sb.insert(0, '\"');
                    sb.append('\"');
                }
            }
            quotedParams.add(sb.toString());
        }
        ArrayList<String> arrayList = quotedParams;
        if (arrayList == null) {
            GDBDriver.$$$reportNull$$$0(56);
        }
        return arrayList;
    }

    protected void doPrepareInferiorEnv(GeneralCommandLine targetCommandLine, Map<String, String> gdbEnv) throws ExecutionException, DebuggerCommandException {
        boolean unbufferedIO;
        if (!targetCommandLine.isPassParentEnvironment()) {
            this.sendSilentRequestAndWaitForDone("unset env", new Object[0]);
            gdbEnv = Collections.emptyMap();
        }
        Map targetEnv = targetCommandLine.getEffectiveEnvironment();
        for (Map.Entry entry : ContainerUtil.diff((Map)targetEnv, gdbEnv).entrySet()) {
            String key = StringUtil.escapeLineBreak((String)((String)entry.getKey()));
            String value = (String)((Couple)entry.getValue()).first;
            if (key.contains("=")) {
                CidrDebuggerLog.LOG.warn("Ignoring '" + key + "' env variable.");
                continue;
            }
            this.gdbSet("env " + key, value);
        }
        if (this.isMac() && !(unbufferedIO = "YES".equalsIgnoreCase((String)targetEnv.get("NSUnbufferedIO")))) {
            this.warnUser("NSUnbufferedIO is not set, output may be delayed");
        }
    }

    protected void doSelectWinbreakBinary() throws ExecutionException, DebuggerCommandException {
        if (!this.isWindows() || this.myMIAsyncMode) {
            return;
        }
        String winBreakName = null;
        Pattern pattern = Pattern.compile(".+, file type (.+)\\.");
        Response response = this.sendSilentRequestAndWaitForDone("info target", new Object[0]);
        String consoleOutput = response.getOutput();
        for (String eachLine : StringUtil.splitByLines((String)consoleOutput)) {
            Matcher matcher = pattern.matcher(eachLine);
            if (!matcher.matches()) continue;
            String type = matcher.group(1);
            if (type.matches(".*\\bi\\d86\\b.*")) {
                winBreakName = "winbreak32.exe";
            } else if (type.contains("86_64") || type.contains("86-64")) {
                winBreakName = "winbreak64.exe";
            } else {
                throw new ExecutionException(GDBBundle.message("error.cannot.determine.architecture.target", type));
            }
            CidrDebuggerLog.LOG.debug("Winbreak selected: " + winBreakName + " for: " + type);
            break;
        }
        if (winBreakName == null) {
            throw new ExecutionException(GDBBundle.message("error.cannot.determine.architecture.target", "\n" + consoleOutput));
        }
        File winBreakFile = CidrDebuggerPathManager.getWinbreakFile(winBreakName);
        if (!winBreakFile.exists()) {
            throw new ExecutionException(GDBBundle.message("error.cannot.find.winbreak.executable", winBreakFile.getPath()));
        }
        this.myWinBreakPath = winBreakFile.getPath();
    }

    private void attachTo(final int pid) throws ExecutionException {
        this.executeCommandNoUserException(new AttachConnectCommand(){

            @Override
            protected int attach() throws ExecutionException, DebuggerCommandException {
                GDBDriver.this.buildRequest("-target-attach %d", pid).suppressRunningEvent(GDBDriver.this.isWindows()).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
                return pid;
            }

            @Override
            protected void whenAttached() {
                GDBDriver.this.handleAttached(pid);
            }
        });
    }

    private void detach(boolean isRemoteTarget) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            this.doInterruptAndWait();
            Response response = this.buildRequest("-target-detach", new Object[0]).suppressTargetFinishedEvent().send().waitFor(new GDBResponse.ResultRecord.Type[0]);
            String message = response.getGDBErrorMessage();
            if (message != null) {
                if (message.equals("Remote connection closed") || message.matches("Remote communication error\\. *Target disconnected\\..*") || message.equals("Remote doesn't know how to detach") || message.equals("Can't detach process.")) {
                    this.warnUser(message);
                } else if (!message.equals("The program is not being run.")) {
                    throw new GDBCommandException(response, message);
                }
            }
            if (isRemoteTarget) {
                this.handleDisconnected();
            } else {
                this.handleDetached();
            }
        });
    }

    private void connectTo(final @NotNull String connectionString, final @NotNull List<String> additionalCommands) throws ExecutionException {
        if (connectionString == null) {
            GDBDriver.$$$reportNull$$$0(57);
        }
        if (additionalCommands == null) {
            GDBDriver.$$$reportNull$$$0(58);
        }
        this.executeCommandNoUserException(new AttachConnectCommand(){

            @Override
            protected int attach() throws ExecutionException, DebuggerCommandException {
                GDBDriver.this.sendRequest("-target-select remote %s", connectionString).waitFor(GDBResponse.ResultRecord.Type.connected);
                for (String command : additionalCommands) {
                    GDBDriver.this.sendRequest("%s", command).waitFor(GDBResponse.ResultRecord.Type.done);
                }
                return -1;
            }

            @Override
            protected void whenAttached() {
                GDBDriver.this.handleConnected(connectionString);
            }
        });
    }

    @Override
    public boolean interrupt() throws ExecutionException {
        return this.executeCommandNoUserException(() -> this.doInterrupt(false));
    }

    private boolean doInterrupt(boolean tearDownRequest) throws ExecutionException {
        this.throwIfTerminatedOrHasPendingErrors(tearDownRequest);
        Integer pid = this.myTargetPID;
        if (pid == null || this.getState() != DebuggerDriver.TargetState.RUNNING) {
            return false;
        }
        if (this.myMIAsyncMode) {
            return this.doInterruptAsync(tearDownRequest);
        }
        this.doInterruptWithSignal(pid, tearDownRequest);
        return true;
    }

    protected boolean doInterruptAsync(boolean tearDownRequest) throws ExecutionException {
        try {
            this.buildRequest("-exec-interrupt", new Object[0]).tearDownRequest(tearDownRequest).send().waitFor(GDBResponse.ResultRecord.Type.done);
            return true;
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.warn((Throwable)e);
            return false;
        }
    }

    protected void doInterruptWithSignal(int pid, boolean tearDownRequest) throws ExecutionException {
        this.sendRequestOrSpecialCommunication("interrupt", tearDownRequest, (ThrowableRunnable<? extends ExecutionException>)((ThrowableRunnable)() -> {
            if (CidrDebuggerLog.LOG.isDebugEnabled()) {
                CidrDebuggerLog.LOG.debug(">interrupt");
            }
            if (this.isWindows()) {
                this.doInterruptWinBreak(pid);
            } else {
                this.doInterruptUnixSignal(pid);
            }
        }));
    }

    private void doInterruptWinBreak(int pid) throws ExecutionException {
        CidrDebuggerLog.LOG.debug(">Sending interrupt signal using 'winbreak'");
        if (this.myWinBreakPath == null) {
            throw new ExecutionException(GDBBundle.message("error.winbreak.was.not.selected", new Object[0]));
        }
        ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{this.myWinBreakPath, Integer.toString(pid)}));
        String stderr = output.getStderr();
        CidrDebuggerLog.LOG.debug(stderr);
        int exitCode = output.getExitCode();
        if (exitCode != 0) {
            CidrDebuggerLog.LOG.debug("winbreak failed with exit code " + exitCode);
            throw new ExecutionException(GDBDriver.extractErrorLinesFromOutput(stderr));
        }
    }

    @NlsSafe
    @NotNull
    private static String extractErrorLinesFromOutput(@Nls @NotNull String stderr) {
        if (stderr == null) {
            GDBDriver.$$$reportNull$$$0(59);
        }
        Scanner scanner = new Scanner(stderr);
        StringBuilder errorMessage = new StringBuilder();
        while (scanner.hasNext()) {
            if (scanner.findInLine("ERROR: (.*)") != null) {
                MatchResult result2 = scanner.match();
                if (errorMessage.length() > 0) {
                    errorMessage.append('\n');
                }
                errorMessage.append(result2.group(1));
            }
            scanner.nextLine();
        }
        String string = errorMessage.toString();
        String string2 = string;
        if (string2 == null) {
            GDBDriver.$$$reportNull$$$0(60);
        }
        return string2;
        finally {
            scanner.close();
        }
    }

    private void doInterruptUnixSignal(int pid) throws ExecutionException {
        @NlsSafe String SIG = "SIG";
        String signalDisplayName = SIG + this.myInterruptSignalName;
        String signalCommand = "Sending " + signalDisplayName + " to " + pid;
        CidrDebuggerLog.LOG.debug(">" + signalCommand);
        int err = this.getHostMachine().sendSignal(pid, this.myInterruptSignalName);
        if (err == -1) {
            throw new ExecutionException(GDBBundle.message("error.cannot.send.signal.to.pid", signalDisplayName, pid));
        }
    }

    private boolean doInterruptAndWait() throws ExecutionException {
        return this.doInterruptAndWait(false);
    }

    private boolean doInterruptAndWait(boolean tearDownRequest) throws ExecutionException {
        this.myStopSemaphore.down();
        try {
            if (this.doInterrupt(tearDownRequest)) {
                if (tearDownRequest && !GDBDriver.waitForSemaphore(this.myStopSemaphore, 1500L)) {
                    throw new ExecutionException(GDBBundle.message("error.cannot.interrupt.gdb.to.request.exit", new Object[0]));
                }
                GDBDriver.waitForSemaphore(this.myStopSemaphore);
                boolean bl = this.myIsInterruptedStop;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.myStopSemaphore.up();
        }
    }

    @TestOnly
    public String @NotNull [] listVarObjects() throws ExecutionException, DebuggerCommandException {
        String[] stringArray = this.executeCommand(new SuspendedCommand<String[]>(){

            @Override
            public String[] call() throws ExecutionException, DebuggerCommandException {
                Response response = GDBDriver.this.sendRequestAndWaitForDone("-var-update 0 *", new Object[0]);
                GDBTuple changelist = Objects.requireNonNull(response.getResultList().getTuple("changelist"));
                return (String[])changelist.stream().map(t -> ((GDBTuple)t).getString("name")).toArray(String[]::new);
            }
        });
        if (stringArray == null) {
            GDBDriver.$$$reportNull$$$0(61);
        }
        return stringArray;
    }

    @Override
    public boolean resume() throws ExecutionException {
        return this.executeCommandNoUserException(this::doResume);
    }

    private boolean doResume() throws ExecutionException, DebuggerCommandException {
        return this.doResume(false);
    }

    private boolean doResume(boolean suppressRunningEvent) throws ExecutionException, DebuggerCommandException {
        if (this.getState() == DebuggerDriver.TargetState.NOT_READY) {
            return false;
        }
        return this.doResumeInternal(suppressRunningEvent);
    }

    private boolean doResumeInternal(boolean suppressRunningEvent) throws ExecutionException, GDBCommandException {
        try {
            this.buildRequest("-exec-continue %s", this.onStoppedThreadAndFrame()).suppressRunningEvent(suppressRunningEvent).send().waitFor(GDBResponse.ResultRecord.Type.running);
            return true;
        }
        catch (GDBCommandException e) {
            if (GDBDriver.messageContains(e, "The program is not being run.")) {
                return false;
            }
            throw e;
        }
    }

    private boolean getInstructionMode(@Nullable Boolean stepByInstruction) {
        boolean frameHasNoDebugInfo;
        DebuggerDriver.StopPlace stopPlace = this.myStopPlace;
        boolean bl = frameHasNoDebugInfo = stopPlace != null && !stopPlace.frame.hasDebugInfo();
        if (stepByInstruction != Boolean.TRUE) {
            if (frameHasNoDebugInfo && stepByInstruction == Boolean.FALSE) {
                CidrDebuggerLog.LOG.error("Attempt to line-step through function with no source line information; forcing instruction stepping mode");
            }
            stepByInstruction = frameHasNoDebugInfo;
        }
        return stepByInstruction;
    }

    @Override
    public void stepInto(boolean forceStepIntoFramesWithNoDebugInfo, @Nullable Boolean stepByInstruction) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            boolean instructionMode = this.getInstructionMode(stepByInstruction);
            if (!instructionMode) {
                this.doSetStepMode(forceStepIntoFramesWithNoDebugInfo);
            }
            this.buildRequest("-exec-step%s %s", GDBDriver.withInstructionMode(instructionMode), this.onStoppedThreadAndFrame()).onSteppingFinished(stopPlace -> {
                if (instructionMode || forceStepIntoFramesWithNoDebugInfo || stopPlace.frame.hasDebugInfo()) {
                    return true;
                }
                if (this.isMac() && this.isIndirectSymbolFrame(stopPlace.frame)) {
                    this.executeAsyncCommand(() -> this.sendSilentRequest("-exec-step %s", this.onStoppedThreadAndFrame()));
                    return false;
                }
                return this.asyncStepOutUntilFrameWithDebugInfo(stopPlace);
            }).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
        });
    }

    @Override
    public void stepOver(@Nullable Boolean stepByInstruction) throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            try (CidrEventSpan ignored = new CidrEventSpan("debug", "stepOver", null);){
                boolean instructionMode = this.getInstructionMode(stepByInstruction);
                if (!instructionMode) {
                    this.doSetStepMode(false);
                }
                this.buildRequest("-exec-next%s %s", GDBDriver.withInstructionMode(instructionMode), this.onStoppedThreadAndFrame()).onSteppingFinished(instructionMode ? null : this::asyncStepOutUntilFrameWithDebugInfo).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
            }
        });
    }

    @Override
    public void stepOut() throws ExecutionException {
        this.executeCommandNoUserException(() -> {
            boolean instructionMode = this.getInstructionMode(null);
            this.doSetStepMode(false);
            this.buildRequest("-exec-finish %s", this.onStoppedThreadAndFrame()).onSteppingFinished(instructionMode ? null : this::asyncStepOutUntilFrameWithDebugInfo).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
        });
    }

    private boolean asyncStepOutUntilFrameWithDebugInfo(@NotNull DebuggerDriver.StopPlace stopPlace) {
        boolean shouldStop;
        if (stopPlace == null) {
            GDBDriver.$$$reportNull$$$0(62);
        }
        if (!(shouldStop = stopPlace.frame.hasDebugInfo())) {
            this.executeAsyncCommand(() -> this.buildRequest("-exec-next %s", this.onStoppedThreadAndFrame()).suppressAll().onSteppingFinished(this::asyncStepOutUntilFrameWithDebugInfo).send());
        }
        return shouldStop;
    }

    @Override
    public void runTo(@NotNull String path, int line) throws ExecutionException {
        if (path == null) {
            GDBDriver.$$$reportNull$$$0(63);
        }
        this.runTo(GDBDriver.atSourceLine(this.toEnvPath(path), line));
    }

    @Override
    public void runTo(@NotNull Address address) throws ExecutionException {
        if (address == null) {
            GDBDriver.$$$reportNull$$$0(64);
        }
        this.runTo(GDBDriver.atAddress(address));
    }

    protected void runTo(@NotNull String location) throws ExecutionException {
        if (location == null) {
            GDBDriver.$$$reportNull$$$0(65);
        }
        this.executeCommandNoUserException(() -> {
            String command = GDBDriver.format("advance %s", location);
            String consoleCommand = GDBDriver.createConsoleCommand(command, this.myStopPlace);
            return this.sendRequestAndWaitForRunning("%s", consoleCommand);
        });
    }

    @Override
    @NotNull
    public DebuggerDriver.StopPlace jumpToLine(@NotNull LLThread thread, @NotNull String path, int line, boolean canLeaveFunction) throws ExecutionException, DebuggerCommandException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(66);
        }
        if (path == null) {
            GDBDriver.$$$reportNull$$$0(67);
        }
        DebuggerDriver.StopPlace stopPlace = this.executeCommand(() -> {
            void var10_12;
            String sourceLine = GDBDriver.atSourceLine(this.toEnvPath(path), line);
            Response lineInfoResponse = this.sendSilentRequestAndWaitForDone("info line %s", sourceLine);
            String[] outputLines = StringUtil.splitByLines((String)lineInfoResponse.getOutput(), (boolean)true);
            ArrayList<CallSite> result2 = new ArrayList<CallSite>(outputLines.length);
            String[] stringArray = outputLines;
            int n = stringArray.length;
            boolean bl = false;
            while (var10_12 < n) {
                String lineInfo = stringArray[var10_12];
                Matcher lineMatcher = LINE_INFO_RESULT.matcher(lineInfo);
                if (lineMatcher.matches()) {
                    result2.add((CallSite)((Object)("0x" + lineMatcher.group(2))));
                } else {
                    lineMatcher = LINE_INFO_NO_CODE_RESULT.matcher(lineInfo);
                    if (lineMatcher.matches()) {
                        result2.add((CallSite)((Object)("0x" + lineMatcher.group(2))));
                    }
                }
                ++var10_12;
            }
            if (result2.size() == 0) {
                throw new DebuggerCommandException(String.format("Can't resolve address for line %s", sourceLine));
            }
            if (result2.size() > 1) {
                StringBuilder errMsg = new StringBuilder("Too many candidates found :\n");
                for (String string : result2) {
                    errMsg.append("\t").append(string).append("\n");
                }
                throw new DebuggerCommandException(errMsg.toString());
            }
            String address = (String)result2.get(0);
            return this.doJumpToAddress(thread, address);
        });
        if (stopPlace == null) {
            GDBDriver.$$$reportNull$$$0(68);
        }
        return stopPlace;
    }

    @Override
    @NotNull
    public DebuggerDriver.StopPlace jumpToAddress(@NotNull LLThread thread, @NotNull Address address, boolean canLeaveFunction) throws ExecutionException, DebuggerCommandException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(69);
        }
        if (address == null) {
            GDBDriver.$$$reportNull$$$0(70);
        }
        DebuggerDriver.StopPlace stopPlace = this.executeCommand(() -> this.doJumpToAddress(thread, address.toString()));
        if (stopPlace == null) {
            GDBDriver.$$$reportNull$$$0(71);
        }
        return stopPlace;
    }

    @NotNull
    private DebuggerDriver.StopPlace doJumpToAddress(@NotNull LLThread thread, @NotNull String value) throws ExecutionException, DebuggerCommandException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(72);
        }
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(73);
        }
        this.sendRequestAndWaitForDone("-gdb-set $pc=%s", value);
        DebuggerDriver.ResultList<LLFrame> frames = this.doGetFrames(thread.getId(), 0, 1, false);
        return new DebuggerDriver.StopPlace(thread, (LLFrame)frames.list.get(0));
    }

    @Override
    public void addPathMapping(int index, @NotNull String from, @NotNull String to) throws ExecutionException {
        if (from == null) {
            GDBDriver.$$$reportNull$$$0(74);
        }
        if (to == null) {
            GDBDriver.$$$reportNull$$$0(75);
        }
        DebuggerDriver.PathMapping pathMapping = new DebuggerDriver.PathMapping(from, to);
        List<DebuggerDriver.PathMapping> list = Collections.singletonList(pathMapping);
        this.executeCommandNoUserException(() -> this.doAddPathMapping(list));
    }

    @Override
    public void addForcedFileMapping(int index, @NotNull String from, @Nullable DebuggerSourceFileHash hash, @NotNull String to) throws ExecutionException {
        if (from == null) {
            GDBDriver.$$$reportNull$$$0(76);
        }
        if (to == null) {
            GDBDriver.$$$reportNull$$$0(77);
        }
        this.addPathMapping(index, from, to);
    }

    private boolean abort() throws ExecutionException {
        return this.executeCommandNoUserException(() -> {
            DebuggerDriver.TargetState state = this.getState();
            if (state == DebuggerDriver.TargetState.NOT_READY || state == DebuggerDriver.TargetState.FINISHED) {
                return false;
            }
            this.doInterruptAndWait();
            try {
                this.sendSilentRequest("kill", new Object[0]).waitFor(GDBResponse.ResultRecord.Type.done);
            }
            catch (GDBCommandException e) {
                if ("The program is not being run.".equals(e.getMessage())) {
                    return false;
                }
                throw e;
            }
            return true;
        });
    }

    @Override
    protected boolean doExit() throws ExecutionException {
        return this.executeCommandNoUserException(() -> {
            boolean sendGdbExit;
            boolean bl = sendGdbExit = !this.isInPromptMode();
            if (sendGdbExit) {
                try {
                    this.doInterruptAndWait(true);
                }
                catch (ExecutionFinishedException executionFinishedException) {
                    // empty catch block
                }
                this.buildRequest("-gdb-exit", new Object[0]).tearDownRequest(true).send();
            }
            return sendGdbExit;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LLWatchpoint addWatchpoint(long threadId, int frameIndex, @NotNull LLValue value, @NotNull String expr, @Nullable LLWatchpoint.Lifetime lifetime, @NotNull LLWatchpoint.AccessType accessType) throws ExecutionException, DebuggerCommandException {
        void accessType2;
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(78);
        }
        if (expr == null) {
            GDBDriver.$$$reportNull$$$0(79);
        }
        if (accessType == null) {
            GDBDriver.$$$reportNull$$$0(80);
        }
        LLWatchpoint lLWatchpoint = this.executeCommand(() -> this.lambda$addWatchpoint$30(threadId, frameIndex, lifetime, expr, (LLWatchpoint.AccessType)accessType2));
        if (lLWatchpoint == null) {
            GDBDriver.$$$reportNull$$$0(81);
        }
        return lLWatchpoint;
    }

    @NotNull
    private String doGetWatchpointExpression(long threadId, int frameIndex, LLWatchpoint.Lifetime lifetime, String expression) throws ExecutionException, DebuggerCommandException {
        if (lifetime == LLWatchpoint.Lifetime.PERSISTENT) {
            LLValue evaluated = this.doEvaluate(threadId, frameIndex, "&(" + (String)expression + ")", null);
            String value = GDBDriver.doLoadVariable((LLValue)evaluated).data.getValue();
            if (value.isEmpty()) {
                throw new DebuggerCommandException(CANNOT_SET_WATCHPOINT_FOR_EXPRESSION);
            }
            expression = "*" + value;
        }
        String string = expression;
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(82);
        }
        return string;
    }

    private static LLWatchpoint readWatchpoint(GDBTuple resultList, LLWatchpoint.AccessType accessType) throws ExecutionException {
        GDBTuple tuple = resultList.getRequiredTuple(accessType.getTupleKey());
        return new LLWatchpoint(tuple.getRequiredInt("number"), tuple.getRequiredString("exp"));
    }

    @Override
    @NotNull
    public LLBreakpoint addBreakpoint(@NotNull String path, int line, @Nullable String condition, boolean ignoreSourceHash) throws ExecutionException, DebuggerCommandException {
        if (path == null) {
            GDBDriver.$$$reportNull$$$0(83);
        }
        LLBreakpoint lLBreakpoint = this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                LLBreakpoint lLBreakpoint = this.doInsertBreakpoint(GDBDriver.atSourceLine(this.toEnvPath(path), line), condition);
                return lLBreakpoint;
            }
            finally {
                if (interrupted) {
                    this.doResume(true);
                }
            }
        });
        if (lLBreakpoint == null) {
            GDBDriver.$$$reportNull$$$0(84);
        }
        return lLBreakpoint;
    }

    @Override
    @NotNull
    public LLBreakpoint addAddressBreakpoint(@NotNull Address address, @Nullable String condition) throws ExecutionException, DebuggerCommandException {
        if (address == null) {
            GDBDriver.$$$reportNull$$$0(85);
        }
        LLBreakpoint lLBreakpoint = this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                LLBreakpoint lLBreakpoint = this.doInsertAddressBreakpoint(address, condition);
                return lLBreakpoint;
            }
            finally {
                if (interrupted) {
                    this.doResume(true);
                }
            }
        });
        if (lLBreakpoint == null) {
            GDBDriver.$$$reportNull$$$0(86);
        }
        return lLBreakpoint;
    }

    public String interruptAndExecuteConsole(@NotNull String command) throws ExecutionException, DebuggerCommandException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(87);
        }
        return this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                String miCommand = GDBDriver.createConsoleCommand(command);
                String string = this.sendSilentRequestAndWaitForDone("%s", miCommand).getOutput();
                return string;
            }
            finally {
                if (interrupted) {
                    this.doResume(true);
                }
            }
        });
    }

    @NotNull
    private LLBreakpoint doInsertBreakpoint(@NotNull String location, @Nullable String condition) throws ExecutionException, DebuggerCommandException {
        if (location == null) {
            GDBDriver.$$$reportNull$$$0(88);
        }
        GDBTuple resultList = this.doGdbBreakInsert(location, condition, false);
        return GDBDriver.readBreakpoint(resultList);
    }

    @NotNull
    private LLBreakpoint doInsertAddressBreakpoint(@NotNull Address address, @Nullable String condition) throws ExecutionException, DebuggerCommandException {
        if (address == null) {
            GDBDriver.$$$reportNull$$$0(89);
        }
        GDBTuple resultList = this.sendRequestAndWaitForDone("-break-insert %s *%s", GDBDriver.withCondition(condition), address.toString()).getResultList();
        return GDBDriver.readBreakpoint(resultList);
    }

    @NotNull
    private GDBTuple doGdbBreakInsert(@NotNull String location, @Nullable String condition, boolean temporary) throws ExecutionException, GDBCommandException {
        if (location == null) {
            GDBDriver.$$$reportNull$$$0(90);
        }
        GDBTuple gDBTuple = this.sendRequestAndWaitForDone("-break-insert -f %s %s %s", temporary ? "-t" : "", GDBDriver.withCondition(condition), location).getResultList();
        if (gDBTuple == null) {
            GDBDriver.$$$reportNull$$$0(91);
        }
        return gDBTuple;
    }

    @Override
    @NotNull
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull DebuggerDriver.SymbolicBreakpoint symBreakpoint) throws ExecutionException, DebuggerCommandException {
        if (symBreakpoint == null) {
            GDBDriver.$$$reportNull$$$0(92);
        }
        LLSymbolicBreakpoint lLSymbolicBreakpoint = this.executeCommand(() -> this.doInsertSymbolicBreakpoint(symBreakpoint.getPattern(), symBreakpoint.getCondition(), false));
        if (lLSymbolicBreakpoint == null) {
            GDBDriver.$$$reportNull$$$0(93);
        }
        return lLSymbolicBreakpoint;
    }

    @NotNull
    private LLSymbolicBreakpoint doInsertSymbolicBreakpoint(@NotNull String function, @Nullable String condition, boolean temporary) throws ExecutionException, DebuggerCommandException {
        if (function == null) {
            GDBDriver.$$$reportNull$$$0(94);
        }
        GDBTuple bkpt = this.doGdbBreakInsert(GDBDriver.atFunction(function), condition, temporary).getRequiredTuple("bkpt");
        int number = bkpt.getRequiredInt("number");
        return new LLSymbolicBreakpoint(number);
    }

    @Override
    public void removeCodepoints(@NotNull Collection<Integer> ids) throws ExecutionException, DebuggerCommandException {
        if (ids == null) {
            GDBDriver.$$$reportNull$$$0(95);
        }
        this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                for (Integer each : ids) {
                    this.sendRequestAndWaitForDone("-break-delete %d", each);
                }
            }
            finally {
                if (interrupted) {
                    this.doResume(true);
                }
            }
        });
    }

    @Nullable
    private static LLBreakpointLocation readBreakpointLocation(@NotNull GDBTuple info, @NotNull String id) {
        Address address;
        if (info == null) {
            GDBDriver.$$$reportNull$$$0(96);
        }
        if (id == null) {
            GDBDriver.$$$reportNull$$$0(97);
        }
        String addr = info.getString("addr");
        boolean pending = "<PENDING>".equals(addr);
        GDBTuple.Location location = info.getLocation("fullname", "line");
        if (location == null && pending) {
            location = info.getLocation("pending");
        }
        if ((address = info.getAddressLocation("addr")) == null) {
            return null;
        }
        if (location != null) {
            return new LLBreakpointLocation(id, location.path, location.line, address);
        }
        return new LLBreakpointLocation(id, address);
    }

    @NotNull
    private static LLBreakpoint readBreakpoint(@NotNull GDBTuple info) throws ExecutionException, DebuggerCommandException {
        Object locations;
        boolean multipleLocations;
        if (info == null) {
            GDBDriver.$$$reportNull$$$0(98);
        }
        Pair<GDBTuple, List<GDBTuple>> breakpointWithLocations = info.getWithSuccessors("bkpt", GDBTuple.class);
        GDBTuple breakpointTuple = (GDBTuple)breakpointWithLocations.first;
        List multipleLocationTuples = (List)breakpointWithLocations.second;
        if (breakpointTuple == null) {
            throw new DebuggerCommandException("No code at this line");
        }
        int number = breakpointTuple.getRequiredInt("number");
        String addr = breakpointTuple.getString("addr");
        boolean bl = multipleLocations = "<MULTIPLE>".equals(addr) && !multipleLocationTuples.isEmpty();
        if (multipleLocations) {
            locations = new SmartList();
            for (GDBTuple locTuple : multipleLocationTuples) {
                String locId;
                LLBreakpointLocation location = GDBDriver.readBreakpointLocation(locTuple, locId = locTuple.getRequiredString("number"));
                if (location == null) continue;
                locations.add(location);
            }
        } else {
            String locId = number + ".1";
            LLBreakpointLocation location = GDBDriver.readBreakpointLocation(breakpointTuple, locId);
            locations = location != null ? Collections.singletonList(location) : Collections.emptyList();
        }
        GDBTuple.Location originalLocation = breakpointTuple.getLocation("original-location");
        String origFilePath = originalLocation != null ? originalLocation.path : "<address>";
        int origLine = originalLocation != null ? originalLocation.line : 0;
        String condition = breakpointTuple.getString("cond");
        return new LLBreakpoint(number, origFilePath, origLine, (List<LLBreakpointLocation>)locations, condition);
    }

    @NotNull
    private DebuggerDriver.StopPlace doReadStopPlace(@NotNull GDBTuple stopTuple) throws ExecutionException {
        if (stopTuple == null) {
            GDBDriver.$$$reportNull$$$0(99);
        }
        long threadId = stopTuple.getRequiredInt("thread-id");
        LLThread thread = new LLThread(threadId, "STOPPED", null);
        GDBTuple frameTuple = stopTuple.getRequiredTupleOrThrow("frame", () -> new ExecutionException(GDBBundle.message("error.cannot.read.stop.place", stopTuple)));
        LLFrame frame = this.doReadFrame(0, frameTuple);
        return new DebuggerDriver.StopPlace(thread, frame);
    }

    @NotNull
    private CompletableFuture<DebuggerDriver.StopPlace> doReadStopPlaceAsync(@NotNull GDBTuple stopTuple) {
        if (stopTuple == null) {
            GDBDriver.$$$reportNull$$$0(100);
        }
        CompletableFuture<DebuggerDriver.StopPlace> completableFuture = this.myThreadFrameInfoDriverDelegate.doReadStopPlaceAsync(this.myBridge, stopTuple);
        if (completableFuture == null) {
            GDBDriver.$$$reportNull$$$0(101);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public List<LLThread> getThreads() throws ExecutionException, DebuggerCommandException {
        List<LLThread> list = this.myThreadFrameInfoDriverDelegate.getThreads(this.myBridge);
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(102);
        }
        return list;
    }

    @NotNull
    private List<LLThread> doGetThreads() throws ExecutionException, DebuggerCommandException {
        Response response = this.sendRequestAndWaitForDone("-thread-info", new Object[0]);
        GDBTuple threads = response.getResultList().getRequiredTuple("threads");
        ArrayList<LLThread> result2 = new ArrayList<LLThread>(threads.size());
        for (GDBTuple each : threads) {
            int id = each.getRequiredInt("id");
            String name = each.getString("name");
            @NonNls String state = each.getRequiredString("state");
            result2.add(new LLThread(id, StringUtil.toUpperCase((String)state), null, name));
        }
        result2.sort(Comparator.comparingLong(LLThread::getId));
        ArrayList<LLThread> arrayList = result2;
        if (arrayList == null) {
            GDBDriver.$$$reportNull$$$0(103);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLFrame> getFrames(@NotNull LLThread thread, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(104);
        }
        DebuggerDriver.ResultList<LLFrame> resultList = this.myThreadFrameInfoDriverDelegate.getFrames(this.myBridge, thread, from, count, untilFirstLineWithCode);
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(105);
        }
        return resultList;
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLFrame> getFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        DebuggerDriver.ResultList resultList = this.executeCommand(() -> this.doGetFrames(threadId, from, count, untilFirstLineWithCode));
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(106);
        }
        return resultList;
    }

    @NotNull
    private DebuggerDriver.ResultList<LLFrame> doGetFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws ExecutionException, DebuggerCommandException {
        Response response = this.sendRequest("-stack-list-frames --thread %d %d %d", threadId, from, from + count).waitFor(new GDBResponse.ResultRecord.Type[0]);
        GDBTuple stack = response.getResultList().getTuple("stack");
        List<GDBTuple> frames = stack == null ? null : stack.getAll("frame", GDBTuple.class);
        String msg = response.getGDBErrorMessage();
        if (frames == null) {
            if (msg != null && msg.contains(" Not enough frames in stack")) {
                DebuggerDriver.ResultList<LLFrame> resultList = DebuggerDriver.ResultList.empty();
                if (resultList == null) {
                    GDBDriver.$$$reportNull$$$0(107);
                }
                return resultList;
            }
            throw new DebuggerCommandException(msg != null ? msg : "Cannot collect frames");
        }
        if (msg != null) {
            this.warnUser(msg);
        }
        ArrayList<LLFrame> result2 = new ArrayList<LLFrame>(frames.size());
        for (int i = 0; i < Math.min(frames.size(), count); ++i) {
            GDBTuple each = frames.get(i);
            LLFrame frame = this.doReadFrame(each.getRequiredInt("level"), each);
            result2.add(frame);
            if (untilFirstLineWithCode && frame.getLine() != -1) break;
        }
        boolean hasMore = result2.size() < frames.size();
        DebuggerDriver.ResultList<LLFrame> resultList = DebuggerDriver.ResultList.create(result2, hasMore);
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(108);
        }
        return resultList;
    }

    @NotNull
    private LLFrame doReadFrame(int level, @NotNull GDBTuple frameTuple) {
        if (frameTuple == null) {
            GDBDriver.$$$reportNull$$$0(109);
        }
        String func = frameTuple.getString("func");
        String addrStr = frameTuple.getString("addr");
        String fullname = frameTuple.getString("fullname");
        String file = this.myStarter.convertToLocalPath(fullname != null ? fullname : frameTuple.getString("file"));
        int line = -1;
        if (file != null) {
            line = frameTuple.getInt("line", 0) - 1;
        }
        Address addr = Address.NULL;
        if (addrStr != null) {
            try {
                addr = GDBDriver.parseAddress(addrStr);
            }
            catch (ExecutionException e) {
                CidrDebuggerLog.LOG.warn((Throwable)e);
            }
        }
        return new LLFrame(level, "??".equals(func) ? null : func, file, null, line, addr, null, false);
    }

    private boolean isIndirectSymbolFrame(@NotNull LLFrame frame) {
        LongSet indirectSymbols;
        if (frame == null) {
            GDBDriver.$$$reportNull$$$0(110);
        }
        if ((indirectSymbols = this.myIndirectSymbols) == null) {
            return false;
        }
        return !frame.hasDebugInfo() && !frame.hasSymbolInfo() && indirectSymbols.contains(frame.getProgramCounter().unsignedLongValue());
    }

    @Override
    @NotNull
    public List<LLValue> getVariables(@NotNull LLThread thread, @NotNull LLFrame frame) throws ExecutionException, DebuggerCommandException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(111);
        }
        if (frame == null) {
            GDBDriver.$$$reportNull$$$0(112);
        }
        List<LLValue> list = this.myThreadFrameInfoDriverDelegate.getVariables(this.myBridge, thread, frame);
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(113);
        }
        return list;
    }

    @Override
    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        List list = (List)this.executeCommand(() -> this.doGetFrameVariables(threadId, frameIndex));
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(114);
        }
        return list;
    }

    @NotNull
    private String doGetFrameAddr(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        Response response = this.sendRequestAndWaitForDone("-data-evaluate-expression %s $fp", GDBDriver.onThreadAndFrame(threadId, frameIndex));
        String string = response.getResultList().getRequiredStringOrThrow("value", () -> new ExecutionException(GDBBundle.message("error.cannot.evaluate.frame.address.for.thread.frame", threadId, frameIndex)));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(115);
        }
        return string;
    }

    @NotNull
    private List<LLValue> doGetFrameVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        SmartList result2 = new SmartList();
        String frameAddress = null;
        for (String varName : this.doListFrameVariables(threadId, frameIndex)) {
            Pair<Boolean, String> typePair = this.doGetExpressionType(varName, threadId, frameIndex);
            LLValue llValue = new LLValue(varName.isEmpty() ? "<unknown>" : varName, (String)typePair.second, null, null, varName);
            if (((Boolean)typePair.first).booleanValue()) {
                if (frameAddress == null) {
                    frameAddress = this.doGetFrameAddr(threadId, frameIndex);
                }
                String fvKey = GDBDriver.makeFVKey(frameAddress, varName);
                FrameValueLoader loader = new FrameValueLoader(fvKey, threadId, frameIndex);
                llValue.putUserData(LLVALUE_DATA_LOADER, loader);
            } else {
                GDBDriver.doUpdateLoadedData(llValue, EMPTY_LOADED_VALUE);
            }
            result2.add(llValue);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            GDBDriver.$$$reportNull$$$0(116);
        }
        return smartList;
    }

    @Override
    @NotNull
    public LLValueData getData(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(117);
        }
        LLValueData lLValueData = this.myThreadFrameInfoDriverDelegate.getData(this.myBridge, value);
        if (lLValueData == null) {
            GDBDriver.$$$reportNull$$$0(118);
        }
        return lLValueData;
    }

    @Override
    @Nullable
    public String getDescription(@NotNull LLValue value, int maxLength) throws ExecutionException, DebuggerCommandException {
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(119);
        }
        return (String)this.executeCommand(() -> {
            Response response;
            boolean lengthChanged;
            String id = GDBDriver.doLoadVariable((LLValue)value).id;
            boolean bl = lengthChanged = maxLength != 250;
            if (lengthChanged) {
                this.doSetMaxDescription(false);
            }
            try {
                if (lengthChanged) {
                    this.sendRequestAndWaitForDone("-var-update --no-values %s", GDBDriver.stringify(id));
                }
                response = this.sendRequestAndWaitForDone("-var-evaluate-expression %s", GDBDriver.stringify(id));
            }
            finally {
                if (lengthChanged) {
                    this.doSetMaxDescription(true);
                }
            }
            return (String)GDBDriver.getDescriptionFromValue((String)response.getResultList().getRequiredString((String)"value")).second;
        });
    }

    @TestOnly
    @NotNull
    public String getVariableID(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(120);
        }
        String string = (String)this.executeCommand(() -> GDBDriver.doLoadVariable((LLValue)value).id);
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(121);
        }
        return string;
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLValue> getVariableChildren(@NotNull LLValue value, int from, int count) throws ExecutionException, DebuggerCommandException {
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(122);
        }
        DebuggerDriver.ResultList<LLValue> resultList = this.myThreadFrameInfoDriverDelegate.getVariableChildren(this.myBridge, value, from, count);
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(123);
        }
        return resultList;
    }

    @NotNull
    private DebuggerDriver.ResultList<LLValue> doGetVariableChildren(final @NotNull LLValue var, final int offset, final int count) throws ExecutionException, DebuggerCommandException {
        if (var == null) {
            GDBDriver.$$$reportNull$$$0(124);
        }
        LLValueLoadedData data = GDBDriver.doLoadVariable(var);
        MapElement mapElement = (MapElement)var.getUserData(LLVALUE_MAP_ELEMENT);
        if (mapElement != null) {
            int endOffset = offset + count;
            List<LLValue> all = Arrays.asList(mapElement.getKey(), mapElement.getValue());
            List<LLValue> list = all.subList(Math.min(offset, 2), Math.min(endOffset, 2));
            boolean hasMore = endOffset < 2;
            DebuggerDriver.ResultList<LLValue> resultList = DebuggerDriver.ResultList.create(list, hasMore);
            if (resultList == null) {
                GDBDriver.$$$reportNull$$$0(125);
            }
            return resultList;
        }
        if (data.isMap) {
            return this.doGetMapChildren(var, offset, count);
        }
        final ArrayList result2 = new ArrayList();
        boolean readAsStruct = this.doVisitCppClassChildren(var, new StructChildrenVisitor(){
            int currentOffset;
            int restCount;
            {
                this.currentOffset = offset;
                this.restCount = count;
            }

            @Override
            public boolean visitRealChild(@NotNull GDBTuple child) {
                if (child == null) {
                    12.$$$reportNull$$$0(0);
                }
                if (this.currentOffset >= 1) {
                    --this.currentOffset;
                    return true;
                }
                result2.add(GDBDriver.this.doReadVariable(child, var.getReferenceExpression(), null));
                --this.restCount;
                this.currentOffset = Math.max(0, this.currentOffset - 1);
                return this.restCount != 0;
            }

            @Override
            public boolean visitFakeChild(@NotNull LLValue fakeChild, int childrenCount) throws ExecutionException, DebuggerCommandException {
                if (fakeChild == null) {
                    12.$$$reportNull$$$0(1);
                }
                if (this.currentOffset >= childrenCount) {
                    this.currentOffset -= childrenCount;
                    return true;
                }
                int innerEndPos = Math.min(this.currentOffset + this.restCount, childrenCount);
                result2.addAll(GDBDriver.this.doGetPlainVariableChildren((LLValue)fakeChild, (int)this.currentOffset, (int)innerEndPos).list);
                this.restCount -= innerEndPos - this.currentOffset;
                this.currentOffset = 0;
                return this.restCount != 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "child";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fakeChild";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$12";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRealChild";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFakeChild";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (readAsStruct) {
            int childrenCount = this.doGetChildrenCount(var);
            boolean hasMore = offset + result2.size() < childrenCount;
            DebuggerDriver.ResultList<LLValue> resultList = DebuggerDriver.ResultList.create(result2, hasMore);
            if (resultList == null) {
                GDBDriver.$$$reportNull$$$0(126);
            }
            return resultList;
        }
        return this.doGetPlainVariableChildren(var, offset, offset + count);
    }

    @NotNull
    private DebuggerDriver.ResultList<LLValue> doGetPlainVariableChildren(@NotNull LLValue var, int offset, int endPos) throws ExecutionException, DebuggerCommandException {
        if (var == null) {
            GDBDriver.$$$reportNull$$$0(127);
        }
        if (offset > endPos) {
            throw new ExecutionException(GDBBundle.message("error.incorrect.children.range.from.to", offset, endPos));
        }
        Pair<GDBTuple, Boolean> childList = this.doListChildren(var, offset, endPos);
        ArrayList<LLValue> result2 = new ArrayList<LLValue>();
        boolean hasMore = (Boolean)childList.second;
        for (Object o : (GDBTuple)childList.first) {
            GDBTuple each = GDBDriver.getChildTuple((GDBTuple)childList.first, o);
            if (each == null) {
                hasMore = false;
                break;
            }
            result2.add(this.doReadVariable(each, var.getReferenceExpression(), null));
        }
        DebuggerDriver.ResultList<LLValue> resultList = DebuggerDriver.ResultList.create(result2, hasMore);
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(128);
        }
        return resultList;
    }

    @NotNull
    private Pair<GDBTuple, Boolean> doListChildren(@NotNull LLValue var, int offset, int endPos) throws ExecutionException, DebuggerCommandException {
        LLValueLoadedData loaded;
        if (var == null) {
            GDBDriver.$$$reportNull$$$0(129);
        }
        if (!(loaded = GDBDriver.doLoadVariable(var)).mayHaveChildren()) {
            Pair pair = Pair.create((Object)new GDBTuple(), (Object)false);
            if (pair == null) {
                GDBDriver.$$$reportNull$$$0(130);
            }
            return pair;
        }
        String id = loaded.id;
        String listChildrenArg = Registry.is((String)"cidr.debugger.gdb.listChildrenWithoutValues", (boolean)false) ? "--no-values" : "--all-values";
        Response response = this.sendRequestAndWaitForDone("-var-list-children %s %s %d %d", listChildrenArg, GDBDriver.stringify(id), offset, endPos);
        GDBTuple resultList = response.getResultList();
        GDBTuple children = resultList.getTupleOrEmpty("children");
        boolean hasMore = resultList.getBoolean("has_more");
        if (hasMore) {
            this.sendRequestAndWaitForDone("-var-set-update-range %s 0 %d", GDBDriver.stringify(id), endPos);
        }
        Pair pair = Pair.create((Object)children, (Object)hasMore);
        if (pair == null) {
            GDBDriver.$$$reportNull$$$0(131);
        }
        return pair;
    }

    private boolean doVisitCppClassChildren(@NotNull LLValue var, @NotNull StructChildrenVisitor visitor) throws ExecutionException, DebuggerCommandException {
        Object o;
        GDBTuple each;
        Integer childrenCount;
        if (var == null) {
            GDBDriver.$$$reportNull$$$0(132);
        }
        if (visitor == null) {
            GDBDriver.$$$reportNull$$$0(133);
        }
        if ((childrenCount = GDBDriver.doLoadVariable((LLValue)var).childrenCount) == null) {
            return false;
        }
        if (childrenCount == 0) {
            return true;
        }
        if (childrenCount > 10) {
            return false;
        }
        GDBTuple children = (GDBTuple)var.getUserData(LLVALUE_CLASS_CHILDREN_CACHE);
        if (children == null) {
            children = (GDBTuple)this.doListChildren((LLValue)var, (int)-1, (int)-1).first;
            var.putUserData(LLVALUE_CLASS_CHILDREN_CACHE, children);
        }
        Iterator iterator2 = children.iterator();
        while (iterator2.hasNext() && (each = GDBDriver.getChildTuple(children, o = iterator2.next())) != null) {
            if (each.getString("type") != null) {
                if (visitor.visitRealChild(each)) continue;
                break;
            }
            String name = each.getRequiredStringOrThrow("name", msg -> new ExecutionException(GDBBundle.message("error.unexpected.gdb.fake.variable", msg)));
            LLValue fakeValue = new LLValue("", "", null, null, name);
            int numchild = each.getInt("numchild", 0);
            GDBDriver.doUpdateLoadedData(fakeValue, new LLValueLoadedData(name, null, numchild, false, false, "", null));
            if (visitor.visitFakeChild(fakeValue, numchild)) continue;
            break;
        }
        return true;
    }

    @NotNull
    private DebuggerDriver.ResultList<LLValue> doGetMapChildren(LLValue var, int offset, int count) throws ExecutionException, DebuggerCommandException {
        Pair<GDBTuple, Boolean> childList = this.doListChildren(var, offset * 2, (offset + count) * 2);
        ArrayList<LLValue> result2 = new ArrayList<LLValue>();
        boolean hasMore = (Boolean)childList.second;
        int size = ((GDBTuple)childList.first).size();
        for (int i = 0; i < size - 1; i += 2) {
            GDBTuple keyTuple = GDBDriver.getChildTuple((GDBTuple)childList.first, ((GDBTuple)childList.first).get(i));
            GDBTuple valueTuple = GDBDriver.getChildTuple((GDBTuple)childList.first, ((GDBTuple)childList.first).get(i + 1));
            if (keyTuple == null || valueTuple == null) {
                hasMore = false;
                break;
            }
            LLValue key = this.doReadVariable(keyTuple, var.getReferenceExpression(), "first");
            LLValue value = this.doReadVariable(valueTuple, var.getReferenceExpression(), "second");
            LLValue element = new LLValue("[" + (offset + i / 2) + "]", "std::pair<" + key.getType() + ", " + value.getType() + ">", null, null, value.getReferenceExpression());
            element.putUserData(LLVALUE_DATA, new LLValueLoadedData("<map element>", null, 2, false, false, "", null));
            element.putUserData(LLVALUE_MAP_ELEMENT, new MapElement(key, value));
            result2.add(element);
        }
        DebuggerDriver.ResultList<LLValue> resultList = DebuggerDriver.ResultList.create(result2, hasMore);
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(134);
        }
        return resultList;
    }

    @Nullable
    private static GDBTuple getChildTuple(GDBTuple varObjList, Object o) throws ExecutionException {
        if (!(o instanceof Pair)) {
            throw new ExecutionException(GDBBundle.message("error.invalid.object.in.list", varObjList));
        }
        Pair p = (Pair)o;
        if (!"child".equals(p.first)) {
            throw new ExecutionException(GDBBundle.message("error.pair.first.required.to.be.child", p));
        }
        GDBTuple result2 = (GDBTuple)p.second;
        String name = result2.getString("name");
        return name != null && name.matches(".*\\.<error at.*") ? null : result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    private GDBResponse.Record doCreateVar(@NotNull String expression, long threadId, int n) throws ExecutionException, DebuggerCommandException {
        Response response;
        block13: {
            void frameIndex;
            if (expression == null) {
                GDBDriver.$$$reportNull$$$0(135);
            }
            String varId = GDBDriver.format("var%d_%s", this.allocatedVariables.size() + 1, NON_ID_PATTERN.matcher(expression).replaceAll(""));
            this.allocatedVariables.add(varId);
            String command = GDBDriver.createMI2Command(GDBDriver.format("-var-create %s * %s", varId, GDBDriver.stringify(GDBDriver.escapeVariadicArgIfNeeded(expression))), threadId, (int)frameIndex);
            GDBCommandException err = null;
            response = null;
            try {
                response = this.sendRequestAndWaitForDone("%s", command);
            }
            catch (GDBCommandException e) {
                err = e;
            }
            if (response == null || response.getReceivedSignalCount() != 0) {
                try {
                    this.sendRequestAndWaitForDone("-var-set-frozen %s 1", GDBDriver.stringify(varId));
                }
                catch (GDBCommandException e) {
                    if (!"Variable object not found".equals(e.getResponse().getGDBErrorMessage())) {
                        if (err != null) {
                            err.addSuppressed(e);
                        }
                    }
                }
                finally {
                    if (err == null) break block13;
                    throw err;
                }
            }
        }
        GDBResponse.Record record = response.getRecord();
        if (record == null) {
            GDBDriver.$$$reportNull$$$0(136);
        }
        return record;
    }

    @NotNull
    private LLValue doReadVariable(@NotNull GDBTuple varTuple, @NotNull String parentRef, @Nullable String displayName) {
        if (varTuple == null) {
            GDBDriver.$$$reportNull$$$0(137);
        }
        if (parentRef == null) {
            GDBDriver.$$$reportNull$$$0(138);
        }
        String name = varTuple.getString("name");
        String type = varTuple.getString("type");
        boolean invalid = name == null || type == null;
        name = StringUtil.notNullize((String)name, (String)"<unknown>");
        type = StringUtil.notNullize((String)type, (String)"<unknown>");
        String id = name;
        String value = varTuple.getString("value");
        String displayHint = varTuple.getString("displayhint");
        String exp = varTuple.getString("exp");
        if (exp != null) {
            String childName = StringUtil.substringAfterLast((String)name, (String)".");
            boolean isAnonymous = childName != null && childName.endsWith("_anonymous") && StringUtil.parseInt((String)StringUtil.trimEnd((String)childName, (String)"_anonymous"), (int)-1) != -1;
            name = isAnonymous ? "" : exp;
        }
        LLValue result2 = new LLValue(displayName != null ? displayName : name, GDBDriver.fixType(type), null, null, (String)(parentRef.isEmpty() ? name : parentRef + "." + name));
        if (invalid) {
            GDBDriver.doUpdateLoadedData(result2, new LLValueLoadedData("", null, 0, false, false, StringUtil.notNullize((String)value), displayHint));
        } else {
            LLValueLoadedData data = GDBDriver.doReadLoadedData(varTuple, id, null, StringUtil.notNullize((String)value));
            if (value == null) {
                result2.putUserData(LLVALUE_DATA_LOADER, new CreatedValueLoader(data));
            } else {
                GDBDriver.doUpdateLoadedData(result2, data);
            }
        }
        LLValue lLValue = result2;
        if (lLValue == null) {
            GDBDriver.$$$reportNull$$$0(139);
        }
        return lLValue;
    }

    @NotNull
    private static LLValueLoadedData doLoadVariable(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
        LLValueLoadedData data;
        LLValueLoader loader;
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(140);
        }
        if ((loader = (LLValueLoader)value.getUserData(LLVALUE_DATA_LOADER)) != null) {
            loader.loadValue(value);
            value.putUserData(LLVALUE_DATA_LOADER, null);
        }
        if ((data = (LLValueLoadedData)value.getUserData(LLVALUE_DATA)) == null) {
            throw new ExecutionException(GDBBundle.message("error.variable.not.initialized", new Object[]{value}));
        }
        LLValueLoadedData lLValueLoadedData = data;
        if (lLValueLoadedData == null) {
            GDBDriver.$$$reportNull$$$0(141);
        }
        return lLValueLoadedData;
    }

    @NotNull
    private static LLValueLoadedData doReadLoadedData(@NotNull GDBTuple varTuple, @NotNull String id, @Nullable String fvKey, @NotNull String value) {
        if (varTuple == null) {
            GDBDriver.$$$reportNull$$$0(142);
        }
        if (id == null) {
            GDBDriver.$$$reportNull$$$0(143);
        }
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(144);
        }
        Integer childrenCount = null;
        boolean isDynamic = varTuple.getBoolean("dynamic");
        boolean hasDynamicChildren = false;
        if (isDynamic) {
            hasDynamicChildren = varTuple.getBoolean("has_more", true);
        } else {
            childrenCount = varTuple.getInt("numchild", 0);
        }
        String displayHint = varTuple.getString("displayhint");
        return new LLValueLoadedData(id, fvKey, childrenCount, isDynamic, hasDynamicChildren, value, displayHint);
    }

    private static void doUpdateLoadedData(@NotNull LLValue var, @NotNull LLValueLoadedData data) {
        if (var == null) {
            GDBDriver.$$$reportNull$$$0(145);
        }
        if (data == null) {
            GDBDriver.$$$reportNull$$$0(146);
        }
        var.putUserData(LLVALUE_DATA, data);
    }

    @Override
    @Nullable
    public Integer getChildrenCount(@NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
        if (var == null) {
            GDBDriver.$$$reportNull$$$0(147);
        }
        return (Integer)this.executeCommand(() -> this.doGetChildrenCount(var));
    }

    @Nullable
    private Integer doGetChildrenCount(LLValue var) throws ExecutionException, DebuggerCommandException {
        LLValueLoadedData data = GDBDriver.doLoadVariable(var);
        Integer nullableChildrenCount = data.childrenCount;
        if (nullableChildrenCount == null) {
            return null;
        }
        MapElement mapElement = (MapElement)var.getUserData(LLVALUE_MAP_ELEMENT);
        if (mapElement != null) {
            return nullableChildrenCount;
        }
        Integer classChildrenCountCache = (Integer)var.getUserData(LLVALUE_CLASS_CHILDREN_COUNT_CACHE);
        if (classChildrenCountCache != null) {
            return classChildrenCountCache;
        }
        final int[] childrenCount = new int[]{nullableChildrenCount};
        if (this.doVisitCppClassChildren(var, new StructChildrenVisitor(){

            @Override
            public boolean visitFakeChild(@NotNull LLValue fakeChild, int fakeChildrenCount) {
                if (fakeChild == null) {
                    13.$$$reportNull$$$0(0);
                }
                childrenCount[0] = childrenCount[0] - 1;
                childrenCount[0] = childrenCount[0] + fakeChildrenCount;
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeChild", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$13", "visitFakeChild"));
            }
        })) {
            var.putUserData(LLVALUE_CLASS_CHILDREN_COUNT_CACHE, childrenCount[0]);
        }
        return childrenCount[0];
    }

    private static String fixType(@Nullable String type) {
        return type == null ? null : type.replace("'", "");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LLValue evaluate(final long threadId, final int frameIndex, final @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage debuggerLanguage) throws ExecutionException, DebuggerCommandException {
        void language;
        if (expression == null) {
            GDBDriver.$$$reportNull$$$0(148);
        }
        final String debuggerLanguage2 = GDBDriver.convertLanguage((DebuggerDriver.DebuggerLanguage)language);
        LLValue lLValue = this.executeCommand(new EvaluationCommand<LLValue>(expression){

            @Override
            public LLValue call() throws ExecutionException, DebuggerCommandException {
                return GDBDriver.this.doEvaluate(threadId, frameIndex, expression, debuggerLanguage2);
            }
        });
        if (lLValue == null) {
            GDBDriver.$$$reportNull$$$0(149);
        }
        return lLValue;
    }

    @Override
    @NotNull
    public List<LLInstruction> disassembleFunction(@NotNull Address address, @NotNull AddressRange fallbackRange) throws ExecutionException, DebuggerCommandException {
        if (address == null) {
            GDBDriver.$$$reportNull$$$0(150);
        }
        if (fallbackRange == null) {
            GDBDriver.$$$reportNull$$$0(151);
        }
        List list = this.executeCommand(() -> this.doDisassembleFunction(address, fallbackRange));
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(152);
        }
        return list;
    }

    @Override
    @NotNull
    public List<LLInstruction> disassemble(@NotNull AddressRange range) throws ExecutionException, DebuggerCommandException {
        if (range == null) {
            GDBDriver.$$$reportNull$$$0(153);
        }
        List list = this.executeCommand(() -> this.doDisassembleRange(range));
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(154);
        }
        return list;
    }

    @NotNull
    protected ArrayList<LLInstruction> doDisassembleFunction(@NotNull Address address, @NotNull AddressRange fallbackRange) throws ExecutionException, DebuggerCommandException {
        if (address == null) {
            GDBDriver.$$$reportNull$$$0(155);
        }
        if (fallbackRange == null) {
            GDBDriver.$$$reportNull$$$0(156);
        }
        assert (fallbackRange.contains(address));
        Pair<Address, String> functionStart = this.doGetFunctionStart(address);
        if (functionStart == null) {
            ArrayList<LLInstruction> arrayList = this.doDisassembleRange(fallbackRange);
            if (arrayList == null) {
                GDBDriver.$$$reportNull$$$0(157);
            }
            return arrayList;
        }
        Address startAddress = (Address)functionStart.first;
        String functionName = (String)functionStart.second;
        if (address.minus(startAddress) > 65536L) {
            ArrayList<LLInstruction> arrayList = this.doDisassembleRange(fallbackRange);
            if (arrayList == null) {
                GDBDriver.$$$reportNull$$$0(158);
            }
            return arrayList;
        }
        Pair<Address, String> pastFunctionEnd = this.doGetFunctionStart(startAddress.plus(65536));
        if (pastFunctionEnd != null && ((Address)pastFunctionEnd.first).equals(startAddress)) {
            AddressRange startUntilFallbackEndRange = AddressUtil.addressRangeInclusive(startAddress, fallbackRange.getEndInclusive());
            ArrayList<LLInstruction> arrayList = this.doDisassembleRange(fallbackRange.intersectWith(startUntilFallbackEndRange));
            if (arrayList == null) {
                GDBDriver.$$$reportNull$$$0(159);
            }
            return arrayList;
        }
        return this.doDisassemble(startAddress.toString(), functionName);
    }

    @NotNull
    protected ArrayList<LLInstruction> doDisassembleRange(@NotNull AddressRange range) throws ExecutionException, DebuggerCommandException {
        if (range == null) {
            GDBDriver.$$$reportNull$$$0(160);
        }
        return this.doDisassemble(GDBDriver.format("%s,+%d", range.getStart(), range.getSize()), null);
    }

    @NotNull
    private ArrayList<LLInstruction> doDisassemble(@NotNull String disassembleAddressArg, @Nullable String functionName) throws ExecutionException, GDBCommandException {
        if (disassembleAddressArg == null) {
            GDBDriver.$$$reportNull$$$0(161);
        }
        Response response = this.sendSilentRequestAndWaitForDone("disassemble /r %s", disassembleAddressArg);
        String[] outputLines = StringUtil.splitByLines((String)response.getOutput(), (boolean)true);
        ArrayList<LLInstruction> result2 = new ArrayList<LLInstruction>(outputLines.length);
        for (String line : outputLines) {
            LLInstruction instruction;
            Matcher lineMatcher = INSTRUCTION_LINE.matcher(line);
            if (!lineMatcher.matches() || (instruction = GDBDriver.parseInstruction(functionName, lineMatcher.group(1), lineMatcher.group(2), lineMatcher.group(3), lineMatcher.group(4))) == null) continue;
            result2.add(instruction);
        }
        ArrayList<LLInstruction> arrayList = result2;
        if (arrayList == null) {
            GDBDriver.$$$reportNull$$$0(162);
        }
        return arrayList;
    }

    @Nullable
    protected static LLInstruction parseInstruction(@Nullable String functionName, @NotNull String addressString, @Nullable String functionOffsetStr, @NotNull String opcodes, @NotNull String disassembly) {
        if (addressString == null) {
            GDBDriver.$$$reportNull$$$0(163);
        }
        if (opcodes == null) {
            GDBDriver.$$$reportNull$$$0(164);
        }
        if (disassembly == null) {
            GDBDriver.$$$reportNull$$$0(165);
        }
        if (CANNOT_ACCESS_MEMORY_AT_ADDRESS.matcher(disassembly).matches()) {
            return null;
        }
        String instruction = null;
        String comment = null;
        if (!BAD_INSTRUCTION_WITH_PREFIX_SUFFIX.matcher(disassembly).matches()) {
            Matcher commentMatcher = INSTRUCTION_COMMENT.matcher(disassembly = INSTRUCTION_ENDING_WITH_ADDRESS_AND_SYMBOL_NAME.matcher(disassembly).replaceAll("$1  # $2"));
            if (commentMatcher.matches()) {
                instruction = commentMatcher.group(1);
                comment = commentMatcher.group(2);
            } else {
                instruction = disassembly;
            }
        }
        Address address = Address.parseHexString(addressString);
        LLSymbolOffset functionOffset = functionOffsetStr == null ? null : LLSymbolOffset.parseAngleBrackets(functionOffsetStr, functionName);
        return LLInstruction.create(address, opcodes, instruction, comment, functionOffset);
    }

    @Nullable
    protected Pair<Address, String> doGetFunctionStart(@NotNull Address address) throws ExecutionException, DebuggerCommandException {
        Response response;
        if (address == null) {
            GDBDriver.$$$reportNull$$$0(166);
        }
        if ((response = this.doDataDisassemble(AddressUtil.addressToRange(address, 1L))).getRecord().getType() == GDBResponse.ResultRecord.Type.error) {
            return null;
        }
        GDBTuple asmInsns = response.getResultList().getRequiredTuple("asm_insns");
        if (asmInsns.isEmpty()) {
            return null;
        }
        GDBTuple insn = (GDBTuple)asmInsns.get(0);
        String funcName = insn.getString("func-name");
        Integer offset = insn.getInteger("offset", null);
        if (funcName == null || offset == null) {
            return null;
        }
        Address functionStart = insn.getRequiredAddress("address").minus(offset);
        if (functionStart.equals(Address.NULL)) {
            return null;
        }
        return Pair.create((Object)functionStart, (Object)funcName);
    }

    @NotNull
    private Response doDataDisassemble(@NotNull AddressRange range) throws ExecutionException, DebuggerCommandException {
        if (range == null) {
            GDBDriver.$$$reportNull$$$0(167);
        }
        Response response = this.sendRequest("-data-disassemble -s %s -e %s -- 2", range.getStart(), AddressUtil.getEndCoerced(range)).waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.error);
        if (response == null) {
            GDBDriver.$$$reportNull$$$0(168);
        }
        return response;
    }

    @Override
    @NotNull
    public List<LLModule> getLoadedModules() throws ExecutionException, DebuggerCommandException {
        Map<String, List<LLSection>> sectionsMap = this.doGetSectionsMap();
        List modules = ContainerUtil.map(sectionsMap.keySet(), LLModule::new);
        List<LLModule> list = Collections.unmodifiableList(modules);
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(169);
        }
        return list;
    }

    @Override
    @NotNull
    public List<LLSection> getModuleSections(@NotNull LLModule module) throws ExecutionException, DebuggerCommandException {
        if (module == null) {
            GDBDriver.$$$reportNull$$$0(170);
        }
        List list = this.executeCommand(() -> {
            Map<String, List<LLSection>> sectionsMap = this.doGetSectionsMap();
            List<LLSection> sections = sectionsMap.get(module.getPath());
            if (sections == null) {
                throw new DebuggerCommandException("Unknown module '" + module + "'");
            }
            return sections;
        });
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(171);
        }
        return list;
    }

    @NotNull
    protected Map<String, List<LLSection>> doGetSectionsMap() throws ExecutionException, GDBCommandException {
        if (this.mySectionsMap == null) {
            Response response = this.sendSilentRequestAndWaitForDone("%s", GDBDriver.createConsoleCommand("maintenance info sections ALLOBJ"));
            this.mySectionsMap = GDBDriver.doReadSectionsMap(response.getOutput());
        }
        Map<String, List<LLSection>> map = this.mySectionsMap;
        if (map == null) {
            GDBDriver.$$$reportNull$$$0(172);
        }
        return map;
    }

    @NotNull
    protected static Map<String, List<LLSection>> doReadSectionsMap(@NotNull String output) throws ExecutionException {
        if (output == null) {
            GDBDriver.$$$reportNull$$$0(173);
        }
        LinkedHashMap<String, List<LLSection>> sectionsMap = new LinkedHashMap<String, List<LLSection>>();
        ArrayList<LLSection> sections = null;
        for (String str : output.split("\n")) {
            Matcher matcher;
            if (str.startsWith(OBJECT_FILE_PREFIX)) {
                String objectName = StringUtil.trimStart((String)str, (String)OBJECT_FILE_PREFIX);
                sections = new ArrayList<LLSection>();
                sectionsMap.putIfAbsent(objectName, Collections.unmodifiableList(sections));
                continue;
            }
            if (sections == null || !(matcher = SECTIONS_INFO.matcher(str)).matches()) continue;
            Address start = GDBDriver.parseAddress(matcher.group(1));
            Address end = GDBDriver.parseAddress(matcher.group(2));
            String name = matcher.group(3);
            List flags = StringUtil.split((String)matcher.group(4), (String)" ");
            sections.add(new LLSection(name, flags, AddressUtil.addressRangeExclusive(start, end)));
        }
        LinkedHashMap<String, List<LLSection>> linkedHashMap = sectionsMap;
        if (linkedHashMap == null) {
            GDBDriver.$$$reportNull$$$0(174);
        }
        return linkedHashMap;
    }

    @Override
    @NotNull
    public List<LLMemoryHunk> dumpMemory(@NotNull AddressRange range) throws ExecutionException, DebuggerCommandException {
        if (range == null) {
            GDBDriver.$$$reportNull$$$0(175);
        }
        List list = this.executeCommand(() -> {
            Response response = this.sendRequestAndWaitForDone("-data-read-memory-bytes %s %d", range.getStart(), range.getSize());
            ArrayList<LLMemoryHunk> list = new ArrayList<LLMemoryHunk>();
            for (Object o : response.getResultList().getRequiredTuple("memory")) {
                GDBTuple tuple = (GDBTuple)o;
                Address begin = tuple.getRequiredAddress("begin").plus(tuple.getInt("offset", 0));
                Address end = tuple.getRequiredAddress("end");
                AddressRange hunkRange = AddressUtil.addressRangeExclusive(begin, end);
                String contents = tuple.getRequiredString("contents");
                byte[] bytes = GDBDriver.bytesFromString(contents);
                if ((long)bytes.length != range.getSize()) {
                    CidrDebuggerLog.LOG.warn("Memory range of size " + range.getSize() + "; content size is " + bytes.length);
                    continue;
                }
                LLMemoryHunk hunk = new LLMemoryHunk(hunkRange, bytes);
                list.add(hunk);
            }
            return list;
        });
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(176);
        }
        return list;
    }

    private static byte[] bytesFromString(@NotNull String data) {
        if (data == null) {
            GDBDriver.$$$reportNull$$$0(177);
        }
        byte[] bytes = new byte[data.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)((Character.digit(data.charAt(i * 2), 16) << 4) + Character.digit(data.charAt(i * 2 + 1), 16));
        }
        return bytes;
    }

    private LLValue doEvaluate(long threadId, int frameIndex, String expression, @Nullable String language) throws ExecutionException, DebuggerCommandException {
        if (language != null) {
            this.sendRequestAndWaitForDone("-gdb-set language %s", language);
        }
        try {
            LLValue lLValue;
            try (CidrEventSpan ignored = new CidrEventSpan("debug", "doEvaluate", (Object)expression);){
                GDBResponse.Record response = this.doCreateVar(expression, threadId, frameIndex);
                lLValue = this.doReadVariable(response.getResultList(), "", null);
            }
            return lLValue;
        }
        finally {
            if (language != null) {
                this.sendRequestAndWaitForDone("-gdb-set language auto", new Object[0]);
            }
        }
    }

    @Nullable
    private static String convertLanguage(@Nullable DebuggerDriver.DebuggerLanguage language) throws DebuggerCommandException {
        if (language == null) {
            return null;
        }
        if (language instanceof DebuggerDriver.StandardDebuggerLanguage) {
            switch ((DebuggerDriver.StandardDebuggerLanguage)language) {
                case C: {
                    return "c";
                }
                case C_PLUS_PLUS: {
                    return "c++";
                }
                case OBJC: {
                    return "objective-c";
                }
            }
        }
        throw new DebuggerCommandException(language + " is not supported by GDB");
    }

    @Override
    @NotNull
    public DebuggerDriver.ShellCommandResult executeShellCommand(@NotNull String executable, @Nullable List<String> params, @Nullable String workingDir, int timeoutSecs) throws ExecutionException {
        if (executable == null) {
            GDBDriver.$$$reportNull$$$0(178);
        }
        throw new ExecutionException(GDBBundle.message("error.executing.shell.commands.not.implemented.yet", new Object[0]));
    }

    @Override
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public void executeConsoleCommand(@NotNull String command) throws ExecutionException, DebuggerCommandException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(179);
        }
        this.executeInterpreterCommand(-1L, -1, command);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public void executeConsoleCommand(long threadId, int frameIndex, @NlsSafe @NotNull String string) throws ExecutionException, DebuggerCommandException {
        void command;
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(180);
        }
        this.executeInterpreterCommand(threadId, frameIndex, (String)command);
    }

    @Override
    @NotNull
    public String executeInterpreterCommand(@NotNull String command) throws ExecutionException, DebuggerCommandException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(181);
        }
        String string = this.executeInterpreterCommand(-1L, -1, command);
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(182);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String executeInterpreterCommand(long threadId, int frameIndex, @NotNull String string) throws ExecutionException, DebuggerCommandException {
        void command;
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(183);
        }
        String string2 = this.executeCommand(new ConsoleCommand<String>((String)command, (String)command, threadId, frameIndex){
            final /* synthetic */ String val$command;
            final /* synthetic */ long val$threadId;
            final /* synthetic */ int val$frameIndex;
            {
                this.val$command = string;
                this.val$threadId = l;
                this.val$frameIndex = n;
                super(expression);
            }

            @Override
            public String call() throws ExecutionException {
                String commandToSend;
                if (GDBDriver.this.checkIsInPromptModeWhenSettled(300)) {
                    commandToSend = this.val$command;
                } else {
                    String trimmed;
                    long actualThreadId = this.val$threadId;
                    int actualFrameIndex = this.val$frameIndex;
                    DebuggerDriver.StopPlace currentPlace = GDBDriver.this.myStopPlace;
                    if (actualThreadId < 0L && currentPlace != null) {
                        actualThreadId = currentPlace.thread.getId();
                        actualFrameIndex = currentPlace.frame.getIndex();
                    }
                    if ("run".equals(trimmed = this.val$command.trim())) {
                        GDBDriver.this.handleDebuggerOutput(GDBBundle.message("command.0.is.not.supported", trimmed) + "\n", ProcessOutputTypes.STDOUT);
                        return "";
                    }
                    commandToSend = GDBDriver.createConsoleCommand(trimmed, actualThreadId, actualFrameIndex);
                }
                return GDBDriver.this.sendRequest("%s", commandToSend).waitAndPokeForPrompt((int)this.getTimeout()).getOutput();
            }
        });
        if (string2 == null) {
            GDBDriver.$$$reportNull$$$0(184);
        }
        return string2;
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<String> completeConsoleCommand(@NotNull String command, int pos) throws ExecutionException {
        DebuggerDriver.ResultList resultList;
        String completionPrefix;
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(185);
        }
        if ((completionPrefix = StringUtil.trimLeading((String)command.substring(0, pos))).startsWith("!")) {
            DebuggerDriver.ResultList<String> resultList2 = DebuggerDriver.ResultList.empty();
            if (resultList2 == null) {
                GDBDriver.$$$reportNull$$$0(186);
            }
            return resultList2;
        }
        try {
            resultList = this.executeCommand(() -> this.doCompleteConsoleCommand(completionPrefix));
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.debug((Throwable)e);
            DebuggerDriver.ResultList<String> resultList3 = DebuggerDriver.ResultList.empty();
            if (resultList3 == null) {
                GDBDriver.$$$reportNull$$$0(188);
            }
            return resultList3;
        }
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(187);
        }
        return resultList;
    }

    @NotNull
    private DebuggerDriver.ResultList<String> doCompleteConsoleCommand(@NotNull String completionPrefix) throws ExecutionException, GDBCommandException {
        List fullCompletions;
        if (completionPrefix == null) {
            GDBDriver.$$$reportNull$$$0(189);
        }
        if (this.checkIsInPromptModeWhenSettled(300)) {
            DebuggerDriver.ResultList<String> resultList = DebuggerDriver.ResultList.empty();
            if (resultList == null) {
                GDBDriver.$$$reportNull$$$0(190);
            }
            return resultList;
        }
        Response response = this.sendSilentRequestAndWaitForDone("complete %s", completionPrefix);
        Object[] outputLines = StringUtil.splitByLines((String)response.getOutput(), (boolean)true);
        boolean hasMore = false;
        if (outputLines.length > 0 && ((String)outputLines[outputLines.length - 1]).endsWith(MAX_COMPLETIONS_REACHED)) {
            outputLines[outputLines.length - 1] = "";
            hasMore = true;
        }
        if ((fullCompletions = ContainerUtil.filter((Object[])outputLines, line -> !StringUtil.isEmptyOrSpaces((String)line) && !line.startsWith("!"))).isEmpty()) {
            DebuggerDriver.ResultList<String> resultList = DebuggerDriver.ResultList.empty();
            if (resultList == null) {
                GDBDriver.$$$reportNull$$$0(191);
            }
            return resultList;
        }
        int indexOfSpace = completionPrefix.lastIndexOf(32);
        String trimPrefix = indexOfSpace == -1 ? "" : completionPrefix.substring(0, indexOfSpace + 1);
        List completions = ContainerUtil.map((Collection)fullCompletions, line -> StringUtil.trimStart((String)line, (String)trimPrefix));
        DebuggerDriver.ResultList<String> resultList = DebuggerDriver.ResultList.create(completions, hasMore);
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(192);
        }
        return resultList;
    }

    @Override
    public void handleSignal(@NotNull String signalName, boolean stop, boolean pass, boolean notify) throws ExecutionException, DebuggerCommandException {
        if (signalName == null) {
            GDBDriver.$$$reportNull$$$0(193);
        }
        this.executeCommand(() -> {
            ArrayList<String> options = new ArrayList<String>(3);
            options.add(GDBDriver.handleSignalOption(stop, "stop"));
            options.add(GDBDriver.handleSignalOption(pass, "pass"));
            options.add(GDBDriver.handleSignalOption(notify, "print"));
            String command = GDBDriver.format("handle %s %s", signalName, StringUtil.join(options, (String)" "));
            this.sendRequestAndWaitForDone("%s", GDBDriver.createConsoleCommand(command));
        });
    }

    private static String handleSignalOption(boolean on, String option) {
        String prefix = "";
        if (!on) {
            prefix = "no";
        }
        return prefix + option;
    }

    @NotNull
    public static String createConsoleCommand(@NotNull String request) {
        if (request == null) {
            GDBDriver.$$$reportNull$$$0(194);
        }
        return GDBDriver.createConsoleCommand(request, -1L, -1);
    }

    @NotNull
    protected static String createConsoleCommand(@NotNull String request, @Nullable DebuggerDriver.StopPlace stopPlace) {
        if (request == null) {
            GDBDriver.$$$reportNull$$$0(195);
        }
        return GDBDriver.createConsoleCommand(request, GDBDriver.onThreadAndFrame(stopPlace));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected static String createConsoleCommand(@NotNull String request, long threadId, int n) {
        void frameIndex;
        if (request == null) {
            GDBDriver.$$$reportNull$$$0(196);
        }
        return GDBDriver.createConsoleCommand(request, GDBDriver.onThreadAndFrame(threadId, (int)frameIndex));
    }

    @NotNull
    protected static String createConsoleCommand(@NotNull String request, @NotNull String onThreadAndFrame) {
        if (request == null) {
            GDBDriver.$$$reportNull$$$0(197);
        }
        if (onThreadAndFrame == null) {
            GDBDriver.$$$reportNull$$$0(198);
        }
        String string = GDBDriver.format("-interpreter-exec %s console %s", onThreadAndFrame, GDBDriver.stringify(request));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(199);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected static String createMI2Command(@NotNull String request, long threadId, int n) {
        void frameIndex;
        if (request == null) {
            GDBDriver.$$$reportNull$$$0(200);
        }
        String string = GDBDriver.format("%d-interpreter-exec %s %s %s", 0, GDBDriver.onThreadAndFrame(threadId, (int)frameIndex), "mi2", GDBDriver.stringify(request));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(201);
        }
        return string;
    }

    private String onStoppedThreadAndFrame() {
        return GDBDriver.onThreadAndFrame(this.myStopPlace);
    }

    private static String onThreadAndFrame(@Nullable DebuggerDriver.StopPlace stopPlace) {
        long threadId = stopPlace == null ? -1L : stopPlace.thread.getId();
        int frameIndex = stopPlace == null ? -1 : stopPlace.frame.getIndex();
        return GDBDriver.onThreadAndFrame(threadId, frameIndex);
    }

    private static String onThreadAndFrame(long threadId, int frameIndex) {
        return threadId >= 0L ? GDBDriver.format("--thread %d --frame %d", threadId, frameIndex) : "";
    }

    private static String atSourceLine(@NotNull String source, int line) {
        if (source == null) {
            GDBDriver.$$$reportNull$$$0(202);
        }
        return GDBDriver.stringify(GDBDriver.format("%s:%d", source, line + 1));
    }

    private static String atAddress(@NotNull Address address) {
        if (address == null) {
            GDBDriver.$$$reportNull$$$0(203);
        }
        return GDBDriver.format("*%s", address);
    }

    private static String atFunction(@NotNull String func) {
        if (func == null) {
            GDBDriver.$$$reportNull$$$0(204);
        }
        return GDBDriver.format("--function %s", GDBDriver.stringify(func));
    }

    private static String withCondition(@Nullable String condition) {
        return condition != null ? GDBDriver.format("-c %s", GDBDriver.stringify(condition)) : "";
    }

    private static String withInstructionMode(boolean stepByInstruction) {
        return stepByInstruction ? "-instruction" : "";
    }

    @Contract(pure=true)
    @NotNull
    protected Request buildRequest(@PrintFormat @NonNls @NotNull String command, Object ... args) {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(205);
        }
        if (args == null) {
            GDBDriver.$$$reportNull$$$0(206);
        }
        return new Request(GDBDriver.format(command, args));
    }

    @NotNull
    protected Communication sendRequest(@PrintFormat @NonNls @NotNull String command, Object ... args) throws ExecutionException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(207);
        }
        if (args == null) {
            GDBDriver.$$$reportNull$$$0(208);
        }
        Communication communication = this.buildRequest(command, args).send();
        if (communication == null) {
            GDBDriver.$$$reportNull$$$0(209);
        }
        return communication;
    }

    @NotNull
    protected Response sendRequestAndWaitForDone(@PrintFormat @NonNls @NotNull String command, Object ... args) throws ExecutionException, GDBCommandException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(210);
        }
        if (args == null) {
            GDBDriver.$$$reportNull$$$0(211);
        }
        Response response = this.sendRequest(command, args).waitFor(GDBResponse.ResultRecord.Type.done);
        if (response == null) {
            GDBDriver.$$$reportNull$$$0(212);
        }
        return response;
    }

    @NotNull
    protected Response sendRequestAndWaitForRunning(@PrintFormat @NonNls @NotNull String command, Object ... args) throws ExecutionException, GDBCommandException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(213);
        }
        if (args == null) {
            GDBDriver.$$$reportNull$$$0(214);
        }
        Response response = this.sendRequest(command, args).waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
        if (response == null) {
            GDBDriver.$$$reportNull$$$0(215);
        }
        return response;
    }

    @NotNull
    private Communication sendSilentRequest(@PrintFormat @NonNls @NotNull String command, Object ... args) throws ExecutionException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(216);
        }
        if (args == null) {
            GDBDriver.$$$reportNull$$$0(217);
        }
        Communication communication = this.buildRequest(command, args).suppressAll().send();
        if (communication == null) {
            GDBDriver.$$$reportNull$$$0(218);
        }
        return communication;
    }

    @NotNull
    protected Response sendSilentRequestAndWaitForDone(@PrintFormat @NonNls @NotNull String command, Object ... args) throws ExecutionException, GDBCommandException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(219);
        }
        if (args == null) {
            GDBDriver.$$$reportNull$$$0(220);
        }
        Response response = this.sendSilentRequest(command, args).waitFor(GDBResponse.ResultRecord.Type.done);
        if (response == null) {
            GDBDriver.$$$reportNull$$$0(221);
        }
        return response;
    }

    protected void sendRequestOrSpecialCommunication(@NotNull String commandDisplayString, boolean tearDownRequest, @NotNull ThrowableRunnable<? extends ExecutionException> r) throws ExecutionException {
        if (commandDisplayString == null) {
            GDBDriver.$$$reportNull$$$0(222);
        }
        if (r == null) {
            GDBDriver.$$$reportNull$$$0(223);
        }
        GDBDriver.waitForSemaphore(this.myCommandSemaphore);
        this.throwIfTerminatedOrHasPendingErrors(tearDownRequest);
        this.myCommandSemaphore.down();
        this.myLastCommand = commandDisplayString;
        r.run();
    }

    private void throwIfTerminatedOrHasPendingErrors(boolean tearDownRequest) throws ExecutionException {
        if (!tearDownRequest && this.myProcessHandler.isProcessTerminating() || this.myProcessHandler.isProcessTerminated()) {
            throw new ExecutionFinishedException();
        }
        this.checkErrors();
    }

    @Override
    public void checkErrors() throws ExecutionException {
        while (!this.myResultQueue.isEmpty()) {
            Response response = (Response)this.myResultQueue.remove();
            try {
                response.checkError();
            }
            catch (ExecutionException e) {
                if (ExceptionUtil.causedBy((Throwable)e, ExecutionFinishedException.class)) continue;
                throw e;
            }
        }
    }

    @Override
    protected void handleDebuggerOutput(@Nls @NotNull String text, @NotNull Key type) {
        if (text == null) {
            GDBDriver.$$$reportNull$$$0(224);
        }
        if (type == null) {
            GDBDriver.$$$reportNull$$$0(225);
        }
        if (!this.myCommunication.suppressOutputEvent) {
            super.handleDebuggerOutput(text, type);
        }
    }

    @Override
    protected void handleRunning() {
        if (!this.myCommunication.suppressRunningEvent) {
            super.handleRunning();
        }
    }

    @Override
    protected void handleTargetFinished(int code, @Nullable String description) {
        if (this.myCommunication.suppressTargetFinishedEvent) {
            return;
        }
        this.myStopSemaphore.up();
        super.handleTargetFinished(code, description);
    }

    @Override
    protected void handleTargetTerminated() {
        this.myStopSemaphore.up();
        super.handleTargetTerminated();
    }

    private boolean isTerminated() {
        return this.myProcessHandler.isProcessTerminating() || this.myProcessHandler.isProcessTerminated();
    }

    protected boolean checkIsInPromptModeWhenSettled(int timeoutMs) {
        while (this.isInPromptMode()) {
            try {
                Response response = this.myResultQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
                if (response == Response.NULL) continue;
            }
            catch (InterruptedException e) {}
            break;
        }
        return this.isInPromptMode();
    }

    private static ExecutionException unexpectedResponse(Object response) {
        return new ExecutionException(GDBBundle.message("error.unexpected.response", response));
    }

    private static boolean messageContains(@NotNull Exception e, @NotNull String string) {
        String message;
        if (e == null) {
            GDBDriver.$$$reportNull$$$0(226);
        }
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(227);
        }
        return (message = e.getMessage()) != null && message.contains(string);
    }

    private static void waitForSemaphore(@NotNull Semaphore s) throws ExecutionException {
        if (s == null) {
            GDBDriver.$$$reportNull$$$0(228);
        }
        try {
            s.waitForUnsafe();
        }
        catch (InterruptedException e) {
            throw new ExecutionException(GDBBundle.message("error.execution.interrupted", new Object[0]), (Throwable)e);
        }
    }

    private static boolean waitForSemaphore(@NotNull Semaphore s, long msTimeout) throws ExecutionException {
        if (s == null) {
            GDBDriver.$$$reportNull$$$0(229);
        }
        try {
            return s.waitForUnsafe(msTimeout);
        }
        catch (InterruptedException e) {
            throw new ExecutionException(GDBBundle.message("error.execution.interrupted", new Object[0]), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPromptLevel() {
        Deque<Integer> deque = this.myPromptLevelStack;
        synchronized (deque) {
            return this.myPromptLevelStack.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPromptMode(int promptLevel) {
        Deque<Integer> deque = this.myPromptLevelStack;
        synchronized (deque) {
            Deque<Integer> stack = this.myPromptLevelStack;
            if (promptLevel > 0) {
                while (!stack.isEmpty() && stack.getLast() > promptLevel) {
                    stack.removeLast();
                }
                if (stack.isEmpty() || stack.getLast() < promptLevel) {
                    stack.addLast(promptLevel);
                }
            } else {
                stack.clear();
            }
        }
        this.handlePrompt(promptLevel);
    }

    private boolean enterPromptMode(String prompt) {
        if (!PROMPT.matcher(prompt).matches()) {
            return false;
        }
        CidrDebuggerLog.LOG.assertTrue(this.myIsConsoleCommand, (Object)"Prompt mode is only expected as a result of a console command");
        this.setPromptMode(prompt.length());
        this.myResultQueue.offer(Response.NULL);
        this.myCommandSemaphore.up();
        return true;
    }

    private void processResponse(@NotNull String output) {
        if (output == null) {
            GDBDriver.$$$reportNull$$$0(230);
        }
        try (CidrEventSpan ignored = new CidrEventSpan("debug", "processResponse", (Object)output);){
            try {
                this.doProcessResponse(output);
            }
            catch (Throwable e) {
                this.myResultQueue.offer(new ErrorResponse(GDBBundle.message("error.cannot.process.mi.record", this.myCommunication.command, output), e));
            }
        }
    }

    private void doProcessResponse(@NotNull String output) throws GDBResponse.ResponseParseException, ExecutionException {
        if (output == null) {
            GDBDriver.$$$reportNull$$$0(231);
        }
        if (CidrDebuggerLog.LOG.isDebugEnabled()) {
            CidrDebuggerLog.LOG.debug("<" + output);
        }
        if ("(gdb)".equals(output)) {
            CidrDebuggerLog.LOG.assertTrue(!this.isInPromptMode(), (Object)"Prompt mode should have been reset on ^result record");
            this.myCommandSemaphore.up();
            return;
        }
        if (output.startsWith("0^")) {
            return;
        }
        GDBResponse response = GDBResponse.parse(output);
        if (response instanceof GDBResponse.StreamRecord) {
            this.doProcessStreamRecord((GDBResponse.StreamRecord)response);
        } else if (response instanceof GDBResponse.ResultRecord) {
            this.doProcessResultRecord((GDBResponse.ResultRecord)response);
        } else if (response instanceof GDBResponse.AsyncRecord) {
            this.doProcessAsyncRecord((GDBResponse.AsyncRecord)response);
        } else {
            throw GDBDriver.unexpectedResponse(output);
        }
    }

    private void doProcessStreamRecord(GDBResponse.StreamRecord record) {
        String text = record.getText();
        switch (record.getCategory()) {
            case target: {
                this.handleTargetOutput(text, ProcessOutputTypes.STDOUT);
                break;
            }
            case console: {
                if (this.myIsConsoleCommand && this.enterPromptMode(text)) break;
                if (this.myGdbVersion == null) {
                    this.myGdbVersion = VersionUtil.parseVersion((String)text, (Pattern[])new Pattern[]{VERSION_PATTERN});
                    this.myWindowsIoRedirectionEnabled = this.isWindows() && !StringUtil.containsIgnoreCase((String)text, (String)"cygwin") && this.myGdbVersion != null && this.myGdbVersion.major >= 8 && !Registry.is((String)"cidr.debugger.gdb.workaround.windows.forceExternalConsole", (boolean)false) && !this.myUseExternalConsoleRequested;
                }
                this.myCommunication.consoleOutput.append(text);
            }
            case log: {
                this.handleDebuggerOutput(text, ProcessOutputTypes.STDOUT);
            }
        }
    }

    private void doProcessResultRecord(GDBResponse.ResultRecord record) throws ExecutionException {
        this.setPromptMode(0);
        switch ((GDBResponse.ResultRecord.Type)record.getType()) {
            case continuing: 
            case stepping: {
                return;
            }
            case running: {
                this.myStopPlace = null;
                this.handleRunning();
                if (!this.myCommunication.suppressRunningResult) break;
                return;
            }
            case error: {
                GDBTuple tuple = record.getResultList();
                String reason = tuple.getString("reason");
                if (!"breakpoint-hit".equals(reason)) break;
                this.doReadStopPlaceAsync(tuple).thenAccept(stopPlace -> {
                    this.myStopPlace = stopPlace;
                    try {
                        this.processBreakpointHit((DebuggerDriver.StopPlace)stopPlace, tuple);
                    }
                    catch (ExecutionException e) {
                        throw new CompletionException(e);
                    }
                });
                break;
            }
        }
        this.myResultQueue.offer(this.myCommunication.createResponse(record));
    }

    private void doProcessAsyncRecord(GDBResponse.AsyncRecord record) throws ExecutionException {
        String type = ((GDBResponse.AsyncRecord.Type)record.getType()).getValue();
        GDBTuple resultTuple = record.getResultList();
        switch ((GDBResponse.AsyncRecord.Category)record.getCategory()) {
            case notify: {
                switch (type) {
                    case "library-loaded": {
                        String moduleName = resultTuple.getString("id");
                        if (moduleName != null) {
                            this.handleModulesLoaded(Collections.singletonList(new LLModule(moduleName)));
                        }
                    }
                    case "library-unloaded": {
                        this.mySectionsMap = null;
                        return;
                    }
                    case "breakpoint-modified": {
                        try {
                            LLBreakpoint breakpoint = GDBDriver.readBreakpoint(resultTuple);
                            this.handleBreakpointUpdated(breakpoint);
                        }
                        catch (DebuggerCommandException e) {
                            throw new ExecutionException((Throwable)e);
                        }
                        return;
                    }
                    case "thread-group-exited": {
                        int code = resultTuple.getInt("exit-code", 1);
                        this.handleTargetFinished(code, null);
                        return;
                    }
                    case "thread-group-started": {
                        this.myTargetPID = resultTuple.getRequiredInt("pid");
                        return;
                    }
                }
                return;
            }
            case exec: {
                if (!type.equals("stopped")) {
                    return;
                }
                if (resultTuple.getAll("reason", String.class).stream().anyMatch(o -> o.startsWith("exited"))) {
                    DebuggerDriver.TargetState state = this.getState();
                    CidrDebuggerLog.LOG.assertTrue(state == DebuggerDriver.TargetState.FINISHED, (Object)("Finished state should have been reported already: " + state));
                    return;
                }
                if (this.myPendingForAttachNotification.tryUp()) {
                    return;
                }
                boolean bl = this.myIsInterruptedStop = resultTuple.getString("reason", "").equals("signal-received") && (resultTuple.getString("signal-name", "").equals("SIGINT") || resultTuple.getString("signal-name", "").equals("SIG" + this.myInterruptSignalName));
                if (this.myStopSemaphore.tryUp() && this.myIsInterruptedStop) {
                    return;
                }
                this.doReadStopPlaceAsync(resultTuple).thenAccept(stopPlace -> {
                    this.myStopPlace = stopPlace;
                    try {
                        this.doProcessAsyncStopPlace(resultTuple, (DebuggerDriver.StopPlace)stopPlace);
                    }
                    catch (ExecutionException e) {
                        throw new CompletionException(e);
                    }
                });
                return;
            }
        }
    }

    private void doProcessAsyncStopPlace(GDBTuple resultTuple, DebuggerDriver.StopPlace stopPlace) throws ExecutionException {
        switch (resultTuple.getString("reason", "")) {
            case "signal-received": {
                ++this.myCommunication.receivedSignalCount;
                String name = resultTuple.getString("signal-name");
                String meaning = resultTuple.getString("signal-meaning");
                if (GDBDriver.isTargetTerminationSignal(name)) {
                    this.handleTargetTerminated();
                    return;
                }
                if (name == null || meaning == null) break;
                this.handleSignal(stopPlace, name, meaning);
                this.tryToFlushOnWindows();
                return;
            }
            case "breakpoint-hit": {
                this.processBreakpointHit(stopPlace, resultTuple);
                this.tryToFlushOnWindows();
                return;
            }
            case "location-reached": {
                break;
            }
            case "function-finished": 
            case "end-stepping-range": {
                boolean shouldHandle = this.myCommunication.myThreadPlan.onSteppingFinished(stopPlace);
                if (shouldHandle) break;
                return;
            }
            case "watchpoint-trigger": 
            case "read-watchpoint-trigger": 
            case "access-watchpoint-trigger": {
                String tupleKey;
                String[] tupleKeys = new String[]{"wpt", "hw-rwpt", "hw-awpt"};
                GDBTuple wpt = null;
                String[] stringArray = tupleKeys;
                int n = stringArray.length;
                for (int i = 0; i < n && (wpt = resultTuple.getTuple(tupleKey = stringArray[i])) == null; ++i) {
                }
                if (wpt == null) break;
                int number = wpt.getRequiredInt("number");
                this.handleWatchpoint(stopPlace, number);
                this.tryToFlushOnWindows();
                return;
            }
            case "watchpoint-scope": {
                int wpnum = resultTuple.getRequiredInt("wpnum");
                this.handleWatchpointScope(wpnum);
                this.tryToFlushOnWindows();
                return;
            }
        }
        this.handleInterrupted(stopPlace);
        this.tryToFlushOnWindows();
    }

    protected void tryToFlushOnWindows() throws ExecutionException {
        if (this.myWindowsIoRedirectionEnabled && Registry.is((String)"cidr.debugger.gdb.workaround.windows.flushStreamsOnSuspend", (boolean)true) && this.getState() == DebuggerDriver.TargetState.SUSPENDED) {
            String fflushCall = "((int(*)(void*))fflush)(0)";
            String command = GDBDriver.format("0-data-evaluate-expression %s", "((int(*)(void*))fflush)(0)");
            new Communication(this, command).doInitiate();
        }
    }

    private void processBreakpointHit(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull GDBTuple resultTuple) throws ExecutionException {
        int num;
        boolean shouldHandle;
        if (stopPlace == null) {
            GDBDriver.$$$reportNull$$$0(232);
        }
        if (resultTuple == null) {
            GDBDriver.$$$reportNull$$$0(233);
        }
        if (shouldHandle = this.myCommunication.myThreadPlan.onBreakpointHit(stopPlace, num = resultTuple.getRequiredInt("bkptno"))) {
            this.handleBreakpoint(stopPlace, num);
        }
    }

    private void cleanupOnTermination() {
        OutputStream processInput = this.myProcessInput;
        if (processInput != null) {
            try {
                processInput.close();
            }
            catch (IOException e) {
                CidrDebuggerLog.LOG.warn((Throwable)e);
            }
        }
        this.myProcessInput = null;
        this.myResultQueue.offer(new ErrorResponse((NotNullProducer<ExecutionException>)((NotNullProducer)ExecutionFinishedException::new)));
        this.myCommandSemaphore.up();
        this.myStopSemaphore.up();
        this.myPendingForAttachNotification.up();
        this.myCommandExecutor.shutdown();
    }

    protected <T> T executeCommandNoUserException(Command<T> c) throws ExecutionException {
        long timeout = c.getTimeout();
        try {
            CompletableFuture<T> future = this.doExecuteCommand(c, false);
            return timeout < 0L ? ExecutionResult.get(future) : ExecutionResult.get(future, timeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            CompletionException ce = (CompletionException)ExceptionUtil.findCause((Throwable)e, CompletionException.class);
            ExecutionException cause = (ExecutionException)((Object)ExceptionUtil.findCause((Throwable)(ce != null ? ce : e).getCause(), ExecutionException.class));
            throw cause != null ? cause : e;
        }
        catch (RejectedExecutionException e) {
            throw new ExecutionFinishedException((Throwable)e);
        }
        catch (TimeoutException e) {
            CidrDebuggerLog.LOG.warn("Command timed out (" + timeout + "): " + this.myLastCommand);
            if (c instanceof EvaluationCommand) {
                throw new DebuggerEvaluationTimedOutException(((EvaluationCommand)c).getExpression());
            }
            throw new DebuggerCommandTimedOutException(CidrDebuggerBundle.message("debug.command.error.timedOut", new Object[0]));
        }
    }

    protected <T> T executeCommand(Command<T> c) throws ExecutionException, DebuggerCommandException {
        try {
            return this.executeCommandNoUserException(c);
        }
        catch (ExecutionException e) {
            DebuggerCommandException cause = (DebuggerCommandException)ExceptionUtil.findCause((Throwable)e, DebuggerCommandException.class);
            if (cause != null) {
                throw new DebuggerCommandException(cause.getMessage(), cause);
            }
            throw e;
        }
    }

    private <T> CompletableFuture<T> executeAsyncCommand(Command<T> c) {
        return this.doExecuteCommand(c, true);
    }

    private <T> CompletableFuture<T> doExecuteCommand(Command<T> c, boolean async) {
        return CompletableFuture.supplyAsync(() -> {
            Object t;
            CidrEventSpan ignored = new CidrEventSpan("debug", "doExecuteCommand", (Object)c.getClass().getName());
            try {
                if (c instanceof SuspendedCommand && this.getState() == DebuggerDriver.TargetState.RUNNING) {
                    throw new DebuggerIllegalStateException(CidrDebuggerBundle.message("debug.command.error.notSuspended", new Object[0]));
                }
                this.myIsConsoleCommand = c instanceof ConsoleCommand;
                if (!this.myIsConsoleCommand && !(c instanceof DestroyCommand) && this.checkIsInPromptModeWhenSettled(500)) {
                    throw new DebuggerIllegalStateException(CidrDebuggerBundle.message("debug.command.error.inPrompt", new Object[0]));
                }
                t = c.call();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (async) {
                        this.myResultQueue.offer(new ErrorResponse(e));
                    }
                    throw new CompletionException(e);
                }
            }
            ignored.close();
            return t;
        }, this.myCommandExecutor);
    }

    @NotNull
    public static Pair<String, String> getDescriptionFromValue(@NotNull String value) {
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(234);
        }
        String description = null;
        Matcher matcher = VALUE_DESCRIPTION_PATTERN.matcher(value);
        if (matcher.matches()) {
            value = matcher.group(1);
            description = matcher.group(2);
        }
        if (description == null) {
            description = value;
        }
        Pair pair = Pair.create((Object)value, (Object)description);
        if (pair == null) {
            GDBDriver.$$$reportNull$$$0(235);
        }
        return pair;
    }

    @NotNull
    private Collection<String> doListFrameVariables(long threadId, int frameIndex) throws ExecutionException, DebuggerCommandException {
        Response response = this.sendRequestAndWaitForDone("-stack-list-variables %s --no-values", GDBDriver.onThreadAndFrame(threadId, frameIndex));
        GDBTuple variables = response.getResultList().getRequiredTuple("variables");
        Collection collection = variables.stream().map(var -> ((GDBTuple)var).getString("name", "")).collect(Collectors.toCollection(LinkedHashSet::new));
        if (collection == null) {
            GDBDriver.$$$reportNull$$$0(236);
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private Pair<Boolean, String> doGetExpressionType(@NotNull String expr, long threadId, int n) throws ExecutionException {
        void frameIndex;
        if (expr == null) {
            GDBDriver.$$$reportNull$$$0(237);
        }
        if (StringUtil.isEmptyOrSpaces((String)expr)) {
            return new Pair((Object)false, (Object)"<unknown>");
        }
        String command = GDBDriver.createConsoleCommand(GDBDriver.format("whatis/mt %s", GDBDriver.escapeVariadicArgIfNeeded(expr)), threadId, (int)frameIndex);
        try {
            String output = this.sendSilentRequestAndWaitForDone("%s", command).getOutput();
            Matcher m = WHATIS_TYPE_OUTPUT.matcher(output);
            if (m.matches()) {
                String substring = m.group(1) != null ? m.group(1) : m.group(2);
                return new Pair((Object)true, (Object)StringUtil.convertLineSeparators((String)substring, (String)" ").trim());
            }
            return new Pair((Object)false, (Object)"<unknown>");
        }
        catch (GDBCommandException e) {
            String error = e.getMessage();
            if ("value has been optimized out".equals(error)) {
                return new Pair((Object)false, (Object)"<optimized out>");
            }
            return new Pair((Object)false, (Object)("error: " + error));
        }
    }

    @NotNull
    private static String escapeVariadicArgIfNeeded(@NotNull String expr) {
        if (expr == null) {
            GDBDriver.$$$reportNull$$$0(238);
        }
        if (StringUtil.containsChar((String)expr, (char)'#') && !StringUtil.containsChar((String)expr, (char)'\'')) {
            String string = "'" + expr + "'";
            if (string == null) {
                GDBDriver.$$$reportNull$$$0(239);
            }
            return string;
        }
        String string = expr;
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(240);
        }
        return string;
    }

    @NotNull
    private static String makeFVKey(@NotNull String frameAddr, @NotNull String name) {
        if (frameAddr == null) {
            GDBDriver.$$$reportNull$$$0(241);
        }
        if (name == null) {
            GDBDriver.$$$reportNull$$$0(242);
        }
        String string = frameAddr + "-" + name;
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(243);
        }
        return string;
    }

    @Override
    @NotNull
    public HostMachine getHostMachine() {
        HostMachine hostMachine = this.myStarter.getHostMachine();
        if (hostMachine == null) {
            GDBDriver.$$$reportNull$$$0(244);
        }
        return hostMachine;
    }

    @NotNull
    private String toEnvPath(@NotNull String path) {
        if (path == null) {
            GDBDriver.$$$reportNull$$$0(245);
        }
        String string = this.myStarter.convertToEnvPath(path);
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(246);
        }
        return string;
    }

    private boolean isWindows() {
        return this.getHostMachine().getOSType() == OSType.WIN;
    }

    private boolean isMac() {
        return this.getHostMachine().getOSType() == OSType.MAC;
    }

    private boolean isUnix() {
        return !this.isWindows();
    }

    private boolean isMacOSSierra() {
        return !this.getHostMachine().isRemote() && SystemInfo.isMac;
    }

    private boolean isLinux() {
        return this.getHostMachine().getOSType() == OSType.LINUX;
    }

    public void setThreadFrameInfoDriverDelegate(@NotNull ThreadFrameInfoDriverDelegate driverDelegate) {
        if (driverDelegate == null) {
            GDBDriver.$$$reportNull$$$0(247);
        }
        this.myThreadFrameInfoDriverDelegate = driverDelegate;
    }

    private /* synthetic */ LLWatchpoint lambda$addWatchpoint$30(long threadId, int frameIndex, LLWatchpoint.Lifetime lifetime, String expr, LLWatchpoint.AccessType accessType) throws ExecutionException, DebuggerCommandException {
        if (this.getState() == DebuggerDriver.TargetState.RUNNING) {
            throw new ExecutionException(GDBBundle.message("error.cannot.set.watchpoint.while.program.running", new Object[0]));
        }
        String watchpointExpression = this.doGetWatchpointExpression(threadId, frameIndex, lifetime, expr);
        Response response = this.sendRequestAndWaitForDone("-break-watch %s %s", accessType.getParamString(), GDBDriver.stringify(watchpointExpression));
        return GDBDriver.readWatchpoint(response.getResultList(), accessType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 23: 
            case 28: 
            case 35: 
            case 44: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 60: 
            case 61: 
            case 68: 
            case 71: 
            case 81: 
            case 82: 
            case 84: 
            case 86: 
            case 91: 
            case 93: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 121: 
            case 123: 
            case 125: 
            case 126: 
            case 128: 
            case 130: 
            case 131: 
            case 134: 
            case 136: 
            case 139: 
            case 141: 
            case 149: 
            case 152: 
            case 154: 
            case 157: 
            case 158: 
            case 159: 
            case 162: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 174: 
            case 176: 
            case 182: 
            case 184: 
            case 186: 
            case 187: 
            case 188: 
            case 190: 
            case 191: 
            case 192: 
            case 199: 
            case 201: 
            case 209: 
            case 212: 
            case 215: 
            case 218: 
            case 221: 
            case 235: 
            case 236: 
            case 239: 
            case 240: 
            case 243: 
            case 244: 
            case 246: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 23: 
            case 28: 
            case 35: 
            case 44: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 60: 
            case 61: 
            case 68: 
            case 71: 
            case 81: 
            case 82: 
            case 84: 
            case 86: 
            case 91: 
            case 93: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 121: 
            case 123: 
            case 125: 
            case 126: 
            case 128: 
            case 130: 
            case 131: 
            case 134: 
            case 136: 
            case 139: 
            case 141: 
            case 149: 
            case 152: 
            case 154: 
            case 157: 
            case 158: 
            case 159: 
            case 162: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 174: 
            case 176: 
            case 182: 
            case 184: 
            case 186: 
            case 187: 
            case 188: 
            case 190: 
            case 191: 
            case 192: 
            case 199: 
            case 201: 
            case 209: 
            case 212: 
            case 215: 
            case 218: 
            case 221: 
            case 235: 
            case 236: 
            case 239: 
            case 240: 
            case 243: 
            case 244: 
            case 246: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "architectureType";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 23: 
            case 28: 
            case 35: 
            case 44: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 60: 
            case 61: 
            case 68: 
            case 71: 
            case 81: 
            case 82: 
            case 84: 
            case 86: 
            case 91: 
            case 93: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 121: 
            case 123: 
            case 125: 
            case 126: 
            case 128: 
            case 130: 
            case 131: 
            case 134: 
            case 136: 
            case 139: 
            case 141: 
            case 149: 
            case 152: 
            case 154: 
            case 157: 
            case 158: 
            case 159: 
            case 162: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 174: 
            case 176: 
            case 182: 
            case 184: 
            case 186: 
            case 187: 
            case 188: 
            case 190: 
            case 191: 
            case 192: 
            case 199: 
            case 201: 
            case 209: 
            case 212: 
            case 215: 
            case 218: 
            case 221: 
            case 235: 
            case 236: 
            case 239: 
            case 240: 
            case 243: 
            case 244: 
            case 246: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver";
                break;
            }
            case 9: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 10: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 14: 
            case 228: 
            case 229: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setting";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installer";
                break;
            }
            case 25: 
            case 242: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreFile";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePathMappings";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execSearchPaths";
                break;
            }
            case 33: 
            case 36: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionString";
                break;
            }
            case 34: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 38: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalCommands";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCommandLine";
                break;
            }
            case 43: 
            case 63: 
            case 67: 
            case 83: 
            case 245: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 46: 
            case 49: 
            case 87: 
            case 179: 
            case 180: 
            case 181: 
            case 183: 
            case 185: 
            case 205: 
            case 207: 
            case 210: 
            case 213: 
            case 216: 
            case 219: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersList";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stderr";
                break;
            }
            case 62: 
            case 232: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopPlace";
                break;
            }
            case 64: 
            case 70: 
            case 85: 
            case 89: 
            case 150: 
            case 155: 
            case 166: 
            case 203: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 65: 
            case 88: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 66: 
            case 69: 
            case 72: 
            case 104: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 73: 
            case 78: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 140: 
            case 144: 
            case 234: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 79: 
            case 237: 
            case 238: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symBreakpoint";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 96: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 97: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 99: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopTuple";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameTuple";
                break;
            }
            case 110: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 124: 
            case 127: 
            case 129: 
            case 132: 
            case 145: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 135: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 137: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varTuple";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentRef";
                break;
            }
            case 146: 
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 151: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackRange";
                break;
            }
            case 153: 
            case 160: 
            case 167: 
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disassembleAddressArg";
                break;
            }
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addressString";
                break;
            }
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opcodes";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disassembly";
                break;
            }
            case 173: 
            case 230: 
            case 231: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 178: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionPrefix";
                break;
            }
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signalName";
                break;
            }
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onThreadAndFrame";
                break;
            }
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 204: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 206: 
            case 208: 
            case 211: 
            case 214: 
            case 217: 
            case 220: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 222: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandDisplayString";
                break;
            }
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 225: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 226: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 227: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 233: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultTuple";
                break;
            }
            case 241: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameAddr";
                break;
            }
            case 247: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driverDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleLanguage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterruptSignalName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "shellQuote";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "gdbShow";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCoreDump";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "loadForRemote";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createDupFdCall";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellWrapper";
                break;
            }
            case 50: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellCommandLineString";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferiorArgs";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "quoteParametersForIORedirectionOnWindows";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "extractErrorLinesFromOutput";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "listVarObjects";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "jumpToLine";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "jumpToAddress";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "addWatchpoint";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetWatchpointExpression";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "addBreakpoint";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "addAddressBreakpoint";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "doGdbBreakInsert";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "addSymbolicBreakpoint";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "doReadStopPlaceAsync";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreads";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetThreads";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrames";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetFrames";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariables";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetFrameAddr";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetFrameVariables";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableID";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableChildren";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetVariableChildren";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetPlainVariableChildren";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "doListChildren";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetMapChildren";
                break;
            }
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateVar";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "doReadVariable";
                break;
            }
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadVariable";
                break;
            }
            case 149: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "disassembleFunction";
                break;
            }
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "disassemble";
                break;
            }
            case 157: 
            case 158: 
            case 159: {
                objectArray = objectArray2;
                objectArray2[1] = "doDisassembleFunction";
                break;
            }
            case 162: {
                objectArray = objectArray2;
                objectArray2[1] = "doDisassemble";
                break;
            }
            case 168: {
                objectArray = objectArray2;
                objectArray2[1] = "doDataDisassemble";
                break;
            }
            case 169: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedModules";
                break;
            }
            case 171: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleSections";
                break;
            }
            case 172: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetSectionsMap";
                break;
            }
            case 174: {
                objectArray = objectArray2;
                objectArray2[1] = "doReadSectionsMap";
                break;
            }
            case 176: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpMemory";
                break;
            }
            case 182: 
            case 184: {
                objectArray = objectArray2;
                objectArray2[1] = "executeInterpreterCommand";
                break;
            }
            case 186: 
            case 187: 
            case 188: {
                objectArray = objectArray2;
                objectArray2[1] = "completeConsoleCommand";
                break;
            }
            case 190: 
            case 191: 
            case 192: {
                objectArray = objectArray2;
                objectArray2[1] = "doCompleteConsoleCommand";
                break;
            }
            case 199: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleCommand";
                break;
            }
            case 201: {
                objectArray = objectArray2;
                objectArray2[1] = "createMI2Command";
                break;
            }
            case 209: {
                objectArray = objectArray2;
                objectArray2[1] = "sendRequest";
                break;
            }
            case 212: {
                objectArray = objectArray2;
                objectArray2[1] = "sendRequestAndWaitForDone";
                break;
            }
            case 215: {
                objectArray = objectArray2;
                objectArray2[1] = "sendRequestAndWaitForRunning";
                break;
            }
            case 218: {
                objectArray = objectArray2;
                objectArray2[1] = "sendSilentRequest";
                break;
            }
            case 221: {
                objectArray = objectArray2;
                objectArray2[1] = "sendSilentRequestAndWaitForDone";
                break;
            }
            case 235: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionFromValue";
                break;
            }
            case 236: {
                objectArray = objectArray2;
                objectArray2[1] = "doListFrameVariables";
                break;
            }
            case 239: 
            case 240: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeVariadicArgIfNeeded";
                break;
            }
            case 243: {
                objectArray = objectArray2;
                objectArray2[1] = "makeFVKey";
                break;
            }
            case 244: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostMachine";
                break;
            }
            case 246: {
                objectArray = objectArray2;
                objectArray2[1] = "toEnvPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setMIOutputFilterInTests";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 23: 
            case 28: 
            case 35: 
            case 44: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 60: 
            case 61: 
            case 68: 
            case 71: 
            case 81: 
            case 82: 
            case 84: 
            case 86: 
            case 91: 
            case 93: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 121: 
            case 123: 
            case 125: 
            case 126: 
            case 128: 
            case 130: 
            case 131: 
            case 134: 
            case 136: 
            case 139: 
            case 141: 
            case 149: 
            case 152: 
            case 154: 
            case 157: 
            case 158: 
            case 159: 
            case 162: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 174: 
            case 176: 
            case 182: 
            case 184: 
            case 186: 
            case 187: 
            case 188: 
            case 190: 
            case 191: 
            case 192: 
            case 199: 
            case 201: 
            case 209: 
            case 212: 
            case 215: 
            case 218: 
            case 221: 
            case 235: 
            case 236: 
            case 239: 
            case 240: 
            case 243: 
            case 244: 
            case 246: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeWatchpoint";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addSymbolsFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "shellQuote";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "warnUser";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "gdbSet";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "gdbShow";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "loadForLaunch";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loadForAttach";
                break;
            }
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "loadCoreDump";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "targetSelectCore";
                break;
            }
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "loadForRemote";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "doAddPathMapping";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadIndirectSymbols";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "doLoadExecutable";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "launch";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createDupFdCall";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "doWrapExec";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getShellWrapper";
                break;
            }
            case 49: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getShellCommandLineString";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getInferiorArgs";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "quoteParametersForIORedirectionOnWindows";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "connectTo";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "extractErrorLinesFromOutput";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "asyncStepOutUntilFrameWithDebugInfo";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "runTo";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "jumpToLine";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "jumpToAddress";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "doJumpToAddress";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "addPathMapping";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "addForcedFileMapping";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "addWatchpoint";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpoint";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "addAddressBreakpoint";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "interruptAndExecuteConsole";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "doInsertBreakpoint";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "doInsertAddressBreakpoint";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "doGdbBreakInsert";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "addSymbolicBreakpoint";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "doInsertSymbolicBreakpoint";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "removeCodepoints";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "readBreakpointLocation";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "readBreakpoint";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "doReadStopPlace";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "doReadStopPlaceAsync";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getFrames";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "doReadFrame";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "isIndirectSymbolFrame";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "getVariables";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "getVariableID";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getVariableChildren";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "doGetVariableChildren";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "doGetPlainVariableChildren";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "doListChildren";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "doVisitCppClassChildren";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "doCreateVar";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "doReadVariable";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "doLoadVariable";
                break;
            }
            case 142: 
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "doReadLoadedData";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateLoadedData";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenCount";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "disassembleFunction";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "disassemble";
                break;
            }
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "doDisassembleFunction";
                break;
            }
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "doDisassembleRange";
                break;
            }
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "doDisassemble";
                break;
            }
            case 163: 
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "parseInstruction";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "doGetFunctionStart";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "doDataDisassemble";
                break;
            }
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "getModuleSections";
                break;
            }
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "doReadSectionsMap";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "dumpMemory";
                break;
            }
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "bytesFromString";
                break;
            }
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "executeShellCommand";
                break;
            }
            case 179: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "executeConsoleCommand";
                break;
            }
            case 181: 
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "executeInterpreterCommand";
                break;
            }
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "completeConsoleCommand";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "doCompleteConsoleCommand";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "handleSignal";
                break;
            }
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleCommand";
                break;
            }
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "createMI2Command";
                break;
            }
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "atSourceLine";
                break;
            }
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "atAddress";
                break;
            }
            case 204: {
                objectArray = objectArray;
                objectArray[2] = "atFunction";
                break;
            }
            case 205: 
            case 206: {
                objectArray = objectArray;
                objectArray[2] = "buildRequest";
                break;
            }
            case 207: 
            case 208: {
                objectArray = objectArray;
                objectArray[2] = "sendRequest";
                break;
            }
            case 210: 
            case 211: {
                objectArray = objectArray;
                objectArray[2] = "sendRequestAndWaitForDone";
                break;
            }
            case 213: 
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "sendRequestAndWaitForRunning";
                break;
            }
            case 216: 
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "sendSilentRequest";
                break;
            }
            case 219: 
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "sendSilentRequestAndWaitForDone";
                break;
            }
            case 222: 
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "sendRequestOrSpecialCommunication";
                break;
            }
            case 224: 
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "handleDebuggerOutput";
                break;
            }
            case 226: 
            case 227: {
                objectArray = objectArray;
                objectArray[2] = "messageContains";
                break;
            }
            case 228: 
            case 229: {
                objectArray = objectArray;
                objectArray[2] = "waitForSemaphore";
                break;
            }
            case 230: {
                objectArray = objectArray;
                objectArray[2] = "processResponse";
                break;
            }
            case 231: {
                objectArray = objectArray;
                objectArray[2] = "doProcessResponse";
                break;
            }
            case 232: 
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "processBreakpointHit";
                break;
            }
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionFromValue";
                break;
            }
            case 237: {
                objectArray = objectArray;
                objectArray[2] = "doGetExpressionType";
                break;
            }
            case 238: {
                objectArray = objectArray;
                objectArray[2] = "escapeVariadicArgIfNeeded";
                break;
            }
            case 241: 
            case 242: {
                objectArray = objectArray;
                objectArray[2] = "makeFVKey";
                break;
            }
            case 245: {
                objectArray = objectArray;
                objectArray[2] = "toEnvPath";
                break;
            }
            case 247: {
                objectArray = objectArray;
                objectArray[2] = "setThreadFrameInfoDriverDelegate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 23: 
            case 28: 
            case 35: 
            case 44: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 60: 
            case 61: 
            case 68: 
            case 71: 
            case 81: 
            case 82: 
            case 84: 
            case 86: 
            case 91: 
            case 93: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 121: 
            case 123: 
            case 125: 
            case 126: 
            case 128: 
            case 130: 
            case 131: 
            case 134: 
            case 136: 
            case 139: 
            case 141: 
            case 149: 
            case 152: 
            case 154: 
            case 157: 
            case 158: 
            case 159: 
            case 162: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 174: 
            case 176: 
            case 182: 
            case 184: 
            case 186: 
            case 187: 
            case 188: 
            case 190: 
            case 191: 
            case 192: 
            case 199: 
            case 201: 
            case 209: 
            case 212: 
            case 215: 
            case 218: 
            case 221: 
            case 235: 
            case 236: 
            case 239: 
            case 240: 
            case 243: 
            case 244: 
            case 246: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ThreadFrameInfoDriverDelegate {
        @NotNull
        public CompletableFuture<DebuggerDriver.StopPlace> doReadStopPlaceAsync(@NotNull Bridge var1, @NotNull GDBTuple var2);

        @NotNull
        public List<LLThread> getThreads(@NotNull Bridge var1) throws ExecutionException, DebuggerCommandException;

        @NotNull
        public DebuggerDriver.ResultList<LLFrame> getFrames(@NotNull Bridge var1, @NotNull LLThread var2, int var3, int var4, boolean var5) throws ExecutionException, DebuggerCommandException;

        @NotNull
        public List<LLValue> getVariables(@NotNull Bridge var1, @NotNull LLThread var2, @NotNull LLFrame var3) throws ExecutionException, DebuggerCommandException;

        @NotNull
        public LLValueData getData(@NotNull Bridge var1, @NotNull LLValue var2) throws ExecutionException, DebuggerCommandException;

        @NotNull
        public DebuggerDriver.ResultList<LLValue> getVariableChildren(@NotNull Bridge var1, @NotNull LLValue var2, int var3, int var4) throws ExecutionException, DebuggerCommandException;
    }

    public static interface Bridge {
        @NotNull
        public <T> CompletableFuture<T> executeAsyncCommand(@NotNull Command<T> var1);

        @NotNull
        public <T> T executeCommand(@NotNull Command<T> var1) throws ExecutionException, DebuggerCommandException;

        @NotNull
        public String sendSilentRequestAndGetOutput(@PrintFormat @NonNls @NotNull String var1, Object ... var2) throws ExecutionException, GDBCommandException;

        @NotNull
        public LLFrame doReadFrame(int var1, @NotNull GDBTuple var2);

        @NotNull
        public DebuggerDriver.ResultList<LLFrame> doGetFrames(long var1, int var3, int var4, boolean var5) throws ExecutionException, DebuggerCommandException;

        @NotNull
        public List<LLValue> doGetFrameVariables(long var1, int var3) throws ExecutionException, DebuggerCommandException;

        @NotNull
        public LLValueData doEvaluateAndLoad(long var1, int var3, String var4, @Nullable String var5) throws ExecutionException, DebuggerCommandException;

        @Nullable
        public DebuggerDriver.StopPlace getStopPlace();

        @NotNull
        public LLValueData doLoadVariableData(@NotNull LLValue var1) throws ExecutionException, DebuggerCommandException;

        @NotNull
        public DebuggerDriver.ResultList<LLValue> doGetVariableChildren(@NotNull LLValue var1, int var2, int var3) throws ExecutionException, DebuggerCommandException;
    }

    private static class GDBCommandException
    extends DebuggerCommandException {
        @NotNull
        private final Response myResponse;

        GDBCommandException(@NotNull Response response, @NotNull String message) {
            if (response == null) {
                GDBCommandException.$$$reportNull$$$0(0);
            }
            if (message == null) {
                GDBCommandException.$$$reportNull$$$0(1);
            }
            super(message);
            this.myResponse = response;
        }

        @NotNull
        public Response getResponse() {
            Response response = this.myResponse;
            if (response == null) {
                GDBCommandException.$$$reportNull$$$0(2);
            }
            return response;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "response";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$GDBCommandException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$GDBCommandException";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class FrameValueLoader
    implements LLValueLoader {
        @NotNull
        private final String myFvKey;
        private final long myThreadId;
        private final int myFrameIndex;

        /*
         * WARNING - void declaration
         */
        FrameValueLoader(String fvKey, long threadId, int n) {
            void frameIndex;
            if (fvKey == null) {
                FrameValueLoader.$$$reportNull$$$0(0);
            }
            this.myFvKey = fvKey;
            this.myThreadId = threadId;
            this.myFrameIndex = frameIndex;
        }

        @Override
        public void loadValue(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
            if (value == null) {
                FrameValueLoader.$$$reportNull$$$0(1);
            }
            String name = value.getName();
            GDBResponse.Record varObj = GDBDriver.this.doCreateVar(name, this.myThreadId, this.myFrameIndex);
            String id = varObj.getResultList().getRequiredString("name");
            String v = varObj.getResultList().getString("value", "");
            LLValueLoadedData data = GDBDriver.doReadLoadedData(varObj.getResultList(), id, this.myFvKey, v);
            GDBDriver.doUpdateLoadedData(value, data);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fvKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$FrameValueLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CreatedValueLoader
    implements LLValueLoader {
        @NotNull
        private final LLValueLoadedData partialLoadedData;

        CreatedValueLoader(LLValueLoadedData partialLoadedData) {
            if (partialLoadedData == null) {
                CreatedValueLoader.$$$reportNull$$$0(0);
            }
            this.partialLoadedData = partialLoadedData;
        }

        @Override
        public void loadValue(@NotNull LLValue value) throws ExecutionException, DebuggerCommandException {
            if (value == null) {
                CreatedValueLoader.$$$reportNull$$$0(1);
            }
            String id = this.partialLoadedData.id;
            GDBTuple varObj = GDBDriver.this.sendRequestAndWaitForDone("-var-evaluate-expression %s", DebuggerDriver.stringify(id)).getResultList();
            String val = varObj.getRequiredString("value");
            String displayHint = varObj.getString("displayhint", "");
            GDBDriver.doUpdateLoadedData(value, new LLValueLoadedData(id, this.partialLoadedData.fvKey, this.partialLoadedData.childrenCount, this.partialLoadedData.isDynamic, this.partialLoadedData.hasDynamicChildren, val, displayHint));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "partialLoadedData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$CreatedValueLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface LLValueLoader {
        public void loadValue(@NotNull LLValue var1) throws ExecutionException, DebuggerCommandException;
    }

    private static class LLValueLoadedData {
        @NotNull
        public final String id;
        @Nullable
        public final String fvKey;
        @Nullable
        public final Integer childrenCount;
        public final boolean isDynamic;
        public final boolean hasDynamicChildren;
        public final boolean isMap;
        @NotNull
        public final LLValueData data;

        LLValueLoadedData(@NotNull String id, @Nullable String fvKey, @Nullable Integer childrenCount, boolean isDynamic, boolean hasDynamicChildren, @NotNull String value, @Nullable String displayHint) {
            if (id == null) {
                LLValueLoadedData.$$$reportNull$$$0(0);
            }
            if (value == null) {
                LLValueLoadedData.$$$reportNull$$$0(1);
            }
            this.id = id;
            this.fvKey = fvKey;
            this.childrenCount = childrenCount;
            this.isDynamic = isDynamic;
            this.hasDynamicChildren = hasDynamicChildren;
            this.isMap = displayHint != null && "map".equals(displayHint.split("=", 2)[0]);
            String descriptionFromDisplayHint = LLValueLoadedData.extractDescriptionFromDisplayHint(displayHint);
            if (descriptionFromDisplayHint != null && value.equals("{...}")) {
                value = descriptionFromDisplayHint;
            }
            Pair<String, String> valueAndDescription = GDBDriver.getDescriptionFromValue(value);
            value = (String)valueAndDescription.first;
            String description = (String)valueAndDescription.second;
            boolean hasLongerDescription = description != null && description.length() >= 250;
            boolean mayHaveChildren = childrenCount != null && childrenCount > 0 || hasDynamicChildren || isDynamic;
            this.data = new LLValueData(value, description, hasLongerDescription, mayHaveChildren, isDynamic);
        }

        public boolean mayHaveChildren() {
            return this.data.mayHaveChildren();
        }

        @Nullable
        private static String extractDescriptionFromDisplayHint(@Nullable String displayHint) {
            int eqIndex;
            if (displayHint != null && (eqIndex = displayHint.indexOf(61)) != -1) {
                return displayHint.substring(eqIndex + 1);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$LLValueLoadedData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MapElement {
        @NotNull
        private final LLValue myKey;
        @NotNull
        private final LLValue myValue;

        MapElement(@NotNull LLValue key, @NotNull LLValue value) {
            if (key == null) {
                MapElement.$$$reportNull$$$0(0);
            }
            if (value == null) {
                MapElement.$$$reportNull$$$0(1);
            }
            this.myKey = key;
            this.myValue = value;
        }

        @NotNull
        public LLValue getKey() {
            LLValue lLValue = this.myKey;
            if (lLValue == null) {
                MapElement.$$$reportNull$$$0(2);
            }
            return lLValue;
        }

        @NotNull
        public LLValue getValue() {
            LLValue lLValue = this.myValue;
            if (lLValue == null) {
                MapElement.$$$reportNull$$$0(3);
            }
            return lLValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$MapElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$MapElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ErrorResponse
    implements Response {
        @NotNull
        private final NotNullProducer<ExecutionException> myErrorSupplier;

        ErrorResponse(@Nullable Throwable throwable) {
            this((NotNullProducer<ExecutionException>)((NotNullProducer)() -> new ExecutionException(throwable)));
        }

        ErrorResponse(@NlsContexts.DialogMessage @Nullable String message, @Nullable Throwable throwable) {
            this((NotNullProducer<ExecutionException>)((NotNullProducer)() -> new ExecutionException(message, throwable)));
        }

        ErrorResponse(@NotNull NotNullProducer<ExecutionException> errorSupplier) {
            if (errorSupplier == null) {
                ErrorResponse.$$$reportNull$$$0(0);
            }
            this.myErrorSupplier = errorSupplier;
        }

        @NotNull
        public ExecutionException getError() {
            ExecutionException executionException = (ExecutionException)((Object)this.myErrorSupplier.produce());
            if (executionException == null) {
                ErrorResponse.$$$reportNull$$$0(1);
            }
            return executionException;
        }

        @Override
        @NotNull
        public GDBResponse.Record getRecord() throws ExecutionException {
            throw this.getError();
        }

        @Override
        @NotNull
        public String getOutput() throws ExecutionException {
            throw this.getError();
        }

        @Override
        public void checkError() throws ExecutionException {
            throw this.getError();
        }

        @Override
        public int getReceivedSignalCount() throws ExecutionException {
            throw this.getError();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorSupplier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ErrorResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ErrorResponse";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getError";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ResultResponse
    implements Response {
        @NotNull
        private final GDBResponse.Record myRecord;
        @NotNull
        private final String myOutput;
        private final int myReceivedSignalCount;

        ResultResponse(@NotNull GDBResponse.Record record, @NotNull String output, int receivedSignalCount) {
            if (record == null) {
                ResultResponse.$$$reportNull$$$0(0);
            }
            if (output == null) {
                ResultResponse.$$$reportNull$$$0(1);
            }
            this.myRecord = record;
            this.myOutput = output;
            this.myReceivedSignalCount = receivedSignalCount;
        }

        @Override
        @NotNull
        public GDBResponse.Record getRecord() {
            GDBResponse.Record record = this.myRecord;
            if (record == null) {
                ResultResponse.$$$reportNull$$$0(2);
            }
            return record;
        }

        @Override
        @NotNull
        public String getOutput() {
            String string = this.myOutput;
            if (string == null) {
                ResultResponse.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public int getReceivedSignalCount() {
            return this.myReceivedSignalCount;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "record";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ResultResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ResultResponse";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecord";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOutput";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static interface Response {
        public static final Response NULL = new Response(){

            @Override
            @NotNull
            public GDBResponse.Record getRecord() {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public String getOutput() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getReceivedSignalCount() {
                throw new UnsupportedOperationException();
            }
        };

        @NotNull
        public GDBResponse.Record getRecord() throws ExecutionException;

        @NotNull
        default public GDBTuple getResultList() throws ExecutionException {
            GDBTuple gDBTuple = this.getRecord().getResultList();
            if (gDBTuple == null) {
                Response.$$$reportNull$$$0(0);
            }
            return gDBTuple;
        }

        @NlsSafe
        @NotNull
        public String getOutput() throws ExecutionException;

        default public void checkError() throws ExecutionException {
        }

        @NotNull
        default public GDBCommandException createGDBError() throws ExecutionException {
            String errorMessage = this.getGDBErrorMessage();
            if (errorMessage == null) {
                errorMessage = "Unknown GDB error";
            }
            return new GDBCommandException(this, errorMessage);
        }

        @Nullable
        default public String getGDBErrorMessage() throws ExecutionException {
            return this.getRecord().getResultList().getString("msg");
        }

        public int getReceivedSignalCount() throws ExecutionException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Response", "getResultList"));
        }
    }

    protected class Request {
        @NotNull
        private final String myCommand;
        private boolean mySuppressOutputEvent;
        private boolean mySuppressRunningEvent;
        private boolean mySuppressTargetFinishedEvent;
        private boolean mySuppressRunningResult;
        @NotNull
        private ThreadPlan myThreadPlan;
        private boolean myTearDownRequest;

        public Request(String command) {
            if (command == null) {
                Request.$$$reportNull$$$0(0);
            }
            this.myThreadPlan = ThreadPlan.DEFAULT;
            this.myCommand = command;
        }

        @NotNull
        public Communication send() throws ExecutionException {
            Communication communication = new Communication(GDBDriver.this, this.myCommand, this.mySuppressOutputEvent, this.mySuppressRunningEvent, this.mySuppressTargetFinishedEvent, this.mySuppressRunningResult, this.myTearDownRequest, this.myThreadPlan);
            communication.initiate();
            Communication communication2 = communication;
            if (communication2 == null) {
                Request.$$$reportNull$$$0(1);
            }
            return communication2;
        }

        @NotNull
        public String getCommand() {
            String string = this.myCommand;
            if (string == null) {
                Request.$$$reportNull$$$0(2);
            }
            return string;
        }

        public Request suppressAll() {
            return this.suppressOutputEvent().suppressRunningEvent().suppressRunningResult();
        }

        public Request suppressOutputEvent() {
            return this.suppressOutputEvent(true);
        }

        public Request suppressOutputEvent(boolean suppressOutputEvent) {
            this.mySuppressOutputEvent = suppressOutputEvent;
            return this;
        }

        public Request suppressRunningEvent() {
            return this.suppressRunningEvent(true);
        }

        public Request suppressRunningEvent(boolean suppressRunningEvent) {
            this.mySuppressRunningEvent = suppressRunningEvent;
            return this;
        }

        public Request suppressTargetFinishedEvent() {
            return this.suppressTargetFinishedEvent(true);
        }

        public Request suppressTargetFinishedEvent(boolean suppressTargetFinishedEvent) {
            this.mySuppressTargetFinishedEvent = suppressTargetFinishedEvent;
            return this;
        }

        public Request suppressRunningResult() {
            return this.suppressRunningResult(true);
        }

        public Request suppressRunningResult(boolean suppressRunningResult) {
            this.mySuppressRunningResult = suppressRunningResult;
            return this;
        }

        private Request tearDownRequest(boolean tearDownRequest) {
            this.myTearDownRequest = tearDownRequest;
            return this;
        }

        public Request withThreadPlan(@Nullable ThreadPlan threadPlan) {
            this.myThreadPlan = threadPlan != null ? threadPlan : ThreadPlan.DEFAULT;
            return this;
        }

        public Request onSteppingFinished(@Nullable ThreadPlan.SteppingFinished threadPlan) {
            return this.withThreadPlan(threadPlan);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Request";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Request";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "send";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class ConsoleCommand<T>
    extends EvaluationCommand<T> {
        ConsoleCommand(@NotNull String expression) {
            if (expression == null) {
                ConsoleCommand.$$$reportNull$$$0(0);
            }
            super(expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ConsoleCommand", "<init>"));
        }
    }

    protected static abstract class EvaluationCommand<T>
    implements SuspendedCommand<T> {
        @NotNull
        private final String myExpression;

        public EvaluationCommand(@NotNull String expression) {
            if (expression == null) {
                EvaluationCommand.$$$reportNull$$$0(0);
            }
            this.myExpression = expression;
        }

        @NotNull
        public String getExpression() {
            String string = this.myExpression;
            if (string == null) {
                EvaluationCommand.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public long getTimeout() {
            return GDBDriver.getEvaluationTimeoutMs();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$EvaluationCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$EvaluationCommand";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface SuspendedCommand<T>
    extends Command<T> {
    }

    protected static interface DestroyCommand
    extends Command<Boolean> {
        @Override
        default public long getTimeout() {
            return 1500L;
        }
    }

    protected abstract class AttachConnectCommand
    implements LaunchCommand {
        protected AttachConnectCommand() {
        }

        @Override
        @NotNull
        public Integer call() throws ExecutionException, DebuggerCommandException {
            int pid;
            GDBDriver.this.myPendingForAttachNotification.down();
            try {
                pid = this.attach();
                GDBDriver.waitForSemaphore(GDBDriver.this.myPendingForAttachNotification);
            }
            finally {
                GDBDriver.this.myPendingForAttachNotification.up();
            }
            GDBDriver.this.doSelectWinbreakBinary();
            this.whenAttached();
            GDBDriver.this.sendRequestAndWaitForRunning("-exec-continue", new Object[0]);
            Integer n = pid;
            if (n == null) {
                AttachConnectCommand.$$$reportNull$$$0(0);
            }
            return n;
        }

        protected abstract int attach() throws ExecutionException, DebuggerCommandException;

        protected abstract void whenAttached() throws ExecutionException, DebuggerCommandException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$AttachConnectCommand", "call"));
        }
    }

    protected static interface LaunchCommand
    extends StartCommand<Integer> {
    }

    protected static interface LoadingCommand
    extends StartCommand<Void>,
    VoidCommand {
    }

    protected static interface StartCommand<T>
    extends Command<T> {
        @Override
        default public long getTimeout() {
            return GDBDriver.getLoadTimeoutMs();
        }
    }

    protected static interface VoidCommand
    extends Command<Void> {
        @Override
        @Nullable
        default public Void call() throws ExecutionException, DebuggerCommandException {
            this.run();
            return null;
        }

        public void run() throws ExecutionException, DebuggerCommandException;
    }

    public static interface Command<T> {
        @Nullable
        public T call() throws ExecutionException, DebuggerCommandException;

        default public long getTimeout() {
            return GDBDriver.getTimeoutMs();
        }
    }

    protected class Communication {
        private static final String GDB_POKE_COMMAND = "0-gdb-set $__poke_gdb=1";
        @NotNull
        public final String command;
        public final boolean suppressOutputEvent;
        public final boolean suppressRunningEvent;
        public final boolean suppressTargetFinishedEvent;
        public final boolean suppressRunningResult;
        public final boolean tearDownRequest;
        @NotNull
        public final ThreadPlan myThreadPlan;
        @NotNull
        public final StringBuffer consoleOutput;
        public int receivedSignalCount;
        final /* synthetic */ GDBDriver this$0;

        public Communication(@NotNull GDBDriver this$0, String command) {
            if (command == null) {
                Communication.$$$reportNull$$$0(0);
            }
            this(this$0, command, false, false, false, false, false, ThreadPlan.DEFAULT);
        }

        public Communication(@NotNull GDBDriver this$0, String command, boolean suppressOutputEvent, boolean suppressRunningEvent, boolean suppressTargetFinishedEvent, boolean suppressRunningResult, @NotNull boolean tearDownRequest, ThreadPlan threadPlan) {
            if (command == null) {
                Communication.$$$reportNull$$$0(1);
            }
            if (threadPlan == null) {
                Communication.$$$reportNull$$$0(2);
            }
            this.this$0 = this$0;
            this.consoleOutput = new StringBuffer();
            this.command = command;
            CidrDebuggerLog.LOG.assertTrue(!StringUtil.containsLineBreak((CharSequence)command) || this.isMultilineCommand(), (Object)("MI command must not contain unescaped newlines: " + command));
            this.suppressOutputEvent = suppressOutputEvent;
            this.suppressRunningEvent = suppressRunningEvent;
            this.suppressTargetFinishedEvent = suppressTargetFinishedEvent;
            this.suppressRunningResult = suppressRunningResult;
            this.tearDownRequest = tearDownRequest;
            this.myThreadPlan = threadPlan;
        }

        protected boolean isMultilineCommand() {
            int promptLevel = this.this$0.getPromptLevel();
            return promptLevel == 1 && this.command.equals("end") || promptLevel == 0 && this.command.endsWith("\nend");
        }

        protected boolean usePokeCommandWorkaround() {
            if (this.this$0.isLinux() && this.command.startsWith("-exec-run")) {
                return true;
            }
            if (this.this$0.isLinux() && this.command.startsWith("-target-attach")) {
                return true;
            }
            return this.this$0.isWindows() && this.isMultilineCommand();
        }

        public void initiate() throws ExecutionException {
            this.this$0.sendRequestOrSpecialCommunication(this.command, this.tearDownRequest, (ThrowableRunnable<? extends ExecutionException>)((ThrowableRunnable)() -> {
                this.this$0.myCommunication = this;
                this.doInitiate();
            }));
        }

        public void doInitiate() throws ExecutionException {
            this.doWrite(this.command);
            if (this.usePokeCommandWorkaround()) {
                this.doWrite(GDB_POKE_COMMAND);
            }
        }

        protected void doWrite(@NotNull String command) throws ExecutionException {
            if (command == null) {
                Communication.$$$reportNull$$$0(3);
            }
            try {
                this.doWriteIO(command);
            }
            catch (IOException e) {
                if (this.this$0.isTerminated()) {
                    throw new ExecutionFinishedException((Throwable)e);
                }
                throw new ExecutionException(GDBBundle.message("error.cannot.send.request", new Object[0]), (Throwable)e);
            }
        }

        protected void doWriteIO(@NotNull String command) throws IOException {
            if (command == null) {
                Communication.$$$reportNull$$$0(4);
            }
            if (CidrDebuggerLog.LOG.isDebugEnabled()) {
                CidrDebuggerLog.LOG.debug(">" + command);
            }
            this.this$0.mySink.write(command + "\n");
            this.this$0.mySink.flush();
        }

        public Response createResponse(@NotNull GDBResponse.Record record) {
            if (record == null) {
                Communication.$$$reportNull$$$0(5);
            }
            return new ResultResponse(record, this.consoleOutput.toString(), this.receivedSignalCount);
        }

        public Response waitAndPokeForPrompt(int timeoutMs) throws ExecutionException {
            return this.doWaitForResponse(true, timeoutMs);
        }

        @NotNull
        public Response waitFor(GDBResponse.ResultRecord.Type ... expectedTypes) throws ExecutionException, GDBCommandException {
            if (expectedTypes == null) {
                Communication.$$$reportNull$$$0(6);
            }
            Response response = this.doWaitForResponse(false, 0);
            GDBResponse.Record result2 = response.getRecord();
            Object resultType = result2.getType();
            if (expectedTypes.length == 0 || ArrayUtil.contains(resultType, (Object[])expectedTypes)) {
                Response response2 = response;
                if (response2 == null) {
                    Communication.$$$reportNull$$$0(7);
                }
                return response2;
            }
            String errorMessage = response.getGDBErrorMessage();
            if (!"-exec-interrupt".equals(this.command) || !GDBDriver.INFERIOR_NOT_EXECUTING.equals(errorMessage)) {
                CidrDebuggerLog.LOG.warn(">" + this.command);
                CidrDebuggerLog.LOG.warn("<" + result2);
            }
            if (this.this$0.getState() != DebuggerDriver.TargetState.NOT_READY) {
                if ("ptrace: No such process.".equals(errorMessage)) {
                    this.this$0.handleTargetTerminated();
                    throw new ExecutionFinishedException();
                }
                if (this.this$0.getState() == DebuggerDriver.TargetState.FINISHED && ArrayUtil.contains((Object)GDBResponse.ResultRecord.Type.running, (Object[])expectedTypes)) {
                    throw new ExecutionFinishedException();
                }
            }
            if (resultType == GDBResponse.ResultRecord.Type.error) {
                throw response.createGDBError();
            }
            throw GDBDriver.unexpectedResponse(result2);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        private Response doWaitForResponse(boolean isConsoleCommand, int timeoutMs) throws ExecutionException {
            try {
                Response response;
                CidrEventSpan ignored = new CidrEventSpan("debug", "doWaitForResponse", (Object)this.command);
                int timeoutElapsedMs = 0;
                int timeoutStepMs = 125;
                int EXP_BACK_OFF = 2;
                while (true) {
                    Response response2;
                    if ((response2 = this.this$0.myResultQueue.poll(timeoutStepMs, TimeUnit.MILLISECONDS)) == null) break block11;
                    response = response2;
                    break;
                }
                {
                    catch (Throwable throwable) {
                        try {
                            ignored.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                {
                    block11: {
                        ignored.close();
                        Response response3 = response;
                        if (response3 != null) return response3;
                        Communication.$$$reportNull$$$0(8);
                        return response3;
                    }
                    if (timeoutMs > 0 && (timeoutElapsedMs += timeoutStepMs) > timeoutMs) {
                        throw new ExecutionException(GDBBundle.message("error.no.result.response.or.multiline.prompt.within.reasonable.amount.time", new Object[0]));
                    }
                    if (isConsoleCommand) {
                        this.doWrite("\n");
                    }
                    timeoutStepMs *= 2;
                    continue;
                }
            }
            catch (InterruptedException e) {
                throw new ExecutionException(GDBBundle.message("error.execution.interrupted", new Object[0]), (Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threadPlan";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "record";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectedTypes";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Communication";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Communication";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "waitFor";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doWaitForResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doWrite";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "doWriteIO";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createResponse";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "waitFor";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static interface ThreadPlan {
        public static final ThreadPlan DEFAULT = new ThreadPlan(){};

        default public boolean onSteppingFinished(@NotNull DebuggerDriver.StopPlace stopPlace) throws ExecutionException {
            if (stopPlace == null) {
                ThreadPlan.$$$reportNull$$$0(0);
            }
            return true;
        }

        default public boolean onBreakpointHit(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) throws ExecutionException {
            if (stopPlace == null) {
                ThreadPlan.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "stopPlace";
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ThreadPlan";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onSteppingFinished";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onBreakpointHit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        @FunctionalInterface
        public static interface BreakpointHit
        extends ThreadPlan {
            @Override
            public boolean onBreakpointHit(@NotNull DebuggerDriver.StopPlace var1, int var2) throws ExecutionException;
        }

        @FunctionalInterface
        public static interface SteppingFinished
        extends ThreadPlan {
            @Override
            public boolean onSteppingFinished(@NotNull DebuggerDriver.StopPlace var1) throws ExecutionException;
        }
    }

    private static class StructChildrenVisitor {
        private StructChildrenVisitor() {
        }

        boolean visitRealChild(@NotNull GDBTuple child) {
            if (child == null) {
                StructChildrenVisitor.$$$reportNull$$$0(0);
            }
            return true;
        }

        boolean visitFakeChild(@NotNull LLValue fakeChild, int childrenCount) throws ExecutionException, DebuggerCommandException {
            if (fakeChild == null) {
                StructChildrenVisitor.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fakeChild";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$StructChildrenVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRealChild";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFakeChild";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface MIResponseFilter
    extends BiFunction<String, String, String> {
        @Override
        public String apply(@NotNull String var1, @NotNull String var2);
    }
}

