/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GDBDriverConfiguration
extends DebuggerDriverConfiguration {
    @Override
    @NotNull
    @NlsSafe
    public String getDriverName() {
        return "GDB";
    }

    @Override
    public boolean isAttachSupported() {
        return !SystemInfo.isMac;
    }

    @Override
    @NotNull
    public DebuggerDriver createDriver(@NotNull DebuggerDriver.Handler handler, @NotNull ArchitectureType architectureType) throws ExecutionException {
        if (handler == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(0);
        }
        if (architectureType == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(1);
        }
        return new GDBDriver(handler, this, architectureType);
    }

    @Override
    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver, @NotNull ArchitectureType architectureType) throws ExecutionException {
        if (driver == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(2);
        }
        if (architectureType == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(3);
        }
        GeneralCommandLine result2 = new GeneralCommandLine();
        result2.setExePath(this.getGDBExecutablePath());
        GDBDriverConfiguration.setupCommonParameters(result2);
        result2.addParameters(new String[]{"--interpreter=mi2"});
        result2.putUserData(GDBDriver.PRETTY_PRINTERS_PATH, (Object)FileUtil.toSystemIndependentName((String)CidrDebuggerPathManager.getBundledGDBSTLPrettyPrinters().getAbsolutePath()));
        result2.putUserData(GDBDriver.ENABLE_STL_PRETTY_PRINTERS, (Object)CidrDebuggerSettings.getInstance().STL_RENDERERS_ENABLED);
        GeneralCommandLine generalCommandLine = result2;
        if (generalCommandLine == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(4);
        }
        return generalCommandLine;
    }

    @NotNull
    protected String getGDBExecutablePath() {
        String string = CidrDebuggerPathManager.getBundledGDBBinary().getAbsolutePath();
        if (string == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(5);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, long threadId, int frameIndex, @NotNull UserDataHolderEx userDataHolderEx) {
        void cacheHolder;
        if (driver == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(6);
        }
        if (userDataHolderEx == null) {
            GDBDriverConfiguration.$$$reportNull$$$0(7);
        }
        return new EvaluationContext(driver, expirable, threadId, frameIndex, (UserDataHolderEx)cacheHolder){

            @Override
            @NotNull
            public String convertToRValue(@NotNull LLValueData rValue, @NotNull Pair<LLValue, String> valuePair) {
                if (rValue == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (valuePair == null) {
                    1.$$$reportNull$$$0(1);
                }
                String string = 1.cast((String)valuePair.getSecond(), ((LLValue)((Object)valuePair.getFirst())).getType());
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rValue";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "valuePair";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriverConfiguration$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriverConfiguration$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convertToRValue";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "convertToRValue";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "architectureType";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriverConfiguration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriverConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDriverCommandLine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGDBExecutablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDriver";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDriverCommandLine";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createEvaluationContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

