/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.PathUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCodePointHandlerBase;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrLineBreakpointType;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class CidrBreakpointHandler
extends CidrCodePointHandlerBase<XLineBreakpoint<?>> {
    public CidrBreakpointHandler(CidrDebugProcess process) {
        this(process, (Class<? extends XLineBreakpointType<?>>)CidrLineBreakpointType.class);
    }

    public CidrBreakpointHandler(CidrDebugProcess process, @NotNull Class<? extends XLineBreakpointType<?>> type) {
        if (type == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(0);
        }
        super(process, type);
    }

    @Override
    protected Collection<LLCodepoint> addCodepointsInBackend(DebuggerDriver driver, XLineBreakpoint<?> breakpoint, long threadId, int frameIndex) throws ExecutionException {
        LLBreakpoint result2;
        CidrLineBreakpointType.Properties properties;
        String condition = this.convertCondition((XBreakpoint<? extends XBreakpointProperties>)breakpoint);
        String path = VfsUtilCore.urlToPath((String)breakpoint.getFileUrl());
        boolean ignoreSourceHash = false;
        if (breakpoint.getProperties() instanceof CidrLineBreakpointType.Properties && (properties = (CidrLineBreakpointType.Properties)breakpoint.getProperties()) != null && properties.isRelaxedMatch()) {
            path = PathUtil.getFileName((String)path);
            ignoreSourceHash = true;
        }
        try {
            result2 = driver.addBreakpoint(path, breakpoint.getLine(), condition, ignoreSourceHash);
        }
        catch (DebuggerCommandException e) {
            this.myProcess.getSession().setBreakpointInvalid(breakpoint, e.getMessage());
            return Collections.emptyList();
        }
        this.updateBreakpointPresentation(breakpoint, result2);
        return Collections.singletonList(result2);
    }

    public void handleBreakpointAdded(@NotNull LLBreakpoint newBreakpoint) {
        if (newBreakpoint == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(1);
        }
    }

    public void handleBreakpointRemoved(@NotNull XLineBreakpoint<?> uiBreakpoint) {
        if (uiBreakpoint == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(2);
        }
    }

    public void handleBreakpointUpdated(@NotNull XLineBreakpoint<?> uiBreakpoint, @NotNull LLBreakpoint newBreakpoint) {
        if (uiBreakpoint == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(3);
        }
        if (newBreakpoint == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(4);
        }
        this.unregisterCodepointsMapping(uiBreakpoint);
        this.registerCodepointsMapping(uiBreakpoint, Collections.singletonList(newBreakpoint));
        this.updateBreakpointPresentation(uiBreakpoint, newBreakpoint);
    }

    private void updateBreakpointPresentation(@NotNull XLineBreakpoint<?> uiBreakpoint, @NotNull LLBreakpoint breakpoint) {
        if (uiBreakpoint == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(5);
        }
        if (breakpoint == null) {
            CidrBreakpointHandler.$$$reportNull$$$0(6);
        }
        if (!breakpoint.isPending()) {
            this.myProcess.getSession().setBreakpointVerified(uiBreakpoint);
        } else {
            this.myProcess.getSession().setBreakpointInvalid(uiBreakpoint, CidrDebuggerBundle.message("debug.breakpoint.line.unresolved.hint", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBreakpoint";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiBreakpoint";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrBreakpointHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleBreakpointAdded";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleBreakpointRemoved";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "handleBreakpointUpdated";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateBreakpointPresentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

