/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u0012\u0010\u0007\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002\u001a&\u0010\u0007\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0086\b\u00f8\u0001\u0000\u001a\u001d\u0010\f\u001a\u0002H\r\"\f\b\u0000\u0010\r*\u0006\u0012\u0002\b\u00030\u000e*\u0002H\r\u00a2\u0006\u0002\u0010\u000f\u001a1\u0010\f\u001a\u0002H\r\"\f\b\u0000\u0010\r*\u0006\u0012\u0002\b\u00030\u000e*\u0002H\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u001a\u0012\u0010\u0011\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0014\u0010\u0014\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u001a\u0010\u0017\u001a\u00020\u0002*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0087\u0006\u00a2\u0006\u0002\b\u0019\u001a\u001a\u0010\u001a\u001a\u00020\u0002*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0087\u0004\u00a2\u0006\u0002\b\u001b\u001a\u0012\u0010\u001c\u001a\u00020\u0013*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\b\u001a\u00020\u0002\u001a&\u0010\u001d\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\b\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0086\b\u00f8\u0001\u0000\u001a\u0012\u0010\u001d\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002\u001a&\u0010\u001d\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0086\b\u00f8\u0001\u0000\u001a\u001d\u0010\u001e\u001a\u0002H\r\"\f\b\u0000\u0010\r*\u0006\u0012\u0002\b\u00030\u000e*\u0002H\r\u00a2\u0006\u0002\u0010\u000f\u001a1\u0010\u001e\u001a\u0002H\r\"\f\b\u0000\u0010\r*\u0006\u0012\u0002\b\u00030\u000e*\u0002H\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u001a\u0012\u0010\u001f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010\u001f\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010 \u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010 \u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\"*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010#\u001a\u00020\u0002*\u00020\u00012\u0006\u0010$\u001a\u00020%\u001a\u0019\u0010&\u001a\u00020\u0002*\u00020\u00012\u0006\u0010'\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\b(\u001a\u0012\u0010&\u001a\u00020\u0002*\u00020\u00012\u0006\u0010)\u001a\u00020\u0016\u001a\u0015\u0010*\u001a\u00020\u0002*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0086\u0004\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006+"}, d2={"endCoerced", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getEndCoerced", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;)Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "endExclusive", "getEndExclusive", "checkInRange", "range", "lazyMessage", "Lkotlin/Function0;", "", "checkNotEmpty", "T", "Lkotlin/ranges/ClosedRange;", "(Lkotlin/ranges/ClosedRange;)Lkotlin/ranges/ClosedRange;", "(Lkotlin/ranges/ClosedRange;Lkotlin/jvm/functions/Function0;)Lkotlin/ranges/ClosedRange;", "grow", "boundary", "", "positiveReminder", "n", "", "rangeTo", "endInclusive", "addressRangeInclusive", "rangeToExclusive", "addressRangeExclusive", "reminder", "requireInRange", "requireNotEmpty", "roundDown", "roundUp", "slice", "Lkotlin/sequences/Sequence;", "toAlignedBlockRange", "blockSize", "", "toRange", "offsetBytes", "addressToRange", "bytes", "until", "intellij.cidr.debugger.backend"})
@JvmName(name="AddressUtil")
public final class AddressUtil {
    @NotNull
    public static final <T extends ClosedRange<?>> T checkNotEmpty(@NotNull T $this$checkNotEmpty) {
        Intrinsics.checkNotNullParameter($this$checkNotEmpty, (String)"$this$checkNotEmpty");
        T $this$checkNotEmpty$iv = $this$checkNotEmpty;
        boolean $i$f$checkNotEmpty = false;
        T t = $this$checkNotEmpty$iv;
        boolean bl = false;
        boolean bl2 = false;
        T $this$apply$iv = t;
        boolean bl3 = false;
        boolean bl4 = !$this$apply$iv.isEmpty();
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = "Range must not be empty";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return t;
    }

    @NotNull
    public static final <T extends ClosedRange<?>> T checkNotEmpty(@NotNull T $this$checkNotEmpty, @NotNull Function0<? extends Object> lazyMessage) {
        int $i$f$checkNotEmpty = 0;
        Intrinsics.checkNotNullParameter($this$checkNotEmpty, (String)"$this$checkNotEmpty");
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        T t = $this$checkNotEmpty;
        boolean bl = false;
        boolean bl2 = false;
        T $this$apply = t;
        boolean bl3 = false;
        boolean bl4 = !$this$apply.isEmpty();
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            Object object = lazyMessage.invoke();
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return t;
    }

    @NotNull
    public static final <T extends ClosedRange<?>> T requireNotEmpty(@NotNull T $this$requireNotEmpty) {
        Intrinsics.checkNotNullParameter($this$requireNotEmpty, (String)"$this$requireNotEmpty");
        T $this$requireNotEmpty$iv = $this$requireNotEmpty;
        boolean $i$f$requireNotEmpty = false;
        T t = $this$requireNotEmpty$iv;
        boolean bl = false;
        boolean bl2 = false;
        T $this$apply$iv = t;
        boolean bl3 = false;
        boolean bl4 = !$this$apply$iv.isEmpty();
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = "Range must not be empty";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return t;
    }

    @NotNull
    public static final <T extends ClosedRange<?>> T requireNotEmpty(@NotNull T $this$requireNotEmpty, @NotNull Function0<? extends Object> lazyMessage) {
        int $i$f$requireNotEmpty = 0;
        Intrinsics.checkNotNullParameter($this$requireNotEmpty, (String)"$this$requireNotEmpty");
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        T t = $this$requireNotEmpty;
        boolean bl = false;
        boolean bl2 = false;
        T $this$apply = t;
        boolean bl3 = false;
        boolean bl4 = !$this$apply.isEmpty();
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            Object object = lazyMessage.invoke();
            throw (Throwable)new IllegalArgumentException(object.toString());
        }
        return t;
    }

    @NotNull
    public static final AddressRange checkInRange(@NotNull AddressRange $this$checkInRange, @NotNull AddressRange range) {
        Intrinsics.checkNotNullParameter((Object)$this$checkInRange, (String)"$this$checkInRange");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        AddressRange $this$checkInRange$iv = $this$checkInRange;
        boolean $i$f$checkInRange = false;
        AddressRange addressRange = $this$checkInRange$iv;
        boolean bl = false;
        boolean bl2 = false;
        AddressRange $this$apply$iv = addressRange;
        boolean bl3 = false;
        boolean bl4 = range.contains($this$apply$iv);
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = "Range " + $this$checkInRange + " spans beyond the allowed " + range;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return addressRange;
    }

    @NotNull
    public static final AddressRange checkInRange(@NotNull AddressRange $this$checkInRange, @NotNull AddressRange range, @NotNull Function0<? extends Object> lazyMessage) {
        int $i$f$checkInRange = 0;
        Intrinsics.checkNotNullParameter((Object)$this$checkInRange, (String)"$this$checkInRange");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        AddressRange addressRange = $this$checkInRange;
        boolean bl = false;
        boolean bl2 = false;
        AddressRange $this$apply = addressRange;
        boolean bl3 = false;
        boolean bl4 = range.contains($this$apply);
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            Object object = lazyMessage.invoke();
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return addressRange;
    }

    @NotNull
    public static final Address requireInRange(@NotNull Address $this$requireInRange, @NotNull AddressRange range) {
        Intrinsics.checkNotNullParameter((Object)$this$requireInRange, (String)"$this$requireInRange");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Address $this$requireInRange$iv = $this$requireInRange;
        boolean $i$f$requireInRange = false;
        Address address = $this$requireInRange$iv;
        boolean bl = false;
        boolean bl2 = false;
        Address $this$apply$iv = address;
        boolean bl3 = false;
        boolean bl4 = range.contains((Comparable)$this$apply$iv);
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = "Address " + $this$requireInRange + " must be within " + range;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return address;
    }

    @NotNull
    public static final Address requireInRange(@NotNull Address $this$requireInRange, @NotNull AddressRange range, @NotNull Function0<? extends Object> lazyMessage) {
        int $i$f$requireInRange = 0;
        Intrinsics.checkNotNullParameter((Object)$this$requireInRange, (String)"$this$requireInRange");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        Address address = $this$requireInRange;
        boolean bl = false;
        boolean bl2 = false;
        Address $this$apply = address;
        boolean bl3 = false;
        boolean bl4 = range.contains((Comparable)$this$apply);
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            Object object = lazyMessage.invoke();
            throw (Throwable)new IllegalArgumentException(object.toString());
        }
        return address;
    }

    @NotNull
    public static final AddressRange requireInRange(@NotNull AddressRange $this$requireInRange, @NotNull AddressRange range) {
        Intrinsics.checkNotNullParameter((Object)$this$requireInRange, (String)"$this$requireInRange");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        AddressRange $this$requireInRange$iv = $this$requireInRange;
        boolean $i$f$requireInRange = false;
        AddressRange addressRange = $this$requireInRange$iv;
        boolean bl = false;
        boolean bl2 = false;
        AddressRange $this$apply$iv = addressRange;
        boolean bl3 = false;
        boolean bl4 = range.contains($this$apply$iv);
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = "Range " + $this$requireInRange + " must be within " + range;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return addressRange;
    }

    @NotNull
    public static final AddressRange requireInRange(@NotNull AddressRange $this$requireInRange, @NotNull AddressRange range, @NotNull Function0<? extends Object> lazyMessage) {
        int $i$f$requireInRange = 0;
        Intrinsics.checkNotNullParameter((Object)$this$requireInRange, (String)"$this$requireInRange");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        AddressRange addressRange = $this$requireInRange;
        boolean bl = false;
        boolean bl2 = false;
        AddressRange $this$apply = addressRange;
        boolean bl3 = false;
        boolean bl4 = range.contains($this$apply);
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            Object object = lazyMessage.invoke();
            throw (Throwable)new IllegalArgumentException(object.toString());
        }
        return addressRange;
    }

    @NotNull
    public static final Address getEndCoerced(@NotNull AddressRange $this$endCoerced) {
        Intrinsics.checkNotNullParameter((Object)$this$endCoerced, (String)"$this$endCoerced");
        return $this$endCoerced.getEndInclusive().plus(Address.Companion.getCoercing(1));
    }

    @NotNull
    public static final Address getEndExclusive(@NotNull AddressRange $this$endExclusive) {
        Intrinsics.checkNotNullParameter((Object)$this$endExclusive, (String)"$this$endExclusive");
        return $this$endExclusive.getEndInclusive().plus(1);
    }

    @NotNull
    public static final AddressRange grow(@NotNull AddressRange $this$grow, long boundary) {
        Intrinsics.checkNotNullParameter((Object)$this$grow, (String)"$this$grow");
        return AddressUtil.addressRangeExclusive(AddressUtil.roundDown($this$grow.getStart(), (Number)boundary), AddressUtil.roundUp(AddressUtil.getEndExclusive($this$grow), (Number)boundary));
    }

    @NotNull
    public static final Sequence<AddressRange> slice(@NotNull AddressRange $this$slice, long boundary) {
        Intrinsics.checkNotNullParameter((Object)$this$slice, (String)"$this$slice");
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super AddressRange>, Continuation<? super Unit>, Object>($this$slice, boundary, null){
            private /* synthetic */ Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ AddressRange $this_slice;
            final /* synthetic */ long $boundary;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        if (this.$this_slice.isEmpty()) {
                            return Unit.INSTANCE;
                        }
                        prev = this.$this_slice.getStart();
lbl10:
                        // 2 sources

                        while (true) {
                            next = (Address)RangesKt.coerceAtMost((Comparable)AddressUtil.roundUp(prev, (Number)Boxing.boxLong((long)this.$boundary)), (Comparable)this.$this_slice.getEndInclusive());
                            this.L$0 = $this$sequence;
                            this.L$1 = next;
                            this.label = 1;
                            v0 = $this$sequence.yield((Object)AddressUtil.addressRangeInclusive(prev, next), (Continuation)this);
                            if (v0 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl24
                            break;
                        }
                    }
                    case 1: {
                        next = (Address)this.L$1;
                        var2_3 = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        if (!Intrinsics.areEqual((Object)next, (Object)this.$this_slice.getEndInclusive())) {
                            prev = next.plus(Boxing.boxInt((int)1));
                            ** continue;
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$this_slice = addressRange;
                this.$boundary = l;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<SequenceScope<? super AddressRange>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                Object object = function2.L$0 = value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @JvmName(name="addressToRange")
    @NotNull
    public static final AddressRange addressToRange(@NotNull Address $this$toRange, long offsetBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$toRange, (String)"$this$toRange");
        return offsetBytes == 1L ? AddressUtil.addressRangeInclusive($this$toRange, $this$toRange) : (offsetBytes > 0L ? AddressUtil.addressRangeExclusive($this$toRange, $this$toRange.plus(offsetBytes)) : (offsetBytes < 0L ? AddressUtil.addressRangeExclusive($this$toRange.plus(offsetBytes), $this$toRange) : AddressRange.EMPTY));
    }

    @NotNull
    public static final AddressRange toRange(@NotNull Address $this$toRange, @NotNull Number bytes) {
        Intrinsics.checkNotNullParameter((Object)$this$toRange, (String)"$this$toRange");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return AddressUtil.addressToRange($this$toRange, bytes.longValue());
    }

    @NotNull
    public static final AddressRange toAlignedBlockRange(@NotNull Address $this$toAlignedBlockRange, int blockSize) {
        Intrinsics.checkNotNullParameter((Object)$this$toAlignedBlockRange, (String)"$this$toAlignedBlockRange");
        AddressRange addressRange = AddressUtil.toRange(AddressUtil.roundDown($this$toAlignedBlockRange, (Number)blockSize), blockSize);
        boolean bl = false;
        boolean bl2 = false;
        AddressRange it = addressRange;
        boolean bl3 = false;
        boolean bl4 = it.getSize() == (long)blockSize;
        boolean bl5 = false;
        boolean bl6 = false;
        if (_Assertions.ENABLED && !bl4) {
            boolean bl7 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return addressRange;
    }

    @NotNull
    public static final Address roundUp(@NotNull Address $this$roundUp, @NotNull Number n) {
        Intrinsics.checkNotNullParameter((Object)$this$roundUp, (String)"$this$roundUp");
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return Address.Companion.fromUnsignedLong(AddressUtil.roundUp($this$roundUp.getUnsignedLongValue(), n));
    }

    @NotNull
    public static final Address roundDown(@NotNull Address $this$roundDown, @NotNull Number n) {
        Intrinsics.checkNotNullParameter((Object)$this$roundDown, (String)"$this$roundDown");
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return Address.Companion.fromUnsignedLong(AddressUtil.roundDown($this$roundDown.getUnsignedLongValue(), n));
    }

    public static final long reminder(@NotNull Address $this$reminder, @NotNull Number n) {
        Intrinsics.checkNotNullParameter((Object)$this$reminder, (String)"$this$reminder");
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return AddressUtil.positiveReminder($this$reminder.getUnsignedLongValue(), n);
    }

    public static final long roundUp(long $this$roundUp, @NotNull Number n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return AddressUtil.roundDown($this$roundUp + n.longValue() - 1L, n);
    }

    public static final long roundDown(long $this$roundDown, @NotNull Number n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        return $this$roundDown - AddressUtil.positiveReminder($this$roundDown, n.longValue());
    }

    private static final long positiveReminder(long $this$positiveReminder, Number n) {
        long reminder;
        long l = n.longValue();
        return reminder + ((reminder = $this$positiveReminder % l) < 0L ? l : 0L);
    }

    @JvmName(name="addressRangeInclusive")
    @NotNull
    public static final AddressRange addressRangeInclusive(@NotNull Address $this$rangeTo, @NotNull Address endInclusive) {
        Intrinsics.checkNotNullParameter((Object)$this$rangeTo, (String)"$this$rangeTo");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        return new AddressRange($this$rangeTo, endInclusive);
    }

    @JvmName(name="addressRangeExclusive")
    @NotNull
    public static final AddressRange addressRangeExclusive(@NotNull Address $this$rangeToExclusive, @NotNull Address endExclusive) {
        Intrinsics.checkNotNullParameter((Object)$this$rangeToExclusive, (String)"$this$rangeToExclusive");
        Intrinsics.checkNotNullParameter((Object)endExclusive, (String)"endExclusive");
        return AddressUtil.addressRangeInclusive($this$rangeToExclusive, endExclusive.minus(1));
    }

    @NotNull
    public static final AddressRange until(@NotNull Address $this$until, @NotNull Address endExclusive) {
        Intrinsics.checkNotNullParameter((Object)$this$until, (String)"$this$until");
        Intrinsics.checkNotNullParameter((Object)endExclusive, (String)"endExclusive");
        return endExclusive.compareTo(Address.MIN_VALUE) <= 0 ? AddressRange.EMPTY : AddressUtil.addressRangeExclusive($this$until, endExclusive);
    }
}

