/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.ide.CopyPasteManager;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.MemoryLineInfoProvider;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0002'(B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010#\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010$\u001a\u00020\u0010H\u0016J\b\u0010%\u001a\u00020\u0010H\u0002J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/MemoryAddressGutterProvider;", "Lcom/intellij/openapi/editor/TextAnnotationGutterProvider;", "Lcom/intellij/openapi/editor/EditorGutterAction;", "model", "Lcom/jetbrains/cidr/execution/debugger/memory/MemoryLineInfoProvider;", "(Lcom/jetbrains/cidr/execution/debugger/memory/MemoryLineInfoProvider;)V", "isShowingAddresses", "", "()Z", "setShowingAddresses", "(Z)V", "getModel", "()Lcom/jetbrains/cidr/execution/debugger/memory/MemoryLineInfoProvider;", "toggleShowAddressesAction", "Lcom/jetbrains/cidr/execution/debugger/memory/MemoryAddressGutterProvider$ToggleShowAddressesAction;", "doAction", "", "lineNum", "", "getBgColor", "Ljava/awt/Color;", "line", "editor", "Lcom/intellij/openapi/editor/Editor;", "getColor", "Lcom/intellij/openapi/editor/colors/ColorKey;", "getCursor", "Ljava/awt/Cursor;", "getLineText", "", "getPopupActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "getStyle", "Lcom/intellij/openapi/editor/colors/EditorFontType;", "getToolTip", "gutterClosed", "updateAllEditors", "updateEditor", "CopyAddressAction", "ToggleShowAddressesAction", "intellij.cidr.debugger"})
public final class MemoryAddressGutterProvider
implements TextAnnotationGutterProvider,
EditorGutterAction {
    private boolean isShowingAddresses;
    private final ToggleShowAddressesAction toggleShowAddressesAction;
    @NotNull
    private final MemoryLineInfoProvider model;

    public final boolean isShowingAddresses() {
        return this.isShowingAddresses;
    }

    public final void setShowingAddresses(boolean bl) {
        this.isShowingAddresses = bl;
    }

    @Nullable
    public String getLineText(int line, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!this.isShowingAddresses) {
            return " ";
        }
        Address address = this.model.getAddressForLine(line);
        if (address == null) {
            return StringsKt.repeat((CharSequence)" ", (int)19);
        }
        Intrinsics.checkNotNullExpressionValue((Object)address, (String)"model.getAddressForLine(\u2026 ?: return \" \".repeat(19)");
        Address address2 = address;
        return "" + ' ' + address2;
    }

    @Nullable
    public String getToolTip(int line, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (this.isShowingAddresses) {
            return null;
        }
        Address address = this.model.getAddressForLine(line);
        String addr = address != null ? address.toString() : null;
        return addr;
    }

    @NotNull
    public EditorFontType getStyle(int line, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return EditorFontType.BOLD;
    }

    @Nullable
    public ColorKey getColor(int line, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return EditorColors.LINE_NUMBERS_COLOR;
    }

    @Nullable
    public Color getBgColor(int line, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return null;
    }

    @NotNull
    public List<AnAction> getPopupActions(int line, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return CollectionsKt.listOf((Object[])new AnAction[]{new CopyAddressAction(this.model.getAddressForLine(line)), (AnAction)this.toggleShowAddressesAction});
    }

    public void gutterClosed() {
    }

    public void doAction(int lineNum) {
        if (!this.isShowingAddresses) {
            this.isShowingAddresses = true;
            this.updateAllEditors();
        }
    }

    @NotNull
    public Cursor getCursor(int lineNum) {
        Cursor cursor = Cursor.getPredefinedCursor(!this.isShowingAddresses ? 12 : 0);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"Cursor.getPredefinedCurs\u2026se Cursor.DEFAULT_CURSOR)");
        return cursor;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateAllEditors() {
        void $this$forEach$iv;
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
        Editor[] editorArray = editorFactory.getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"EditorFactory.getInstance().allEditors");
        Editor[] editorArray2 = editorArray;
        MemoryAddressGutterProvider memoryAddressGutterProvider = this;
        boolean $i$f$forEach = false;
        void var4_4 = $this$forEach$iv;
        int n = ((void)var4_4).length;
        for (int i = 0; i < n; ++i) {
            void element$iv;
            void p1 = element$iv = var4_4[i];
            boolean bl = false;
            memoryAddressGutterProvider.updateEditor((Editor)p1);
        }
    }

    private final void updateEditor(Editor editor) {
        EditorGutter editorGutter = editor.getGutter();
        if (editorGutter == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorGutterComponentEx");
        }
        ((EditorGutterComponentEx)editorGutter).revalidateMarkup();
    }

    @NotNull
    public final MemoryLineInfoProvider getModel() {
        return this.model;
    }

    public MemoryAddressGutterProvider(@NotNull MemoryLineInfoProvider model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.model = model;
        this.isShowingAddresses = true;
        this.toggleShowAddressesAction = new ToggleShowAddressesAction();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/MemoryAddressGutterProvider$ToggleShowAddressesAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "(Lcom/jetbrains/cidr/execution/debugger/memory/MemoryAddressGutterProvider;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.cidr.debugger"})
    private final class ToggleShowAddressesAction
    extends ToggleAction {
        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return MemoryAddressGutterProvider.this.isShowingAddresses();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Editor editor;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            MemoryAddressGutterProvider.this.setShowingAddresses(state);
            Editor editor2 = editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
            Intrinsics.checkNotNull((Object)editor2);
            MemoryAddressGutterProvider.this.updateEditor(editor2);
        }

        public ToggleShowAddressesAction() {
            super(CidrDebuggerBundle.message("action.show.addresses.text", new Object[0]));
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/MemoryAddressGutterProvider$CopyAddressAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "(Lcom/jetbrains/cidr/execution/debugger/memory/MemoryAddressGutterProvider;Lcom/jetbrains/cidr/execution/debugger/memory/Address;)V", "getAddress", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.cidr.debugger"})
    private final class CopyAddressAction
    extends AnAction {
        @Nullable
        private final Address address;

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabled(this.address != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            CopyPasteManager copyPasteManager = CopyPasteManager.getInstance();
            Address address = this.address;
            String string = address != null ? address.toString() : null;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            copyPasteManager.setContents((Transferable)new StringSelection(string2));
        }

        @Nullable
        public final Address getAddress() {
            return this.address;
        }

        public CopyAddressAction(Address address) {
            super(CidrDebuggerBundle.messagePointer("debug.memory.addess.copy.address", new Object[0]));
            this.address = address;
        }
    }
}

