/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.makefile.execution.build.runners;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.cpp.execution.build.CLionBuildUtil;
import com.jetbrains.cidr.cpp.makefile.MakefileBundle;
import com.jetbrains.cidr.cpp.makefile.MakefileLog;
import com.jetbrains.cidr.cpp.makefile.MakefileWorkspace;
import com.jetbrains.cidr.cpp.makefile.execution.build.MakefileBuildConfiguration;
import com.jetbrains.cidr.cpp.makefile.execution.build.runners.MakefileBuildTaskRunner;
import com.jetbrains.cidr.cpp.makefile.execution.build.runners.MakefileProjectTaskRunnerKt;
import com.jetbrains.cidr.cpp.makefile.settings.MakefileLocalSettings;
import com.jetbrains.cidr.cpp.makefile.settings.MakefileSettingsFacade;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.build.CidrBuildTaskType;
import com.jetbrains.cidr.execution.build.tasks.CidrCleanTaskImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\u0006\u0010\u000b\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/execution/build/runners/ModuleBuildRunner;", "Lcom/jetbrains/cidr/cpp/makefile/execution/build/runners/MakefileBuildTaskRunner;", "Lcom/intellij/task/ModuleBuildTask;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "buildTargets", "", "", "buildConfiguration", "Lcom/jetbrains/cidr/cpp/makefile/execution/build/MakefileBuildConfiguration;", "task", "expandTask", "Lcom/intellij/task/ProjectTask;", "taskDescription", "taskName", "taskProgressName", "taskType", "Lcom/jetbrains/cidr/execution/build/CidrBuildTaskType;", "intellij.clion.makefile"})
final class ModuleBuildRunner
extends MakefileBuildTaskRunner<ModuleBuildTask> {
    private final List<String> buildTargets;

    @Override
    @NotNull
    public List<ProjectTask> expandTask(@NotNull ProjectTask task) {
        List list;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ProjectTask projectTask = task;
        if (projectTask instanceof ModuleBuildTask) {
            if (((ModuleBuildTask)task).isIncrementalBuild()) {
                list = CollectionsKt.listOf((Object)task);
            } else {
                Module module = ((ModuleBuildTask)task).getModule();
                Intrinsics.checkNotNullExpressionValue((Object)module, (String)"task.module");
                Project project2 = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"task.module.project");
                String toolchainName2 = MakefileLocalSettings.Companion.getInstance(project2).getToolchainName();
                list = CollectionsKt.listOf((Object[])new ProjectTask[]{(ProjectTask)new CidrCleanTaskImpl((CidrBuildConfiguration)new MakefileBuildConfiguration(CollectionsKt.listOf((Object)""), toolchainName2, null, 4, null)), task});
            }
        } else {
            MakefileLog.LOG.error("Unexpected project task type: " + task.getPresentableName());
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public MakefileBuildConfiguration buildConfiguration(@NotNull ModuleBuildTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Module module = task.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"task.module");
        Project project2 = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"task.module.project");
        String toolchainName2 = MakefileLocalSettings.Companion.getInstance(project2).getToolchainName();
        return new MakefileBuildConfiguration(this.buildTargets, toolchainName2, null, 4, null);
    }

    @Override
    @NotNull
    public CidrBuildTaskType taskType(@NotNull ModuleBuildTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return CidrBuildTaskType.BUILD;
    }

    @Override
    @NotNull
    public String taskName(@NotNull ModuleBuildTask task) {
        String string;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String displayName = MakefileProjectTaskRunnerKt.access$shortenTargetDisplayName(this.buildConfiguration(task).getName());
        if (displayName == null) {
            String string2 = MakefileBundle.message("build.task.name.empty.target", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MakefileBundle.message(\"\u2026.task.name.empty.target\")");
        } else {
            String string3 = MakefileBundle.message("build.task.name", displayName);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"MakefileBundle.message(\"\u2026.task.name\", displayName)");
        }
        return string;
    }

    @Override
    @NotNull
    public String taskDescription(@NotNull ModuleBuildTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String targetName = MakefileProjectTaskRunnerKt.access$shortenTargetDisplayName(this.buildConfiguration(task).getName());
        String string = CLionBuildUtil.buildDescription(null, (String)CidrBundle.message((String)"build", (Object[])new Object[0]), (String)targetName, null);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CLionBuildUtil.buildDesc\u2026                    null)");
        return string;
    }

    @Override
    @NotNull
    public String taskProgressName(@NotNull ModuleBuildTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String string = CidrExecutionBundle.message((String)"build.progress", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CidrExecutionBundle.message(\"build.progress\")");
        return string;
    }

    public ModuleBuildRunner(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        MakefileSettingsFacade settingsFacade = new MakefileSettingsFacade(project2, ((Object)MakefileWorkspace.Companion.getInstance(project2).getProjectPath()).toString());
        String string = settingsFacade.getBuildTarget();
        if (string == null) {
            string = "all";
        }
        List list = ParametersListUtil.parse((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ParametersListUtil.parse\u2026ULT_RESOLVE_BUILD_TARGET)");
        this.buildTargets = list;
    }
}

