/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.output;

import java.io.Closeable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00060\u0001j\u0002`\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H&R\u0016\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/build/output/LineProcessor;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "Ljava/io/Closeable;", "()V", "lineBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "append", "c", "", "csq", "", "start", "", "end", "close", "", "flushBuffer", "process", "line", "", "intellij.platform.lang.impl"})
public abstract class LineProcessor
implements Appendable,
Closeable {
    private StringBuilder lineBuilder = new StringBuilder();

    public abstract void process(@NotNull String var1);

    @Override
    @NotNull
    public LineProcessor append(@NotNull CharSequence csq) {
        Intrinsics.checkNotNullParameter((Object)csq, (String)"csq");
        CharSequence charSequence = csq;
        for (int j = 0; j < charSequence.length(); ++j) {
            char element2 = charSequence.charAt(j);
            this.append(element2);
        }
        return this;
    }

    @Override
    @NotNull
    public LineProcessor append(@NotNull CharSequence csq, int start2, int end) {
        Intrinsics.checkNotNullParameter((Object)csq, (String)"csq");
        this.append(csq.subSequence(start2, end));
        return this;
    }

    @Override
    @NotNull
    public LineProcessor append(char c) {
        if (this.lineBuilder == null) {
            throw (Throwable)new IllegalStateException("The line processor was closed");
        }
        if (c == '\n') {
            StringBuilder stringBuilder = this.lineBuilder;
            Intrinsics.checkNotNull((Object)stringBuilder);
            Character c2 = StringsKt.lastOrNull((CharSequence)stringBuilder);
            if (c2 != null && c2.charValue() == '\r') {
                StringBuilder stringBuilder2 = this.lineBuilder;
                Intrinsics.checkNotNull((Object)stringBuilder2);
                StringBuilder stringBuilder3 = this.lineBuilder;
                Intrinsics.checkNotNull((Object)stringBuilder3);
                stringBuilder2.deleteCharAt(stringBuilder3.length() - 1);
            }
            this.flushBuffer();
        } else {
            StringBuilder stringBuilder = this.lineBuilder;
            Intrinsics.checkNotNull((Object)stringBuilder);
            stringBuilder.append(c);
        }
        return this;
    }

    @Override
    public void close() {
        if (this.lineBuilder != null) {
            this.flushBuffer();
            this.lineBuilder = null;
        }
    }

    private final void flushBuffer() {
        StringBuilder stringBuilder = this.lineBuilder;
        Intrinsics.checkNotNull((Object)stringBuilder);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineBuilder!!.toString()");
        String line = string;
        StringBuilder stringBuilder2 = this.lineBuilder;
        Intrinsics.checkNotNull((Object)stringBuilder2);
        stringBuilder2.setLength(0);
        this.process(line);
    }
}

