/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.CodeStyleBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.CodeCleanupCodeProcessor;
import com.intellij.codeInsight.actions.DirectoryFormattingOptions;
import com.intellij.codeInsight.actions.FileInEditorProcessor;
import com.intellij.codeInsight.actions.LastRunReformatCodeOptionsProvider;
import com.intellij.codeInsight.actions.LayoutDirectoryDialog;
import com.intellij.codeInsight.actions.LayoutProjectCodeDialog;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.RearrangeCodeProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.actions.ReformatCodeRunOptions;
import com.intellij.codeInsight.actions.ReformatFilesDialog;
import com.intellij.codeInsight.actions.ReformatFilesOptions;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ReformatCodeAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(ReformatCodeAction.class);
    private static ReformatFilesOptions myTestOptions;

    public ReformatCodeAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        PsiDirectory dir;
        DataContext dataContext;
        Project project;
        if (event == null) {
            ReformatCodeAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext = event.getDataContext())) == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        PsiFile file2 = null;
        boolean hasSelection = false;
        if (editor != null) {
            file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file2 == null) {
                return;
            }
            dir = file2.getContainingDirectory();
            hasSelection = editor.getSelectionModel().hasSelection();
        } else {
            if (files2 != null && ReformatCodeAction.containsOnlyFiles(files2)) {
                ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Arrays.asList(files2));
                if (!operationStatus.hasReadonlyFiles()) {
                    ReformatFilesOptions selectedFlags = ReformatCodeAction.getReformatFilesOptions(project, files2);
                    if (selectedFlags == null) {
                        return;
                    }
                    boolean processOnlyChangedText = selectedFlags.getTextRangeType() == TextRangeType.VCS_CHANGED_TEXT;
                    boolean shouldOptimizeImports = selectedFlags.isOptimizeImports() && !DumbService.getInstance((Project)project).isDumb();
                    AbstractLayoutCodeProcessor processor2 = new ReformatCodeProcessor(project, ReformatCodeAction.convertToPsiFiles(files2, project), null, processOnlyChangedText);
                    if (shouldOptimizeImports) {
                        processor2 = new OptimizeImportsProcessor(processor2);
                    }
                    if (selectedFlags.isRearrangeCode()) {
                        processor2 = new RearrangeCodeProcessor(processor2);
                    }
                    if (selectedFlags.isCodeCleanup()) {
                        processor2 = new CodeCleanupCodeProcessor(processor2);
                    }
                    processor2.run();
                }
                return;
            }
            if (PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext) != null || LangDataKeys.MODULE_CONTEXT.getData(dataContext) != null) {
                Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
                ReformatFilesOptions selectedFlags = ReformatCodeAction.getLayoutProjectOptions(project, moduleContext);
                if (selectedFlags != null) {
                    ReformatCodeAction.reformatModule(project, moduleContext, selectedFlags);
                }
                return;
            }
            PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element2 == null) {
                return;
            }
            if (element2 instanceof PsiDirectoryContainer) {
                dir = (PsiDirectory)ArrayUtil.getFirstElement((Object[])((PsiDirectoryContainer)element2).getDirectories());
            } else if (element2 instanceof PsiDirectory) {
                dir = (PsiDirectory)element2;
            } else {
                file2 = element2.getContainingFile();
                if (file2 == null) {
                    return;
                }
                dir = file2.getContainingDirectory();
            }
        }
        if (file2 == null && dir != null) {
            DirectoryFormattingOptions options2 = ReformatCodeAction.getDirectoryFormattingOptions(project, dir);
            if (options2 != null) {
                ReformatCodeAction.reformatDirectory(project, dir, options2);
            }
            return;
        }
        if (file2 == null || editor == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        LastRunReformatCodeOptionsProvider provider2 = new LastRunReformatCodeOptionsProvider(PropertiesComponent.getInstance());
        ReformatCodeRunOptions currentRunOptions = provider2.getLastRunOptions(file2);
        TextRangeType processingScope = currentRunOptions.getTextRangeType();
        if (hasSelection) {
            processingScope = TextRangeType.SELECTED_TEXT;
        } else if (processingScope == TextRangeType.VCS_CHANGED_TEXT) {
            if (VcsFacade.getInstance().isChangeNotTrackedForFile(project, file2)) {
                processingScope = TextRangeType.WHOLE_FILE;
            }
        } else {
            processingScope = TextRangeType.WHOLE_FILE;
        }
        currentRunOptions.setProcessingScope(processingScope);
        new FileInEditorProcessor(file2, editor, currentRunOptions).processCode();
    }

    @Nullable
    private static DirectoryFormattingOptions getDirectoryFormattingOptions(@NotNull Project project, @NotNull PsiDirectory dir) {
        if (project == null) {
            ReformatCodeAction.$$$reportNull$$$0(1);
        }
        if (dir == null) {
            ReformatCodeAction.$$$reportNull$$$0(2);
        }
        LayoutDirectoryDialog dialog2 = new LayoutDirectoryDialog(project, CodeStyleBundle.message((String)"process.reformat.code", (Object[])new Object[0]), CodeInsightBundle.message((String)"process.scope.directory", (Object[])new Object[]{dir.getVirtualFile().getPath()}), VcsFacade.getInstance().hasChanges(dir));
        boolean enableIncludeDirectoriesCb = dir.getSubdirectories().length > 0;
        dialog2.setEnabledIncludeSubdirsCb(enableIncludeDirectoriesCb);
        dialog2.setSelectedIncludeSubdirsCb(enableIncludeDirectoriesCb);
        if (dialog2.showAndGet()) {
            return dialog2;
        }
        return null;
    }

    public static void reformatDirectory(@NotNull Project project, @NotNull PsiDirectory dir, @NotNull DirectoryFormattingOptions options2) {
        if (project == null) {
            ReformatCodeAction.$$$reportNull$$$0(3);
        }
        if (dir == null) {
            ReformatCodeAction.$$$reportNull$$$0(4);
        }
        if (options2 == null) {
            ReformatCodeAction.$$$reportNull$$$0(5);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        AbstractLayoutCodeProcessor processor2 = new ReformatCodeProcessor(project, dir, options2.isIncludeSubdirectories(), options2.getTextRangeType() == TextRangeType.VCS_CHANGED_TEXT);
        ReformatCodeAction.registerScopeFilter(processor2, options2.getSearchScope());
        ReformatCodeAction.registerFileMaskFilter(processor2, options2.getFileTypeMask());
        if (options2.isOptimizeImports()) {
            processor2 = new OptimizeImportsProcessor(processor2);
        }
        if (options2.isRearrangeCode()) {
            processor2 = new RearrangeCodeProcessor(processor2);
        }
        if (options2.isCodeCleanup()) {
            processor2 = new CodeCleanupCodeProcessor(processor2);
        }
        processor2.run();
    }

    private static void reformatModule(@NotNull Project project, @Nullable Module moduleContext, @NotNull ReformatFilesOptions selectedFlags) {
        if (project == null) {
            ReformatCodeAction.$$$reportNull$$$0(6);
        }
        if (selectedFlags == null) {
            ReformatCodeAction.$$$reportNull$$$0(7);
        }
        boolean shouldOptimizeImports = selectedFlags.isOptimizeImports() && !DumbService.getInstance((Project)project).isDumb();
        boolean processOnlyChangedText = selectedFlags.getTextRangeType() == TextRangeType.VCS_CHANGED_TEXT;
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        AbstractLayoutCodeProcessor processor2 = moduleContext != null ? new ReformatCodeProcessor(project, moduleContext, processOnlyChangedText) : new ReformatCodeProcessor(project, processOnlyChangedText);
        ReformatCodeAction.registerScopeFilter(processor2, selectedFlags.getSearchScope());
        ReformatCodeAction.registerFileMaskFilter(processor2, selectedFlags.getFileTypeMask());
        if (shouldOptimizeImports) {
            processor2 = new OptimizeImportsProcessor(processor2);
        }
        if (selectedFlags.isRearrangeCode()) {
            processor2 = new RearrangeCodeProcessor(processor2);
        }
        processor2.run();
    }

    public static void registerScopeFilter(@NotNull AbstractLayoutCodeProcessor processor2, @Nullable SearchScope scope2) {
        if (processor2 == null) {
            ReformatCodeAction.$$$reportNull$$$0(8);
        }
        if (scope2 == null) {
            return;
        }
        processor2.addFileFilter(arg_0 -> ((SearchScope)scope2).contains(arg_0));
    }

    public static void registerFileMaskFilter(@NotNull AbstractLayoutCodeProcessor processor2, @Nullable String fileTypeMask) {
        if (processor2 == null) {
            ReformatCodeAction.$$$reportNull$$$0(9);
        }
        if (fileTypeMask == null) {
            return;
        }
        Condition<CharSequence> patternCondition = ReformatCodeAction.getFileTypeMaskPattern(fileTypeMask);
        processor2.addFileFilter(file2 -> patternCondition.value((Object)file2.getNameSequence()));
    }

    @NotNull
    private static Condition<CharSequence> getFileTypeMaskPattern(@Nullable String mask) {
        Condition<CharSequence> condition2;
        try {
            condition2 = FindInProjectUtil.createFileMaskCondition(mask);
        }
        catch (PatternSyntaxException e) {
            LOG.info("Error while processing file mask: ", (Throwable)e);
            Condition condition3 = Conditions.alwaysTrue();
            if (condition3 == null) {
                ReformatCodeAction.$$$reportNull$$$0(11);
            }
            return condition3;
        }
        if (condition2 == null) {
            ReformatCodeAction.$$$reportNull$$$0(10);
        }
        return condition2;
    }

    public static PsiFile @NotNull [] convertToPsiFiles(VirtualFile @NotNull [] files2, @NotNull Project project) {
        if (project == null) {
            ReformatCodeAction.$$$reportNull$$$0(12);
        }
        if (files2 == null) {
            ReformatCodeAction.$$$reportNull$$$0(13);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        List list2 = PsiUtilCore.toPsiFiles((PsiManager)psiManager, Arrays.asList(files2));
        PsiFile[] psiFileArray = PsiUtilCore.toPsiFileArray((Collection)list2);
        if (psiFileArray == null) {
            ReformatCodeAction.$$$reportNull$$$0(14);
        }
        return psiFileArray;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ReformatCodeAction.$$$reportNull$$$0(15);
        }
        Presentation presentation2 = event.getPresentation();
        boolean available = ReformatCodeAction.isActionAvailable(event);
        if (event.isFromContextMenu()) {
            presentation2.setEnabledAndVisible(available);
        } else {
            presentation2.setEnabled(available);
        }
    }

    private static boolean isActionAvailable(@NotNull AnActionEvent event) {
        DataContext dataContext;
        Project project;
        if (event == null) {
            ReformatCodeAction.$$$reportNull$$$0(16);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext = event.getDataContext())) == null) {
            return false;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (editor != null) {
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file2 == null || file2.getVirtualFile() == null) {
                return false;
            }
            if (LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null) {
                return true;
            }
        } else if (files2 != null && ReformatCodeAction.containsOnlyFiles(files2)) {
            boolean anyFormatters = false;
            for (VirtualFile virtualFile2 : files2) {
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile2);
                if (psiFile == null) {
                    return false;
                }
                FormattingModelBuilder builder2 = LanguageFormatting.INSTANCE.forContext((PsiElement)psiFile);
                if (builder2 == null) continue;
                anyFormatters = true;
                break;
            }
            if (!anyFormatters) {
                return false;
            }
        } else if ((files2 == null || files2.length != 1) && LangDataKeys.MODULE_CONTEXT.getData(dataContext) == null && PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext) == null) {
            PsiFile file3;
            PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element2 == null) {
                return false;
            }
            if (!(element2 instanceof PsiDirectory || (file3 = element2.getContainingFile()) != null && LanguageFormatting.INSTANCE.forContext((PsiElement)file3) != null)) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static ReformatFilesOptions getReformatFilesOptions(@NotNull Project project, VirtualFile @NotNull [] files2) {
        if (project == null) {
            ReformatCodeAction.$$$reportNull$$$0(17);
        }
        if (files2 == null) {
            ReformatCodeAction.$$$reportNull$$$0(18);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return myTestOptions;
        }
        ReformatFilesDialog dialog2 = new ReformatFilesDialog(project, files2);
        if (!dialog2.showAndGet()) {
            return null;
        }
        return dialog2;
    }

    @Nullable
    private static ReformatFilesOptions getLayoutProjectOptions(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            ReformatCodeAction.$$$reportNull$$$0(19);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return myTestOptions;
        }
        String text2 = module != null ? CodeInsightBundle.message((String)"process.scope.module", (Object[])new Object[]{module.getModuleFilePath()}) : CodeInsightBundle.message((String)"process.scope.project", (Object[])new Object[]{project.getPresentableUrl()});
        boolean enableOnlyVCSChangedRegions = module != null ? VcsFacade.getInstance().hasChanges(module) : VcsFacade.getInstance().hasChanges(project);
        LayoutProjectCodeDialog dialog2 = new LayoutProjectCodeDialog(project, CodeStyleBundle.message((String)"process.reformat.code", (Object[])new Object[0]), text2, enableOnlyVCSChangedRegions);
        if (!dialog2.showAndGet()) {
            return null;
        }
        return dialog2;
    }

    @TestOnly
    public static void setTestOptions(@NotNull ReformatFilesOptions options2) {
        if (options2 == null) {
            ReformatCodeAction.$$$reportNull$$$0(20);
        }
        myTestOptions = options2;
    }

    static boolean containsOnlyFiles(VirtualFile @NotNull [] files2) {
        if (files2 == null) {
            ReformatCodeAction.$$$reportNull$$$0(21);
        }
        if (files2.length < 1) {
            return false;
        }
        for (VirtualFile virtualFile2 : files2) {
            if (!virtualFile2.isDirectory()) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 12: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFlags";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/ReformatCodeAction";
                break;
            }
            case 13: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/ReformatCodeAction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeMaskPattern";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToPsiFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoryFormattingOptions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reformatDirectory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reformatModule";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerScopeFilter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerFileMaskFilter";
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertToPsiFiles";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isActionAvailable";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getReformatFilesOptions";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutProjectOptions";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setTestOptions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "containsOnlyFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

