/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.TypeOrElementOrAttributeReference;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddSchemaPrefixIntention
extends PsiElementBaseIntentionAction {
    public AddSchemaPrefixIntention() {
        this.setText(XmlBundle.message((String)"xml.intention.insert.namespace.prefix.name", (Object[])new Object[0]));
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            AddSchemaPrefixIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(final @NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        XmlAttribute xmlns;
        if (project == null) {
            AddSchemaPrefixIntention.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            AddSchemaPrefixIntention.$$$reportNull$$$0(2);
        }
        if ((xmlns = AddSchemaPrefixIntention.getXmlnsDeclaration(element2)) == null) {
            return;
        }
        final String namespace = xmlns.getValue();
        XmlTag tag2 = xmlns.getParent();
        if (tag2 != null) {
            final Set ns = tag2.getLocalNamespaceDeclarations().keySet();
            String nsPrefix = Messages.showInputDialog((Project)project, (String)XmlBundle.message((String)"namespace.prefix", (Object[])new Object[0]), (String)XmlBundle.message((String)"xml.intention.insert.namespace.prefix.command", (Object[])new Object[0]), (Icon)Messages.getInformationIcon(), (String)"", (InputValidator)new InputValidator(){

                public boolean checkInput(String inputString) {
                    return !ns.contains(inputString) && AddSchemaPrefixIntention.isValidPrefix(inputString, project);
                }

                public boolean canClose(String inputString) {
                    return this.checkInput(inputString);
                }
            });
            if (nsPrefix == null) {
                return;
            }
            final ArrayList tags = new ArrayList();
            final ArrayList values2 = new ArrayList();
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{tag2.getContainingFile()}).withName(XmlBundle.message((String)"xml.intention.insert.namespace.prefix.command", (Object[])new Object[0])).run(() -> {
                tag2.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlTag(XmlTag tag2) {
                        if (tag2.getNamespace().equals(namespace) && tag2.getNamespacePrefix().isEmpty()) {
                            tags.add(tag2);
                        }
                        super.visitXmlTag(tag2);
                    }

                    public void visitXmlAttributeValue(XmlAttributeValue value2) {
                        XmlTag tag2;
                        PsiElement xmlElement;
                        PsiReference ref = null;
                        boolean skip = false;
                        for (PsiReference reference2 : value2.getReferences()) {
                            if (reference2 instanceof TypeOrElementOrAttributeReference) {
                                ref = reference2;
                                continue;
                            }
                            if (!(reference2 instanceof SchemaPrefixReference)) continue;
                            skip = true;
                            break;
                        }
                        if (!skip && ref != null && (xmlElement = ref.resolve()) instanceof XmlElement && (tag2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)xmlElement, XmlTag.class, (boolean)false)) != null && tag2.getNamespace().equals(namespace) && ref.getRangeInElement().getLength() == value2.getValue().length()) {
                            values2.add(value2);
                        }
                    }
                });
                for (XmlAttributeValue value2 : values2) {
                    ((XmlAttribute)value2.getParent()).setValue(nsPrefix + ":" + value2.getValue());
                }
                for (XmlTag xmlTag : tags) {
                    xmlTag.setName(nsPrefix + ":" + xmlTag.getLocalName());
                }
                xmlns.setName("xmlns:" + nsPrefix);
            });
        }
    }

    private static boolean isValidPrefix(String prefix2, Project project) {
        try {
            XmlTag tag2 = XmlElementFactory.getInstance((Project)project).createTagFromText((CharSequence)("<" + prefix2 + ":foo/>"));
            return "foo".equals(tag2.getLocalName());
        }
        catch (IncorrectOperationException e) {
            return false;
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        if (project == null) {
            AddSchemaPrefixIntention.$$$reportNull$$$0(3);
        }
        if (element2 == null) {
            AddSchemaPrefixIntention.$$$reportNull$$$0(4);
        }
        return AddSchemaPrefixIntention.getXmlnsDeclaration(element2) != null;
    }

    @Nullable
    private static XmlAttribute getXmlnsDeclaration(PsiElement element2) {
        PsiElement parent = element2.getParent();
        if (parent instanceof XmlTag) {
            XmlTag tag2 = (XmlTag)parent;
            if (tag2.getNamespacePrefix().isEmpty()) {
                while (tag2 != null) {
                    XmlAttribute attr = tag2.getAttribute("xmlns");
                    if (attr != null) {
                        return attr;
                    }
                    tag2 = tag2.getParentTag();
                }
            }
        } else if (parent instanceof XmlAttribute && ((XmlAttribute)parent).getName().equals("xmlns")) {
            return (XmlAttribute)parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/AddSchemaPrefixIntention";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/AddSchemaPrefixIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

