/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.BundleBase;
import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.IdeValidationHost;
import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.RemoveAttributeIntentionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.dtd.DTDLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlUndefinedElementFixProvider;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.AnchorReference;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlHighlightVisitor
extends XmlElementVisitor
implements HighlightVisitor,
IdeValidationHost {
    private static final Logger LOG = Logger.getInstance(XmlHighlightVisitor.class);
    private static boolean ourDoJaxpTesting;
    private HighlightInfoHolder myHolder;

    private void addElementsForTag(XmlTag tag2, @NotNull @InspectionMessage String localizedMessage, HighlightInfoType type) {
        if (localizedMessage == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(0);
        }
        this.addElementsForTagWithManyQuickFixes(tag2, localizedMessage, type, new IntentionAction[]{null});
    }

    private void addElementsForTagWithManyQuickFixes(XmlTag tag2, @NotNull @InspectionMessage String localizedMessage, HighlightInfoType type, IntentionAction ... quickFixActions) {
        if (localizedMessage == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(1);
        }
        this.bindMessageToTag(tag2, type, -1, localizedMessage, quickFixActions);
    }

    public void visitXmlToken(XmlToken token2) {
        XmlTag tag2;
        String marker;
        String s;
        int i2;
        IElementType tokenType = token2.getTokenType();
        if (tokenType == XmlTokenType.XML_NAME || tokenType == XmlTokenType.XML_TAG_NAME) {
            PsiElement element2 = token2.getPrevSibling();
            while (element2 instanceof PsiWhiteSpace) {
                element2 = element2.getPrevSibling();
            }
            if (element2 instanceof XmlToken) {
                PsiElement parent;
                if (((XmlToken)element2).getTokenType() == XmlTokenType.XML_START_TAG_START && (parent = element2.getParent()) instanceof XmlTag && !(token2.getNextSibling() instanceof OuterLanguageElement)) {
                    this.checkTag((XmlTag)parent);
                }
            } else {
                PsiElement parent = token2.getParent();
                if (parent instanceof XmlAttribute && !(token2.getNextSibling() instanceof OuterLanguageElement)) {
                    this.checkAttribute((XmlAttribute)parent);
                }
            }
        } else if (tokenType == XmlTokenType.XML_DATA_CHARACTERS && token2.getParent() instanceof XmlText && token2.textContains(']') && token2.textContains('>') && (i2 = (s = token2.getText()).indexOf(marker = "]]>")) != -1 && (tag2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)token2, XmlTag.class)) != null && XmlExtension.getExtensionByElement((PsiElement)tag2).shouldBeHighlightedAsTag(tag2) && !XmlHighlightVisitor.skipValidation((PsiElement)tag2)) {
            TextRange textRange = token2.getTextRange();
            int start2 = textRange.getStartOffset() + i2;
            HighlightInfoType type = tag2 instanceof HtmlTag ? HighlightInfoType.WARNING : HighlightInfoType.ERROR;
            String description2 = XmlAnalysisBundle.message((String)"xml.inspections.cdata.end.should.not.appear.in.content", (Object[])new Object[0]);
            HighlightInfo info2 = HighlightInfo.newHighlightInfo(type).range(start2, start2 + marker.length()).descriptionAndTooltip(description2).create();
            this.addToResults(info2);
        }
    }

    private void checkTag(XmlTag tag2) {
        if (ourDoJaxpTesting) {
            return;
        }
        if (!this.myHolder.hasErrorResults()) {
            this.checkTagByDescriptor(tag2);
        }
        if (!this.myHolder.hasErrorResults() && !XmlHighlightVisitor.skipValidation((PsiElement)tag2)) {
            XmlElementDescriptor descriptor2 = tag2.getDescriptor();
            if (tag2 instanceof HtmlTag && (descriptor2 instanceof AnyXmlElementDescriptor || descriptor2 == null)) {
                return;
            }
            this.checkReferences((PsiElement)tag2);
        }
    }

    private void bindMessageToTag(XmlTag tag2, HighlightInfoType warning, int messageLength, @NotNull @InspectionMessage String localizedMessage, IntentionAction ... quickFixActions) {
        if (localizedMessage == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(2);
        }
        XmlToken childByRole = XmlTagUtil.getStartTagNameElement((XmlTag)tag2);
        this.bindMessageToAstNode((PsiElement)childByRole, warning, messageLength, localizedMessage, quickFixActions);
        childByRole = XmlTagUtil.getEndTagNameElement((XmlTag)tag2);
        this.bindMessageToAstNode((PsiElement)childByRole, warning, messageLength, localizedMessage, quickFixActions);
    }

    public void visitXmlProcessingInstruction(XmlProcessingInstruction processingInstruction) {
        super.visitXmlProcessingInstruction(processingInstruction);
        PsiElement parent = processingInstruction.getParent();
        if (parent instanceof XmlProlog && processingInstruction.getText().startsWith("<?xml ")) {
            PsiElement e = PsiTreeUtil.prevLeaf((PsiElement)processingInstruction);
            while (e != null) {
                if (!(e instanceof PsiWhiteSpace && PsiTreeUtil.prevLeaf((PsiElement)e) != null || e instanceof OuterLanguageElement)) {
                    PsiElement eParent = e.getParent();
                    if (eParent instanceof PsiComment) {
                        e = eParent;
                    }
                    if (eParent instanceof XmlProcessingInstruction) break;
                    String description2 = XmlAnalysisBundle.message((String)"xml.inspections.xml.declaration.should.precede.all.document.content", (Object[])new Object[0]);
                    this.addToResults(HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(e).descriptionAndTooltip(description2).create());
                }
                e = PsiTreeUtil.prevLeaf((PsiElement)e);
            }
        }
        this.checkReferences((PsiElement)processingInstruction);
    }

    private void bindMessageToAstNode(PsiElement childByRole, HighlightInfoType warning, int length, @NotNull @InspectionMessage String localizedMessage, IntentionAction ... quickFixActions) {
        if (localizedMessage == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(3);
        }
        if (childByRole != null) {
            TextRange textRange = childByRole.getTextRange();
            if (length == -1) {
                length = textRange.getLength();
            }
            int startOffset = textRange.getStartOffset();
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(warning).range(childByRole, startOffset, startOffset + length).descriptionAndTooltip(localizedMessage).create();
            if (highlightInfo == null) {
                highlightInfo = HighlightInfo.newHighlightInfo(warning).range(new TextRange(startOffset, startOffset + length)).textAttributes(Holder.NONEMPTY_TEXT_ATTRIBUTES).descriptionAndTooltip(localizedMessage).create();
            }
            for (IntentionAction quickFixAction : quickFixActions) {
                if (quickFixAction == null) continue;
                QuickFixAction.registerQuickFixAction(highlightInfo, textRange, quickFixAction);
            }
            this.addToResults(highlightInfo);
        }
    }

    private void checkTagByDescriptor(XmlTag tag2) {
        XmlElementDescriptor elementDescriptor;
        String name = tag2.getName();
        PsiElement parent = tag2.getParent();
        if (parent instanceof XmlTag) {
            XmlTag parentTag = (XmlTag)parent;
            elementDescriptor = XmlUtil.getDescriptorFromContext(tag2);
            XmlElementDescriptor parentDescriptor = parentTag.getDescriptor();
            if (parentDescriptor != null && elementDescriptor == null && XmlHighlightVisitor.shouldBeValidated(tag2)) {
                if (tag2 instanceof HtmlTag) {
                    return;
                }
                this.addElementsForTag(tag2, XmlAnalysisBundle.message((String)"xml.inspections.element.is.not.allowed.here", (Object[])new Object[]{name}), XmlHighlightVisitor.getTagProblemInfoType(tag2));
                return;
            }
            if (elementDescriptor instanceof AnyXmlElementDescriptor || elementDescriptor == null) {
                elementDescriptor = tag2.getDescriptor();
            }
            if (elementDescriptor == null) {
                return;
            }
        } else {
            elementDescriptor = tag2.getDescriptor();
            if (elementDescriptor == null) {
                this.addElementsForTag(tag2, XmlAnalysisBundle.message((String)"xml.inspections.element.must.be.declared", (Object[])new Object[]{name}), HighlightInfoType.WRONG_REF);
                return;
            }
        }
        if (elementDescriptor instanceof Validator) {
            ((Validator)elementDescriptor).validate(tag2, this);
        }
    }

    private static HighlightInfoType getTagProblemInfoType(XmlTag tag2) {
        if (tag2 instanceof HtmlTag && "http://www.w3.org/1999/html".equals(tag2.getNamespace())) {
            if (XmlHighlightVisitor.isInjectedWithoutValidation((PsiElement)tag2)) {
                return HighlightInfoType.INFORMATION;
            }
            return HighlightInfoType.WARNING;
        }
        return HighlightInfoType.WRONG_REF;
    }

    public static boolean isInjectedWithoutValidation(PsiElement element2) {
        return InjectedLanguageManager.FRANKENSTEIN_INJECTION.get((UserDataHolder)element2.getContainingFile()) == Boolean.TRUE;
    }

    public static boolean skipValidation(PsiElement context2) {
        return context2 instanceof XmlElement && ((XmlElement)context2).skipValidation();
    }

    public static void setSkipValidation(@NotNull PsiElement element2) {
        if (element2 == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(4);
        }
        element2.putUserData(XmlElement.DO_NOT_VALIDATE, (Object)Boolean.TRUE);
    }

    public void visitXmlAttribute(XmlAttribute attribute) {
    }

    private void checkAttribute(XmlAttribute attribute) {
        XmlTag tag2 = attribute.getParent();
        if (tag2 == null) {
            return;
        }
        String name = attribute.getName();
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)attribute);
        if (!(prevLeaf instanceof PsiWhiteSpace)) {
            TextRange textRange = attribute.getTextRange();
            HighlightInfoType type = tag2 instanceof HtmlTag ? HighlightInfoType.WARNING : HighlightInfoType.ERROR;
            String description2 = XmlAnalysisBundle.message((String)"xml.inspections.attribute.should.be.preceded.with.space", (Object[])new Object[0]);
            HighlightInfo info2 = HighlightInfo.newHighlightInfo(type).range(textRange.getStartOffset(), textRange.getStartOffset()).descriptionAndTooltip(description2).create();
            this.addToResults(info2);
        }
        if (attribute.isNamespaceDeclaration() || "http://www.w3.org/2001/XMLSchema-instance".equals(attribute.getNamespace())) {
            return;
        }
        XmlElementDescriptor elementDescriptor = tag2.getDescriptor();
        if (elementDescriptor == null || elementDescriptor instanceof AnyXmlElementDescriptor || ourDoJaxpTesting) {
            return;
        }
        XmlAttributeDescriptor attributeDescriptor = attribute.getDescriptor();
        if (attributeDescriptor == null) {
            PsiFile file2;
            String localizedMessage;
            HighlightInfo highlightInfo;
            if (!XmlUtil.attributeFromTemplateFramework(name, tag2) && (highlightInfo = this.reportAttributeProblem(tag2, name, attribute, localizedMessage = XmlAnalysisBundle.message((String)"xml.inspections.attribute.is.not.allowed.here", (Object[])new Object[]{name}))) != null && (file2 = tag2.getContainingFile()) != null) {
                for (XmlUndefinedElementFixProvider fixProvider : XmlUndefinedElementFixProvider.EP_NAME.getExtensionList()) {
                    IntentionAction[] fixes = fixProvider.createFixes(attribute);
                    if (fixes == null) continue;
                    for (IntentionAction action2 : fixes) {
                        QuickFixAction.registerQuickFixAction(highlightInfo, action2);
                    }
                    break;
                }
            }
        } else {
            this.checkDuplicateAttribute(tag2, attribute);
            PsiReference[] attrRefs = attribute.getReferences();
            this.doCheckRefs((PsiElement)attribute, attrRefs, !attribute.getNamespacePrefix().isEmpty() ? 2 : 1);
        }
    }

    @Nullable
    private HighlightInfo reportAttributeProblem(XmlTag tag2, String localName, XmlAttribute attribute, @NotNull @InspectionMessage String localizedMessage) {
        if (localizedMessage == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(5);
        }
        RemoveAttributeIntentionFix removeAttributeIntention = new RemoveAttributeIntentionFix(localName);
        if (!(tag2 instanceof HtmlTag)) {
            HighlightInfoType tagProblemInfoType = HighlightInfoType.WRONG_REF;
            ASTNode node2 = SourceTreeToPsiMap.psiElementToTree((PsiElement)attribute);
            assert (node2 != null);
            ASTNode child2 = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(node2);
            assert (child2 != null);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(tagProblemInfoType).range(child2).descriptionAndTooltip(localizedMessage).create();
            this.addToResults(highlightInfo);
            QuickFixAction.registerQuickFixAction(highlightInfo, removeAttributeIntention);
            return highlightInfo;
        }
        return null;
    }

    private void checkDuplicateAttribute(XmlTag tag2, XmlAttribute attribute) {
        if (XmlHighlightVisitor.skipValidation((PsiElement)tag2)) {
            return;
        }
        XmlAttribute[] attributes2 = tag2.getAttributes();
        PsiFile containingFile = tag2.getContainingFile();
        XmlExtension extension2 = containingFile instanceof XmlFile ? XmlExtension.getExtension(containingFile) : DefaultXmlExtension.DEFAULT_EXTENSION;
        for (XmlAttribute tagAttribute : attributes2) {
            ProgressManager.checkCanceled();
            if (attribute == tagAttribute || !Comparing.strEqual((String)attribute.getName(), (String)tagAttribute.getName())) continue;
            String localName = attribute.getLocalName();
            if (extension2.canBeDuplicated(tagAttribute)) continue;
            ASTNode attributeNode = SourceTreeToPsiMap.psiElementToTree((PsiElement)attribute);
            assert (attributeNode != null);
            ASTNode attributeNameNode = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attributeNode);
            assert (attributeNameNode != null);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo(XmlHighlightVisitor.getTagProblemInfoType(tag2)).range(attributeNameNode).descriptionAndTooltip(XmlAnalysisBundle.message((String)"xml.inspections.duplicate.attribute", (Object[])new Object[]{localName})).create();
            this.addToResults(highlightInfo);
            RemoveAttributeIntentionFix intentionAction = new RemoveAttributeIntentionFix(localName);
            QuickFixAction.registerQuickFixAction(highlightInfo, intentionAction);
        }
    }

    public void visitXmlDocument(XmlDocument document) {
        PsiMetaData psiMetaData;
        if (document.getLanguage() == DTDLanguage.INSTANCE && (psiMetaData = document.getMetaData()) instanceof Validator) {
            ((Validator)psiMetaData).validate(document, this);
        }
    }

    public void visitXmlTag(XmlTag tag2) {
    }

    public void visitXmlAttributeValue(XmlAttributeValue value2) {
        String error2;
        this.checkReferences((PsiElement)value2);
        PsiElement parent = value2.getParent();
        if (!(parent instanceof XmlAttribute)) {
            return;
        }
        XmlAttribute attribute = (XmlAttribute)parent;
        XmlTag tag2 = attribute.getParent();
        if (tag2 == null) {
            LOG.error("Missing tag for attribute: " + attribute.getName(), new Attachment[]{new Attachment(this.myHolder.getContextFile().getName(), this.myHolder.getContextFile().getText())});
            return;
        }
        XmlAttributeDescriptor attributeDescriptor = attribute.getDescriptor();
        if (attributeDescriptor != null && !XmlHighlightVisitor.skipValidation((PsiElement)value2) && (error2 = attributeDescriptor.validateValue((XmlElement)value2, attribute.getValue())) != null) {
            HighlightInfoType type = XmlHighlightVisitor.getTagProblemInfoType(tag2);
            this.addToResults(HighlightInfo.newHighlightInfo(type).range((PsiElement)value2).descriptionAndTooltip(error2).create());
        }
    }

    private void checkReferences(PsiElement value2) {
        if (value2 == null) {
            return;
        }
        this.doCheckRefs(value2, value2.getReferences(), 0);
    }

    private void doCheckRefs(PsiElement value2, PsiReference[] references, int start2) {
        for (int i2 = start2; i2 < references.length; ++i2) {
            LocalQuickFix[] fixes;
            PsiElement parent;
            PsiReference reference2 = references[i2];
            ProgressManager.checkCanceled();
            if (XmlHighlightVisitor.isUrlReference(reference2) || !XmlHighlightVisitor.hasBadResolve(reference2, false)) continue;
            String description2 = XmlHighlightVisitor.getErrorDescription(reference2);
            int startOffset = reference2.getElement().getTextRange().getStartOffset();
            TextRange referenceRange = reference2.getRangeInElement();
            if (referenceRange.getStartOffset() > referenceRange.getEndOffset()) {
                LOG.error("Reference range start offset > end offset:  " + reference2 + ", start offset: " + referenceRange.getStartOffset() + ", end offset: " + referenceRange.getEndOffset());
            }
            HighlightInfoType type = XmlHighlightVisitor.getTagProblemInfoType((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)value2, XmlTag.class));
            if (value2 instanceof XmlAttributeValue && (parent = value2.getParent()) instanceof XmlAttribute) {
                String name = StringUtil.toLowerCase((String)((XmlAttribute)parent).getName());
                if (type.getSeverity(null).compareTo(HighlightInfoType.WARNING.getSeverity(null)) > 0 && name.endsWith("stylename")) {
                    type = HighlightInfoType.WARNING;
                }
            }
            HighlightInfo info2 = HighlightInfo.newHighlightInfo(type).range(startOffset + referenceRange.getStartOffset(), startOffset + referenceRange.getEndOffset()).descriptionAndTooltip(description2).create();
            this.addToResults(info2);
            if (reference2 instanceof LocalQuickFixProvider && (fixes = ((LocalQuickFixProvider)reference2).getQuickFixes()) != null) {
                InspectionManager manager2 = InspectionManager.getInstance((Project)reference2.getElement().getProject());
                for (LocalQuickFix fix : fixes) {
                    ProblemDescriptor descriptor2 = manager2.createProblemDescriptor(value2, description2, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true);
                    QuickFixAction.registerQuickFixAction(info2, (IntentionAction)new LocalQuickFixAsIntentionAdapter(fix, descriptor2));
                }
            }
            if (info2 == null) continue;
            UnresolvedReferenceQuickFixProvider.registerReferenceFixes(reference2, new QuickFixActionRegistrarImpl(info2));
        }
    }

    public static boolean isUrlReference(PsiReference reference2) {
        return reference2 instanceof FileReferenceOwner || reference2 instanceof AnchorReference;
    }

    @NotNull
    @InspectionMessage
    public static String getErrorDescription(@NotNull PsiReference reference2) {
        String description2;
        if (reference2 == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(6);
        }
        String message2 = reference2 instanceof EmptyResolveMessageProvider ? ((EmptyResolveMessageProvider)reference2).getUnresolvedMessagePattern() : AnalysisBundle.message((String)"cannot.resolve.symbol", (Object[])new Object[0]);
        try {
            description2 = BundleBase.format((String)message2, (Object[])new Object[]{reference2.getCanonicalText()});
        }
        catch (IllegalArgumentException ex) {
            description2 = message2;
        }
        String string = description2;
        if (string == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static boolean hasBadResolve(PsiReference reference2, boolean checkSoft) {
        if (!checkSoft && reference2.isSoft()) {
            return false;
        }
        if (reference2 instanceof PsiPolyVariantReference) {
            return ((PsiPolyVariantReference)reference2).multiResolve(false).length == 0;
        }
        return reference2.resolve() == null;
    }

    public void visitXmlDoctype(XmlDoctype xmlDoctype) {
        if (XmlHighlightVisitor.skipValidation((PsiElement)xmlDoctype)) {
            return;
        }
        this.checkReferences((PsiElement)xmlDoctype);
    }

    private void addToResults(HighlightInfo info2) {
        this.myHolder.add(info2);
    }

    public static void setDoJaxpTesting(boolean doJaxpTesting) {
        ourDoJaxpTesting = doJaxpTesting;
    }

    @Override
    public void addMessage(PsiElement context2, String message2, @NotNull Validator.ValidationHost.ErrorType type) {
        if (type == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(8);
        }
        this.addMessageWithFixes(context2, message2, type, new IntentionAction[0]);
    }

    @Override
    public void addMessageWithFixes(PsiElement context2, String message2, @NotNull Validator.ValidationHost.ErrorType type, IntentionAction ... fixes) {
        if (type == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(9);
        }
        if (fixes == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(10);
        }
        if (message2 != null && !message2.isEmpty()) {
            HighlightInfoType defaultInfoType;
            PsiFile containingFile = context2.getContainingFile();
            HighlightInfoType highlightInfoType = type == Validator.ValidationHost.ErrorType.ERROR ? HighlightInfoType.ERROR : (defaultInfoType = type == Validator.ValidationHost.ErrorType.WARNING ? HighlightInfoType.WARNING : HighlightInfoType.WEAK_WARNING);
            if (context2 instanceof XmlTag && XmlExtension.getExtension(containingFile).shouldBeHighlightedAsTag((XmlTag)context2)) {
                this.addElementsForTagWithManyQuickFixes((XmlTag)context2, message2, defaultInfoType, fixes);
            } else {
                HighlightInfo highlightInfo;
                PsiLanguageInjectionHost contextOfFile = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
                if (contextOfFile != null) {
                    TextRange range2 = InjectedLanguageManager.getInstance((Project)context2.getProject()).injectedToHost(context2, context2.getTextRange());
                    highlightInfo = HighlightInfo.newHighlightInfo(defaultInfoType).range(range2).descriptionAndTooltip(message2).create();
                } else {
                    highlightInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(context2).descriptionAndTooltip(message2).create();
                }
                for (IntentionAction quickFixAction : fixes) {
                    if (quickFixAction == null) continue;
                    QuickFixAction.registerQuickFixAction(highlightInfo, quickFixAction);
                }
                this.addToResults(highlightInfo);
            }
        }
    }

    @Override
    public boolean suitableForFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(11);
        }
        if (file2 instanceof XmlFile) {
            return true;
        }
        for (PsiFile psiFile : file2.getViewProvider().getAllFiles()) {
            if (!(psiFile instanceof XmlFile)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(@NotNull PsiElement element2) {
        if (element2 == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(12);
        }
        element2.accept((PsiElementVisitor)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean analyze(@NotNull PsiFile file2, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action2) {
        if (file2 == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(13);
        }
        if (holder == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(14);
        }
        if (action2 == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(15);
        }
        this.myHolder = holder;
        try {
            action2.run();
        }
        finally {
            this.myHolder = null;
        }
        return true;
    }

    @Override
    @NotNull
    public HighlightVisitor clone() {
        return new XmlHighlightVisitor();
    }

    public static String getUnquotedValue(XmlAttributeValue value2, XmlTag tag2) {
        String unquotedValue = value2.getValue();
        if (tag2 instanceof HtmlTag) {
            unquotedValue = StringUtil.toLowerCase((String)unquotedValue);
        }
        return unquotedValue;
    }

    public static boolean shouldBeValidated(@NotNull XmlTag tag2) {
        PsiElement parent;
        if (tag2 == null) {
            XmlHighlightVisitor.$$$reportNull$$$0(16);
        }
        if ((parent = tag2.getParent()) instanceof XmlTag) {
            return !XmlHighlightVisitor.skipValidation(parent) && !XmlUtil.tagFromTemplateFramework(tag2);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localizedMessage";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addElementsForTag";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addElementsForTagWithManyQuickFixes";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bindMessageToTag";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindMessageToAstNode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSkipValidation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reportAttributeProblem";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getErrorDescription";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addMessage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addMessageWithFixes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "suitableForFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeValidated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private static final TextAttributes NONEMPTY_TEXT_ATTRIBUTES = new TextAttributes(){

            public boolean isEmpty() {
                return false;
            }
        };

        private Holder() {
        }
    }
}

