/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.codeInsight.editorActions.TypingActionsExtension;
import com.intellij.ide.PasteProvider;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorTextInsertHandler;
import com.intellij.openapi.editor.actions.BasePasteHandler;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.Producer;
import com.intellij.util.SlowOperations;
import com.intellij.util.text.CharArrayUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PasteHandler
extends EditorActionHandler
implements EditorTextInsertHandler {
    private static final ExtensionPointName<PasteProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.customPasteProvider");
    private final EditorActionHandler myOriginalHandler;

    public PasteHandler(EditorActionHandler originalAction) {
        this.myOriginalHandler = originalAction;
    }

    public void doExecute(@NotNull Editor editor, Caret caret, DataContext dataContext) {
        if (editor == null) {
            PasteHandler.$$$reportNull$$$0(0);
        }
        assert (caret == null) : "Invocation of 'paste' operation for specific caret is not supported";
        this.execute(editor, dataContext, null);
    }

    private static Transferable getContentsToPasteToEditor(@Nullable Producer<? extends Transferable> producer) {
        if (producer == null) {
            return CopyPasteManager.getInstance().getContents();
        }
        return (Transferable)producer.produce();
    }

    public void execute(@NotNull Editor editor, DataContext dataContext, @Nullable Producer<? extends Transferable> producer) {
        Transferable transferable;
        if (editor == null) {
            PasteHandler.$$$reportNull$$$0(1);
        }
        if ((transferable = PasteHandler.getContentsToPasteToEditor(producer)) == null) {
            return;
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return;
        }
        Document document = editor.getDocument();
        if (!EditorModificationUtil.requestWriting((Editor)editor)) {
            return;
        }
        DataContext context2 = dataId -> PasteAction.TRANSFERABLE_PROVIDER.is(dataId) ? () -> transferable : dataContext.getData(dataId);
        Project project = editor.getProject();
        if (project == null || editor.isColumnMode() || editor.getCaretModel().getCaretCount() > 1) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, null, context2);
            }
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, null, context2);
            }
            return;
        }
        DumbService.getInstance((Project)project).runWithAlternativeResolveEnabled(() -> {
            document.startGuardedBlockChecking();
            try {
                for (PasteProvider provider2 : EP_NAME.getExtensionList()) {
                    if (!provider2.isPasteEnabled(context2)) continue;
                    provider2.performPaste(context2);
                    return;
                }
                PasteHandler.doPaste(editor, project, file2, document, transferable);
            }
            catch (ReadOnlyFragmentModificationException e) {
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document).handle(e);
            }
            finally {
                document.stopGuardedBlockChecking();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doPaste(@NotNull Editor editor, @NotNull Project project, PsiFile file2, Document document, @NotNull Transferable content2) {
        if (editor == null) {
            PasteHandler.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PasteHandler.$$$reportNull$$$0(3);
        }
        if (content2 == null) {
            PasteHandler.$$$reportNull$$$0(4);
        }
        TypingActionsExtension typingActionsExtension = TypingActionsExtension.findForContext(project, editor);
        try {
            typingActionsExtension.startPaste(project, editor);
            PasteHandler.doPasteAction(editor, project, file2, document, content2, typingActionsExtension);
        }
        finally {
            typingActionsExtension.endPaste(project, editor);
        }
    }

    private static void doPasteAction(Editor editor, Project project, PsiFile file2, Document document, @NotNull Transferable content2, @NotNull TypingActionsExtension typingActionsExtension) {
        if (content2 == null) {
            PasteHandler.$$$reportNull$$$0(5);
        }
        if (typingActionsExtension == null) {
            PasteHandler.$$$reportNull$$$0(6);
        }
        CopyPasteManager.getInstance().stopKillRings();
        String text2 = null;
        try {
            text2 = (String)content2.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            editor.getComponent().getToolkit().beep();
        }
        if (text2 == null) {
            return;
        }
        int textLength = text2.length();
        if (BasePasteHandler.isContentTooLarge(textLength)) {
            BasePasteHandler.contentLengthLimitExceededMessage(textLength);
            return;
        }
        CodeInsightSettings settings2 = CodeInsightSettings.getInstance();
        HashMap extraData = new HashMap();
        ArrayList allValues = new ArrayList();
        for (CopyPastePostProcessor processor2 : CopyPastePostProcessor.EP_NAME.getExtensionList()) {
            List data2 = processor2.extractTransferableData(content2);
            if (data2.isEmpty()) continue;
            extraData.put(processor2, data2);
            allValues.addAll(data2);
        }
        text2 = TextBlockTransferable.convertLineSeparators(editor, text2, allValues);
        CaretModel caretModel = editor.getCaretModel();
        SelectionModel selectionModel = editor.getSelectionModel();
        int col = caretModel.getLogicalPosition().column;
        int caretOffset = caretModel.getOffset();
        int blockIndentAnchorColumn = selectionModel.hasSelection() && caretOffset >= selectionModel.getSelectionStart() ? editor.offsetToLogicalPosition((int)selectionModel.getSelectionStart()).column : col;
        RawText rawText = RawText.fromTransferable((Transferable)content2);
        String newText = text2;
        for (CopyPastePreProcessor preProcessor : CopyPastePreProcessor.EP_NAME.getExtensionList()) {
            newText = preProcessor.preprocessOnPaste(project, file2, editor, newText, rawText);
        }
        boolean pastedTextWasChanged = !text2.equals(newText);
        int indentOptions = pastedTextWasChanged ? 4 : settings2.REFORMAT_ON_PASTE;
        text2 = newText;
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file2) == null && indentOptions != 1) {
            indentOptions = 2;
        }
        String _text = text2;
        ApplicationManager.getApplication().runWriteAction(() -> {
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)_text, (boolean)false, (boolean)true);
            if (!project.isDisposed()) {
                ((UndoManagerImpl)UndoManager.getInstance((Project)project)).addDocumentAsAffected(editor.getDocument());
            }
        });
        int length = text2.length();
        int offset = caretModel.getOffset() - length;
        if (offset < 0) {
            length += offset;
            offset = 0;
        }
        RangeMarker bounds2 = document.createRangeMarker(offset, offset + length);
        caretModel.moveToOffset(bounds2.getEndOffset());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        selectionModel.removeSelection();
        Ref skipIndentation = new Ref((Object)(pastedTextWasChanged ? Boolean.FALSE : null));
        for (Map.Entry e : extraData.entrySet()) {
            SlowOperations.allowSlowOperations(() -> ((CopyPastePostProcessor)e.getKey()).processTransferableData(project, editor, bounds2, caretOffset, (Ref<Boolean>)skipIndentation, (List)e.getValue()));
        }
        boolean pastedTextContainsWhiteSpacesOnly = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)bounds2.getStartOffset(), (String)" \n\t") >= bounds2.getEndOffset();
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (!(pastedTextContainsWhiteSpacesOnly || virtualFile2 != null && SingleRootFileViewProvider.isTooLargeForIntelligence(virtualFile2))) {
            int howtoReformat = skipIndentation.get() == Boolean.TRUE && (indentOptions == 2 || indentOptions == 3) ? 1 : indentOptions;
            ApplicationManager.getApplication().runWriteAction(() -> typingActionsExtension.format(project, editor, howtoReformat, bounds2.getStartOffset(), bounds2.getEndOffset(), blockIndentAnchorColumn, true));
        }
        if (bounds2.isValid()) {
            caretModel.moveToOffset(bounds2.getEndOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            selectionModel.removeSelection();
            editor.putUserData(EditorEx.LAST_PASTED_REGION, (Object)TextRange.create((Segment)bounds2));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typingActionsExtension";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/PasteHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doPaste";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doPasteAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

