/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.BackgroundHighlighter;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.TriConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class BackgroundHighlightingUtil {
    static <T> void lookForInjectedFileInOtherThread(@NotNull Project project, @NotNull Editor editor, @NotNull BiFunction<? super PsiFile, ? super Editor, ? extends T> backgroundProcessor, @NotNull TriConsumer<? super PsiFile, ? super Editor, ? super T> edtProcessor) {
        if (project == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(1);
        }
        if (backgroundProcessor == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(2);
        }
        if (edtProcessor == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!BackgroundHighlightingUtil.isValidEditor(editor)) {
            return;
        }
        int offsetBefore = editor.getCaretModel().getOffset();
        ReadAction.nonBlocking(() -> {
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
            if (psiFile == null) {
                return null;
            }
            if (psiFile instanceof PsiCompiledFile) {
                psiFile = ((PsiCompiledFile)psiFile).getDecompiledPsiFile();
            }
            if (psiFile instanceof PsiBinaryFile && BinaryFileTypeDecompilers.getInstance().forFileType(psiFile.getFileType()) == null) {
                return null;
            }
            PsiFile newFile = BackgroundHighlightingUtil.getInjectedFileIfAny(offsetBefore, psiFile);
            Editor newEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, newFile);
            Object result2 = backgroundProcessor.apply(newFile, newEditor);
            return Trinity.create((Object)newFile, (Object)newEditor, result2);
        }).withDocumentsCommitted(project).expireWhen(() -> !BackgroundHighlightingUtil.isValidEditor(editor)).coalesceBy(new Object[]{BackgroundHighlightingUtil.class, editor}).finishOnUiThread(ModalityState.stateForComponent((Component)editor.getComponent()), t -> {
            if (t == null) {
                return;
            }
            PsiFile foundFile = (PsiFile)t.getFirst();
            Editor newEditor = (Editor)t.getSecond();
            Object result2 = t.getThird();
            if (foundFile == null) {
                return;
            }
            if (foundFile.isValid() && offsetBefore == editor.getCaretModel().getOffset()) {
                edtProcessor.accept((Object)foundFile, (Object)newEditor, result2);
            } else {
                BackgroundHighlightingUtil.lookForInjectedFileInOtherThread(project, editor, backgroundProcessor, edtProcessor);
            }
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static boolean isValidEditor(@NotNull Editor editor) {
        Project editorProject;
        if (editor == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(4);
        }
        return (editorProject = editor.getProject()) != null && !editorProject.isDisposed() && !editor.isDisposed() && UIUtil.isShowing((Component)editor.getContentComponent());
    }

    @NotNull
    private static PsiFile getInjectedFileIfAny(int offset, @NotNull PsiFile psiFile) {
        PsiFile injected;
        PsiElement injectedElement;
        if (psiFile == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(5);
        }
        if ((injectedElement = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).findInjectedElementAt(psiFile, offset)) != null && (injected = injectedElement.getContainingFile()) != null) {
            PsiFile psiFile2 = injected;
            if (psiFile2 == null) {
                BackgroundHighlightingUtil.$$$reportNull$$$0(6);
            }
            return psiFile2;
        }
        PsiFile psiFile3 = psiFile;
        if (psiFile3 == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(7);
        }
        return psiFile3;
    }

    @TestOnly
    public static void enableListenersInTest(@NotNull Project project, @NotNull Disposable disposable2) {
        if (project == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(8);
        }
        if (disposable2 == null) {
            BackgroundHighlightingUtil.$$$reportNull$$$0(9);
        }
        BackgroundHighlighter.enableListenersInTest(project, disposable2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/BackgroundHighlightingUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/BackgroundHighlightingUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedFileIfAny";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "lookForInjectedFileInOtherThread";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValidEditor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedFileIfAny";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "enableListenersInTest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

