/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.codeInsight.highlighting.PsiHighlightedReference;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class HyperlinkAnnotator
implements Annotator {
    private static final Key<@Nls String> messageKey = Key.create((String)"hyperlink.message");

    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        if (element2 == null) {
            HyperlinkAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HyperlinkAnnotator.$$$reportNull$$$0(1);
        }
        if (holder.isBatchMode()) {
            return;
        }
        for (PsiHighlightedReference reference2 : PsiSymbolReferenceService.getService().getReferences(element2, PsiHighlightedReference.class)) {
            TextRange range2 = reference2.getAbsoluteRange();
            if (range2.isEmpty()) continue;
            String message2 = reference2.highlightMessage();
            AnnotationBuilder annotationBuilder = message2 == null ? holder.newSilentAnnotation(reference2.highlightSeverity()) : holder.newAnnotation(reference2.highlightSeverity(), message2);
            reference2.highlightReference(annotationBuilder.range(range2)).create();
        }
        if (WebReference.isWebReferenceWorthy(element2)) {
            for (PsiReference reference3 : element2.getReferences()) {
                TextRange rangeInElement;
                TextRange range3;
                if (reference3 instanceof WebReference) {
                    String message3 = (String)holder.getCurrentAnnotationSession().getUserData(messageKey);
                    if (message3 == null) {
                        message3 = HyperlinkAnnotator.getMessage();
                        holder.getCurrentAnnotationSession().putUserData(messageKey, (Object)message3);
                    }
                    range3 = reference3.getRangeInElement().shiftRight(element2.getTextRange().getStartOffset());
                    holder.newAnnotation(HighlightSeverity.INFORMATION, message3).range(range3).textAttributes(CodeInsightColors.INACTIVE_HYPERLINK_ATTRIBUTES).create();
                    continue;
                }
                if (!(reference3 instanceof HighlightedReference) || reference3.isSoft() || (rangeInElement = reference3.getRangeInElement()).isEmpty()) continue;
                range3 = rangeInElement.shiftRight(element2.getTextRange().getStartOffset());
                holder.newSilentAnnotation(HighlightInfoType.HIGHLIGHTED_REFERENCE_SEVERITY).range(range3).textAttributes(DefaultLanguageHighlighterColors.HIGHLIGHTED_REFERENCE).create();
            }
        }
    }

    @Nls
    @NotNull
    @ApiStatus.Internal
    public static String getMessage() {
        Shortcut keyboardShortcut;
        Object message2 = IdeBundle.message((String)"open.url.in.browser.tooltip", (Object[])new Object[0]);
        Object[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts("GotoDeclaration");
        Object shortcutText = "";
        Shortcut mouseShortcut = (Shortcut)ContainerUtil.find((Object[])shortcuts, shortcut -> !shortcut.isKeyboard());
        if (mouseShortcut != null) {
            shortcutText = (String)shortcutText + KeymapUtil.getShortcutText((Shortcut)mouseShortcut);
            shortcutText = ((String)shortcutText).replace("Button1 ", "");
        }
        if ((keyboardShortcut = (Shortcut)ContainerUtil.find((Object[])shortcuts, shortcut -> shortcut.isKeyboard())) != null) {
            if (!((String)shortcutText).isEmpty()) {
                shortcutText = (String)shortcutText + ", ";
            }
            shortcutText = (String)shortcutText + KeymapUtil.getShortcutText((Shortcut)keyboardShortcut);
        }
        if (!((String)shortcutText).isEmpty()) {
            message2 = (String)message2 + " (" + (String)shortcutText + ")";
        }
        String string = message2;
        if (string == null) {
            HyperlinkAnnotator.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/HyperlinkAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/HyperlinkAnnotator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

