/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.BlockConstrainedPresentation;
import com.intellij.codeInsight.hints.BlockConstraints;
import com.intellij.codeInsight.hints.ConstrainedPresentation;
import com.intellij.codeInsight.hints.HintsBuffer;
import com.intellij.codeInsight.hints.HorizontalConstrainedPresentation;
import com.intellij.codeInsight.hints.HorizontalConstraints;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.InlayHintsSinkImplKt;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.RecursivelyUpdatingRootPresentation;
import com.intellij.codeInsight.hints.presentation.RootInlayPresentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0018H\u0016J&\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000e2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u001aH\u0016J(\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\r\u0010\u001c\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u001dR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsSinkImpl;", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "buffer", "Lcom/intellij/codeInsight/hints/HintsBuffer;", "document", "Lcom/intellij/openapi/editor/Document;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "addBlockElement", "", "logicalLine", "", "showAbove", "", "presentation", "Lcom/intellij/codeInsight/hints/presentation/RootInlayPresentation;", "constraints", "Lcom/intellij/codeInsight/hints/BlockConstraints;", "offset", "relatesToPrecedingText", "priority", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "addInlineElement", "Lcom/intellij/codeInsight/hints/HorizontalConstraints;", "placeAtTheEndOfLine", "complete", "complete$intellij_platform_lang_impl", "intellij.platform.lang.impl"})
public final class InlayHintsSinkImpl
implements InlayHintsSink {
    private final HintsBuffer buffer;
    private final Document document;
    @NotNull
    private final Editor editor;

    public void addInlineElement(int offset, boolean relatesToPrecedingText, @NotNull InlayPresentation presentation2, boolean placeAtTheEndOfLine) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        this.addInlineElement(offset, (RootInlayPresentation)new RecursivelyUpdatingRootPresentation(presentation2), new HorizontalConstraints(0, relatesToPrecedingText, placeAtTheEndOfLine));
    }

    public void addInlineElement(int offset, @NotNull RootInlayPresentation<?> presentation2, @Nullable HorizontalConstraints constraints2) {
        Intrinsics.checkNotNullParameter(presentation2, (String)"presentation");
        InlayHintsSinkImplKt.access$addCreatingListIfNeeded((Int2ObjectMap)this.buffer.getInlineHints(), offset, (ConstrainedPresentation)new HorizontalConstrainedPresentation(presentation2, constraints2));
    }

    public void addBlockElement(int offset, boolean relatesToPrecedingText, boolean showAbove2, int priority, @NotNull InlayPresentation presentation2) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        int line = this.document.getLineNumber(offset);
        RecursivelyUpdatingRootPresentation root = new RecursivelyUpdatingRootPresentation(presentation2);
        this.addBlockElement(line, showAbove2, (RootInlayPresentation)root, new BlockConstraints(relatesToPrecedingText, priority));
    }

    public void addBlockElement(int logicalLine, boolean showAbove2, @NotNull RootInlayPresentation<?> presentation2, @Nullable BlockConstraints constraints2) {
        Intrinsics.checkNotNullParameter(presentation2, (String)"presentation");
        Int2ObjectOpenHashMap<List<ConstrainedPresentation<?, BlockConstraints>>> map2 = showAbove2 ? this.buffer.getBlockAboveHints$intellij_platform_lang_impl() : this.buffer.getBlockBelowHints$intellij_platform_lang_impl();
        int offset = this.document.getLineStartOffset(logicalLine);
        InlayHintsSinkImplKt.access$addCreatingListIfNeeded((Int2ObjectMap)map2, offset, (ConstrainedPresentation)new BlockConstrainedPresentation(presentation2, constraints2));
    }

    @NotNull
    public final HintsBuffer complete$intellij_platform_lang_impl() {
        return this.buffer;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public InlayHintsSinkImpl(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this.buffer = new HintsBuffer();
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        this.document = document;
    }
}

