/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationListener;
import com.intellij.codeInsight.hints.presentation.PresentationUtilKt;
import com.intellij.codeInsight.hints.presentation.SequencePresentation;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001'B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u0002J*\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00100\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u0018\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0004H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\t\u00a8\u0006("}, d2={"Lcom/intellij/codeInsight/hints/presentation/SequencePresentation;", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "presentations", "", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "(Ljava/util/List;)V", "height", "", "getHeight", "()I", "presentationUnderCursor", "getPresentations", "()Ljava/util/List;", "width", "getWidth", "changePresentationUnderCursor", "", "presentation", "handleMouse", "original", "Ljava/awt/Point;", "action", "Lkotlin/Function2;", "mouseClicked", "event", "Ljava/awt/event/MouseEvent;", "translated", "mouseExited", "mouseMoved", "paint", "g", "Ljava/awt/Graphics2D;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toString", "", "updateState", "", "previousPresentation", "InternalListener", "intellij.platform.lang.impl"})
public final class SequencePresentation
extends BasePresentation {
    private InlayPresentation presentationUnderCursor;
    @NotNull
    private final List<InlayPresentation> presentations;

    /*
     * WARNING - void declaration
     */
    public int getWidth() {
        void var3_3;
        Iterable $this$sumBy$iv = this.presentations;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            InlayPresentation inlayPresentation = (InlayPresentation)element$iv;
            int n = sum$iv;
            boolean bl = false;
            int n2 = it.getWidth();
            sum$iv = n + n2;
        }
        return (int)var3_3;
    }

    public int getHeight() {
        Object v0;
        Iterable $this$maxBy$iv = this.presentations;
        boolean $i$f$maxBy = false;
        Iterable $this$maxByOrNull$iv$iv = $this$maxBy$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv$iv = $this$maxByOrNull$iv$iv.iterator();
        if (!iterator$iv$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv$iv = iterator$iv$iv.next();
            if (!iterator$iv$iv.hasNext()) {
                v0 = maxElem$iv$iv;
            } else {
                InlayPresentation it = (InlayPresentation)maxElem$iv$iv;
                boolean bl = false;
                int maxValue$iv$iv = it.getHeight();
                do {
                    Object e$iv$iv = iterator$iv$iv.next();
                    InlayPresentation it2 = (InlayPresentation)e$iv$iv;
                    $i$a$-maxBy-SequencePresentation$height$1 = false;
                    int v$iv$iv = it2.getHeight();
                    if (maxValue$iv$iv >= v$iv$iv) continue;
                    maxElem$iv$iv = e$iv$iv;
                    maxValue$iv$iv = v$iv$iv;
                } while (iterator$iv$iv.hasNext());
                v0 = maxElem$iv$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        return ((InlayPresentation)v0).getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes2) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
        int xOffset = 0;
        try {
            for (InlayPresentation presentation2 : this.presentations) {
                presentation2.paint(g, attributes2);
                xOffset += presentation2.getWidth();
                g.translate(presentation2.getWidth(), 0);
            }
        }
        finally {
            g.translate(-xOffset, 0);
        }
    }

    private final void handleMouse(Point original, Function2<? super InlayPresentation, ? super Point, Unit> action2) {
        int x = original.x;
        int y = original.y;
        if (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight()) {
            return;
        }
        int xOffset = 0;
        for (InlayPresentation presentation2 : this.presentations) {
            int presentationWidth = presentation2.getWidth();
            if (x < xOffset + presentationWidth) {
                if (y > presentation2.getHeight()) {
                    this.changePresentationUnderCursor(null);
                    return;
                }
                this.changePresentationUnderCursor(presentation2);
                Point translated = PresentationUtilKt.translateNew(original, -xOffset, 0);
                action2.invoke((Object)presentation2, (Object)translated);
                return;
            }
            xOffset += presentationWidth;
        }
    }

    public void mouseClicked(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        this.handleMouse(translated, (Function2<? super InlayPresentation, ? super Point, Unit>)((Function2)new Function2<InlayPresentation, Point, Unit>(event){
            final /* synthetic */ MouseEvent $event;

            public final void invoke(@NotNull InlayPresentation presentation2, @NotNull Point point) {
                Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                presentation2.mouseClicked(this.$event, point);
            }
            {
                this.$event = mouseEvent;
                super(2);
            }
        }));
    }

    public void mouseMoved(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        this.handleMouse(translated, (Function2<? super InlayPresentation, ? super Point, Unit>)((Function2)new Function2<InlayPresentation, Point, Unit>(event){
            final /* synthetic */ MouseEvent $event;

            public final void invoke(@NotNull InlayPresentation presentation2, @NotNull Point point) {
                Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                presentation2.mouseMoved(this.$event, point);
            }
            {
                this.$event = mouseEvent;
                super(2);
            }
        }));
    }

    public void mouseExited() {
        this.changePresentationUnderCursor(null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean updateState(@NotNull InlayPresentation previousPresentation) {
        Intrinsics.checkNotNullParameter((Object)previousPresentation, (String)"previousPresentation");
        if (!(previousPresentation instanceof SequencePresentation)) {
            return true;
        }
        if (((SequencePresentation)previousPresentation).presentations.size() != this.presentations.size()) {
            return true;
        }
        List<InlayPresentation> previousPresentations = ((SequencePresentation)previousPresentation).presentations;
        boolean changed2 = false;
        boolean bl = false;
        for (InlayPresentation presentation2 : (Iterable)this.presentations) {
            void index2;
            if (presentation2.updateState(previousPresentations.get((int)index2))) {
                changed2 = true;
            }
            ++index2;
        }
        return changed2;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.presentations, (CharSequence)" ", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)toString.1.INSTANCE, (int)24, null);
    }

    private final void changePresentationUnderCursor(InlayPresentation presentation2) {
        if (Intrinsics.areEqual((Object)this.presentationUnderCursor, (Object)presentation2) ^ true) {
            InlayPresentation inlayPresentation = this.presentationUnderCursor;
            if (inlayPresentation != null) {
                inlayPresentation.mouseExited();
            }
            this.presentationUnderCursor = presentation2;
        }
    }

    @NotNull
    public final List<InlayPresentation> getPresentations() {
        return this.presentations;
    }

    public SequencePresentation(@NotNull List<? extends InlayPresentation> presentations) {
        Intrinsics.checkNotNullParameter(presentations, (String)"presentations");
        this.presentations = presentations;
        if (this.presentations.isEmpty()) {
            throw (Throwable)new IllegalArgumentException();
        }
        for (InlayPresentation presentation2 : this.presentations) {
            presentation2.addListener((PresentationListener)new InternalListener(presentation2));
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/codeInsight/hints/presentation/SequencePresentation$InternalListener;", "Lcom/intellij/codeInsight/hints/presentation/PresentationListener;", "currentPresentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "(Lcom/intellij/codeInsight/hints/presentation/SequencePresentation;Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;)V", "contentChanged", "", "area", "Ljava/awt/Rectangle;", "shiftOfCurrent", "", "sizeChanged", "previous", "Ljava/awt/Dimension;", "current", "intellij.platform.lang.impl"})
    private final class InternalListener
    implements PresentationListener {
        private final InlayPresentation currentPresentation;

        public void contentChanged(@NotNull Rectangle area) {
            Intrinsics.checkNotNullParameter((Object)area, (String)"area");
            area.add(this.shiftOfCurrent(), 0);
            SequencePresentation.this.fireContentChanged(area);
        }

        public void sizeChanged(@NotNull Dimension previous, @NotNull Dimension current2) {
            Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
            Intrinsics.checkNotNullParameter((Object)current2, (String)"current");
            SequencePresentation.this.fireSizeChanged(previous, current2);
        }

        private final int shiftOfCurrent() {
            int shift = 0;
            for (InlayPresentation presentation2 : SequencePresentation.this.getPresentations()) {
                if (presentation2 == this.currentPresentation) {
                    return shift;
                }
                shift += presentation2.getWidth();
            }
            throw (Throwable)new IllegalStateException();
        }

        public InternalListener(InlayPresentation currentPresentation) {
            Intrinsics.checkNotNullParameter((Object)currentPresentation, (String)"currentPresentation");
            this.currentPresentation = currentPresentation;
        }
    }
}

