/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.FList;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LookupPreview {
    private final List<Inlay> myInlays = new ArrayList<Inlay>();
    private final LookupImpl myLookup;

    LookupPreview(LookupImpl lookup2) {
        this.myLookup = lookup2;
    }

    void updatePreview(@Nullable LookupElement item) {
        if (!Registry.is((String)"ide.lookup.preview.insertion")) {
            return;
        }
        this.myInlays.forEach(Disposer::dispose);
        this.myInlays.clear();
        String suffix = this.getSuffixText(item);
        Editor editor = this.myLookup.getTopLevelEditor();
        if (!suffix.isEmpty() && editor instanceof EditorImpl && !editor.getSelectionModel().hasSelection() && InplaceRefactoring.getActiveInplaceRenamer(editor) == null) {
            this.myLookup.performGuardedChange(() -> {
                for (Caret caret : editor.getCaretModel().getAllCarets()) {
                    LookupPreview.ensureCaretBeforeInlays(caret);
                    this.addInlay(suffix, caret.getOffset());
                }
            });
        }
    }

    private static void ensureCaretBeforeInlays(Caret caret) {
        LogicalPosition position = caret.getLogicalPosition();
        if (position.leansForward) {
            caret.moveToLogicalPosition(position.leanForward(false));
        }
    }

    private String getSuffixText(@Nullable LookupElement item) {
        if (item != null) {
            String itemText = StringUtil.notNullize((String)LookupElementPresentation.renderElement((LookupElement)item).getItemText());
            String prefix2 = this.myLookup.itemPattern(item);
            if (prefix2.isEmpty()) {
                return itemText;
            }
            FList<TextRange> fragments = LookupCellRenderer.getMatchingFragments(prefix2, itemText);
            if (fragments != null && !fragments.isEmpty()) {
                ArrayList<TextRange> list2 = new ArrayList<TextRange>((Collection<TextRange>)fragments);
                return itemText.substring(((TextRange)list2.get(list2.size() - 1)).getEndOffset());
            }
        }
        return "";
    }

    private void addInlay(String suffix, int caretOffset) {
        Inlay inlay = this.myLookup.getTopLevelEditor().getInlayModel().addInlineElement(caretOffset, true, LookupPreview.createGrayRenderer(suffix));
        if (inlay != null) {
            this.myInlays.add(inlay);
            Disposer.register((Disposable)this.myLookup, (Disposable)inlay);
        }
    }

    @NotNull
    private static EditorCustomElementRenderer createGrayRenderer(final String suffix) {
        return new EditorCustomElementRenderer(){

            public int calcWidthInPixels(@NotNull Inlay inlay) {
                if (inlay == null) {
                    1.$$$reportNull$$$0(0);
                }
                Editor editor = inlay.getEditor();
                return editor.getContentComponent().getFontMetrics(this.getFont(editor)).stringWidth(suffix);
            }

            public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
                if (inlay == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (g == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (r == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (textAttributes == null) {
                    1.$$$reportNull$$$0(4);
                }
                Editor editor = inlay.getEditor();
                g.setColor((Color)JBColor.GRAY);
                g.setFont(this.getFont(editor));
                g.drawString(suffix, r.x, r.y + editor.getAscent());
            }

            private Font getFont(@NotNull Editor editor) {
                if (editor == null) {
                    1.$$$reportNull$$$0(5);
                }
                return editor.getColorsScheme().getFont(EditorFontType.PLAIN);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inlay";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "g";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "r";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "textAttributes";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupPreview$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "calcWidthInPixels";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "paint";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getFont";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }
}

