/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.CtrlMouseAction;
import com.intellij.codeInsight.navigation.CtrlMouseDocInfo;
import com.intellij.codeInsight.navigation.CtrlMouseInfo;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.navigation.SingleTargetElementInfo;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.CancellablePromise;

@ApiStatus.Internal
public final class CtrlMouseHandler {
    static final Logger LOG = Logger.getInstance(CtrlMouseHandler.class);
    private final Project myProject;
    private HighlightersSet myHighlighter;
    @JdkConstants.InputEventMask
    private int myStoredModifiers;
    private TooltipProvider myTooltipProvider;
    @Nullable
    private Point myPrevMouseLocation;
    private LightweightHint myHint;
    private final KeyListener myEditorKeyListener;
    private final VisibleAreaListener myVisibleAreaListener;
    private final EditorMouseListener myEditorMouseAdapter;
    private final EditorMouseMotionListener myEditorMouseMotionListener;

    public CtrlMouseHandler(@NotNull Project project) {
        if (project == null) {
            CtrlMouseHandler.$$$reportNull$$$0(0);
        }
        this.myEditorKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.handleKey(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.handleKey(e);
            }

            private void handleKey(KeyEvent e) {
                int modifiers = e.getModifiers();
                if (modifiers == CtrlMouseHandler.this.myStoredModifiers) {
                    return;
                }
                CtrlMouseAction action2 = CtrlMouseHandler.getCtrlMouseAction(modifiers);
                if (action2 == null) {
                    CtrlMouseHandler.this.disposeHighlighter();
                    CtrlMouseHandler.this.cancelPreviousTooltip();
                } else {
                    TooltipProvider tooltipProvider = CtrlMouseHandler.this.myTooltipProvider;
                    if (tooltipProvider != null) {
                        if (action2 != tooltipProvider.getAction()) {
                            CtrlMouseHandler.this.disposeHighlighter();
                        }
                        CtrlMouseHandler.this.myStoredModifiers = modifiers;
                        CtrlMouseHandler.this.cancelPreviousTooltip();
                        CtrlMouseHandler.this.myTooltipProvider = new TooltipProvider(tooltipProvider, action2);
                        CtrlMouseHandler.this.myTooltipProvider.execute();
                    }
                }
            }
        };
        this.myVisibleAreaListener = __ -> {
            this.disposeHighlighter();
            this.cancelPreviousTooltip();
        };
        this.myEditorMouseAdapter = new EditorMouseListener(){

            public void mouseReleased(@NotNull EditorMouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                CtrlMouseHandler.this.disposeHighlighter();
                CtrlMouseHandler.this.cancelPreviousTooltip();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/navigation/CtrlMouseHandler$2", "mouseReleased"));
            }
        };
        this.myEditorMouseMotionListener = new EditorMouseMotionListener(){

            public void mouseMoved(@NotNull EditorMouseEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (e.isConsumed() || !CtrlMouseHandler.this.myProject.isInitialized() || CtrlMouseHandler.this.myProject.isDisposed()) {
                    return;
                }
                MouseEvent mouseEvent = e.getMouseEvent();
                Point prevLocation = CtrlMouseHandler.this.myPrevMouseLocation;
                CtrlMouseHandler.this.myPrevMouseLocation = mouseEvent.getLocationOnScreen();
                if (CtrlMouseHandler.this.isMouseOverTooltip(mouseEvent.getLocationOnScreen()) || ScreenUtil.isMovementTowards((Point)prevLocation, (Point)mouseEvent.getLocationOnScreen(), (Rectangle)CtrlMouseHandler.this.getHintBounds())) {
                    return;
                }
                CtrlMouseHandler.this.cancelPreviousTooltip();
                CtrlMouseHandler.this.myStoredModifiers = mouseEvent.getModifiers();
                CtrlMouseAction ctrlMouseAction = CtrlMouseHandler.getCtrlMouseAction(CtrlMouseHandler.this.myStoredModifiers);
                if (ctrlMouseAction == null || e.getArea() != EditorMouseEventArea.EDITING_AREA) {
                    CtrlMouseHandler.this.disposeHighlighter();
                    return;
                }
                Editor editor = e.getEditor();
                if (!(editor instanceof EditorEx) || editor.getProject() != null && editor.getProject() != CtrlMouseHandler.this.myProject) {
                    return;
                }
                if (!e.isOverText()) {
                    CtrlMouseHandler.this.disposeHighlighter();
                    return;
                }
                CtrlMouseHandler.this.myTooltipProvider = new TooltipProvider((EditorEx)editor, e.getLogicalPosition(), ctrlMouseAction);
                CtrlMouseHandler.this.myTooltipProvider.execute();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/navigation/CtrlMouseHandler$3", "mouseMoved"));
            }
        };
        this.myProject = project;
        StartupManager.getInstance((Project)project).runAfterOpened(() -> {
            EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
            eventMulticaster.addEditorMouseListener(this.myEditorMouseAdapter, (Disposable)project);
            eventMulticaster.addEditorMouseMotionListener(this.myEditorMouseMotionListener, (Disposable)project);
            eventMulticaster.addCaretListener(new CaretListener(){

                public void caretPositionChanged(@NotNull CaretEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (CtrlMouseHandler.this.myHint != null) {
                        DocumentationManager.getInstance(CtrlMouseHandler.this.myProject).updateToolwindowContext();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/navigation/CtrlMouseHandler$4", "caretPositionChanged"));
                }
            }, (Disposable)project);
        });
        project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                CtrlMouseHandler.this.disposeHighlighter();
                CtrlMouseHandler.this.cancelPreviousTooltip();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/navigation/CtrlMouseHandler$5", "selectionChanged"));
            }
        });
    }

    private void cancelPreviousTooltip() {
        if (this.myTooltipProvider != null) {
            this.myTooltipProvider.dispose();
            this.myTooltipProvider = null;
        }
    }

    private boolean isMouseOverTooltip(@NotNull Point mouseLocationOnScreen) {
        Rectangle bounds2;
        if (mouseLocationOnScreen == null) {
            CtrlMouseHandler.$$$reportNull$$$0(1);
        }
        return (bounds2 = this.getHintBounds()) != null && bounds2.contains(mouseLocationOnScreen);
    }

    @Nullable
    private Rectangle getHintBounds() {
        LightweightHint hint = this.myHint;
        if (hint == null) {
            return null;
        }
        JComponent hintComponent = hint.getComponent();
        if (!hintComponent.isShowing()) {
            return null;
        }
        return new Rectangle(hintComponent.getLocationOnScreen(), hintComponent.getSize());
    }

    @Nullable
    private static CtrlMouseAction getCtrlMouseAction(@JdkConstants.InputEventMask int modifiers) {
        if (modifiers == 0) {
            return null;
        }
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        if (keymapManager2 == null) {
            return null;
        }
        MouseShortcut shortcut = new MouseShortcut(1, modifiers, 1);
        List actionIds = keymapManager2.getActiveKeymap().getActionIds(shortcut);
        return (CtrlMouseAction)ContainerUtil.getOnlyItem((Collection)ContainerUtil.mapNotNull((Collection)actionIds, CtrlMouseHandler::getCtrlMouseAction));
    }

    @Nullable
    private static CtrlMouseAction getCtrlMouseAction(@NotNull String actionId) {
        AnAction action2;
        if (actionId == null) {
            CtrlMouseHandler.$$$reportNull$$$0(2);
        }
        return (action2 = ActionManager.getInstance().getAction(actionId)) instanceof CtrlMouseAction ? (CtrlMouseAction)action2 : null;
    }

    private static boolean areSimilar(@NotNull CtrlMouseInfo info1, @NotNull CtrlMouseInfo info2) {
        if (info1 == null) {
            CtrlMouseHandler.$$$reportNull$$$0(3);
        }
        if (info2 == null) {
            CtrlMouseHandler.$$$reportNull$$$0(4);
        }
        return info1.getRanges().equals(info2.getRanges());
    }

    private static boolean isValidAndRangesAreCorrect(@NotNull CtrlMouseInfo info2, @NotNull Document document) {
        if (info2 == null) {
            CtrlMouseHandler.$$$reportNull$$$0(5);
        }
        if (document == null) {
            CtrlMouseHandler.$$$reportNull$$$0(6);
        }
        if (!info2.isValid()) {
            return false;
        }
        List<TextRange> ranges = info2.getRanges();
        TextRange docRange = new TextRange(0, document.getTextLength());
        for (TextRange range2 : ranges) {
            if (docRange.contains(range2)) continue;
            return false;
        }
        return true;
    }

    private static void showDumbModeNotification(@NotNull Project project) {
        if (project == null) {
            CtrlMouseHandler.$$$reportNull$$$0(7);
        }
        DumbService.getInstance((Project)project).showDumbModeNotification(CodeInsightBundle.message((String)"notification.element.information.is.not.available.during.index.update", (Object[])new Object[0]));
    }

    private void disposeHighlighter() {
        HighlightersSet highlighter = this.myHighlighter;
        if (highlighter != null) {
            this.myHighlighter = null;
            highlighter.uninstall();
            HintManager.getInstance().hideAllHints();
        }
    }

    private void updateText(@NotNull String updatedText, @NotNull Consumer<? super String> newTextConsumer, @NotNull LightweightHint hint, @NotNull Editor editor) {
        if (updatedText == null) {
            CtrlMouseHandler.$$$reportNull$$$0(8);
        }
        if (newTextConsumer == null) {
            CtrlMouseHandler.$$$reportNull$$$0(9);
        }
        if (hint == null) {
            CtrlMouseHandler.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            CtrlMouseHandler.$$$reportNull$$$0(11);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            JComponent component2 = hint.getComponent();
            Dimension oldSize = component2.getPreferredSize();
            newTextConsumer.consume((Object)updatedText);
            Dimension newSize = component2.getPreferredSize();
            if (newSize.width == oldSize.width) {
                return;
            }
            component2.setPreferredSize(new Dimension(newSize.width, newSize.height));
            if (hint.isRealPopup()) {
                TooltipProvider tooltipProvider = this.myTooltipProvider;
                if (tooltipProvider != null) {
                    hint.hide();
                    tooltipProvider.showHint(new LightweightHint(component2), editor);
                } else {
                    component2.setPreferredSize(new Dimension(newSize.width, oldSize.height));
                    hint.pack();
                }
                return;
            }
            Container topLevelLayeredPaneChild = null;
            boolean adjustBounds = false;
            for (Container current2 = component2.getParent(); current2 != null; current2 = current2.getParent()) {
                if (current2 instanceof JLayeredPane) {
                    adjustBounds = true;
                    break;
                }
                topLevelLayeredPaneChild = current2;
            }
            if (adjustBounds && topLevelLayeredPaneChild != null) {
                Rectangle bounds2 = topLevelLayeredPaneChild.getBounds();
                topLevelLayeredPaneChild.setBounds(bounds2.x, bounds2.y, bounds2.width + newSize.width - oldSize.width, bounds2.height);
            }
        });
    }

    @NotNull
    private HighlightersSet installHighlighterSet(@NotNull CtrlMouseInfo info2, @NotNull EditorEx editor, boolean highlighterOnly) {
        if (info2 == null) {
            CtrlMouseHandler.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            CtrlMouseHandler.$$$reportNull$$$0(13);
        }
        editor.getContentComponent().addKeyListener(this.myEditorKeyListener);
        editor.getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        if (info2.isNavigatable()) {
            editor.setCustomCursor(CtrlMouseHandler.class, Cursor.getPredefinedCursor(12));
        }
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        if (!highlighterOnly || info2.isNavigatable()) {
            TextAttributes attributes2 = info2.isNavigatable() ? EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR) : new TextAttributes(null, HintUtil.getInformationColor(), null, null, 0);
            for (TextRange range2 : info2.getRanges()) {
                TextAttributes attr = NavigationUtil.patchAttributesColor(attributes2, range2, editor);
                RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(range2.getStartOffset(), range2.getEndOffset(), 5900, attr, HighlighterTargetArea.EXACT_RANGE);
                highlighters.add(highlighter);
            }
        }
        return new HighlightersSet(highlighters, editor, info2);
    }

    @TestOnly
    public boolean isCalculationInProgress() {
        TooltipProvider provider2 = this.myTooltipProvider;
        if (provider2 == null) {
            return false;
        }
        CancellablePromise<?> progress2 = provider2.myExecutionProgress;
        if (progress2 == null) {
            return false;
        }
        return !progress2.isDone();
    }

    @TestOnly
    @Nullable
    public static String getInfo(PsiElement element2, PsiElement atPointer) {
        return SingleTargetElementInfo.generateInfo((PsiElement)element2, (PsiElement)atPointer, (boolean)true).text;
    }

    @TestOnly
    @Nullable
    public static String getGoToDeclarationOrUsagesText(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            CtrlMouseHandler.$$$reportNull$$$0(14);
        }
        if ((project = editor.getProject()) == null) {
            return null;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return null;
        }
        CtrlMouseInfo ctrlMouseInfo2 = CtrlMouseHandler.getCtrlMouseInfo("GotoDeclaration", editor, file2, editor.getCaretModel().getOffset());
        return ctrlMouseInfo2 == null ? null : ctrlMouseInfo2.getDocInfo().text;
    }

    @ApiStatus.Internal
    @Nullable
    public static CtrlMouseInfo getCtrlMouseInfo(@NotNull String actionId, @NotNull Editor editor, @NotNull PsiFile file2, int offset) {
        CtrlMouseAction action2;
        if (actionId == null) {
            CtrlMouseHandler.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            CtrlMouseHandler.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            CtrlMouseHandler.$$$reportNull$$$0(17);
        }
        if ((action2 = CtrlMouseHandler.getCtrlMouseAction(actionId)) == null) {
            return null;
        }
        return action2.getCtrlMouseInfo(editor, file2, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseLocationOnScreen";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info2";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTextConsumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isMouseOverTooltip";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCtrlMouseAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "areSimilar";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidAndRangesAreCorrect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showDumbModeNotification";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "updateText";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "installHighlighterSet";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getGoToDeclarationOrUsagesText";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getCtrlMouseInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class QuickDocHyperlinkListener
    implements HyperlinkListener {
        @NotNull
        private final DocumentationProvider myProvider;
        @NotNull
        private final PsiElement myContext;

        QuickDocHyperlinkListener(@NotNull DocumentationProvider provider2, PsiElement context2) {
            if (provider2 == null) {
                QuickDocHyperlinkListener.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                QuickDocHyperlinkListener.$$$reportNull$$$0(1);
            }
            this.myProvider = provider2;
            this.myContext = context2;
        }

        @Override
        public void hyperlinkUpdate(@NotNull HyperlinkEvent e) {
            if (e == null) {
                QuickDocHyperlinkListener.$$$reportNull$$$0(2);
            }
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            String description2 = e.getDescription();
            if (StringUtil.isEmpty((String)description2) || !description2.startsWith("psi_element://")) {
                return;
            }
            String elementName = e.getDescription().substring("psi_element://".length());
            DumbService.getInstance((Project)CtrlMouseHandler.this.myProject).withAlternativeResolveEnabled(() -> {
                PsiElement targetElement = this.myProvider.getDocumentationElementForLink(PsiManager.getInstance((Project)CtrlMouseHandler.this.myProject), elementName, this.myContext);
                if (targetElement != null) {
                    LightweightHint hint = CtrlMouseHandler.this.myHint;
                    if (hint != null) {
                        hint.hide(true);
                    }
                    DocumentationManager.getInstance(CtrlMouseHandler.this.myProject).showJavaDocInfo(targetElement, this.myContext, null);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$QuickDocHyperlinkListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class HighlightersSet {
        @NotNull
        private final List<? extends RangeHighlighter> myHighlighters;
        @NotNull
        private final EditorEx myHighlighterView;
        @NotNull
        private final CtrlMouseInfo myStoredInfo;

        private HighlightersSet(@NotNull List<? extends RangeHighlighter> highlighters, @NotNull EditorEx highlighterView, CtrlMouseInfo storedInfo) {
            if (highlighters == null) {
                HighlightersSet.$$$reportNull$$$0(0);
            }
            if (highlighterView == null) {
                HighlightersSet.$$$reportNull$$$0(1);
            }
            if (storedInfo == null) {
                HighlightersSet.$$$reportNull$$$0(2);
            }
            this.myHighlighters = highlighters;
            this.myHighlighterView = highlighterView;
            this.myStoredInfo = storedInfo;
        }

        public void uninstall() {
            for (RangeHighlighter rangeHighlighter : this.myHighlighters) {
                rangeHighlighter.dispose();
            }
            this.myHighlighterView.setCustomCursor(CtrlMouseHandler.class, null);
            this.myHighlighterView.getContentComponent().removeKeyListener(CtrlMouseHandler.this.myEditorKeyListener);
            this.myHighlighterView.getScrollingModel().removeVisibleAreaListener(CtrlMouseHandler.this.myVisibleAreaListener);
        }

        @NotNull
        CtrlMouseInfo getStoredInfo() {
            CtrlMouseInfo ctrlMouseInfo2 = this.myStoredInfo;
            if (ctrlMouseInfo2 == null) {
                HighlightersSet.$$$reportNull$$$0(3);
            }
            return ctrlMouseInfo2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlighters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlighterView";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storedInfo";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$HighlightersSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$HighlightersSet";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStoredInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class TooltipProvider {
        @NotNull
        private final EditorEx myHostEditor;
        private final int myHostOffset;
        @NotNull
        private final CtrlMouseAction myAction;
        private boolean myDisposed;
        private CancellablePromise<?> myExecutionProgress;

        TooltipProvider(@NotNull EditorEx hostEditor, @NotNull LogicalPosition hostPos, CtrlMouseAction action2) {
            if (hostEditor == null) {
                TooltipProvider.$$$reportNull$$$0(0);
            }
            if (hostPos == null) {
                TooltipProvider.$$$reportNull$$$0(1);
            }
            if (action2 == null) {
                TooltipProvider.$$$reportNull$$$0(2);
            }
            this.myHostEditor = hostEditor;
            this.myHostOffset = hostEditor.logicalPositionToOffset(hostPos);
            this.myAction = action2;
        }

        TooltipProvider(@NotNull TooltipProvider source, CtrlMouseAction action2) {
            if (action2 == null) {
                TooltipProvider.$$$reportNull$$$0(3);
            }
            if (source == null) {
                TooltipProvider.$$$reportNull$$$0(4);
            }
            this.myHostEditor = source.myHostEditor;
            this.myHostOffset = source.myHostOffset;
            this.myAction = action2;
        }

        void dispose() {
            this.myDisposed = true;
            if (this.myExecutionProgress != null) {
                this.myExecutionProgress.cancel();
            }
        }

        @NotNull
        CtrlMouseAction getAction() {
            CtrlMouseAction ctrlMouseAction = this.myAction;
            if (ctrlMouseAction == null) {
                TooltipProvider.$$$reportNull$$$0(5);
            }
            return ctrlMouseAction;
        }

        void execute() {
            if (PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).getPsiFile((Document)this.myHostEditor.getDocument()) == null) {
                return;
            }
            int selStart = this.myHostEditor.getSelectionModel().getSelectionStart();
            int selEnd = this.myHostEditor.getSelectionModel().getSelectionEnd();
            if (this.myHostOffset >= selStart && this.myHostOffset < selEnd) {
                CtrlMouseHandler.this.disposeHighlighter();
                return;
            }
            this.myExecutionProgress = ReadAction.nonBlocking(() -> this.doExecute()).withDocumentsCommitted(CtrlMouseHandler.this.myProject).expireWhen(() -> this.isTaskOutdated(this.myHostEditor)).finishOnUiThread(ModalityState.defaultModalityState(), Runnable::run).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }

        private Runnable createDisposalContinuation() {
            return () -> CtrlMouseHandler.this.disposeHighlighter();
        }

        @NotNull
        private Runnable doExecute() {
            CtrlMouseInfo info2;
            EditorEx editor;
            block8: {
                Runnable runnable2;
                editor = this.getPossiblyInjectedEditor();
                int offset = this.getOffset(editor);
                PsiFile file2 = PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).getPsiFile((Document)editor.getDocument());
                if (file2 == null) {
                    Runnable runnable3 = this.createDisposalContinuation();
                    if (runnable3 == null) {
                        TooltipProvider.$$$reportNull$$$0(6);
                    }
                    return runnable3;
                }
                try {
                    info2 = this.myAction.getCtrlMouseInfo(editor, file2, offset);
                    if (info2 != null) break block8;
                    runnable2 = this.createDisposalContinuation();
                }
                catch (IndexNotReadyException e) {
                    CtrlMouseHandler.showDumbModeNotification(CtrlMouseHandler.this.myProject);
                    Runnable runnable4 = this.createDisposalContinuation();
                    if (runnable4 == null) {
                        TooltipProvider.$$$reportNull$$$0(8);
                    }
                    return runnable4;
                }
                if (runnable2 == null) {
                    TooltipProvider.$$$reportNull$$$0(7);
                }
                return runnable2;
            }
            CtrlMouseDocInfo docInfo = info2.getDocInfo();
            LOG.debug("Obtained info about element under cursor");
            Runnable runnable5 = () -> this.addHighlighterAndShowHint(info2, docInfo, editor);
            if (runnable5 == null) {
                TooltipProvider.$$$reportNull$$$0(9);
            }
            return runnable5;
        }

        @NotNull
        private EditorEx getPossiblyInjectedEditor() {
            DocumentEx document = this.myHostEditor.getDocument();
            if (PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).isCommitted((Document)document)) {
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).getPsiFile((Document)document);
                EditorEx editorEx = (EditorEx)InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)this.myHostEditor, psiFile, this.myHostOffset);
                if (editorEx == null) {
                    TooltipProvider.$$$reportNull$$$0(10);
                }
                return editorEx;
            }
            EditorEx editorEx = this.myHostEditor;
            if (editorEx == null) {
                TooltipProvider.$$$reportNull$$$0(11);
            }
            return editorEx;
        }

        private boolean isTaskOutdated(@NotNull Editor editor) {
            if (editor == null) {
                TooltipProvider.$$$reportNull$$$0(12);
            }
            return this.myDisposed || CtrlMouseHandler.this.myProject.isDisposed() || editor.isDisposed() || !ApplicationManager.getApplication().isUnitTestMode() && !UIUtil.isShowing((Component)editor.getContentComponent());
        }

        private int getOffset(@NotNull Editor editor) {
            if (editor == null) {
                TooltipProvider.$$$reportNull$$$0(13);
            }
            return editor instanceof EditorWindow ? ((EditorWindow)editor).getDocument().hostToInjected(this.myHostOffset) : this.myHostOffset;
        }

        private void addHighlighterAndShowHint(@NotNull CtrlMouseInfo info2, @NotNull CtrlMouseDocInfo docInfo, @NotNull EditorEx editor) {
            LightweightHint hint;
            if (info2 == null) {
                TooltipProvider.$$$reportNull$$$0(14);
            }
            if (docInfo == null) {
                TooltipProvider.$$$reportNull$$$0(15);
            }
            if (editor == null) {
                TooltipProvider.$$$reportNull$$$0(16);
            }
            if (this.myDisposed || editor.isDisposed()) {
                return;
            }
            if (CtrlMouseHandler.this.myHighlighter != null) {
                if (!CtrlMouseHandler.areSimilar(info2, CtrlMouseHandler.this.myHighlighter.getStoredInfo())) {
                    CtrlMouseHandler.this.disposeHighlighter();
                } else {
                    if (info2.isNavigatable()) {
                        editor.setCustomCursor(CtrlMouseHandler.class, Cursor.getPredefinedCursor(12));
                    }
                    return;
                }
            }
            if (!CtrlMouseHandler.isValidAndRangesAreCorrect(info2, editor.getDocument()) || !info2.isNavigatable() && docInfo.text == null) {
                return;
            }
            boolean highlighterOnly = EditorSettingsExternalizable.getInstance().isShowQuickDocOnMouseOverElement() && DocumentationManager.getInstance(CtrlMouseHandler.this.myProject).getDocInfoHint() != null;
            CtrlMouseHandler.this.myHighlighter = CtrlMouseHandler.this.installHighlighterSet(info2, editor, highlighterOnly);
            if (highlighterOnly || docInfo.text == null) {
                return;
            }
            QuickDocHyperlinkListener hyperlinkListener = docInfo.docProvider == null || docInfo.context == null ? null : new QuickDocHyperlinkListener(docInfo.docProvider, docInfo.context);
            Ref newTextConsumerRef = new Ref();
            JComponent component2 = HintUtil.createInformationLabel(docInfo.text, hyperlinkListener, null, (Ref<? super Consumer<String>>)newTextConsumerRef);
            component2.setBorder((Border)JBUI.Borders.empty((int)6, (int)6, (int)5, (int)6));
            CtrlMouseHandler.this.myHint = hint = new LightweightHint(this.wrapInScrollPaneIfNeeded(component2, editor));
            hint.addHintListener(__ -> {
                CtrlMouseHandler.this.myHint = null;
            });
            this.showHint(hint, editor);
            Consumer newTextConsumer = (Consumer)newTextConsumerRef.get();
            if (newTextConsumer != null) {
                this.updateOnPsiChanges(hint, info2, (Consumer<? super String>)newTextConsumer, docInfo.text, editor);
            }
        }

        @NotNull
        private JComponent wrapInScrollPaneIfNeeded(@NotNull JComponent component2, @NotNull Editor editor) {
            if (component2 == null) {
                TooltipProvider.$$$reportNull$$$0(17);
            }
            if (editor == null) {
                TooltipProvider.$$$reportNull$$$0(18);
            }
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                Dimension preferredSize = component2.getPreferredSize();
                Dimension maxSize2 = this.getMaxPopupSize(editor);
                if (preferredSize.width > maxSize2.width || preferredSize.height > maxSize2.height) {
                    JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)component2, (boolean)true);
                    scrollPane.setPreferredSize(new Dimension(Math.min(preferredSize.width, maxSize2.width), Math.min(preferredSize.height, maxSize2.height)));
                    JScrollPane jScrollPane = scrollPane;
                    if (jScrollPane == null) {
                        TooltipProvider.$$$reportNull$$$0(19);
                    }
                    return jScrollPane;
                }
            }
            JComponent jComponent = component2;
            if (jComponent == null) {
                TooltipProvider.$$$reportNull$$$0(20);
            }
            return jComponent;
        }

        @NotNull
        private Dimension getMaxPopupSize(@NotNull Editor editor) {
            if (editor == null) {
                TooltipProvider.$$$reportNull$$$0(21);
            }
            Rectangle rectangle = ScreenUtil.getScreenRectangle((Component)editor.getContentComponent());
            return new Dimension((int)(0.9 * (double)Math.max(640, rectangle.width)), (int)(0.33 * (double)Math.max(480, rectangle.height)));
        }

        private void updateOnPsiChanges(@NotNull LightweightHint hint, @NotNull CtrlMouseInfo info2, @NotNull Consumer<? super String> textConsumer, @NotNull String oldText, @NotNull Editor editor) {
            if (hint == null) {
                TooltipProvider.$$$reportNull$$$0(22);
            }
            if (info2 == null) {
                TooltipProvider.$$$reportNull$$$0(23);
            }
            if (textConsumer == null) {
                TooltipProvider.$$$reportNull$$$0(24);
            }
            if (oldText == null) {
                TooltipProvider.$$$reportNull$$$0(25);
            }
            if (editor == null) {
                TooltipProvider.$$$reportNull$$$0(26);
            }
            if (!hint.isVisible()) {
                return;
            }
            Disposable hintDisposable = Disposer.newDisposable((String)"CtrlMouseHandler.TooltipProvider.updateOnPsiChanges");
            hint.addHintListener(__ -> Disposer.dispose((Disposable)hintDisposable));
            CtrlMouseHandler.this.myProject.getMessageBus().connect(hintDisposable).subscribe(PsiModificationTracker.TOPIC, () -> ReadAction.nonBlocking(() -> {
                try {
                    CtrlMouseDocInfo newDocInfo = info2.getDocInfo();
                    return () -> {
                        if (newDocInfo.text != null && !oldText.equals(newDocInfo.text)) {
                            CtrlMouseHandler.this.updateText(newDocInfo.text, textConsumer, hint, editor);
                        }
                    };
                }
                catch (IndexNotReadyException e) {
                    CtrlMouseHandler.showDumbModeNotification(CtrlMouseHandler.this.myProject);
                    return this.createDisposalContinuation();
                }
            }).finishOnUiThread(ModalityState.defaultModalityState(), Runnable::run).withDocumentsCommitted(CtrlMouseHandler.this.myProject).expireWith(hintDisposable).expireWhen(() -> !CtrlMouseHandler.isValidAndRangesAreCorrect(info2, editor.getDocument())).coalesceBy(new Object[]{CtrlMouseHandler.class, hint}).submit((Executor)AppExecutorUtil.getAppExecutorService()));
        }

        public void showHint(@NotNull LightweightHint hint, @NotNull Editor editor) {
            if (hint == null) {
                TooltipProvider.$$$reportNull$$$0(27);
            }
            if (editor == null) {
                TooltipProvider.$$$reportNull$$$0(28);
            }
            if (ApplicationManager.getApplication().isUnitTestMode() || editor.isDisposed()) {
                return;
            }
            HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
            short constraint = 1;
            LogicalPosition position = editor.offsetToLogicalPosition(this.getOffset(editor));
            Point p = HintManagerImpl.getHintPosition(hint, editor, position, constraint);
            if (p.y - hint.getComponent().getPreferredSize().height < 0) {
                constraint = 2;
                p = HintManagerImpl.getHintPosition(hint, editor, position, constraint);
            }
            hintManager.showEditorHint(hint, editor, p, 42, 0, false, HintManagerImpl.createHintHint(editor, p, hint, constraint).setContentActive(false));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 19: 
                case 20: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 19: 
                case 20: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hostEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hostPos";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$TooltipProvider";
                    break;
                }
                case 12: 
                case 13: 
                case 16: 
                case 18: 
                case 21: 
                case 26: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 14: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docInfo";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 22: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hint";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textConsumer";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$TooltipProvider";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAction";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doExecute";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPossiblyInjectedEditor";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrapInScrollPaneIfNeeded";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 19: 
                case 20: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "isTaskOutdated";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getOffset";
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "addHighlighterAndShowHint";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapInScrollPaneIfNeeded";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "getMaxPopupSize";
                    break;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "updateOnPsiChanges";
                    break;
                }
                case 27: 
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "showHint";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 19: 
                case 20: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

