/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import org.jetbrains.annotations.Nullable;

public class ImplementationSearcher {
    public PsiElement @Nullable [] searchImplementations(Editor editor, PsiElement element2, int offset) {
        TargetElementUtil targetElementUtil = TargetElementUtil.getInstance();
        boolean onRef = (Boolean)ReadAction.compute(() -> targetElementUtil.findTargetElement(editor, ImplementationSearcher.getFlags() & 0xFFFFFFF6, offset) == null);
        return this.searchImplementations(element2, editor, onRef && (Boolean)ReadAction.compute(() -> element2 == null || targetElementUtil.includeSelfInGotoImplementation(element2)) != false, onRef);
    }

    public PsiElement @Nullable [] searchImplementations(PsiElement element2, Editor editor, boolean includeSelfAlways, boolean includeSelfIfNoOthers) {
        if (element2 == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        Object[] elements = this.searchDefinitions(element2, editor);
        if (elements == null) {
            return null;
        }
        if (elements.length > 0) {
            return this.filterElements(element2, (PsiElement[])(includeSelfAlways ? (PsiElement[])ArrayUtil.prepend((Object)element2, (Object[])elements) : elements));
        }
        if (includeSelfAlways || includeSelfIfNoOthers) {
            return new PsiElement[]{element2};
        }
        return PsiElement.EMPTY_ARRAY;
    }

    protected static SearchScope getSearchScope(PsiElement element2, Editor editor) {
        try {
            DumbService dumbService = (DumbService)ReadAction.compute(() -> DumbService.getInstance((Project)element2.getProject()));
            return (SearchScope)dumbService.runReadActionInSmartMode(() -> TargetElementUtil.getInstance().getSearchScope(editor, element2));
        }
        catch (PsiInvalidElementAccessException e) {
            throw new ProcessCanceledException((Throwable)e);
        }
    }

    protected PsiElement @Nullable(value="For the case the search has been cancelled") [] searchDefinitions(PsiElement element2, Editor editor) {
        Ref result2 = Ref.create();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> result2.set((Object)((PsiElement[])this.search(element2, editor).toArray((Object[])PsiElement.EMPTY_ARRAY))), ImplementationSearcher.getSearchingForImplementations(), true, element2.getProject())) {
            return null;
        }
        return (PsiElement[])result2.get();
    }

    protected Query<PsiElement> search(PsiElement element2, Editor editor) {
        return DefinitionsScopedSearch.search((PsiElement)element2, (SearchScope)ImplementationSearcher.getSearchScope(element2, editor), (boolean)this.isSearchDeep());
    }

    protected boolean isSearchDeep() {
        return true;
    }

    protected PsiElement[] filterElements(PsiElement element2, PsiElement[] targetElements) {
        return targetElements;
    }

    public static int getFlags() {
        return TargetElementUtil.getInstance().getDefinitionSearchFlags();
    }

    @NlsContexts.ProgressTitle
    public static String getSearchingForImplementations() {
        return CodeInsightBundle.message((String)"searching.for.implementations", (Object[])new Object[0]);
    }

    public static abstract class BackgroundableImplementationSearcher
    extends ImplementationSearcher {
        @Override
        protected PsiElement[] searchDefinitions(PsiElement element2, Editor editor) {
            CommonProcessors.CollectProcessor<PsiElement> processor2 = new CommonProcessors.CollectProcessor<PsiElement>(){

                public boolean process(PsiElement element2) {
                    this.processElement(element2);
                    return super.process((Object)element2);
                }
            };
            this.search(element2, editor).forEach((Processor)processor2);
            return (PsiElement[])processor2.toArray((Object[])PsiElement.EMPTY_ARRAY);
        }

        protected abstract void processElement(PsiElement var1);
    }

    public static class FirstImplementationsSearcher
    extends ImplementationSearcher {
        @Override
        protected PsiElement[] searchDefinitions(final PsiElement element2, final Editor editor) {
            PsiElement[] psiElementArray;
            if (this.canShowPopupWithOneItem(element2)) {
                return new PsiElement[]{element2};
            }
            final PsiElementProcessor.FindElement collectProcessor = new PsiElementProcessor.FindElement();
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    this.search(element2, editor).forEach((Processor)new PsiElementProcessorAdapter<PsiElement>((PsiElementProcessor)collectProcessor){

                        public boolean processInReadAction(PsiElement element2) {
                            return !this.accept(element2) || super.processInReadAction(element2);
                        }
                    });
                }
            }, FirstImplementationsSearcher.getSearchingForImplementations(), true, element2.getProject())) {
                return null;
            }
            PsiElement foundElement = collectProcessor.getFoundElement();
            if (foundElement != null) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = foundElement;
            } else {
                psiElementArray = PsiElement.EMPTY_ARRAY;
            }
            return psiElementArray;
        }

        protected boolean canShowPopupWithOneItem(PsiElement element2) {
            return this.accept(element2);
        }

        protected boolean accept(PsiElement element2) {
            return true;
        }
    }
}

