/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonInspectionsReportConverter
implements InspectionsReportConverter {
    @NonNls
    private static final String FORMAT_NAME = "json";
    @NonNls
    private static final String JSON_EXTENSION = ".json";
    @NonNls
    private static final String FILE = "file";
    @NonNls
    private static final String LINE = "line";
    @NonNls
    private static final String OFFSET = "offset";
    @NonNls
    private static final String LENGTH = "length";
    @NonNls
    private static final String MODULE = "module";
    @NonNls
    private static final String PACKAGE = "package";
    @NonNls
    protected static final String PROBLEM = "problem";
    @NonNls
    protected static final String PROBLEMS = "problems";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String PLUGIN_ID = "pluginId";
    @NonNls
    private static final String PLUGIN_VERSION = "pluginVersion";
    @NonNls
    private static final String GLOBAL_TOOL = "isGlobalTool";
    @NonNls
    private static final String LANGUAGE = "language";
    @NonNls
    private static final String SEVERITY_ATTR = "severity";
    @NonNls
    private static final String ATTRIBUTE_KEY_ATTR = "attribute_key";
    @NonNls
    private static final String HINT = "hint";
    @NonNls
    private static final String HINTS = "hints";
    @NonNls
    private static final String DISPLAY_NAME = "displayName";
    @NonNls
    private static final String DEFAULT_SEVERITY = "defaultSeverity";
    @NonNls
    private static final String SHORT_NAME = "shortName";
    @NonNls
    private static final String ENABLED = "enabled";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String ID = "id";
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String GROUP = "group";
    @NonNls
    private static final String GROUPS = "groups";
    @NonNls
    private static final String INSPECTION = "inspection";
    @NonNls
    private static final String HIGHLIGHTED_ELEMENT = "highlighted_element";
    @NonNls
    private static final String DUPLICATED_CODE_AGGREGATE = "DuplicatedCode_aggregate";

    public String getFormatName() {
        return FORMAT_NAME;
    }

    public boolean useTmpDirForRawData() {
        return true;
    }

    public void convert(@NotNull String rawDataDirectoryPath, @Nullable String outputPath, @NotNull Map<String, Tools> tools, @NotNull List<? extends File> inspectionsResults) throws InspectionsReportConverter.ConversionException {
        if (rawDataDirectoryPath == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(0);
        }
        if (tools == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(1);
        }
        if (inspectionsResults == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(2);
        }
        if (outputPath == null) {
            throw new InspectionsReportConverter.ConversionException("Output path isn't specified");
        }
        try {
            Files.createDirectories(new File(outputPath).toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new InspectionsReportConverter.ConversionException("Cannot create dirs in output path: " + outputPath + " error: " + e.getMessage());
        }
        Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
        SAXBuilder builder2 = new SAXBuilder();
        for (File file2 : inspectionsResults) {
            String fileNameWithoutExt = FileUtil.getNameWithoutExtension((File)file2);
            File jsonFile = new File(outputPath, fileNameWithoutExt + JSON_EXTENSION);
            try {
                BufferedWriter writer = Files.newBufferedWriter(jsonFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
                try {
                    JsonWriter jsonWriter = gson2.newJsonWriter((Writer)writer);
                    try {
                        Document doc = builder2.build(file2);
                        if (".descriptions".equals(fileNameWithoutExt)) {
                            JsonInspectionsReportConverter.convertDescriptions(jsonWriter, doc);
                            continue;
                        }
                        if (DUPLICATED_CODE_AGGREGATE.equals(fileNameWithoutExt)) {
                            JsonInspectionsReportConverter.convertDuplicatedCode(jsonWriter, doc);
                            continue;
                        }
                        JsonInspectionsReportConverter.convertProblems(jsonWriter, doc);
                    }
                    finally {
                        if (jsonWriter == null) continue;
                        jsonWriter.close();
                    }
                }
                finally {
                    if (writer == null) continue;
                    ((Writer)writer).close();
                }
            }
            catch (IOException | JDOMException e) {
                throw new InspectionsReportConverter.ConversionException("Cannot convert file: " + file2.getPath() + " error: " + e.getMessage());
            }
        }
    }

    private static void convertDuplicatedCode(@NotNull JsonWriter jsonWriter, @NotNull Document problems) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(3);
        }
        if (problems == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(4);
        }
        jsonWriter.beginObject();
        jsonWriter.name(PROBLEMS);
        jsonWriter.beginArray();
        for (Element duplicates : problems.getRootElement().getChildren("duplicate")) {
            jsonWriter.beginArray();
            for (Element fragment2 : duplicates.getChildren("fragment")) {
                JsonInspectionsReportConverter.convertDuplicateFragment(jsonWriter, fragment2);
            }
            jsonWriter.endArray();
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    private static void convertDuplicateFragment(@NotNull JsonWriter jsonWriter, Element fragment2) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(5);
        }
        jsonWriter.beginObject();
        jsonWriter.name(FILE).value(fragment2.getAttributeValue(FILE));
        String line = fragment2.getAttributeValue(LINE);
        String start2 = fragment2.getAttributeValue("start");
        String end = fragment2.getAttributeValue("end");
        assert (line != null);
        assert (start2 != null);
        assert (end != null);
        jsonWriter.name(LINE).value((long)Integer.parseInt(line));
        jsonWriter.name("start").value((long)Integer.parseInt(start2));
        jsonWriter.name("end").value((long)Integer.parseInt(end));
        jsonWriter.endObject();
    }

    private static void convertProblems(@NotNull JsonWriter jsonWriter, @NotNull Document problems) throws IOException {
        if (jsonWriter == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(6);
        }
        if (problems == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(7);
        }
        jsonWriter.beginObject();
        jsonWriter.name(PROBLEMS);
        jsonWriter.beginArray();
        for (Element problem : problems.getRootElement().getChildren(PROBLEM)) {
            JsonInspectionsReportConverter.convertProblem(jsonWriter, problem);
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    public static void convertProblem(@NotNull JsonWriter writer, @NotNull Element problem) throws IOException {
        Element hints2;
        Element entryPoint;
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(8);
        }
        if (problem == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(9);
        }
        writer.beginObject();
        writer.name(FILE).value(problem.getChildText(FILE));
        JsonInspectionsReportConverter.writeInt(writer, problem, LINE);
        JsonInspectionsReportConverter.writeInt(writer, problem, OFFSET);
        JsonInspectionsReportConverter.writeInt(writer, problem, LENGTH);
        writer.name(MODULE).value(problem.getChildText(MODULE));
        writer.name(PACKAGE).value(problem.getChildText(PACKAGE));
        Element problemClassElement = problem.getChild("problem_class");
        if (problemClassElement != null) {
            JsonInspectionsReportConverter.convertProblemClass(writer, problemClassElement);
        }
        if ((entryPoint = problem.getChild("entry_point")) != null) {
            JsonInspectionsReportConverter.convertEntryPoint(writer, entryPoint);
        }
        if ((hints2 = problem.getChild(HINTS)) != null) {
            JsonInspectionsReportConverter.convertHints(writer, hints2);
        }
        writer.name(HIGHLIGHTED_ELEMENT).value(problem.getChildText(HIGHLIGHTED_ELEMENT));
        writer.name(LANGUAGE).value(problem.getChildText(LANGUAGE));
        writer.name(DESCRIPTION).value(problem.getChildText(DESCRIPTION));
        writer.endObject();
    }

    private static void writeInt(@NotNull JsonWriter writer, @NotNull Element problem, @NotNull String elementName) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(10);
        }
        if (problem == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(11);
        }
        if (elementName == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(12);
        }
        try {
            int intValue = Integer.parseInt(problem.getChildText(elementName));
            writer.name(elementName).value((long)intValue);
        }
        catch (NumberFormatException e) {
            writer.name(elementName).nullValue();
        }
    }

    private static void convertProblemClass(@NotNull JsonWriter writer, @NotNull Element problemClass) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(13);
        }
        if (problemClass == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(14);
        }
        writer.name("problem_class");
        writer.beginObject().name(NAME).value(problemClass.getText());
        String inspectionId = problemClass.getAttributeValue(ID);
        if (inspectionId != null) {
            writer.name(ID).value(inspectionId);
        }
        writer.name(SEVERITY_ATTR).value(problemClass.getAttributeValue(SEVERITY_ATTR)).name(ATTRIBUTE_KEY_ATTR).value(problemClass.getAttributeValue(ATTRIBUTE_KEY_ATTR)).endObject();
    }

    private static void convertEntryPoint(@NotNull JsonWriter writer, @NotNull Element entryPoint) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(15);
        }
        if (entryPoint == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(16);
        }
        writer.name("entry_point");
        writer.beginObject().name("TYPE").value(entryPoint.getAttributeValue("TYPE")).name("FQNAME").value(entryPoint.getAttributeValue("FQNAME")).endObject();
    }

    private static void convertHints(@NotNull JsonWriter writer, @NotNull Element hints2) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(17);
        }
        if (hints2 == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(18);
        }
        writer.name(HINTS);
        writer.beginArray();
        for (Element hint : hints2.getChildren(HINT)) {
            writer.value(hint.getAttributeValue(VALUE));
        }
        writer.endArray();
    }

    private static void convertDescriptions(@NotNull JsonWriter writer, @NotNull Document descriptions) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(19);
        }
        if (descriptions == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(20);
        }
        writer.beginObject();
        JsonInspectionsReportConverter.convertDescriptionsContents(writer, descriptions, null);
        writer.endObject();
    }

    protected static void convertDescriptionsContents(@NotNull JsonWriter writer, @NotNull Document descriptions, @Nullable Predicate<? super String> inspectionFilter) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(21);
        }
        if (descriptions == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(22);
        }
        Element inspectionsElement = descriptions.getRootElement();
        writer.name("profile").value(inspectionsElement.getAttributeValue("profile"));
        writer.name(GROUPS);
        writer.beginArray();
        for (Element group2 : inspectionsElement.getChildren(GROUP)) {
            JsonInspectionsReportConverter.convertGroup(writer, group2, inspectionFilter);
        }
        writer.endArray();
    }

    private static void convertGroup(@NotNull JsonWriter writer, @NotNull Element group2, @Nullable Predicate<? super String> inspectionFilter) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(23);
        }
        if (group2 == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(24);
        }
        if (inspectionFilter != null) {
            boolean anyInspectionsInFilter = false;
            for (Element inspection : group2.getChildren(INSPECTION)) {
                if (!inspectionFilter.test(inspection.getAttributeValue(SHORT_NAME))) continue;
                anyInspectionsInFilter = true;
                break;
            }
            if (!anyInspectionsInFilter) {
                return;
            }
        }
        writer.beginObject();
        writer.name(NAME).value(group2.getAttributeValue(NAME));
        writer.name("inspections").beginArray();
        for (Element inspection : group2.getChildren(INSPECTION)) {
            if (inspectionFilter != null && !inspectionFilter.test(inspection.getAttributeValue(SHORT_NAME))) continue;
            JsonInspectionsReportConverter.convertInspectionDescription(writer, inspection);
        }
        writer.endArray();
        writer.endObject();
    }

    private static void convertInspectionDescription(@NotNull JsonWriter writer, @NotNull Element inspection) throws IOException {
        if (writer == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(25);
        }
        if (inspection == null) {
            JsonInspectionsReportConverter.$$$reportNull$$$0(26);
        }
        writer.beginObject().name(SHORT_NAME).value(inspection.getAttributeValue(SHORT_NAME)).name(DISPLAY_NAME).value(inspection.getAttributeValue(DISPLAY_NAME)).name(DEFAULT_SEVERITY).value(inspection.getAttributeValue(DEFAULT_SEVERITY)).name(PLUGIN_ID).value(inspection.getAttributeValue(PLUGIN_ID)).name(PLUGIN_VERSION).value(inspection.getAttributeValue(PLUGIN_VERSION)).name(LANGUAGE).value(inspection.getAttributeValue(LANGUAGE)).name(GLOBAL_TOOL).value(Boolean.parseBoolean(inspection.getAttributeValue(GLOBAL_TOOL))).name(ENABLED).value(Boolean.parseBoolean(inspection.getAttributeValue(ENABLED))).name(DESCRIPTION).value(inspection.getValue()).endObject();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawDataDirectoryPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionsResults";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonWriter";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROBLEMS;
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROBLEM;
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemClass";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryPoint";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = HINTS;
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptions";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = GROUP;
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = INSPECTION;
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/ex/JsonInspectionsReportConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "convert";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "convertDuplicatedCode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "convertDuplicateFragment";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "convertProblems";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "convertProblem";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "writeInt";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "convertProblemClass";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "convertEntryPoint";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "convertHints";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "convertDescriptions";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "convertDescriptionsContents";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "convertGroup";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "convertInspectionDescription";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

