/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.auth;

import com.intellij.collaboration.auth.services.OAuthService;
import com.intellij.util.Url;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\bH\u0014J\f\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0004H&J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0018\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00048DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u00020\r*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase;", "Lorg/jetbrains/ide/RestService;", "()V", "service", "Lcom/intellij/collaboration/auth/services/OAuthService;", "getService", "()Lcom/intellij/collaboration/auth/services/OAuthService;", "authorizationCode", "", "Lio/netty/handler/codec/http/QueryStringDecoder;", "getAuthorizationCode", "(Lio/netty/handler/codec/http/QueryStringDecoder;)Ljava/lang/String;", "isAuthorizationCodeUrl", "", "(Lio/netty/handler/codec/http/QueryStringDecoder;)Z", "execute", "urlDecoder", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "getServiceName", "oauthService", "sendRedirect", "", "url", "Lcom/intellij/util/Url;", "Companion", "intellij.platform.collaborationTools"})
public abstract class OAuthCallbackHandlerBase
extends RestService {
    private static final String INVALID_REQUEST_ERROR = "Invalid Request";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final OAuthService<?> getService() {
        return this.oauthService();
    }

    @NotNull
    public abstract OAuthService<?> oauthService();

    private final boolean isAuthorizationCodeUrl(QueryStringDecoder $this$isAuthorizationCodeUrl) {
        return Intrinsics.areEqual((Object)$this$isAuthorizationCodeUrl.path(), (Object)this.getService().getAuthorizationCodeUrl().getPath());
    }

    private final String getAuthorizationCode(QueryStringDecoder $this$authorizationCode) {
        List list2 = (List)$this$authorizationCode.parameters().get("code");
        return list2 != null ? (String)CollectionsKt.firstOrNull((List)list2) : null;
    }

    @Override
    @NotNull
    protected String getServiceName() {
        return this.getService().getName();
    }

    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context2) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!this.isAuthorizationCodeUrl(urlDecoder)) {
            return INVALID_REQUEST_ERROR;
        }
        String string = this.getAuthorizationCode(urlDecoder);
        if (string == null) {
            return INVALID_REQUEST_ERROR;
        }
        String code = string;
        boolean isCodeAccepted = this.getService().acceptCode(code);
        Url redirectUrl = isCodeAccepted ? this.getService().getSuccessRedirectUrl() : this.getService().getErrorRedirectUrl();
        this.sendRedirect(request, context2, redirectUrl);
        return null;
    }

    private final void sendRedirect(FullHttpRequest request, ChannelHandlerContext context2, Url url) {
        HttpHeaders headers = new DefaultHttpHeaders().set((CharSequence)HttpHeaderNames.LOCATION, (Object)url.toExternalForm());
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.FOUND;
        Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"HttpResponseStatus.FOUND");
        Channel channel2 = context2.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel2, (String)"context.channel()");
        Responses.send((HttpResponseStatus)httpResponseStatus, (Channel)channel2, (HttpRequest)((HttpRequest)request), null, (HttpHeaders)headers);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$Companion;", "", "()V", "INVALID_REQUEST_ERROR", "", "intellij.platform.collaborationTools"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

