/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ComponentStoreWithExtraComponents;
import com.intellij.configurationStore.DefaultProjectElementNormalizerKt;
import com.intellij.configurationStore.DefaultProjectStoreImpl;
import com.intellij.configurationStore.Macro;
import com.intellij.configurationStore.ProjectIdManager;
import com.intellij.configurationStore.ProjectIdState;
import com.intellij.configurationStore.ProjectStoreBase;
import com.intellij.configurationStore.ProjectStoreBaseKt;
import com.intellij.configurationStore.SaveResult;
import com.intellij.configurationStore.StateLoadPolicy;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.StreamProviderFactory;
import com.intellij.ide.impl.TrustedProjectSettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.Ksuid;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.StringKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0018\u001a\u00020\u0019J#\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\b\u0010 \u001a\u0004\u0018\u00010\u0007J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\nH\u0016J\r\u0010#\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b$J\u0006\u0010%\u001a\u00020\u0007J\u0006\u0010&\u001a\u00020\u0007J\n\u0010'\u001a\u0004\u0018\u00010!H\u0016J\u0006\u0010(\u001a\u00020)J2\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+\"\u0004\b\u0000\u0010-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H-0/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0014J\u0006\u00104\u001a\u00020\u0007J\u0006\u00105\u001a\u00020\nJ\u0010\u00106\u001a\u00020\n2\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\u0004H\u0002J\u001c\u0010;\u001a\u00020\u00192\f\u0010<\u001a\b\u0012\u0004\u0012\u00020!0=2\u0006\u0010>\u001a\u00020?J\u000e\u0010@\u001a\u00020\u00192\u0006\u0010A\u001a\u00020\nJ\"\u0010B\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u00072\u0006\u0010C\u001a\u00020\n2\b\u0010D\u001a\u0004\u0018\u00010\u0004H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006E"}, d2={"Lcom/intellij/configurationStore/ProjectStoreBase;", "Lcom/intellij/configurationStore/ComponentStoreWithExtraComponents;", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "dirOrFile", "Ljava/nio/file/Path;", "dotIdea", "isDirectoryBased", "", "()Z", "loadPolicy", "Lcom/intellij/configurationStore/StateLoadPolicy;", "getLoadPolicy", "()Lcom/intellij/configurationStore/StateLoadPolicy;", "setLoadPolicy", "(Lcom/intellij/configurationStore/StateLoadPolicy;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;", "clearStorages", "", "doSave", "result", "Lcom/intellij/configurationStore/SaveResult;", "forceSavingAllSettings", "doSave$intellij_platform_configurationStore_impl", "(Lcom/intellij/configurationStore/SaveResult;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDirectoryStorePath", "", "ignoreProjectStorageScheme", "getNameFile", "getNameFile$intellij_platform_configurationStore_impl", "getProjectBasePath", "getProjectFilePath", "getProjectWorkspaceId", "getStorageScheme", "Lcom/intellij/openapi/components/StorageScheme;", "getStorageSpecs", "", "Lcom/intellij/openapi/components/Storage;", "T", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "stateSpec", "Lcom/intellij/openapi/components/State;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "getWorkspacePath", "isOptimiseTestLoadSpeed", "isProjectFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "loadProjectFromTemplate", "defaultProject", "reloadStates", "componentNames", "", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "setOptimiseTestLoadSpeed", "value", "setPath", "isRefreshVfsNeeded", "template", "intellij.platform.configurationStore.impl"})
public abstract class ProjectStoreBase
extends ComponentStoreWithExtraComponents
implements IProjectStore {
    private Path dirOrFile;
    private Path dotIdea;
    @NotNull
    private StateLoadPolicy loadPolicy;
    @NotNull
    private final Project project;

    @NotNull
    public final Path getNameFile$intellij_platform_configurationStore_impl() {
        Path path2 = this.getDirectoryStorePath();
        Intrinsics.checkNotNull((Object)path2);
        Path path3 = path2.resolve(".name");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"directoryStorePath!!.resolve(ProjectEx.NAME_FILE)");
        return path3;
    }

    @Override
    @NotNull
    public final StateLoadPolicy getLoadPolicy() {
        return this.loadPolicy;
    }

    public final void setLoadPolicy(@NotNull StateLoadPolicy stateLoadPolicy) {
        Intrinsics.checkNotNullParameter((Object)((Object)stateLoadPolicy), (String)"<set-?>");
        this.loadPolicy = stateLoadPolicy;
    }

    @Override
    public final boolean isOptimiseTestLoadSpeed() {
        return this.loadPolicy != StateLoadPolicy.LOAD;
    }

    @Override
    @NotNull
    public final StorageScheme getStorageScheme() {
        return this.dotIdea == null ? StorageScheme.DEFAULT : StorageScheme.DIRECTORY_BASED;
    }

    @Override
    @NotNull
    public abstract StateStorageManagerImpl getStorageManager();

    protected final boolean isDirectoryBased() {
        return this.dotIdea != null;
    }

    @Override
    public final void setOptimiseTestLoadSpeed(boolean value2) {
        this.loadPolicy = value2 ? StateLoadPolicy.NOT_LOAD : StateLoadPolicy.LOAD;
    }

    @Override
    @NotNull
    public final Path getProjectFilePath() {
        return this.getStorageManager().expandMacro("$PROJECT_FILE$");
    }

    @Override
    @NotNull
    public final Path getWorkspacePath() {
        return this.getStorageManager().expandMacro("$WORKSPACE_FILE$");
    }

    @Override
    public final void clearStorages() {
        this.getStorageManager().clearStorages();
    }

    private final void loadProjectFromTemplate(Project defaultProject) {
        Object object;
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)defaultProject);
        if (iComponentStore == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.configurationStore.DefaultProjectStoreImpl");
        }
        Element element2 = ((DefaultProjectStoreImpl)iComponentStore).getStateCopy();
        if (element2 == null) {
            return;
        }
        Element element3 = element2;
        Logger $this$runAndLogException$iv = ComponentStoreImplKt.getLOG();
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        boolean bl = false;
        try {
            object = Result.Companion;
            Logger $this$runCatching$iv = logger;
            boolean bl2 = false;
            boolean bl3 = false;
            Path dotIdea = this.dotIdea;
            if (dotIdea != null) {
                DefaultProjectElementNormalizerKt.normalizeDefaultProjectElement(defaultProject, element3, dotIdea);
            } else {
                DefaultProjectElementNormalizerKt.moveComponentConfiguration(defaultProject, element3, (Function1<? super String, String>)((Function1)loadProjectFromTemplate.1.1.INSTANCE), (Function1<? super String, ? extends Path>)((Function1)new Function1<String, Path>(this, defaultProject, element3){
                    final /* synthetic */ ProjectStoreBase this$0;
                    final /* synthetic */ Project $defaultProject$inlined;
                    final /* synthetic */ Element $element$inlined;
                    {
                        this.this$0 = projectStoreBase;
                        this.$defaultProject$inlined = project;
                        this.$element$inlined = element2;
                        super(1);
                    }

                    @NotNull
                    public final Path invoke(@NotNull String it) {
                        Path path2;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (Intrinsics.areEqual((Object)it, (Object)"workspace.xml")) {
                            path2 = this.this$0.getWorkspacePath();
                        } else {
                            Path path3 = ProjectStoreBase.access$getDirOrFile$p(this.this$0);
                            path2 = path3;
                            Intrinsics.checkNotNull((Object)path3);
                        }
                        return path2;
                    }
                }));
            }
            Unit unit = Unit.INSTANCE;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl5 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
    }

    @Override
    @NotNull
    public final Path getProjectBasePath() {
        Path path2 = this.dirOrFile;
        if (path2 == null) {
            throw (Throwable)new IllegalStateException("setPath was not yet called");
        }
        Path path3 = path2;
        if (this.isDirectoryBased()) {
            Path path4;
            boolean useParent;
            Object object;
            boolean bl = Registry.is((String)"store.basedir.parent.detection", (boolean)true) && ((object = path3.getFileName()) != null && (object = object.toString()) != null ? StringsKt.startsWith$default((String)object, (String)".idea.", (boolean)false, (int)2, null) : false) ? true : (useParent = false);
            if (useParent) {
                Path path5 = path3.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"path.parent");
                Path path6 = path5.getParent();
                path4 = path6;
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"path.parent.parent");
            } else {
                path4 = path3;
            }
            return path4;
        }
        Path path7 = path3.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"path.parent");
        return path7;
    }

    @Override
    @Nullable
    public String getProjectWorkspaceId() {
        return ((ProjectIdState)ProjectIdManager.Companion.getInstance(this.project).getState()).getId();
    }

    @Override
    public void setPath(@NotNull Path file2, boolean isRefreshVfsNeeded, @Nullable Project template) {
        Path productWorkspaceFile;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.dirOrFile = file2;
        StateStorageManagerImpl storageManager2 = this.getStorageManager();
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        boolean isUnitTestMode = application.isUnitTestMode();
        ArrayList<Macro> macros = new ArrayList<Macro>(5);
        if (StringsKt.endsWith$default((String)((Object)file2).toString(), (String)".ipr", (boolean)false, (int)2, null)) {
            Path workspacePath;
            macros.add(new Macro("$PROJECT_FILE$", file2));
            Path path2 = workspacePath = file2.getParent().resolve(StringsKt.removeSuffix((String)((Object)file2.getFileName()).toString(), (CharSequence)".ipr") + ".iws");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"workspacePath");
            macros.add(new Macro("$WORKSPACE_FILE$", path2));
            if (isUnitTestMode) {
                Boolean componentStoreLoadingEnabled = (Boolean)this.project.getUserData(IProjectStore.COMPONENT_STORE_LOADING_ENABLED);
                boolean bl = componentStoreLoadingEnabled == null ? !PathKt.exists((Path)file2) : componentStoreLoadingEnabled == false;
                if (bl) {
                    this.loadPolicy = StateLoadPolicy.NOT_LOAD;
                }
                macros.add(new Macro("$PRODUCT_WORKSPACE_FILE$", workspacePath));
            }
        } else {
            Path dotIdea;
            this.dotIdea = dotIdea = file2.resolve(".idea");
            Path path3 = dotIdea;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"dotIdea");
            macros.add(new Macro("$PROJECT_CONFIG_DIR$", path3));
            Path path4 = dotIdea.resolve("workspace.xml");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"dotIdea.resolve(\"workspace.xml\")");
            macros.add(new Macro("$WORKSPACE_FILE$", path4));
            Path path5 = dotIdea.resolve("misc.xml");
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"dotIdea.resolve(\"misc.xml\")");
            macros.add(new Macro("$PROJECT_FILE$", path5));
            if (isUnitTestMode) {
                this.setOptimiseTestLoadSpeed(!PathKt.exists((Path)file2));
                Path path6 = dotIdea.resolve("product-workspace.xml");
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"dotIdea.resolve(\"product-workspace.xml\")");
                macros.add(new Macro("$PRODUCT_WORKSPACE_FILE$", path6));
            }
        }
        Path presentableUrl = this.dotIdea == null ? file2 : this.getProjectBasePath();
        String string = PathKt.getSystemIndependentPath((Path)presentableUrl);
        Path path7 = presentableUrl.getFileName();
        String string2 = (path7 != null ? (Comparable)path7 : (Comparable)((Object)"")).toString();
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.US");
        Locale locale2 = locale;
        boolean bl = false;
        String string3 = string2;
        boolean bl2 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
        String cacheFileName = ProjectUtil.doGetProjectFileName((String)string, (String)StringsKt.removeSuffix((String)string5, (CharSequence)".ipr"), (String)".", (String)".xml");
        Path path8 = PathManagerEx.getAppSystemDir().resolve("workspace").resolve(cacheFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"appSystemDir.resolve(\"wo\u2026\").resolve(cacheFileName)");
        macros.add(new Macro("$CACHE_FILE$", path8));
        storageManager2.setMacros((List<Macro>)macros);
        if (template != null) {
            this.loadProjectFromTemplate(template);
        }
        if (isUnitTestMode) {
            return;
        }
        Path productSpecificWorkspaceParentDir = PathManager.getConfigDir().resolve("workspace");
        ProjectIdManager projectIdManager = ProjectIdManager.Companion.getInstance(this.project);
        String projectId = ((ProjectIdState)projectIdManager.getState()).getId();
        if (projectId == null) {
            projectId = Ksuid.generate();
            ((ProjectIdState)projectIdManager.getState()).setId(projectId);
        }
        Path path9 = productWorkspaceFile = productSpecificWorkspaceParentDir.resolve(projectId + ".xml");
        Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"productWorkspaceFile");
        macros.add(new Macro("$PRODUCT_WORKSPACE_FILE$", path9));
        storageManager2.setMacros((List<Macro>)macros);
        Project $this$service$iv = this.project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(TrustedProjectSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        TrustedProjectSettings trustedProjectSettings = (TrustedProjectSettings)((Object)object);
        if (trustedProjectSettings.getTrustedState() == ThreeState.UNSURE && !trustedProjectSettings.getHasCheckedIfOldProject() && PathKt.exists((Path)productWorkspaceFile)) {
            ComponentStoreImplKt.getLOG().info("Marked the project as trusted because there are settings in " + productWorkspaceFile);
            trustedProjectSettings.setTrustedState(ThreeState.YES);
        }
        trustedProjectSettings.setHasCheckedIfOldProject(true);
    }

    @Override
    @NotNull
    protected <T> List<Storage> getStorageSpecs(@NotNull PersistentStateComponent<T> component2, @NotNull State stateSpec, @NotNull StateStorageOperation operation2) {
        List result2;
        Object[] storages;
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkNotNullParameter((Object)operation2, (String)"operation");
        Object[] objectArray = storages = stateSpec.storages();
        boolean bl = false;
        if (objectArray.length == 0) {
            return CollectionsKt.listOf((Object)ProjectStoreBaseKt.getPROJECT_FILE_STORAGE_ANNOTATION());
        }
        if (this.isDirectoryBased()) {
            if (storages.length == 2) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode() && ProjectStoreBaseKt.access$isSpecialStorage((Storage)ArraysKt.first((Object[])storages)) && Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath((Storage)storages[1]), (Object)"$WORKSPACE_FILE$")) {
                    return CollectionsKt.listOf((Object)ArraysKt.first((Object[])storages));
                }
            }
            result2 = null;
            for (Object storage2 : storages) {
                if (!(Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath((Storage)storage2), (Object)"$PROJECT_FILE$") ^ true)) continue;
                if (result2 == null) {
                    result2 = (List)new SmartList();
                }
                result2.add(storage2);
            }
            if (UtilKt.isNullOrEmpty((Collection)result2)) {
                return CollectionsKt.listOf((Object)ProjectStoreBaseKt.getPROJECT_FILE_STORAGE_ANNOTATION());
            }
            List list2 = result2;
            Intrinsics.checkNotNull((Object)list2);
            CollectionsKt.sortWith((List)list2, ComponentStoreImplKt.getDeprecatedComparator());
            if (this.isDirectoryBased()) {
                for (StreamProviderFactory providerFactory : StreamProviderFactory.Companion.getEP_NAME().getIterable((AreaInstance)this.project)) {
                    Object object;
                    Logger $this$runAndLogException$iv = ComponentStoreImplKt.getLOG();
                    boolean $i$f$runAndLogException = false;
                    Logger logger = $this$runAndLogException$iv;
                    boolean bl2 = false;
                    try {
                        object = Result.Companion;
                        Logger $this$runCatching$iv = logger;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        StateStorageManager stateStorageManager = this.getStorageManager();
                        List list3 = result2;
                        Intrinsics.checkNotNull((Object)list3);
                        List<Storage> list4 = providerFactory.customizeStorageSpecs(component2, stateStorageManager, stateSpec, list3, operation2);
                        if (list4 != null) {
                            List<Storage> list5 = list4;
                            boolean bl5 = false;
                            boolean bl6 = false;
                            List<Storage> it = list5;
                            boolean bl7 = false;
                            return it;
                        }
                        Object var13_20 = null;
                        boolean bl8 = false;
                        object = Result.constructor-impl(var13_20);
                    }
                    catch (Throwable throwable) {
                        Result.Companion companion = Result.Companion;
                        boolean bl9 = false;
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
                }
            }
            if (!ProjectStoreBaseKt.access$isSpecialStorage((Storage)CollectionsKt.first((List)result2))) {
                result2.add(ProjectStoreBaseKt.access$getDEPRECATED_PROJECT_FILE_STORAGE_ANNOTATION$p());
            }
            return result2;
        }
        result2 = null;
        boolean hasOnlyDeprecatedStorages = true;
        for (Object storage3 : storages) {
            if (!Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath((Storage)storage3), (Object)"$PROJECT_FILE$") && !Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath((Storage)storage3), (Object)"$WORKSPACE_FILE$") && !ProjectStoreBaseKt.access$isSpecialStorage((Storage)storage3)) continue;
            if (result2 == null) {
                result2 = (List)new SmartList();
            }
            result2.add(storage3);
            if (storage3.deprecated()) continue;
            hasOnlyDeprecatedStorages = false;
        }
        if (UtilKt.isNullOrEmpty((Collection)result2)) {
            return CollectionsKt.listOf((Object)ProjectStoreBaseKt.getPROJECT_FILE_STORAGE_ANNOTATION());
        }
        if (hasOnlyDeprecatedStorages) {
            List list6 = result2;
            Intrinsics.checkNotNull((Object)list6);
            list6.add(ProjectStoreBaseKt.getPROJECT_FILE_STORAGE_ANNOTATION());
        }
        List list7 = result2;
        Intrinsics.checkNotNull((Object)list7);
        CollectionsKt.sortWith((List)list7, ComponentStoreImplKt.getDeprecatedComparator());
        return result2;
    }

    @Override
    public boolean isProjectFile(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!file2.isInLocalFileSystem() || !ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file2)) {
            return false;
        }
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        String filePath = string;
        if (!this.isDirectoryBased()) {
            return Intrinsics.areEqual((Object)filePath, (Object)PathKt.getSystemIndependentPath((Path)this.getProjectFilePath())) || Intrinsics.areEqual((Object)filePath, (Object)PathKt.getSystemIndependentPath((Path)this.getWorkspacePath()));
        }
        Path path2 = this.getProjectFilePath().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"projectFilePath.parent");
        return VfsUtilCore.isAncestorOrSelf((String)PathKt.getSystemIndependentPath((Path)path2), (VirtualFile)file2);
    }

    @Override
    @Nullable
    public String getDirectoryStorePath(boolean ignoreProjectStorageScheme) {
        Path path2 = this.dotIdea;
        return StringKt.nullize$default((String)(path2 != null ? PathKt.getSystemIndependentPath((Path)path2) : null), (boolean)false, (int)1, null);
    }

    @Override
    @Nullable
    public final Path getDirectoryStorePath() {
        return this.dotIdea;
    }

    @Override
    @Nullable
    public Object doSave$intellij_platform_configurationStore_impl(@NotNull SaveResult saveResult, boolean bl, @NotNull Continuation<? super Unit> $completion) {
        return ProjectStoreBase.doSave$intellij_platform_configurationStore_impl$suspendImpl(this, saveResult, bl, $completion);
    }

    static /* synthetic */ Object doSave$intellij_platform_configurationStore_impl$suspendImpl(ProjectStoreBase this_, SaveResult result2, boolean forceSavingAllSettings, Continuation $completion) {
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reloadStates(@NotNull Set<String> componentNames, @NotNull MessageBus messageBus) {
        Intrinsics.checkNotNullParameter(componentNames, (String)"componentNames");
        Intrinsics.checkNotNullParameter((Object)messageBus, (String)"messageBus");
        Project project$iv = this.project;
        boolean $i$f$runBatchUpdate = false;
        Object object = project$iv.getMessageBus().syncPublisher(BatchUpdateListener.TOPIC);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.messageBus.syncP\u2026atchUpdateListener.TOPIC)");
        BatchUpdateListener publisher$iv = (BatchUpdateListener)object;
        publisher$iv.onBatchUpdateStarted();
        try {
            boolean bl = false;
            ComponentStoreImpl.reinitComponents$default(this, componentNames, null, null, 6, null);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            publisher$iv.onBatchUpdateFinished();
        }
    }

    @Override
    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ProjectStoreBase(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.loadPolicy = StateLoadPolicy.LOAD;
    }

    public static final /* synthetic */ Path access$getDirOrFile$p(ProjectStoreBase $this) {
        return $this.dirOrFile;
    }

    public static final /* synthetic */ void access$setDirOrFile$p(ProjectStoreBase $this, Path path2) {
        $this.dirOrFile = path2;
    }
}

