/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.credentialStore.OneTimeStringKt;
import com.intellij.credentialStore.kdbx.SecureString;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/credentialStore/kdbx/ProtectedValue;", "Lorg/jdom/Text;", "Lcom/intellij/credentialStore/kdbx/SecureString;", "encryptedValue", "", "position", "", "streamCipher", "Lorg/bouncycastle/crypto/SkippingStreamCipher;", "([BILorg/bouncycastle/crypto/SkippingStreamCipher;)V", "decryptInto", "", "out", "encodeToBase64", "", "get", "Lcom/intellij/credentialStore/OneTimeString;", "clearable", "", "getText", "", "setNewStreamCipher", "newStreamCipher", "intellij.platform.credentialStore"})
public final class ProtectedValue
extends Text
implements SecureString {
    private byte[] encryptedValue;
    private int position;
    private SkippingStreamCipher streamCipher;

    @Override
    @NotNull
    public synchronized OneTimeString get(boolean clearable) {
        byte[] output2 = new byte[this.encryptedValue.length];
        this.decryptInto(output2);
        return OneTimeStringKt.OneTimeString$default((byte[])output2, (int)0, (int)0, (boolean)clearable, (int)6, null);
    }

    public final synchronized void setNewStreamCipher(@NotNull SkippingStreamCipher newStreamCipher) {
        Intrinsics.checkNotNullParameter((Object)newStreamCipher, (String)"newStreamCipher");
        byte[] value2 = this.encryptedValue;
        this.decryptInto(value2);
        this.position = (int)newStreamCipher.getPosition();
        newStreamCipher.processBytes(value2, 0, value2.length, value2, 0);
        this.streamCipher = newStreamCipher;
    }

    private final synchronized void decryptInto(byte[] out) {
        this.streamCipher.seekTo((long)this.position);
        this.streamCipher.processBytes(this.encryptedValue, 0, this.encryptedValue.length, out, 0);
    }

    @NotNull
    public Void getText() {
        throw (Throwable)new IllegalStateException("encodeToBase64 must be used for serialization");
    }

    @NotNull
    public final String encodeToBase64() {
        String string;
        byte[] byArray = this.encryptedValue;
        boolean bl = false;
        if (byArray.length == 0) {
            string = "";
        } else {
            String string2 = Base64.getEncoder().encodeToString(this.encryptedValue);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Base64.getEncoder().encodeToString(encryptedValue)");
        }
        return string;
    }

    public ProtectedValue(@NotNull byte[] encryptedValue, int position, @NotNull SkippingStreamCipher streamCipher) {
        Intrinsics.checkNotNullParameter((Object)encryptedValue, (String)"encryptedValue");
        Intrinsics.checkNotNullParameter((Object)streamCipher, (String)"streamCipher");
        this.encryptedValue = encryptedValue;
        this.position = position;
        this.streamCipher = streamCipher;
    }
}

