/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DefaultIdeaErrorLogger;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.LogEventException;
import com.intellij.diagnostic.LogMessage;
import com.intellij.idea.Main;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ErrorLogger;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class DialogAppender
extends AppenderSkeleton {
    private static final ErrorLogger[] LOGGERS = new ErrorLogger[]{new DefaultIdeaErrorLogger()};
    private static final int MAX_EARLY_LOGGING_EVENTS = 5;
    private static final int MAX_ASYNC_LOGGING_EVENTS = 5;
    private final Queue<IdeaLoggingEvent> myEarlyEvents = new ArrayDeque<IdeaLoggingEvent>();
    private final AtomicInteger myPendingAppendCounts = new AtomicInteger();
    private volatile Runnable myDialogRunnable;

    protected synchronized void append(@NotNull LoggingEvent event) {
        IdeaLoggingEvent ideaEvent;
        if (event == null) {
            DialogAppender.$$$reportNull$$$0(0);
        }
        if (!event.getLevel().isGreaterOrEqual((Priority)Level.ERROR) || Main.isCommandLine()) {
            return;
        }
        Object messageObject = event.getMessage();
        if (messageObject instanceof IdeaLoggingEvent) {
            ideaEvent = (IdeaLoggingEvent)messageObject;
        } else {
            ThrowableInformation info2 = event.getThrowableInformation();
            if (info2 == null || info2.getThrowable() == null) {
                return;
            }
            ideaEvent = DialogAppender.extractLoggingEvent(messageObject, info2.getThrowable());
        }
        if (LoadingState.COMPONENTS_LOADED.isOccurred()) {
            IdeaLoggingEvent queued;
            while ((queued = this.myEarlyEvents.poll()) != null) {
                this.queueAppend(queued);
            }
            this.queueAppend(ideaEvent);
        } else if (this.myEarlyEvents.size() < 5) {
            this.myEarlyEvents.add(ideaEvent);
        }
    }

    private void queueAppend(IdeaLoggingEvent event) {
        if (this.myPendingAppendCounts.incrementAndGet() > 5) {
            this.myPendingAppendCounts.decrementAndGet();
        } else {
            SwingUtilities.invokeLater(() -> {
                try {
                    this.appendToLoggers(event, LOGGERS);
                }
                finally {
                    this.myPendingAppendCounts.decrementAndGet();
                }
            });
        }
    }

    void appendToLoggers(@NotNull IdeaLoggingEvent event, ErrorLogger @NotNull [] errorLoggers) {
        if (event == null) {
            DialogAppender.$$$reportNull$$$0(1);
        }
        if (errorLoggers == null) {
            DialogAppender.$$$reportNull$$$0(2);
        }
        if (this.myDialogRunnable != null) {
            return;
        }
        for (int i2 = errorLoggers.length - 1; i2 >= 0; --i2) {
            ErrorLogger logger = errorLoggers[i2];
            if (!logger.canHandle(event)) continue;
            this.myDialogRunnable = () -> {
                try {
                    logger.handle(event);
                }
                finally {
                    this.myDialogRunnable = null;
                }
            };
            AppExecutorUtil.getAppExecutorService().execute(this.myDialogRunnable);
            break;
        }
    }

    private static IdeaLoggingEvent extractLoggingEvent(Object messageObject, Throwable throwable) {
        Throwable rootCause = ExceptionUtil.getRootCause((Throwable)throwable);
        if (rootCause instanceof LogEventException) {
            return ((LogEventException)rootCause).getLogMessage();
        }
        String message2 = null;
        List withAttachments = ExceptionUtil.findCauseAndSuppressed((Throwable)throwable, ExceptionWithAttachments.class);
        if (!withAttachments.isEmpty() && withAttachments.get(0) instanceof RuntimeExceptionWithAttachments) {
            message2 = ((RuntimeExceptionWithAttachments)withAttachments.get(0)).getUserMessage();
        }
        if (message2 == null && messageObject != null) {
            message2 = messageObject.toString();
        }
        if (!withAttachments.isEmpty()) {
            return LogMessage.createEvent(throwable, message2, (Attachment[])withAttachments.stream().flatMap(e -> Stream.of(e.getAttachments())).toArray(Attachment[]::new));
        }
        return new IdeaLoggingEvent(message2, throwable);
    }

    @TestOnly
    Runnable getDialogRunnable() {
        return this.myDialogRunnable;
    }

    public boolean requiresLayout() {
        return false;
    }

    public void close() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorLoggers";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/DialogAppender";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "append";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "appendToLoggers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

